/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.hierarchy;

import com.sun.electric.database.change.Undo;
import com.sun.electric.database.geometry.DBMath;
import com.sun.electric.database.geometry.Dimension2D;
import com.sun.electric.database.geometry.Geometric;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.hierarchy.NodeUsage;
import com.sun.electric.database.hierarchy.View;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.network.NetworkTool;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.text.CellName;
import com.sun.electric.database.text.Name;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Connection;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.database.variable.FlagSet;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.SizeOffset;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.technology.technologies.Schematics;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.user.ActivityLogger;
import com.sun.electric.tool.user.ErrorLogger;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.tool.user.ui.TextWindow;
import com.sun.electric.tool.user.ui.TopLevel;
import com.sun.electric.tool.user.ui.WindowContent;
import com.sun.electric.tool.user.ui.WindowFrame;
import java.awt.Dimension;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.JOptionPane;

public class Cell
extends ElectricObject
implements NodeProto,
Comparable {
    public static final Variable.Key CHARACTERISTIC_SPACING = ElectricObject.newKey("FACET_characteristic_spacing");
    public static final Variable.Key CELL_TEXT_KEY = ElectricObject.newKey("FACET_message");
    public static final Variable.Key MULTIPAGE_COUNT_KEY = ElectricObject.newKey("CELL_page_count");
    private static final int WANTNEXPAND = 2;
    private static final int NPLOCKED = 0x100000;
    private static final int NPILOCKED = 0x200000;
    private static final int INCELLLIBRARY = 0x400000;
    private static final int TECEDITCELL = 0x800000;
    private static final int MULTIPAGE = 0x7E000000;
    private static final int ABBREVLEN = 8;
    private static final Rectangle2D CENTERRECT = new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);
    private static int cellNumber = 0;
    private static final FlagSet.Generator flagGenerator = new FlagSet.Generator("Cell");
    private String protoName;
    private CellGroup cellGroup = null;
    private VersionGroup versionGroup;
    private Library lib;
    private View view;
    private Date creationDate;
    private Date revisionDate;
    private int version;
    private int userBits = 0;
    private Name basename;
    private List exports;
    private List essenBounds = new ArrayList();
    private List nodes;
    private Map usagesIn;
    List usagesOf;
    private Map maxSuffix;
    private List arcs;
    private Map tempNames;
    private Rectangle2D cellBounds;
    private boolean boundsDirty = false;
    private boolean boundsEmpty = true;
    private Geometric.RTNode rTree;
    private Undo.Change change;
    private int cellIndex;
    private Technology tech = null;
    private int tempInt;
    private int flagBits;
    private boolean boundLock = false;
    private Rectangle2D lastBounds = new Rectangle2D.Double();
    private static boolean allowCirDep = false;
    static /* synthetic */ Class class$java$lang$String;

    private Cell() {
        this.cellIndex = cellNumber++;
        this.exports = new ArrayList();
        this.nodes = new ArrayList();
        this.usagesIn = new HashMap();
        this.usagesOf = new ArrayList();
        this.maxSuffix = new HashMap();
        this.arcs = new ArrayList();
        this.tempNames = new HashMap();
        this.creationDate = new Date();
        this.revisionDate = new Date();
        this.cellBounds = new Rectangle2D.Double();
        this.rTree = Geometric.RTNode.makeTopLevel();
        this.setLinked(false);
    }

    public static Cell makeInstance(Library lib, String name) {
        PrimitiveNode cellCenterProto;
        NodeInst cellCenter;
        Cell cell = Cell.newInstance(lib, name);
        if (User.isPlaceCellCenter() && (cellCenter = NodeInst.newInstance(cellCenterProto = Generic.tech.cellCenterNode, new Point2D.Double(0.0, 0.0), cellCenterProto.getDefWidth(), cellCenterProto.getDefHeight(), cell)) != null) {
            cellCenter.setVisInside();
            cellCenter.setHardSelect();
        }
        return cell;
    }

    public static Cell newInstance(Library lib, String name) {
        Job.checkChanging();
        Cell cell = Cell.lowLevelAllocate(lib);
        if (cell.lowLevelPopulate(name)) {
            return null;
        }
        if (cell.lowLevelLink()) {
            return null;
        }
        Undo.newObject(cell);
        return cell;
    }

    public void kill() {
        this.checkChanging();
        this.lowLevelUnlink();
        Undo.killObject(this);
    }

    public static Cell copyNodeProto(Cell fromCell, Library toLib, String toName, boolean useExisting) {
        NodeInst ni;
        Cell newCell;
        NodeInst ni2;
        if (fromCell == null) {
            return null;
        }
        if (toLib == null) {
            return null;
        }
        for (int i = 0; i < toName.length(); ++i) {
            char ch = toName.charAt(i);
            if (ch > ' ' && ch != ':' && ch < '\u007f') continue;
            System.out.println("invalid name of new cell");
            return null;
        }
        Library destLib = toLib;
        if (toLib == fromCell.getLibrary()) {
            destLib = null;
        }
        HashMap<NodeInst, NodeProto> nodePrototypes = new HashMap<NodeInst, NodeProto>();
        Iterator it = fromCell.getNodes();
        while (it.hasNext()) {
            ni2 = (NodeInst)it.next();
            nodePrototypes.put(ni2, ni2.getProto());
        }
        if (destLib != null) {
            it = fromCell.getNodes();
            while (it.hasNext()) {
                ni2 = (NodeInst)it.next();
                if (ni2.getProto() instanceof PrimitiveNode) continue;
                Cell niProto = (Cell)ni2.getProto();
                boolean maySubstitute = useExisting;
                if (!maySubstitute && niProto.isIcon() && niProto.isIconOf(fromCell)) {
                    maySubstitute = true;
                }
                if (!maySubstitute) continue;
                Cell lnt = null;
                Iterator cIt = toLib.getCells();
                while (cIt.hasNext() && (!(lnt = (Cell)cIt.next()).getName().equalsIgnoreCase(niProto.getName()) || lnt.getView() != niProto.getView())) {
                    lnt = null;
                }
                if (lnt == null) continue;
                boolean validPorts = true;
                Iterator pIt = ni2.getPortInsts();
                while (pIt.hasNext()) {
                    PortInst pi = (PortInst)pIt.next();
                    PortProto pp = pi.getPortProto();
                    PortProto ppt = lnt.findPortProto(pp.getName());
                    if (ppt != null) {
                        // empty if block
                    }
                    if (ppt != null) continue;
                    System.out.println("Cannot use subcell " + lnt.noLibDescribe() + " in library " + destLib.getName() + ": exports don't match");
                    validPorts = false;
                    break;
                }
                if (!validPorts) continue;
                nodePrototypes.put(ni2, lnt);
            }
        }
        String cellName = toName;
        if (toName.indexOf(123) < 0 && fromCell.getView() != View.UNKNOWN) {
            cellName = toName + "{" + fromCell.getView().getAbbreviation() + "}";
        }
        if ((newCell = Cell.newInstance(toLib, cellName)) == null) {
            return null;
        }
        newCell.lowLevelSetUserbits(fromCell.lowLevelGetUserbits());
        HashMap<NodeInst, NodeInst> newNodes = new HashMap<NodeInst, NodeInst>();
        Iterator it2 = fromCell.getNodes();
        while (it2.hasNext()) {
            NodeInst toNi;
            ni = (NodeInst)it2.next();
            NodeProto lnt = (NodeProto)nodePrototypes.get(ni);
            double scaleX = ni.getXSize();
            if (ni.isXMirrored()) {
                scaleX = -scaleX;
            }
            double scaleY = ni.getYSize();
            if (ni.isYMirrored()) {
                scaleY = -scaleY;
            }
            if ((toNi = NodeInst.newInstance(lnt, new Point2D.Double(ni.getAnchorCenterX(), ni.getAnchorCenterY()), scaleX, scaleY, newCell, ni.getAngle(), ni.getName(), 0)) == null) {
                return null;
            }
            newNodes.put(ni, toNi);
            toNi.setProtoTextDescriptor(ni.getProtoTextDescriptor());
            toNi.setNameTextDescriptor(ni.getNameTextDescriptor());
            toNi.lowLevelSetUserbits(ni.lowLevelGetUserbits());
        }
        it2 = fromCell.getNodes();
        while (it2.hasNext()) {
            String name;
            Variable var;
            ni = (NodeInst)it2.next();
            NodeInst toNi = (NodeInst)newNodes.get(ni);
            toNi.copyVarsFrom(ni);
            if (!newCell.isIcon() || (var = toNi.getVar(Schematics.SCHEM_FUNCTION)) == null || !(name = (String)var.getObject()).equals(fromCell.getName())) continue;
            toNi.updateVar(var.getKey(), (Object)newCell.getName());
        }
        it2 = fromCell.getArcs();
        while (it2.hasNext()) {
            ArcInst ai = (ArcInst)it2.next();
            PortInst[] opi = new PortInst[2];
            for (int i = 0; i < 2; ++i) {
                opi[i] = null;
                Connection con = ai.getConnection(i);
                NodeInst ono = (NodeInst)newNodes.get(con.getPortInst().getNodeInst());
                PortProto pp = con.getPortInst().getPortProto();
                if (ono.getProto() instanceof PrimitiveNode) {
                    opi[i] = ono.findPortInstFromProto(pp);
                } else {
                    PortProto ppt = ono.getProto().findPortProto(pp.getName());
                    if (ppt != null) {
                        opi[i] = ono.findPortInstFromProto(ppt);
                    }
                }
                if (opi[i] != null) continue;
                System.out.println("Error: no port for " + ai.getProto().describe() + " arc on " + ono.getProto().describe() + " node");
            }
            if (opi[0] == null || opi[1] == null) {
                return null;
            }
            ArcInst toAi = ArcInst.newInstance(ai.getProto(), ai.getWidth(), opi[0], opi[1], ai.getHead().getLocation(), ai.getTail().getLocation(), ai.getName(), ai.getAngle());
            if (toAi == null) {
                return null;
            }
            toAi.copyPropertiesFrom(ai);
        }
        it2 = fromCell.getPorts();
        while (it2.hasNext()) {
            Export pp = (Export)it2.next();
            NodeInst ni3 = (NodeInst)newNodes.get(pp.getOriginalPort().getNodeInst());
            PortInst pi = ni3.findPortInst(pp.getOriginalPort().getPortProto().getName());
            if (pi == null) {
                System.out.println("Error: no port on " + pp.getOriginalPort().getNodeInst().getProto().describe() + " cell");
                return null;
            }
            Export ppt = Export.newInstance(newCell, pi, pp.getName());
            if (ppt == null) {
                return null;
            }
            ppt.copyVarsFrom(pp);
            ppt.lowLevelSetUserbits(pp.lowLevelGetUserbits());
            ppt.setTextDescriptor(pp.getTextDescriptor());
        }
        newCell.copyVarsFrom(fromCell);
        newCell.lowLevelSetCreationDate(fromCell.getCreationDate());
        newCell.lowLevelSetRevisionDate(fromCell.getRevisionDate());
        return newCell;
    }

    public void rename(String newName) {
        this.checkChanging();
        CellName n = CellName.parseName(newName + ";" + this.version + "{" + this.view.getAbbreviation() + "}");
        if (n == null) {
            return;
        }
        Iterator it = this.getLibrary().getCells();
        while (it.hasNext()) {
            Cell c = (Cell)it.next();
            if (!newName.equalsIgnoreCase(c.getName()) || this.getView() != c.getView()) continue;
            System.out.println("Already a Cell named " + this.noLibDescribe() + " in Library " + this.getLibrary().getName() + "...making this a new version");
            break;
        }
        Name oldName = this.basename;
        int oldVersion = this.version;
        this.lowLevelRename(n.getName(), this.version);
        Undo.renameObject(this, oldName, oldVersion);
    }

    public void lowLevelRename(String newName, int newVersion) {
        if (this.versionGroup.size() > 1) {
            this.versionGroup.remove(this);
            this.versionGroup = new VersionGroup();
            this.versionGroup.add(this);
        }
        Iterator it = this.getLibrary().getCells();
        while (it.hasNext()) {
            Cell oCell = (Cell)it.next();
            if (oCell.getView() != this.getView() || !oCell.getName().equalsIgnoreCase(newName)) continue;
            int greatestVersion = 0;
            Iterator vIt = oCell.versionGroup.iterator();
            while (vIt.hasNext()) {
                Cell vCell = (Cell)vIt.next();
                if (vCell.getVersion() == newVersion) {
                    newVersion = -1;
                }
                if (vCell.getVersion() <= greatestVersion) continue;
                greatestVersion = vCell.getVersion();
            }
            if (newVersion < 0) {
                newVersion = greatestVersion + 1;
            }
            this.version = newVersion;
            this.versionGroup.remove(this);
            oCell.versionGroup.add(this);
            this.versionGroup = oCell.versionGroup;
            break;
        }
        this.setProtoName(newName);
        this.cellGroup.groupName = null;
    }

    public static Cell lowLevelAllocate(Library lib) {
        Job.checkChanging();
        Cell c = new Cell();
        c.lib = lib;
        return c;
    }

    public boolean lowLevelPopulate(String name) {
        this.checkChanging();
        Library lib = this.getLibrary();
        Cell existingCell = lib.findNodeProto(name);
        CellName n = CellName.parseName(name);
        if (n == null) {
            return true;
        }
        int version = n.getVersion();
        if (version > 0) {
            Iterator it = lib.getCells();
            while (it.hasNext()) {
                Cell c = (Cell)it.next();
                if (!n.getName().equalsIgnoreCase(c.getName()) || n.getView() != c.getView() || version != c.getVersion()) continue;
                System.out.println("Already have cell " + c.getName() + " with version " + version + ", generating a new version");
                version = 1;
                Iterator vIt = lib.getCells();
                while (vIt.hasNext()) {
                    c = (Cell)vIt.next();
                    if (!n.getName().equalsIgnoreCase(c.getName()) || n.getView() != c.getView() || c.getVersion() < version) continue;
                    version = c.getVersion() + 1;
                }
            }
        } else {
            version = 1;
            Iterator it = lib.getCells();
            while (it.hasNext()) {
                Cell c = (Cell)it.next();
                if (!n.getName().equalsIgnoreCase(c.getName()) || n.getView() != c.getView() || c.getVersion() < version) continue;
                version = c.getVersion() + 1;
            }
        }
        this.setProtoName(n.getName());
        this.view = n.getView();
        this.version = version;
        return false;
    }

    private void setProtoName(String name) {
        this.protoName = name;
        this.basename = Name.findName(this.protoName.substring(0, Math.min(8, this.protoName.length())) + '@').getBasename();
        if (this.basename == null) {
            this.basename = PrimitiveNode.Function.UNKNOWN.getBasename();
        }
    }

    public boolean lowLevelLink() {
        Cell displacedCell;
        this.checkChanging();
        if (this.isLinked()) {
            System.out.println(this + " already linked");
            return true;
        }
        this.versionGroup = null;
        Iterator it = this.lib.getCells();
        while (it.hasNext()) {
            Cell c = (Cell)it.next();
            if (c.getView() != this.getView() || !this.getName().equalsIgnoreCase(c.getName())) continue;
            this.versionGroup = c.versionGroup;
            break;
        }
        if (this.versionGroup == null) {
            this.versionGroup = new VersionGroup();
        }
        if ((displacedCell = this.versionGroup.add(this)) != null) {
            // empty if block
        }
        if (this.getNewestVersion() != this) {
            this.cellGroup = null;
        } else {
            if (this.cellGroup == null) {
                Iterator it2 = this.lib.getCells();
                while (it2.hasNext()) {
                    Cell c = (Cell)it2.next();
                    if (c.getCellGroup() == null || !this.getName().equalsIgnoreCase(c.getName())) continue;
                    this.cellGroup = c.getCellGroup();
                    break;
                }
                if (this.cellGroup == null) {
                    this.cellGroup = new CellGroup();
                }
            }
            this.cellGroup.add(this);
        }
        Library lib = this.getLibrary();
        lib.addCell(this);
        Iterator it3 = this.getUsagesIn();
        while (it3.hasNext()) {
            NodeUsage nu = (NodeUsage)it3.next();
            NodeProto np = nu.getProto();
            if (!(np instanceof Cell)) continue;
            ((Cell)np).usagesOf.add(nu);
        }
        this.setLinked(true);
        return false;
    }

    public void lowLevelUnlink() {
        this.checkChanging();
        if (!this.isLinked()) {
            System.out.println(this + " already unlinked");
            return;
        }
        Iterator vIt = this.getVersions();
        Cell newest = (Cell)vIt.next();
        Cell nextNewest = null;
        if (vIt.hasNext()) {
            nextNewest = (Cell)vIt.next();
        }
        this.versionGroup.remove(this);
        this.setVersionGroup(null);
        if (this == newest && nextNewest != null) {
            this.cellGroup.add(nextNewest);
        }
        if (this.cellGroup != null) {
            this.cellGroup.remove(this);
        }
        Library lib = this.getLibrary();
        lib.removeCell(this);
        Iterator it = this.getUsagesIn();
        while (it.hasNext()) {
            NodeUsage nu = (NodeUsage)it.next();
            NodeProto np = nu.getProto();
            if (!(np instanceof Cell)) continue;
            ((Cell)np).usagesOf.remove(nu);
        }
        this.setLinked(false);
    }

    public int lowLevelGetUserbits() {
        return this.userBits;
    }

    public void lowLevelSetUserbits(int userBits) {
        this.checkChanging();
        this.userBits = userBits;
    }

    public double getDefWidth() {
        return this.getBounds().getWidth();
    }

    public double getDefHeight() {
        return this.getBounds().getHeight();
    }

    public SizeOffset getProtoSizeOffset() {
        return SizeOffset.ZERO_OFFSET;
    }

    public Dimension2D getCharacteristicSpacing() {
        Variable var = this.getVar(CHARACTERISTIC_SPACING);
        if (var != null) {
            Object obj = var.getObject();
            if (obj instanceof Integer[]) {
                Integer[] iSpac = (Integer[])obj;
                Dimension2D.Double spacing = new Dimension2D.Double(iSpac[0].intValue(), iSpac[1].intValue());
                return spacing;
            }
            if (obj instanceof Double[]) {
                Double[] dSpac = (Double[])obj;
                Dimension2D.Double spacing = new Dimension2D.Double(dSpac[0], dSpac[1]);
                return spacing;
            }
        }
        return null;
    }

    public void setCharacteristicSpacing(double x, double y) {
        Double[] newVals = new Double[]{new Double(x), new Double(y)};
        this.newVar(CHARACTERISTIC_SPACING, (Object)newVals);
    }

    public void setDirty() {
        this.boundsDirty = true;
    }

    public Iterator searchIterator(Rectangle2D bounds) {
        return new Geometric.Search(bounds, this);
    }

    public void rememberBounds() {
        if (this.boundsDirty) {
            this.getBounds();
        }
        this.boundLock = true;
    }

    public Rectangle2D getRememberedBounds() {
        Rectangle2D retBounds = this.lastBounds;
        if (this.boundLock) {
            retBounds = this.cellBounds;
        }
        this.boundLock = false;
        return retBounds;
    }

    public Rectangle2D getBounds() {
        if (this.boundsDirty) {
            int i;
            if (this.boundLock) {
                this.boundLock = false;
                this.lastBounds.setRect(this.cellBounds);
            }
            this.boundsEmpty = true;
            double cellHighY = 0.0;
            double cellLowY = 0.0;
            double cellHighX = 0.0;
            double cellLowX = 0.0;
            for (i = 0; i < this.nodes.size(); ++i) {
                NodeInst ni = (NodeInst)this.nodes.get(i);
                NodeProto np = ni.getProto();
                if (np == Generic.tech.cellCenterNode) continue;
                if (np == Generic.tech.invisiblePinNode) {
                    boolean found = false;
                    Iterator it = ni.getVariables();
                    while (it.hasNext()) {
                        TextDescriptor td;
                        Variable var = (Variable)it.next();
                        if (!var.isDisplay() || !(td = var.getTextDescriptor()).isInterior() && !td.isInherit()) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                }
                Rectangle2D bounds = ni.getBounds();
                double lowx = bounds.getMinX();
                double highx = bounds.getMaxX();
                double lowy = bounds.getMinY();
                double highy = bounds.getMaxY();
                if (this.boundsEmpty) {
                    this.boundsEmpty = false;
                    cellLowX = lowx;
                    cellHighX = highx;
                    cellLowY = lowy;
                    cellHighY = highy;
                    continue;
                }
                if (lowx < cellLowX) {
                    cellLowX = lowx;
                }
                if (highx > cellHighX) {
                    cellHighX = highx;
                }
                if (lowy < cellLowY) {
                    cellLowY = lowy;
                }
                if (!(highy > cellHighY)) continue;
                cellHighY = highy;
            }
            for (i = 0; i < this.arcs.size(); ++i) {
                ArcInst ai = (ArcInst)this.arcs.get(i);
                Rectangle2D bounds = ai.getBounds();
                double lowx = bounds.getMinX();
                double highx = bounds.getMaxX();
                double lowy = bounds.getMinY();
                double highy = bounds.getMaxY();
                if (lowx < cellLowX) {
                    cellLowX = lowx;
                }
                if (highx > cellHighX) {
                    cellHighX = highx;
                }
                if (lowy < cellLowY) {
                    cellLowY = lowy;
                }
                if (!(highy > cellHighY)) continue;
                cellHighY = highy;
            }
            this.cellBounds.setRect(DBMath.round(cellLowX), DBMath.round(cellLowY), DBMath.round(cellHighX - cellLowX), DBMath.round(cellHighY - cellLowY));
            this.boundsDirty = false;
        }
        return this.cellBounds;
    }

    public Geometric.RTNode getRTree() {
        return this.rTree;
    }

    public void setRTree(Geometric.RTNode rTree) {
        this.checkChanging();
        this.rTree = rTree;
    }

    public Rectangle2D findEssentialBounds() {
        if (this.essenBounds.size() < 2) {
            return null;
        }
        double minX = Double.MAX_VALUE;
        double maxX = Double.MIN_VALUE;
        double minY = Double.MAX_VALUE;
        double maxY = Double.MIN_VALUE;
        for (int i = 0; i < this.essenBounds.size(); ++i) {
            NodeInst ni = (NodeInst)this.essenBounds.get(i);
            minX = Math.min(minX, ni.getTrueCenterX());
            maxX = Math.max(maxX, ni.getTrueCenterX());
            minY = Math.min(minY, ni.getTrueCenterY());
            maxY = Math.max(maxY, ni.getTrueCenterY());
        }
        return new Rectangle2D.Double(minX, minY, maxX - minX, maxY - minY);
    }

    public void adjustReferencePoint(NodeInst referencePointNode) {
        NodeInst ni;
        this.checkChanging();
        double cX = referencePointNode.getAnchorCenterX();
        double cY = referencePointNode.getAnchorCenterY();
        if (cX == 0.0 && cY == 0.0) {
            return;
        }
        referencePointNode.modifyInstance(-cX, -cY, 0.0, 0.0, 0);
        Iterator it = this.getNodes();
        while (it.hasNext()) {
            ni = (NodeInst)it.next();
            if (ni == referencePointNode) continue;
            ni.lowLevelModify(-cX, -cY, 0.0, 0.0, 0);
        }
        it = this.getArcs();
        while (it.hasNext()) {
            ArcInst ai = (ArcInst)it.next();
            ai.lowLevelModify(0.0, -cX, -cY, -cX, -cY);
        }
        it = this.getInstancesOf();
        while (it.hasNext()) {
            ni = (NodeInst)it.next();
            Undo.redrawObject(ni);
            AffineTransform trans = NodeInst.pureRotate(ni.getAngle(), ni.isMirroredAboutXAxis(), ni.isMirroredAboutYAxis());
            Point2D.Double in = new Point2D.Double(cX, cY);
            trans.transform(in, in);
            ni.modifyInstance(((Point2D)in).getX(), ((Point2D)in).getY(), 0.0, 0.0, 0);
        }
        it = WindowFrame.getWindows();
        while (it.hasNext()) {
            Cell cell;
            WindowFrame wf = (WindowFrame)it.next();
            WindowContent content = wf.getContent();
            if (!(content instanceof EditWindow) || (cell = content.getCell()) != this) continue;
            EditWindow wnd = (EditWindow)content;
            Point2D off = wnd.getOffset();
            off.setLocation(off.getX() - cX, off.getY() - cY);
            wnd.setOffset(off);
        }
    }

    public boolean alreadyCellCenter() {
        Iterator it = this.getNodes();
        while (it.hasNext()) {
            NodeInst ni = (NodeInst)it.next();
            if (ni.getProto() != Generic.tech.cellCenterNode) continue;
            return true;
        }
        return false;
    }

    public synchronized Iterator getNodes() {
        ArrayList nodesCopy = new ArrayList(this.nodes);
        return nodesCopy.iterator();
    }

    public int getNumNodes() {
        return this.nodes.size();
    }

    public final NodeInst getNode(int nodeIndex) {
        return (NodeInst)this.nodes.get(nodeIndex);
    }

    public synchronized Iterator getUsagesIn() {
        HashMap usagesCopy = new HashMap(this.usagesIn);
        return usagesCopy.values().iterator();
    }

    public int getNumUsagesIn() {
        return this.usagesIn.size();
    }

    public NodeInst findNode(String name) {
        int n = this.nodes.size();
        for (int i = 0; i < n; ++i) {
            NodeInst ni = (NodeInst)this.nodes.get(i);
            String nodeNm = ni.getName();
            if (nodeNm == null || !nodeNm.equals(name)) continue;
            return ni;
        }
        return null;
    }

    public static void setAllowCircularLibraryDependences(boolean val) {
        allowCirDep = val;
    }

    public NodeUsage addNode(NodeInst ni) {
        Library.LibraryDependency libDep;
        Cell instProto;
        this.checkChanging();
        NodeUsage nu = this.addUsage(ni.getProto());
        if (nu.contains(ni)) {
            System.out.println("Cell " + this + " already contains node inst " + ni);
            return null;
        }
        NodeProto protoType = ni.getProto();
        if (protoType instanceof Cell && (instProto = (Cell)protoType).getLibrary() != this.getLibrary() && (libDep = this.getLibrary().addReferencedLib(instProto.getLibrary())) != null) {
            if (!allowCirDep) {
                System.out.println("ERROR: " + this.libDescribe() + " cannot instantiate " + instProto.libDescribe() + " because it would create a circular library dependence: ");
                System.out.println(libDep.toString());
                return null;
            }
            System.out.println("WARNING: " + this.libDescribe() + " instantiates " + instProto.libDescribe() + " which causes a circular library dependence: ");
            System.out.println(libDep.toString());
        }
        ni.setNodeIndex(this.nodes.size());
        this.nodes.add(ni);
        this.addTempName(ni);
        nu.addInst(ni);
        this.boundsDirty = true;
        NodeProto np = ni.getProto();
        if (np instanceof PrimitiveNode && np == Generic.tech.cellCenterNode) {
            this.adjustReferencePoint(ni);
        }
        if (np instanceof PrimitiveNode && np.getName().equals("Essential-Bounds")) {
            this.essenBounds.add(ni);
        }
        return nu;
    }

    public void removeNode(NodeInst ni) {
        this.checkChanging();
        NodeUsage nu = ni.getNodeUsage();
        if (nu == null || !nu.contains(ni)) {
            System.out.println("Cell " + this + " doesn't contain node inst " + ni);
            return;
        }
        nu.removeInst(ni);
        if (nu.isEmpty()) {
            this.removeUsage(nu);
        }
        this.removeTempName(ni);
        int nodeIndex = ni.getNodeIndex();
        int lastNode = this.nodes.size() - 1;
        if (nodeIndex == lastNode) {
            this.nodes.remove(nodeIndex);
        } else {
            NodeInst lastNi = (NodeInst)this.nodes.remove(lastNode);
            this.nodes.set(nodeIndex, lastNi);
            lastNi.setNodeIndex(nodeIndex);
        }
        ni.setNodeIndex(-1);
        if (ni.getProto() instanceof Cell) {
            this.getLibrary().removeReferencedLib(((Cell)ni.getProto()).getLibrary());
        }
        this.boundsDirty = true;
        this.essenBounds.remove(ni);
    }

    private NodeUsage addUsage(NodeProto protoType) {
        NodeUsage nu;
        if (!this.isLinked()) {
            System.out.println("addUsage of " + protoType + " to unlinked " + this);
        }
        if ((nu = (NodeUsage)this.usagesIn.get(protoType)) == null) {
            nu = new NodeUsage(protoType, this);
            this.usagesIn.put(protoType, nu);
            if (protoType instanceof Cell) {
                ((Cell)protoType).usagesOf.add(nu);
            }
        }
        return nu;
    }

    private void removeUsage(NodeUsage nu) {
        NodeProto protoType;
        if (!this.isLinked()) {
            System.out.println("removeUsage of " + nu.getProto() + " to unliked " + this);
        }
        if ((protoType = nu.getProto()) instanceof Cell) {
            ((Cell)protoType).usagesOf.remove(nu);
        }
        this.usagesIn.remove(protoType);
    }

    public synchronized Iterator getArcs() {
        ArrayList arcsCopy = new ArrayList(this.arcs);
        return arcsCopy.iterator();
    }

    public int getNumArcs() {
        return this.arcs.size();
    }

    public final ArcInst getArc(int arcIndex) {
        return (ArcInst)this.arcs.get(arcIndex);
    }

    public ArcInst findArc(String name) {
        int a = this.arcs.size();
        for (int i = 0; i < a; ++i) {
            ArcInst ai = (ArcInst)this.arcs.get(i);
            String arcNm = ai.getName();
            if (arcNm == null || !arcNm.equals(name)) continue;
            return ai;
        }
        return null;
    }

    public void addArc(ArcInst ai) {
        this.checkChanging();
        if (this.arcs.contains(ai)) {
            System.out.println("Cell " + this + " already contains arc " + ai);
            return;
        }
        ai.setArcIndex(this.arcs.size());
        this.arcs.add(ai);
        this.addTempName(ai);
        this.boundsDirty = true;
    }

    public void removeArc(ArcInst ai) {
        this.checkChanging();
        if (!this.arcs.contains(ai)) {
            System.out.println("Cell " + this + " doesn't contain arc " + ai);
            return;
        }
        this.removeTempName(ai);
        int arcIndex = ai.getArcIndex();
        int lastArc = this.arcs.size() - 1;
        if (arcIndex == lastArc) {
            this.arcs.remove(arcIndex);
        } else {
            ArcInst lastAi = (ArcInst)this.arcs.remove(lastArc);
            this.arcs.set(arcIndex, lastAi);
            lastAi.setArcIndex(arcIndex);
        }
        ai.setArcIndex(-1);
        this.boundsDirty = true;
    }

    void addExport(Export export, Collection oldPortInsts) {
        this.checkChanging();
        export.setPortIndex(this.exports.size());
        this.exports.add(export);
        if (oldPortInsts != null) {
            Iterator it = oldPortInsts.iterator();
            while (it.hasNext()) {
                PortInst pi = (PortInst)it.next();
                pi.getNodeInst().linkPortInst(pi);
            }
        } else {
            Iterator it = this.getInstancesOf();
            while (it.hasNext()) {
                NodeInst ni = (NodeInst)it.next();
                ni.addPortInst(export);
            }
        }
    }

    Collection removeExport(Export export) {
        int portIndex;
        this.checkChanging();
        this.exports.remove(portIndex);
        for (portIndex = export.getPortIndex(); portIndex < this.exports.size(); ++portIndex) {
            ((Export)this.exports.get(portIndex)).setPortIndex(portIndex);
        }
        ArrayList<PortInst> portInsts = new ArrayList<PortInst>();
        Iterator it = this.getInstancesOf();
        while (it.hasNext()) {
            NodeInst ni = (NodeInst)it.next();
            portInsts.add(ni.removePortInst(export));
        }
        export.setPortIndex(-1);
        return portInsts;
    }

    public PortProto findPortProto(String name) {
        if (name == null) {
            return null;
        }
        return this.findPortProto(Name.findName(name));
    }

    public PortProto findPortProto(Name name) {
        if (name == null) {
            return null;
        }
        name = name.lowerCase();
        for (int i = 0; i < this.exports.size(); ++i) {
            PortProto pp = (PortProto)this.exports.get(i);
            if (pp.getNameKey().lowerCase() != name) continue;
            return pp;
        }
        return null;
    }

    public boolean findPortProto(PortProto port) {
        for (int i = 0; i < this.exports.size(); ++i) {
            PortProto pp = (PortProto)this.exports.get(i);
            if (pp != port) continue;
            return true;
        }
        return false;
    }

    public Iterator getPorts() {
        return this.exports.iterator();
    }

    public int getNumPorts() {
        return this.exports.size();
    }

    public final PortProto getPort(int portIndex) {
        return (PortProto)this.exports.get(portIndex);
    }

    public Export findExport(String name) {
        return (Export)this.findPortProto(name);
    }

    public Export findExport(Name name) {
        return (Export)this.findPortProto(name);
    }

    public String getName() {
        return this.protoName;
    }

    public CellName getCellName() {
        return CellName.parseName(this.protoName + ";" + this.version + "{" + this.view.getAbbreviation() + "}");
    }

    public String describe() {
        String name = "";
        if (this.lib != Library.getCurrent()) {
            name = name + this.lib.getName() + ":";
        }
        name = name + this.noLibDescribe();
        return name;
    }

    public String libDescribe() {
        return this.lib.getName() + ":" + this.noLibDescribe();
    }

    public String noLibDescribe() {
        String name = this.protoName;
        if (this.getNewestVersion() != this) {
            name = name + ";" + this.version;
        }
        if (this.view != null) {
            name = name + "{" + this.view.getAbbreviation() + "}";
        }
        return name;
    }

    public static NodeProto findNodeProto(String line) {
        NodeProto np;
        String withoutPrefix;
        Technology tech = Technology.getCurrent();
        Library lib = Library.getCurrent();
        boolean saidtech = false;
        boolean saidlib = false;
        int colon = line.indexOf(58);
        if (colon == -1) {
            withoutPrefix = line;
        } else {
            Library l;
            String prefix = line.substring(0, colon);
            Technology t = Technology.findTechnology(prefix);
            if (t != null) {
                tech = t;
                saidtech = true;
            }
            if ((l = Library.findLibrary(prefix)) != null) {
                lib = l;
                saidlib = true;
            }
            withoutPrefix = line.substring(colon + 1);
        }
        if (!saidlib && (np = tech.findNodeProto(withoutPrefix)) != null) {
            return np;
        }
        if (!saidtech && (np = lib.findNodeProto(withoutPrefix)) != null) {
            return np;
        }
        return null;
    }

    public String[] getTextViewContents() {
        String[] strings = TextWindow.getEditedText(this);
        if (strings != null) {
            return strings;
        }
        Variable var = this.getVar(CELL_TEXT_KEY);
        if (var == null) {
            return null;
        }
        Object obj = var.getObject();
        if (!(obj instanceof String[])) {
            return null;
        }
        return (String[])obj;
    }

    public void setTextViewContents(String[] strings) {
        Job.checkChanging();
        TextWindow.updateText(this, strings);
        this.newVar(CELL_TEXT_KEY, (Object)strings);
    }

    public Poly[] getAllText(boolean hardToSelect, EditWindow wnd) {
        int dispVars = this.numDisplayableVariables(false);
        if (dispVars == 0) {
            return null;
        }
        Poly[] polys = new Poly[dispVars];
        this.addDisplayableVariables(CENTERRECT, polys, 0, wnd, false);
        return polys;
    }

    public Rectangle2D getRelativeTextBounds(EditWindow wnd) {
        Rectangle2D bounds = null;
        Iterator it = this.getNodes();
        while (it.hasNext()) {
            NodeInst ni = (NodeInst)it.next();
            bounds = this.accumulateTextBoundsOnObject(ni, bounds, wnd);
            Iterator pIt = ni.getPortInsts();
            while (pIt.hasNext()) {
                PortInst pi = (PortInst)pIt.next();
                bounds = this.accumulateTextBoundsOnObject(pi, bounds, wnd);
            }
        }
        it = this.getArcs();
        while (it.hasNext()) {
            ArcInst ai = (ArcInst)it.next();
            bounds = this.accumulateTextBoundsOnObject(ai, bounds, wnd);
        }
        it = this.getPorts();
        while (it.hasNext()) {
            Export pp = (Export)it.next();
            bounds = this.accumulateTextBoundsOnObject(pp, bounds, wnd);
        }
        bounds = this.accumulateTextBoundsOnObject(this, bounds, wnd);
        return bounds;
    }

    private Rectangle2D accumulateTextBoundsOnObject(ElectricObject eObj, Rectangle2D bounds, EditWindow wnd) {
        Poly poly;
        Geometric geom;
        Name name;
        Rectangle2D polyBound;
        Poly poly2;
        Iterator vIt = eObj.getVariables();
        while (vIt.hasNext()) {
            TextDescriptor td;
            Variable var = (Variable)vIt.next();
            if (!var.isDisplay() || (td = var.getTextDescriptor()).getSize().isAbsolute() || (poly2 = eObj.computeTextPoly(wnd, var, null)) == null) continue;
            polyBound = poly2.getBounds2D();
            if (bounds == null) {
                bounds = polyBound;
                continue;
            }
            Rectangle2D.union(bounds, polyBound, bounds);
        }
        if (eObj instanceof Geometric && !(name = (geom = (Geometric)eObj).getNameKey()).isTempname() && (poly = eObj.computeTextPoly(wnd, null, name)) != null) {
            Rectangle2D polyBound2 = poly.getBounds2D();
            if (bounds == null) {
                bounds = polyBound2;
            } else {
                Rectangle2D.union(bounds, polyBound2, bounds);
            }
        }
        if (eObj instanceof NodeInst) {
            NodeInst ni = (NodeInst)eObj;
            Iterator it = ni.getExports();
            while (it.hasNext()) {
                Export pp = (Export)it.next();
                poly2 = pp.computeTextPoly(wnd, null, null);
                if (poly2 == null) continue;
                polyBound = poly2.getBounds2D();
                if (bounds == null) {
                    bounds = polyBound;
                    continue;
                }
                Rectangle2D.union(bounds, polyBound, bounds);
            }
        }
        return bounds;
    }

    public Name getBasename() {
        return this.basename;
    }

    public Name getAutoname(Name basename) {
        MaxSuffix ms = (MaxSuffix)this.maxSuffix.get(basename);
        if (ms == null) {
            ms = new MaxSuffix();
            this.maxSuffix.put(basename.lowerCase(), ms);
            return basename.findSuffixed(0);
        }
        ++ms.v;
        return basename.findSuffixed(ms.v);
    }

    public void addTempName(Geometric geom) {
        Name name = geom.getNameKey();
        if (!name.isTempname()) {
            return;
        }
        this.tempNames.put(name.lowerCase(), geom);
        Name basename = name.getBasename();
        if (basename != null && basename != name) {
            int numSuffix;
            MaxSuffix ms = (MaxSuffix)this.maxSuffix.get(basename = basename.lowerCase());
            if (ms == null) {
                ms = new MaxSuffix();
                this.maxSuffix.put(basename, ms);
            }
            if ((numSuffix = name.getNumSuffix()) > ms.v) {
                ms.v = numSuffix;
            }
        }
    }

    public void removeTempName(Geometric geom) {
        Name name = geom.getNameKey();
        if (!name.isTempname()) {
            return;
        }
        this.tempNames.remove(name.lowerCase());
    }

    public boolean hasTempName(Name name) {
        return this.tempNames.get(name) != null;
    }

    public int getUniqueNameIndex(String prefix, Class cls, int startingIndex) {
        int uniqueIndex;
        block4: {
            int len;
            block5: {
                block3: {
                    len = prefix.length();
                    uniqueIndex = startingIndex;
                    if (cls != PortProto.class) break block3;
                    Iterator it = this.getPorts();
                    while (it.hasNext()) {
                        int indexVal;
                        String restOfName;
                        PortProto pp = (PortProto)it.next();
                        if (!pp.getName().startsWith(prefix) || !TextUtils.isANumber(restOfName = pp.getName().substring(len)) || (indexVal = TextUtils.atoi(restOfName)) < uniqueIndex) continue;
                        uniqueIndex = indexVal + 1;
                    }
                    break block4;
                }
                if (cls != NodeInst.class) break block5;
                Iterator it = this.getNodes();
                while (it.hasNext()) {
                    int indexVal;
                    String restOfName;
                    NodeInst ni = (NodeInst)it.next();
                    if (!ni.getName().startsWith(prefix) || !TextUtils.isANumber(restOfName = ni.getName().substring(len)) || (indexVal = TextUtils.atoi(restOfName)) < uniqueIndex) continue;
                    uniqueIndex = indexVal + 1;
                }
                break block4;
            }
            if (cls != ArcInst.class) break block4;
            Iterator it = this.getArcs();
            while (it.hasNext()) {
                int indexVal;
                String restOfName;
                ArcInst ai = (ArcInst)it.next();
                if (!ai.getName().startsWith(prefix) || !TextUtils.isANumber(restOfName = ai.getName().substring(len)) || (indexVal = TextUtils.atoi(restOfName)) < uniqueIndex) continue;
                uniqueIndex = indexVal + 1;
            }
        }
        return uniqueIndex;
    }

    public boolean isUniqueName(String name, Class cls, ElectricObject exclude) {
        return this.isUniqueName(Name.findName(name), cls, exclude);
    }

    public boolean isUniqueName(Name name, Class cls, ElectricObject exclude) {
        name = name.lowerCase();
        if (cls == PortProto.class) {
            Export pp = this.findExport(name);
            return pp == null || exclude == pp;
        }
        if (cls == NodeInst.class) {
            if (name.isTempname()) {
                Geometric geom = (Geometric)this.tempNames.get(name);
                return geom == null || exclude == geom;
            }
            Iterator it = this.getNodes();
            while (it.hasNext()) {
                Name nodeName;
                NodeInst ni = (NodeInst)it.next();
                if (exclude == ni || name != (nodeName = ni.getNameKey()).lowerCase()) continue;
                return false;
            }
            return true;
        }
        if (cls == ArcInst.class) {
            if (name.isTempname()) {
                Geometric geom = (Geometric)this.tempNames.get(name);
                return geom == null || exclude == geom;
            }
            Iterator it = this.getArcs();
            while (it.hasNext()) {
                Name arcName;
                ArcInst ai = (ArcInst)it.next();
                if (exclude == ai || name != (arcName = ai.getNameKey()).lowerCase()) continue;
                return false;
            }
            return true;
        }
        return true;
    }

    public boolean isDeprecatedVariable(Variable.Key key) {
        String name = key.getName();
        if (name.equals("NET_last_good_ncc") || name.equals("NET_last_good_ncc_facet") || name.equals("SIM_window_signal_order")) {
            return true;
        }
        return super.isDeprecatedVariable(key);
    }

    public String toString() {
        return "Cell " + this.describe();
    }

    public Iterator getUsagesOf() {
        return this.usagesOf.iterator();
    }

    public Iterator getInstancesOf() {
        return new NodeInstsIterator();
    }

    public static boolean isInstantiationRecursive(Cell toInstantiate, Cell parent) {
        if (toInstantiate == parent) {
            return true;
        }
        if (toInstantiate.isIconOf(parent) && toInstantiate.isIcon() && !parent.isIcon()) {
            return false;
        }
        return parent.isAChildOf(toInstantiate);
    }

    public boolean isAChildOf(Cell parent) {
        return this.getIsAChildOf(parent, new HashMap());
    }

    private boolean getIsAChildOf(Cell parent, Map checkedParents) {
        Cell c;
        if (parent.isIcon() && (c = parent.contentsView()) != null && c != parent && this.getIsAChildOf(c, checkedParents)) {
            return true;
        }
        if (checkedParents.get(parent) != null) {
            return false;
        }
        checkedParents.put(parent, parent);
        Cell contentView = this.contentsView();
        if (contentView == null) {
            contentView = this;
        }
        Cell iconView = this.iconView();
        Iterator it = parent.getNodes();
        while (it.hasNext()) {
            Cell c2;
            NodeInst ni = (NodeInst)it.next();
            NodeProto np = ni.getProto();
            if (!(np instanceof Cell) || (c2 = (Cell)np).isIconOf(parent)) continue;
            if (c2 == contentView) {
                return true;
            }
            if (c2 == iconView) {
                return true;
            }
            if (!this.getIsAChildOf(c2, checkedParents)) continue;
            return true;
        }
        return false;
    }

    private boolean getIsAParentOf(Cell child) {
        if (this == child) {
            return true;
        }
        Cell lastParent = null;
        Iterator it = child.getInstancesOf();
        while (it.hasNext()) {
            NodeInst ni = (NodeInst)it.next();
            if (ni.getParent() == lastParent) continue;
            lastParent = ni.getParent();
            if (!this.getIsAParentOf(ni.getParent())) continue;
            return true;
        }
        Cell np = child.iconView();
        if (np != null) {
            lastParent = null;
            Iterator it2 = np.getInstancesOf();
            while (it2.hasNext()) {
                NodeInst ni = (NodeInst)it2.next();
                if (ni.getParent() == lastParent) continue;
                lastParent = ni.getParent();
                NodeProto niProto = ni.getProto();
                if (niProto instanceof Cell && ((Cell)niProto).isIconOf(child) && !child.isIcon() || !this.getIsAParentOf(ni.getParent())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isInUse(String action) {
        String parents = null;
        Iterator it = this.getUsagesOf();
        while (it.hasNext()) {
            NodeUsage nu = (NodeUsage)it.next();
            Cell parent = nu.getParent();
            if (parents == null) {
                parents = parent.describe();
                continue;
            }
            parents = parents + ", " + parent.describe();
        }
        if (parents != null) {
            JOptionPane.showMessageDialog(TopLevel.getCurrentJFrame(), "Cannot " + action + " cell " + this.describe() + " because it is used in " + parents, action + " failed", 0);
            return true;
        }
        return false;
    }

    public Cell makeNewVersion() {
        Cell newVersion = Cell.copyNodeProto(this, this.lib, this.noLibDescribe(), false);
        return newVersion;
    }

    public int getVersion() {
        return this.version;
    }

    public int getNumVersions() {
        if (this.versionGroup == null) {
            return 1;
        }
        return this.versionGroup.size();
    }

    public Iterator getVersions() {
        if (this.versionGroup == null) {
            VersionGroup vg = new VersionGroup();
            vg.add(this);
            return vg.iterator();
        }
        return this.versionGroup.iterator();
    }

    public Cell getNewestVersion() {
        return (Cell)this.getVersions().next();
    }

    public void setVersionGroup(VersionGroup versionGroup) {
        this.versionGroup = versionGroup;
    }

    public void joinGroup(Cell otherCell) {
        this.setCellGroup(otherCell.getCellGroup());
    }

    public CellGroup getCellGroup() {
        return this.cellGroup;
    }

    public void putInOwnCellGroup() {
        if (this.cellGroup != null && this.cellGroup.getNumCells() == 1) {
            return;
        }
        CellGroup newGroup = new CellGroup();
        this.setCellGroup(newGroup);
    }

    public void setCellGroup(CellGroup cellGroup) {
        CellGroup oldGroup = this.cellGroup;
        Iterator it = this.getVersions();
        while (it.hasNext()) {
            Cell cell = (Cell)it.next();
            cell.lowLevelSetCellGroup(cellGroup);
            Undo.modifyCellGroup(cell, oldGroup);
        }
    }

    public void lowLevelSetCellGroup(CellGroup cellGroup) {
        this.checkChanging();
        if (cellGroup == null) {
            Exception e = new Exception("Cannot set CellGroup to NULL!");
            ActivityLogger.logException(e);
        }
        if (this.cellGroup == cellGroup) {
            return;
        }
        if (this.cellGroup != null) {
            this.cellGroup.remove(this);
        }
        this.cellGroup = cellGroup;
        if (cellGroup != null) {
            cellGroup.add(this);
        }
    }

    public View getView() {
        return this.view;
    }

    public void setView(View newView) {
        if (newView == this.view) {
            return;
        }
        this.lowLevelUnlink();
        int newVersion = this.version;
        Iterator it = this.lib.getCells();
        while (it.hasNext()) {
            Cell other = (Cell)it.next();
            if (other.view != newView || !other.protoName.equalsIgnoreCase(this.protoName) || other.version < newVersion) continue;
            newVersion = other.version + 1;
        }
        this.view = newView;
        this.version = newVersion;
        this.lowLevelLink();
    }

    public boolean isIcon() {
        return this.view == View.ICON;
    }

    public boolean isIconOf(Cell cell) {
        return this.view == View.ICON && this.cellGroup == cell.cellGroup && cell.isSchematic();
    }

    public boolean isMultiPartIcon() {
        return false;
    }

    public boolean isSchematic() {
        return this.getView() == View.SCHEMATIC;
    }

    public int getNumMultiPages() {
        Integer storedCount;
        if (!this.isMultiPage()) {
            return 1;
        }
        Rectangle2D bounds = this.getBounds();
        int numPages = (int)(bounds.getHeight() / 1000.0) + 1;
        Variable var = this.getVar(MULTIPAGE_COUNT_KEY, Integer.class);
        if (var != null && (storedCount = (Integer)var.getObject()) > numPages) {
            numPages = storedCount;
        }
        return numPages;
    }

    public Cell contentsView() {
        Cell cellInGroup;
        if (!this.isIcon() && this.getView() != View.LAYOUTSKEL) {
            return null;
        }
        Iterator it = this.getCellGroup().getCells();
        while (it.hasNext()) {
            cellInGroup = (Cell)it.next();
            if (!cellInGroup.isSchematic()) continue;
            return cellInGroup;
        }
        it = this.getCellGroup().getCells();
        while (it.hasNext()) {
            cellInGroup = (Cell)it.next();
            if (cellInGroup.getView() != View.LAYOUT) continue;
            return cellInGroup;
        }
        it = this.getCellGroup().getCells();
        while (it.hasNext()) {
            cellInGroup = (Cell)it.next();
            if (cellInGroup.getView() != View.UNKNOWN) continue;
            return cellInGroup;
        }
        return null;
    }

    public Cell iconView() {
        if (!this.isSchematic()) {
            return null;
        }
        Iterator it = this.getCellGroup().getCells();
        while (it.hasNext()) {
            Cell cellInGroup = (Cell)it.next();
            if (!cellInGroup.isIcon()) continue;
            return cellInGroup;
        }
        return null;
    }

    public Cell otherView(View view) {
        Iterator it = this.getCellGroup().getCells();
        while (it.hasNext()) {
            Cell cellInGroup = (Cell)it.next();
            if (cellInGroup.getView() != view) continue;
            return cellInGroup.getNewestVersion();
        }
        return null;
    }

    public Netlist getNetlist(boolean shortResistors) {
        return NetworkTool.getNetlist(this, shortResistors);
    }

    public Netlist getUserNetlist() {
        return NetworkTool.getUserNetlist(this);
    }

    public Netlist acquireUserNetlist() {
        return NetworkTool.acquireUserNetlist(this);
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public void lowLevelSetCreationDate(Date creationDate) {
        this.checkChanging();
        this.creationDate = creationDate;
    }

    public Date getRevisionDate() {
        return this.revisionDate;
    }

    public void lowLevelSetRevisionDate(Date revisionDate) {
        this.checkChanging();
        this.revisionDate = revisionDate;
    }

    public void madeRevision() {
        this.checkChanging();
        this.revisionDate = new Date();
    }

    public void checkCellDates() {
        HashSet cellsChecked = new HashSet();
        this.checkCellDate(this.getRevisionDate(), cellsChecked);
    }

    private void checkCellDate(Date rev_time, HashSet cellsChecked) {
        Iterator it = this.getNodes();
        while (it.hasNext()) {
            Cell contentsCell;
            Cell subCell;
            NodeInst ni = (NodeInst)it.next();
            NodeProto np = ni.getProto();
            if (!(np instanceof Cell) || (subCell = (Cell)np).isIconOf(this)) continue;
            if (!cellsChecked.contains(subCell)) {
                subCell.checkCellDate(rev_time, cellsChecked);
            }
            if ((contentsCell = subCell.contentsView()) == null || cellsChecked.contains(contentsCell)) continue;
            contentsCell.checkCellDate(rev_time, cellsChecked);
        }
        cellsChecked.add(this);
        if (!this.getRevisionDate().after(rev_time)) {
            return;
        }
        System.out.println("WARNING: sub-cell " + this.describe() + " has been edited since the last revision to the current cell");
    }

    public void setWantExpanded() {
        this.checkChanging();
        this.userBits |= 2;
    }

    public void clearWantExpanded() {
        this.checkChanging();
        this.userBits &= 0xFFFFFFFD;
    }

    public boolean isWantExpanded() {
        return (this.userBits & 2) != 0;
    }

    public PrimitiveNode.Function getFunction() {
        return PrimitiveNode.Function.UNKNOWN;
    }

    public void setAllLocked() {
        this.checkChanging();
        this.userBits |= 0x100000;
    }

    public void clearAllLocked() {
        this.checkChanging();
        this.userBits &= 0xFFEFFFFF;
    }

    public boolean isAllLocked() {
        return (this.userBits & 0x100000) != 0;
    }

    public void setInstancesLocked() {
        this.checkChanging();
        this.userBits |= 0x200000;
    }

    public void clearInstancesLocked() {
        this.checkChanging();
        this.userBits &= 0xFFDFFFFF;
    }

    public boolean isInstancesLocked() {
        return (this.userBits & 0x200000) != 0;
    }

    public void setInCellLibrary() {
        this.checkChanging();
        this.userBits |= 0x400000;
    }

    public void clearInCellLibrary() {
        this.checkChanging();
        this.userBits &= 0xFFBFFFFF;
    }

    public boolean isInCellLibrary() {
        return (this.userBits & 0x400000) != 0;
    }

    public void setInTechnologyLibrary() {
        this.checkChanging();
        this.userBits |= 0x800000;
    }

    public void clearInTechnologyLibrary() {
        this.checkChanging();
        this.userBits &= 0xFF7FFFFF;
    }

    public boolean isInTechnologyLibrary() {
        return (this.userBits & 0x800000) != 0;
    }

    public void setMultiPage(boolean multi) {
        this.checkChanging();
        this.userBits = multi ? (this.userBits |= 0x7E000000) : (this.userBits &= 0x81FFFFFF);
    }

    public boolean isMultiPage() {
        return (this.userBits & 0x7E000000) != 0;
    }

    public boolean isActuallyLinked() {
        return this.lib != null && this.lib.isActuallyLinked() && this.lib.contains(this);
    }

    public int checkAndRepair(boolean repair, ErrorLogger errorLogger) {
        String msg;
        ArcInst ai;
        int errorCount = 0;
        for (int i = 0; i < this.exports.size(); ++i) {
            Export pp = (Export)this.exports.get(i);
            if (pp.getPortIndex() == i) continue;
            String msg2 = this + ", " + pp + " has wrong index";
            System.out.println(msg2);
            if (errorLogger != null) {
                ErrorLogger.MessageLog error = errorLogger.logError(msg2, this, 1);
                error.addExport(pp, true, this, null);
            }
            ++errorCount;
        }
        HashMap<Connection, ArcInst> connections = new HashMap<Connection, ArcInst>();
        Iterator it = this.getArcs();
        while (it.hasNext()) {
            ErrorLogger.MessageLog error;
            String msg3;
            ai = (ArcInst)it.next();
            errorCount += ai.checkAndRepair(repair, errorLogger);
            ArcInst otherAi = (ArcInst)connections.get(ai.getHead());
            if (otherAi != null) {
                msg3 = "Cell " + this.describe() + ", Arc " + ai.describe() + ": head connection already on other arc " + otherAi.describe();
                System.out.println(msg3);
                if (errorLogger != null) {
                    error = errorLogger.logError(msg3, this, 1);
                    error.addGeom(ai, true, this, null);
                    error.addGeom(otherAi, true, this, null);
                }
                ++errorCount;
            } else {
                connections.put(ai.getHead(), ai);
            }
            otherAi = (ArcInst)connections.get(ai.getTail());
            if (otherAi != null) {
                msg3 = "Cell " + this.describe() + ", Arc " + ai.describe() + ": tail connection already on other arc " + otherAi.describe();
                System.out.println(msg3);
                if (errorLogger != null) {
                    error = errorLogger.logError(msg3, this, 1);
                    error.addGeom(ai, true, this, null);
                    error.addGeom(otherAi, true, this, null);
                }
                ++errorCount;
                continue;
            }
            connections.put(ai.getTail(), ai);
        }
        it = this.getNodes();
        while (it.hasNext()) {
            NodeInst ni = (NodeInst)it.next();
            errorCount += ni.checkAndRepair(repair, errorLogger);
            Iterator pIt = ni.getConnections();
            while (pIt.hasNext()) {
                Connection con = (Connection)pIt.next();
                ArcInst ai2 = (ArcInst)connections.get(con);
                if (ai2 == null) {
                    String msg4 = "Cell " + this.describe() + ", Node " + ni.describe() + ": has connection to unknown arc: " + con.getArc().describe() + " (node has " + ni.getNumConnections() + " connections)";
                    System.out.println(msg4);
                    if (errorLogger != null) {
                        ErrorLogger.MessageLog error = errorLogger.logError(msg4, this, 1);
                        error.addGeom(ni, true, this, null);
                    }
                    ++errorCount;
                    continue;
                }
                connections.put(con, null);
            }
        }
        it = connections.values().iterator();
        while (it.hasNext()) {
            ai = (ArcInst)it.next();
            if (ai == null) continue;
            String msg5 = "Cell " + this.describe() + ", Arc " + ai.describe() + ": connection is not on any node";
            System.out.println(msg5);
            if (errorLogger != null) {
                ErrorLogger.MessageLog error = errorLogger.logError(msg5, this, 1);
                error.addGeom(ai, true, this, null);
            }
            ++errorCount;
        }
        it = this.getUsagesIn();
        while (it.hasNext()) {
            NodeUsage nu = (NodeUsage)it.next();
            errorCount += nu.checkAndRepair(errorLogger);
        }
        if (this.versionGroup == null) {
            msg = "Cell " + this.describe() + ", Version group is null";
            System.out.println(msg);
            if (errorLogger != null) {
                errorLogger.logError(msg, this, 1);
            }
            ++errorCount;
        }
        if (this.cellGroup == null) {
            msg = "Cell " + this.describe() + ", Cell group is null";
            System.out.println(msg);
            if (errorLogger != null) {
                errorLogger.logError(msg, this, 1);
            }
            ++errorCount;
        }
        return errorCount;
    }

    public boolean objInCell(ElectricObject eObj) {
        block4: {
            block5: {
                block3: {
                    if (!(eObj instanceof NodeInst)) break block3;
                    Iterator it = this.getNodes();
                    while (it.hasNext()) {
                        if ((ElectricObject)it.next() != eObj) continue;
                        return true;
                    }
                    break block4;
                }
                if (!(eObj instanceof ArcInst)) break block5;
                Iterator it = this.getArcs();
                while (it.hasNext()) {
                    if ((ElectricObject)it.next() != eObj) continue;
                    return true;
                }
                break block4;
            }
            if (!(eObj instanceof PortInst)) break block4;
            NodeInst ni = ((PortInst)eObj).getNodeInst();
            Iterator it = this.getNodes();
            while (it.hasNext()) {
                if ((ElectricObject)it.next() != ni) continue;
                return true;
            }
        }
        return false;
    }

    public void setChangeLock() {
    }

    public final int getCellIndex() {
        return this.cellIndex;
    }

    public static int getCellNumber() {
        return cellNumber;
    }

    public void setTempInt(int tempInt) {
        this.checkChanging();
        this.tempInt = tempInt;
    }

    public int getTempInt() {
        return this.tempInt;
    }

    public static FlagSet getFlagSet(int numBits) {
        return FlagSet.getFlagSet(flagGenerator, numBits);
    }

    public void setBit(FlagSet set) {
        this.flagBits |= set.getMask();
    }

    public void clearBit(FlagSet set) {
        this.flagBits &= set.getUnmask();
    }

    public boolean isBit(FlagSet set) {
        return (this.flagBits & set.getMask()) != 0;
    }

    public void setChange(Undo.Change change) {
        this.checkChanging();
        this.change = change;
    }

    public Undo.Change getChange() {
        return this.change;
    }

    public Cell whichCell() {
        return this;
    }

    public Library getLibrary() {
        return this.lib;
    }

    public Technology getTechnology() {
        if (this.tech == null) {
            this.tech = Technology.whatTechnology(this, null, 0, 0, null, 0, 0);
        }
        return this.tech;
    }

    public void setTechnology(Technology tech) {
        if (this instanceof Cell) {
            this.tech = tech;
        }
    }

    public Cell getEquivalent() {
        return this.isIcon() ? this.cellGroup.getMainSchematics() : this;
    }

    public boolean containsInstance(Geometric thing) {
        if (thing instanceof ArcInst) {
            return this.arcs.contains(thing);
        }
        if (thing instanceof NodeInst) {
            NodeInst ni = (NodeInst)thing;
            NodeUsage nu = (NodeUsage)this.usagesIn.get(ni.getProto());
            return nu != null && nu.contains(ni);
        }
        return false;
    }

    public boolean compare(Object obj, StringBuffer buffer) {
        Iterator i;
        boolean found;
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Cell toCompare = (Cell)obj;
        HashSet<Object> noCheckAgain = new HashSet<Object>();
        Iterator it = this.getNodes();
        while (it.hasNext()) {
            found = false;
            NodeInst node = (NodeInst)it.next();
            i = toCompare.getNodes();
            while (i.hasNext()) {
                NodeInst n = (NodeInst)i.next();
                if (noCheckAgain.contains(n) || !node.compare(n, buffer)) continue;
                found = true;
                noCheckAgain.add(n);
                break;
            }
            if (found) continue;
            if (buffer != null) {
                buffer.append("No corresponding node '" + node + "' found in '" + toCompare + "'\n");
            }
            return false;
        }
        if (this.getNumNodes() != toCompare.getNumNodes()) {
            if (buffer != null) {
                buffer.append("Cell '" + toCompare.libDescribe() + "' has more nodes than '" + this + "'\n");
            }
            return false;
        }
        it = this.getArcs();
        while (it.hasNext()) {
            found = false;
            ArcInst arc = (ArcInst)it.next();
            i = toCompare.getArcs();
            while (i.hasNext()) {
                ArcInst a = (ArcInst)i.next();
                if (noCheckAgain.contains(a) || !arc.compare(a, buffer)) continue;
                found = true;
                noCheckAgain.add(a);
                break;
            }
            if (found) continue;
            if (buffer != null) {
                buffer.append("No corresponding arc '" + arc + "' found in other cell" + "\n");
            }
            return false;
        }
        if (this.getNumArcs() != toCompare.getNumArcs()) {
            if (buffer != null) {
                buffer.append("Cell '" + toCompare.libDescribe() + "' has more arcs than '" + this + "'\n");
            }
            return false;
        }
        noCheckAgain.clear();
        it = this.getPorts();
        while (it.hasNext()) {
            found = false;
            Export port = (Export)it.next();
            i = toCompare.getPorts();
            while (i.hasNext()) {
                Export p = (Export)i.next();
                if (noCheckAgain.contains(p) || !port.compare(p, buffer)) continue;
                found = true;
                noCheckAgain.add(p);
                break;
            }
            if (found) continue;
            if (buffer != null) {
                buffer.append("No corresponding port '" + port.getName() + "' found in other cell" + "\n");
            }
            return false;
        }
        if (this.getNumPorts() != toCompare.getNumPorts()) {
            if (buffer != null) {
                buffer.append("Cell '" + toCompare.libDescribe() + "' has more pors than '" + this + "'\n");
            }
            return false;
        }
        noCheckAgain.clear();
        it = this.getVariables();
        while (it.hasNext()) {
            Variable var = (Variable)it.next();
            boolean found2 = false;
            i = toCompare.getVariables();
            while (i.hasNext()) {
                Variable v = (Variable)i.next();
                if (noCheckAgain.contains(v) || !var.compare(v, buffer)) continue;
                found2 = true;
                noCheckAgain.add(v);
                break;
            }
            if (found2) continue;
            if (buffer != null) {
                buffer.append("No corresponding variable '" + var + "' found in other cell" + "\n");
            }
            return false;
        }
        if (this.getNumVariables() != toCompare.getNumVariables()) {
            if (buffer != null) {
                buffer.append("Cell '" + toCompare + "' has more variables than '" + this + "'\n");
            }
            return false;
        }
        return true;
    }

    public int compareTo(Object obj) {
        if (this.equals(obj)) {
            return 0;
        }
        if (!(obj instanceof Cell)) {
            return -1;
        }
        Cell toCompare = (Cell)obj;
        Date toCompareDate = toCompare.getRevisionDate();
        return toCompareDate.compareTo(this.getRevisionDate());
    }

    public void getZValues(double[] array) {
        for (int i = 0; i < this.nodes.size(); ++i) {
            NodeInst ni = (NodeInst)this.nodes.get(i);
            NodeProto nProto = ni.getProto();
            if (nProto instanceof Cell) {
                Cell nCell = (Cell)nProto;
                nCell.getZValues(array);
                continue;
            }
            PrimitiveNode np = (PrimitiveNode)nProto;
            np.getZValues(array);
        }
    }

    public boolean findReferenceInCell(Library elib, Set set) {
        if (this.lib == elib) {
            return true;
        }
        int initial = set.size();
        for (int i = 0; i < this.nodes.size(); ++i) {
            NodeInst ni = (NodeInst)this.nodes.get(i);
            NodeProto nProto = ni.getProto();
            if (!(nProto instanceof Cell)) continue;
            Cell nCell = (Cell)nProto;
            if (nCell.getLibrary() == elib) {
                set.add(this);
                continue;
            }
            nCell.findReferenceInCell(elib, set);
        }
        return set.size() != initial;
    }

    private class NodeInstsIterator
    implements Iterator {
        private Iterator uit;
        private NodeUsage nu;
        private int i;
        private int n;

        NodeInstsIterator() {
            this.uit = Cell.this.getUsagesOf();
            this.n = 0;
            this.i = 0;
            while (this.i >= this.n && this.uit.hasNext()) {
                this.nu = (NodeUsage)this.uit.next();
                this.n = this.nu.getNumInsts();
            }
        }

        public boolean hasNext() {
            return this.i < this.n;
        }

        public Object next() {
            if (this.i >= this.n) {
                this.uit.next();
            }
            NodeInst ni = this.nu.getInst(this.i);
            ++this.i;
            while (this.i >= this.n && this.uit.hasNext()) {
                this.nu = (NodeUsage)this.uit.next();
                this.n = this.nu.getNumInsts();
                this.i = 0;
            }
            return ni;
        }

        public void remove() {
            throw new UnsupportedOperationException("NodeInstsIterator.remove()");
        }
    }

    public static class FrameDescription {
        public static final double MULTIPAGESEPARATION = 1000.0;
        private static final double FRAMESCALE = 18.0;
        private static final double HASCHXSIZE = 153.0;
        private static final double HASCHYSIZE = 99.0;
        private static final double ASCHXSIZE = 198.0;
        private static final double ASCHYSIZE = 153.0;
        private static final double BSCHXSIZE = 306.0;
        private static final double BSCHYSIZE = 198.0;
        private static final double CSCHXSIZE = 432.0;
        private static final double CSCHYSIZE = 306.0;
        private static final double DSCHXSIZE = 648.0;
        private static final double DSCHYSIZE = 432.0;
        private static final double ESCHXSIZE = 864.0;
        private static final double ESCHYSIZE = 648.0;
        private static final double FRAMEWID = 2.6999999999999997;
        private static final double XLOGOBOX = 36.0;
        private static final double YLOGOBOX = 18.0;
        private Cell cell;
        private List lineFromEnd;
        private List lineToEnd;
        private List textPoint;
        private List textSize;
        private List textBox;
        private List textMessage;
        private int pageNo;

        public FrameDescription(Cell cell, int pageNo) {
            this.cell = cell;
            this.pageNo = pageNo;
            this.lineFromEnd = new ArrayList();
            this.lineToEnd = new ArrayList();
            this.textPoint = new ArrayList();
            this.textSize = new ArrayList();
            this.textBox = new ArrayList();
            this.textMessage = new ArrayList();
            this.loadFrame();
        }

        public void renderInit() {
        }

        public void showFrameLine(Point2D from, Point2D to) {
        }

        public void showFrameText(Point2D ctr, double size, double maxWid, double maxHei, String string) {
        }

        public void renderFrame() {
            int i;
            double offY = 0.0;
            if (this.cell.isMultiPage()) {
                offY = (double)this.pageNo * 1000.0;
            }
            for (i = 0; i < this.lineFromEnd.size(); ++i) {
                Point2D from = (Point2D)this.lineFromEnd.get(i);
                Point2D to = (Point2D)this.lineToEnd.get(i);
                if (offY != 0.0) {
                    from = new Point2D.Double(from.getX(), from.getY() + offY);
                    to = new Point2D.Double(to.getX(), to.getY() + offY);
                }
                this.showFrameLine(from, to);
            }
            for (i = 0; i < this.textPoint.size(); ++i) {
                Point2D at = (Point2D)this.textPoint.get(i);
                if (offY != 0.0) {
                    at = new Point2D.Double(at.getX(), at.getY() + offY);
                }
                double size = (Double)this.textSize.get(i);
                Point2D box = (Point2D)this.textBox.get(i);
                double width = box.getX();
                double height = box.getY();
                String msg = (String)this.textMessage.get(i);
                this.showFrameText(at, size, width, height, msg);
            }
        }

        public static int getCellFrameInfo(Cell cell, Dimension d) {
            Variable var = cell.getVar(User.FRAME_SIZE, class$java$lang$String == null ? (class$java$lang$String = Cell.class$("java.lang.String")) : class$java$lang$String);
            if (var == null) {
                return 2;
            }
            String frameInfo = (String)var.getObject();
            if (frameInfo.length() == 0) {
                return 2;
            }
            int retval = 0;
            char chr = frameInfo.charAt(0);
            double wid = 0.0;
            double hei = 0.0;
            if (chr == 'x') {
                wid = 38.7;
                hei = 20.7;
                retval = 1;
            } else {
                switch (chr) {
                    case 'h': {
                        wid = 153.0;
                        hei = 99.0;
                        break;
                    }
                    case 'a': {
                        wid = 198.0;
                        hei = 153.0;
                        break;
                    }
                    case 'b': {
                        wid = 306.0;
                        hei = 198.0;
                        break;
                    }
                    case 'c': {
                        wid = 432.0;
                        hei = 306.0;
                        break;
                    }
                    case 'd': {
                        wid = 648.0;
                        hei = 432.0;
                        break;
                    }
                    case 'e': {
                        wid = 864.0;
                        hei = 648.0;
                    }
                }
            }
            if (frameInfo.indexOf("v") >= 0) {
                d.setSize(hei, wid);
            } else {
                d.setSize(wid, hei);
            }
            return retval;
        }

        private void loadFrame() {
            Dimension d = new Dimension();
            int frameFactor = FrameDescription.getCellFrameInfo(this.cell, d);
            if (frameFactor == 2) {
                return;
            }
            Variable var = this.cell.getVar(User.FRAME_SIZE, class$java$lang$String == null ? (class$java$lang$String = Cell.class$("java.lang.String")) : class$java$lang$String);
            if (var == null) {
                return;
            }
            String frameInfo = (String)var.getObject();
            double schXSize = d.getWidth();
            double schYSize = d.getHeight();
            boolean drawTitleBox = true;
            int xSections = 8;
            int ySections = 4;
            if (frameFactor == 1) {
                ySections = 0;
                xSections = 0;
            } else {
                if (frameInfo.indexOf("v") >= 0) {
                    xSections = 4;
                    ySections = 8;
                }
                if (frameInfo.indexOf("n") >= 0) {
                    drawTitleBox = false;
                }
            }
            double xLogoBox = 36.0;
            double yLogoBox = 18.0;
            double frameWid = 2.6999999999999997;
            if (xSections > 0) {
                char chr;
                int i;
                double xSecSize = (schXSize - frameWid * 2.0) / (double)xSections;
                double ySecSize = (schYSize - frameWid * 2.0) / (double)ySections;
                Point2D.Double point0 = new Point2D.Double(-schXSize / 2.0, -schYSize / 2.0);
                Point2D.Double point1 = new Point2D.Double(-schXSize / 2.0, schYSize / 2.0);
                Point2D.Double point2 = new Point2D.Double(schXSize / 2.0, schYSize / 2.0);
                Point2D.Double point3 = new Point2D.Double(schXSize / 2.0, -schYSize / 2.0);
                this.addLine(point0, point1);
                this.addLine(point1, point2);
                this.addLine(point2, point3);
                this.addLine(point3, point0);
                point0 = new Point2D.Double(-schXSize / 2.0 + frameWid, -schYSize / 2.0 + frameWid);
                point1 = new Point2D.Double(-schXSize / 2.0 + frameWid, schYSize / 2.0 - frameWid);
                point2 = new Point2D.Double(schXSize / 2.0 - frameWid, schYSize / 2.0 - frameWid);
                point3 = new Point2D.Double(schXSize / 2.0 - frameWid, -schYSize / 2.0 + frameWid);
                this.addLine(point0, point1);
                this.addLine(point1, point2);
                this.addLine(point2, point3);
                this.addLine(point3, point0);
                for (i = 0; i < xSections; ++i) {
                    double x = (double)i * xSecSize - (schXSize / 2.0 - frameWid);
                    if (i > 0) {
                        point0 = new Point2D.Double(x, schYSize / 2.0 - frameWid);
                        point1 = new Point2D.Double(x, schYSize / 2.0 - frameWid / 2.0);
                        this.addLine(point0, point1);
                        point0 = new Point2D.Double(x, -schYSize / 2.0 + frameWid);
                        point1 = new Point2D.Double(x, -schYSize / 2.0 + frameWid / 2.0);
                        this.addLine(point0, point1);
                    }
                    chr = (char)(49 + xSections - i - 1);
                    point0 = new Point2D.Double(x + xSecSize / 2.0, schYSize / 2.0 - frameWid / 2.0);
                    this.addText(point0, frameWid, 0.0, 0.0, String.valueOf(chr));
                    point0 = new Point2D.Double(x + xSecSize / 2.0, -schYSize / 2.0 + frameWid / 2.0);
                    this.addText(point0, frameWid, 0.0, 0.0, String.valueOf(chr));
                }
                for (i = 0; i < ySections; ++i) {
                    double y = (double)i * ySecSize - (schYSize / 2.0 - frameWid);
                    if (i > 0) {
                        point0 = new Point2D.Double(schXSize / 2.0 - frameWid, y);
                        point1 = new Point2D.Double(schXSize / 2.0 - frameWid / 2.0, y);
                        this.addLine(point0, point1);
                        point0 = new Point2D.Double(-schXSize / 2.0 + frameWid, y);
                        point1 = new Point2D.Double(-schXSize / 2.0 + frameWid / 2.0, y);
                        this.addLine(point0, point1);
                    }
                    chr = (char)(65 + i);
                    point0 = new Point2D.Double(schXSize / 2.0 - frameWid / 2.0, y + ySecSize / 2.0);
                    this.addText(point0, frameWid, 0.0, 0.0, String.valueOf(chr));
                    point0 = new Point2D.Double(-schXSize / 2.0 + frameWid / 2.0, y + ySecSize / 2.0);
                    this.addText(point0, frameWid, 0.0, 0.0, String.valueOf(chr));
                }
            }
            if (drawTitleBox) {
                Point2D.Double point0 = new Point2D.Double(schXSize / 2.0 - frameWid - xLogoBox, -schYSize / 2.0 + frameWid + yLogoBox);
                Point2D.Double point1 = new Point2D.Double(schXSize / 2.0 - frameWid, -schYSize / 2.0 + frameWid + yLogoBox);
                Point2D.Double point2 = new Point2D.Double(schXSize / 2.0 - frameWid, -schYSize / 2.0 + frameWid);
                Point2D.Double point3 = new Point2D.Double(schXSize / 2.0 - frameWid - xLogoBox, -schYSize / 2.0 + frameWid);
                this.addLine(point0, point1);
                this.addLine(point1, point2);
                this.addLine(point2, point3);
                this.addLine(point3, point0);
                point0 = new Point2D.Double(schXSize / 2.0 - frameWid - xLogoBox, -schYSize / 2.0 + frameWid + yLogoBox * 2.0 / 15.0);
                point1 = new Point2D.Double(schXSize / 2.0 - frameWid, -schYSize / 2.0 + frameWid + yLogoBox * 2.0 / 15.0);
                this.addLine(point0, point1);
                point0 = new Point2D.Double(schXSize / 2.0 - frameWid - xLogoBox, -schYSize / 2.0 + frameWid + yLogoBox * 4.0 / 15.0);
                point1 = new Point2D.Double(schXSize / 2.0 - frameWid, -schYSize / 2.0 + frameWid + yLogoBox * 4.0 / 15.0);
                this.addLine(point0, point1);
                point0 = new Point2D.Double(schXSize / 2.0 - frameWid - xLogoBox, -schYSize / 2.0 + frameWid + yLogoBox * 6.0 / 15.0);
                point1 = new Point2D.Double(schXSize / 2.0 - frameWid, -schYSize / 2.0 + frameWid + yLogoBox * 6.0 / 15.0);
                this.addLine(point0, point1);
                point0 = new Point2D.Double(schXSize / 2.0 - frameWid - xLogoBox, -schYSize / 2.0 + frameWid + yLogoBox * 9.0 / 15.0);
                point1 = new Point2D.Double(schXSize / 2.0 - frameWid, -schYSize / 2.0 + frameWid + yLogoBox * 9.0 / 15.0);
                this.addLine(point0, point1);
                point0 = new Point2D.Double(schXSize / 2.0 - frameWid - xLogoBox, -schYSize / 2.0 + frameWid + yLogoBox * 12.0 / 15.0);
                point1 = new Point2D.Double(schXSize / 2.0 - frameWid, -schYSize / 2.0 + frameWid + yLogoBox * 12.0 / 15.0);
                this.addLine(point0, point1);
                point0 = new Point2D.Double(schXSize / 2.0 - frameWid - xLogoBox / 2.0, -schYSize / 2.0 + frameWid + yLogoBox * 13.5 / 15.0);
                this.addText(point0, yLogoBox * 2.0 / 15.0, xLogoBox, yLogoBox * 3.0 / 15.0, "Name: " + this.cell.describe() + (this.cell.isMultiPage() ? " Page " + (this.pageNo + 1) : ""));
                String projectName = User.getFrameProjectName();
                Variable pVar = this.cell.getLibrary().getVar(User.FRAME_PROJECT_NAME, class$java$lang$String == null ? (class$java$lang$String = Cell.class$("java.lang.String")) : class$java$lang$String);
                if (pVar != null) {
                    projectName = (String)pVar.getObject();
                }
                point0 = new Point2D.Double(schXSize / 2.0 - frameWid - xLogoBox / 2.0, -schYSize / 2.0 + frameWid + yLogoBox * 10.5 / 15.0);
                this.addText(point0, yLogoBox * 2.0 / 15.0, xLogoBox, yLogoBox * 3.0 / 15.0, projectName);
                String designerName = User.getFrameDesignerName();
                Variable dVar = this.cell.getLibrary().getVar(User.FRAME_DESIGNER_NAME, class$java$lang$String == null ? (class$java$lang$String = Cell.class$("java.lang.String")) : class$java$lang$String);
                if (dVar != null) {
                    designerName = (String)dVar.getObject();
                }
                if ((dVar = this.cell.getVar(User.FRAME_DESIGNER_NAME, class$java$lang$String == null ? (class$java$lang$String = Cell.class$("java.lang.String")) : class$java$lang$String)) != null) {
                    designerName = (String)dVar.getObject();
                }
                point0 = new Point2D.Double(schXSize / 2.0 - frameWid - xLogoBox / 2.0, -schYSize / 2.0 + frameWid + yLogoBox * 7.5 / 15.0);
                this.addText(point0, yLogoBox * 2.0 / 15.0, xLogoBox, yLogoBox * 3.0 / 15.0, designerName);
                String companyName = User.getFrameCompanyName();
                Variable cVar = this.cell.getLibrary().getVar(User.FRAME_COMPANY_NAME, class$java$lang$String == null ? (class$java$lang$String = Cell.class$("java.lang.String")) : class$java$lang$String);
                if (cVar != null) {
                    companyName = (String)cVar.getObject();
                }
                point0 = new Point2D.Double(schXSize / 2.0 - frameWid - xLogoBox / 2.0, -schYSize / 2.0 + frameWid + yLogoBox * 5.0 / 15.0);
                this.addText(point0, yLogoBox * 2.0 / 15.0, xLogoBox, yLogoBox * 2.0 / 15.0, companyName);
                point0 = new Point2D.Double(schXSize / 2.0 - frameWid - xLogoBox / 2.0, -schYSize / 2.0 + frameWid + yLogoBox * 3.0 / 15.0);
                this.addText(point0, yLogoBox * 2.0 / 15.0, xLogoBox, yLogoBox * 2.0 / 15.0, "Created: " + TextUtils.formatDate(this.cell.getCreationDate()));
                point0 = new Point2D.Double(schXSize / 2.0 - frameWid - xLogoBox / 2.0, -schYSize / 2.0 + frameWid + yLogoBox * 1.0 / 15.0);
                this.addText(point0, yLogoBox * 2.0 / 15.0, xLogoBox, yLogoBox * 2.0 / 15.0, "Revised: " + TextUtils.formatDate(this.cell.getRevisionDate()));
            }
        }

        private void addLine(Point2D from, Point2D to) {
            this.lineFromEnd.add(from);
            this.lineToEnd.add(to);
        }

        private void addText(Point2D at, double size, double width, double height, String msg) {
            this.textPoint.add(at);
            this.textSize.add(new Double(size));
            this.textBox.add(new Point2D.Double(width, height));
            this.textMessage.add(msg);
        }
    }

    private class MaxSuffix {
        int v = 0;

        private MaxSuffix() {
        }
    }

    private static class VersionGroup {
        private List versions = new ArrayList();

        public Cell add(Cell cell) {
            Cell formerNewestCell = null;
            if (this.versions.size() > 0) {
                formerNewestCell = (Cell)this.versions.iterator().next();
            }
            this.versions.add(cell);
            cell.setVersionGroup(this);
            Collections.sort(this.versions, new TextUtils.CellsByVersion());
            Cell newestCell = (Cell)this.versions.iterator().next();
            if (newestCell == formerNewestCell) {
                formerNewestCell = null;
            }
            return formerNewestCell;
        }

        public void remove(Cell cell) {
            this.versions.remove(cell);
        }

        public int size() {
            return this.versions.size();
        }

        public Iterator iterator() {
            return this.versions.iterator();
        }
    }

    public static class CellGroup {
        private ArrayList cells = new ArrayList();
        private Cell mainSchematic;
        private String groupName = null;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void add(Cell cell) {
            ArrayList arrayList = this.cells;
            synchronized (arrayList) {
                if (!this.cells.contains(cell)) {
                    this.cells.add(cell);
                }
            }
            this.groupName = null;
            cell.cellGroup = this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void remove(Cell f) {
            ArrayList arrayList = this.cells;
            synchronized (arrayList) {
                this.cells.remove(f);
                if (f == this.mainSchematic) {
                    this.mainSchematic = null;
                }
            }
            this.groupName = null;
        }

        public Iterator getCells() {
            return this.cells.iterator();
        }

        public int getNumCells() {
            return this.cells.size();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List getCellsSortedByView() {
            ArrayList sortedList = new ArrayList();
            ArrayList arrayList = this.cells;
            synchronized (arrayList) {
                Iterator it = this.cells.iterator();
                while (it.hasNext()) {
                    sortedList.add(it.next());
                }
            }
            Collections.sort(sortedList, new TextUtils.CellsByView());
            return sortedList;
        }

        public Cell getMainSchematics() {
            if (this.mainSchematic != null) {
                return this.mainSchematic.getNewestVersion();
            }
            Iterator it = this.getCells();
            while (it.hasNext()) {
                Cell c = (Cell)it.next();
                if (!c.isSchematic()) continue;
                this.mainSchematic = c.getNewestVersion();
                return this.mainSchematic;
            }
            return null;
        }

        public void setMainSchematics(Cell cell) {
            if (this.getMainSchematics() == cell) {
                return;
            }
            if (!cell.isSchematic() || cell.getNewestVersion() != cell) {
                System.out.println("Cell " + cell + ": cannot be main schematics");
                return;
            }
            this.mainSchematic = cell;
            Undo.modifyCellGroup(cell, this);
        }

        public boolean containsCell(Cell cell) {
            return this.cells.contains(cell);
        }

        public String toString() {
            return "CellGroup " + this.getName();
        }

        public String getName() {
            if (this.groupName != null) {
                return this.groupName;
            }
            Cell onlyCell = null;
            Iterator it = this.getCells();
            while (it.hasNext()) {
                Cell cell = (Cell)it.next();
                if (onlyCell == null) {
                    onlyCell = cell.getNewestVersion();
                    continue;
                }
                if (cell.getNewestVersion() == onlyCell) continue;
                onlyCell = null;
                break;
            }
            if (onlyCell != null) {
                this.groupName = onlyCell.describe();
                return this.groupName;
            }
            TreeSet<String> groupNames = new TreeSet<String>();
            int widestName = 0;
            Iterator it2 = this.getCells();
            while (it2.hasNext()) {
                Cell cell = (Cell)it2.next();
                String cellName = cell.getName();
                if (cellName.length() > widestName) {
                    widestName = cellName.length();
                }
                groupNames.add(cellName);
            }
            if (groupNames.size() == 1) {
                this.groupName = (String)groupNames.iterator().next();
                return this.groupName;
            }
            for (int i = widestName; i > widestName / 2; --i) {
                String lastName = null;
                boolean allSame = true;
                Iterator it3 = groupNames.iterator();
                while (it3.hasNext()) {
                    String oneName = (String)it3.next();
                    if (!(lastName == null || oneName.length() >= i && lastName.length() >= i && lastName.substring(0, i).equals(oneName.substring(0, i)))) {
                        allSame = false;
                        break;
                    }
                    lastName = oneName;
                }
                if (!allSame) continue;
                this.groupName = lastName.substring(0, i) + "*";
                return this.groupName;
            }
            Iterator it22 = groupNames.iterator();
            while (it22.hasNext()) {
                String oneName = (String)it22.next();
                if (this.groupName == null) {
                    this.groupName = oneName;
                    continue;
                }
                this.groupName = this.groupName + "," + oneName;
            }
            return this.groupName;
        }
    }
}

