/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.hierarchy;

import com.sun.electric.database.change.Undo;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.prototype.ArcProto;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.prototype.PortCharacteristic;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.text.Name;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.topology.Connection;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.PrimitivePort;
import com.sun.electric.tool.user.ViewChanges;
import com.sun.electric.tool.user.ui.EditWindow;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import java.util.Iterator;

public class Export
extends ElectricObject
implements PortProto {
    public static final Variable.Key EXPORT_REFERENCE_NAME;
    private static final int PORTDRAWN = 0x4000000;
    private static final int BODYONLY = 0x8000000;
    private static final int STATEBITS = -268435456;
    private static final int STATEBITSSHIFTED = 30;
    private static final int STATEBITSSH = 27;
    private Name name;
    private int userBits;
    private Cell parent;
    private int portIndex;
    private TextDescriptor descriptor = TextDescriptor.getExportTextDescriptor(this);
    private PortInst originalPort;
    private Undo.Change change;
    static final /* synthetic */ boolean $assertionsDisabled;

    protected Export() {
        this.setLinked(false);
    }

    public static Export newInstance(Cell parent, PortInst portInst, String protoName) {
        return Export.newInstance(parent, portInst, protoName, true);
    }

    public static Export newInstance(Cell parent, PortInst portInst, String protoName, boolean createOnIcon) {
        Cell icon;
        Export pp;
        if (parent.findExport(protoName) != null) {
            String oldName = protoName;
            protoName = ElectricObject.uniqueObjectName(protoName, parent, PortProto.class);
            System.out.println("Cell " + parent.describe() + " already has an export named " + oldName + ", making new export named " + protoName);
            if (!$assertionsDisabled && parent.findExport(protoName) != null) {
                throw new AssertionError();
            }
        }
        if ((pp = Export.lowLevelAllocate()).lowLevelName(parent, protoName)) {
            return null;
        }
        if (pp.lowLevelPopulate(portInst)) {
            return null;
        }
        if (pp.lowLevelLink(null)) {
            return null;
        }
        pp.getTextDescriptor().setSmartPlacement();
        if (createOnIcon && (icon = parent.iconView()) != null && icon.findExport(protoName) == null) {
            Rectangle2D bounds = parent.getBounds();
            double locX = portInst.getPoly().getCenterX();
            double locY = portInst.getPoly().getCenterY();
            Rectangle2D iconBounds = icon.getBounds();
            double newlocX = (locX - bounds.getMinX()) / bounds.getWidth() * iconBounds.getWidth() + iconBounds.getMinX();
            double bodyDX = 1.0;
            double distToXEdge = locX - bounds.getMinX();
            if (locX >= bounds.getCenterX()) {
                bodyDX = -1.0;
                distToXEdge = bounds.getMaxX() - locX;
            }
            double newlocY = (locY - bounds.getMinY()) / bounds.getHeight() * iconBounds.getHeight() + iconBounds.getMinY();
            double bodyDY = 1.0;
            double distToYEdge = locY - bounds.getMinY();
            if (locY >= bounds.getCenterY()) {
                bodyDY = -1.0;
                distToYEdge = bounds.getMaxY() - locY;
            }
            if (distToXEdge > distToYEdge) {
                bodyDX = 0.0;
            } else {
                bodyDY = 0.0;
            }
            Point2D.Double point = new Point2D.Double(newlocX, newlocY);
            EditWindow.gridAlign(point);
            newlocX = ((Point2D)point).getX();
            newlocY = ((Point2D)point).getY();
            if (!ViewChanges.makeIconExport(pp, 0, newlocX, newlocY, newlocX + bodyDX, newlocY + bodyDY, icon)) {
                System.out.println("Warning: Failed to create associated export in icon " + icon.describe());
            }
        }
        Undo.newObject(pp);
        return pp;
    }

    public void kill() {
        Collection oldPortInsts = this.lowLevelUnlink();
        Undo.killExport(this, oldPortInsts);
    }

    public void rename(String newName) {
        String dupName;
        this.checkChanging();
        Cell cell = this.originalPort.getNodeInst().getParent();
        if (!(this.getName().equalsIgnoreCase(newName) && !this.getName().equals(newName) || (dupName = ElectricObject.uniqueObjectName(newName, cell, PortProto.class)).equals(newName))) {
            System.out.println("Cell " + cell.describe() + " already has an export named " + newName + ", making new export named " + dupName);
            newName = dupName;
        }
        Name oldName = this.getNameKey();
        this.lowLevelRename(newName);
        Undo.renameObject(this, oldName, 0);
        Cell iconCell = cell.iconView();
        if (iconCell != null && iconCell != cell) {
            Iterator it = iconCell.getPorts();
            while (it.hasNext()) {
                Export pp = (Export)it.next();
                if (!pp.getName().equals(oldName.toString())) continue;
                pp.rename(newName);
                break;
            }
        }
    }

    public boolean move(PortInst newPi) {
        NodeInst newno = newPi.getNodeInst();
        PortProto newsubpt = newPi.getPortProto();
        if (newno.getParent() != this.parent) {
            return true;
        }
        if (newsubpt.getParent() != newno.getProto()) {
            return true;
        }
        if (this.doesntConnect(newsubpt.getBasePort())) {
            return true;
        }
        PortInst oldPi = this.getOriginalPort();
        this.lowLevelModify(newPi);
        Undo.modifyExport(this, oldPi);
        return false;
    }

    public static Export lowLevelAllocate() {
        Export pp = new Export();
        return pp;
    }

    public boolean lowLevelName(Cell parent, String protoName) {
        this.parent = parent;
        this.lowLevelRename(protoName);
        return false;
    }

    public void lowLevelRename(String newName) {
        this.name = Name.findName(newName);
    }

    public boolean lowLevelPopulate(PortInst originalPort) {
        if (originalPort == null) {
            System.out.println("Null port on Export " + this.getName() + " in cell " + this.parent.describe());
            return true;
        }
        this.originalPort = originalPort;
        if (originalPort.getPortProto() instanceof Export) {
            this.userBits = ((Export)originalPort.getPortProto()).lowLevelGetUserbits();
        }
        this.setCharacteristic(originalPort.getPortProto().getCharacteristic());
        return false;
    }

    public boolean lowLevelLink(Collection oldPortInsts) {
        NodeInst originalNode = this.originalPort.getNodeInst();
        originalNode.addExport(this);
        this.parent.addExport(this, oldPortInsts);
        this.setLinked(true);
        return false;
    }

    public Collection lowLevelUnlink() {
        NodeInst originalNode = this.originalPort.getNodeInst();
        originalNode.removeExport(this);
        this.setLinked(false);
        return this.parent.removeExport(this);
    }

    public void lowLevelModify(PortInst newPi) {
        NodeInst origNode = this.getOriginalPort().getNodeInst();
        origNode.removeExport(this);
        NodeInst newNodeInst = newPi.getNodeInst();
        PortProto newPortProto = newPi.getPortProto();
        newNodeInst.addExport(this);
        this.originalPort = newNodeInst.findPortInstFromProto(newPortProto);
        this.changeallports();
    }

    void setPortIndex(int portIndex) {
        this.portIndex = portIndex;
    }

    public int lowLevelGetUserbits() {
        return this.userBits;
    }

    public void lowLevelSetUserbits(int userBits) {
        this.userBits = userBits;
    }

    public Poly getNamePoly() {
        Poly poly = this.getOriginalPort().getPoly();
        double cX = poly.getCenterX();
        double cY = poly.getCenterY();
        TextDescriptor td = this.getTextDescriptor();
        double offX = td.getXOff();
        double offY = td.getYOff();
        TextDescriptor.Position pos = td.getPos();
        Poly.Type style = pos.getPolyType();
        Point2D[] pointList = new Point2D.Double[1];
        NodeInst ni = this.getOriginalPort().getNodeInst();
        if (ni.getAngle() != 0 || ni.isMirroredAboutXAxis() || ni.isMirroredAboutYAxis()) {
            pointList[0] = new Point2D.Double(cX, cY);
            AffineTransform trans = ni.rotateIn();
            trans.transform(pointList[0], pointList[0]);
            pointList[0].setLocation(pointList[0].getX() + offX, pointList[0].getY() + offY);
            trans = ni.rotateOut();
            trans.transform(pointList[0], pointList[0]);
        } else {
            pointList[0] = new Point2D.Double(cX + offX, cY + offY);
        }
        poly = new Poly(pointList);
        poly.setStyle(style);
        poly.setPort(this);
        poly.setString(this.getName());
        poly.setTextDescriptor(td);
        return poly;
    }

    public void checkChanging() {
        if (this.parent != null) {
            this.parent.checkChanging();
        }
    }

    public Cell whichCell() {
        return this.parent;
    }

    public NodeProto getParent() {
        return this.parent;
    }

    public int getPortIndex() {
        return this.portIndex;
    }

    public TextDescriptor getTextDescriptor() {
        return this.descriptor;
    }

    public void setTextDescriptor(TextDescriptor descriptor) {
        this.descriptor.copy(descriptor);
    }

    public Name getNameKey() {
        return this.name;
    }

    public String getName() {
        return this.name.toString();
    }

    public String getShortName() {
        String name = this.getNameKey().toString();
        int len = name.length();
        for (int i = 0; i < len; ++i) {
            char ch = name.charAt(i);
            if (TextUtils.isLetterOrDigit(ch)) continue;
            return name.substring(0, i);
        }
        return name;
    }

    public String toString() {
        return "Export " + this.getName();
    }

    public PortInst getOriginalPort() {
        return this.originalPort;
    }

    public PrimitivePort getBasePort() {
        PortProto pp = this.originalPort.getPortProto();
        return pp.getBasePort();
    }

    public boolean connectsTo(ArcProto arc) {
        return this.getBasePort().connectsTo(arc);
    }

    public PortCharacteristic getCharacteristic() {
        PortCharacteristic characteristic = PortCharacteristic.findCharacteristic(this.userBits >> 27 & 0x1E);
        return characteristic;
    }

    public void setCharacteristic(PortCharacteristic characteristic) {
        this.userBits = this.userBits & 0xFFFFFFF | characteristic.getBits() << 27;
    }

    public boolean isPower() {
        PortCharacteristic ch = this.getCharacteristic();
        if (ch == PortCharacteristic.PWR) {
            return true;
        }
        if (ch != PortCharacteristic.UNKNOWN) {
            return false;
        }
        return this.isNamedPower();
    }

    public boolean isNamedPower() {
        String name = this.getName().toLowerCase();
        if (name.indexOf("vdd") >= 0) {
            return true;
        }
        if (name.indexOf("vcc") >= 0) {
            return true;
        }
        if (name.indexOf("pwr") >= 0) {
            return true;
        }
        return name.indexOf("power") >= 0;
    }

    public boolean isGround() {
        PortCharacteristic ch = this.getCharacteristic();
        if (ch == PortCharacteristic.GND) {
            return true;
        }
        if (ch != PortCharacteristic.UNKNOWN) {
            return false;
        }
        return this.isNamedGround();
    }

    public boolean isNamedGround() {
        String name = this.getName().toLowerCase();
        if (name.indexOf("vss") >= 0) {
            return true;
        }
        if (name.indexOf("gnd") >= 0) {
            return true;
        }
        return name.indexOf("ground") >= 0;
    }

    public void setAlwaysDrawn() {
        this.userBits |= 0x4000000;
    }

    public void clearAlwaysDrawn() {
        this.userBits &= 0xFBFFFFFF;
    }

    public boolean isAlwaysDrawn() {
        return (this.userBits & 0x4000000) != 0;
    }

    public void setBodyOnly() {
        this.userBits |= 0x8000000;
    }

    public void clearBodyOnly() {
        this.userBits &= 0xF7FFFFFF;
    }

    public boolean isBodyOnly() {
        return (this.userBits & 0x8000000) != 0;
    }

    public boolean isActuallyLinked() {
        if (this.parent == null) {
            return false;
        }
        int portIndex = this.getPortIndex();
        return this.parent.isActuallyLinked() && 0 <= portIndex && portIndex < this.parent.getNumPorts() && this.parent.getPort(portIndex) == this;
    }

    public void setChange(Undo.Change change) {
        this.change = change;
    }

    public Undo.Change getChange() {
        return this.change;
    }

    public PortProto getEquivalent() {
        Cell equiv = this.parent.getEquivalent();
        if (equiv == this.parent) {
            return this;
        }
        if (equiv == null) {
            return null;
        }
        return equiv.findPortProto(this.getNameKey());
    }

    public Export getEquivalentPort(Cell otherCell) {
        if (this.parent == otherCell) {
            return this;
        }
        return otherCell.findExport(this.getName());
    }

    public boolean doesntConnect(PrimitivePort newPP) {
        Iterator it = this.parent.getInstancesOf();
        while (it.hasNext()) {
            NodeInst ni = (NodeInst)it.next();
            Iterator cIt = ni.getConnections();
            while (cIt.hasNext()) {
                Connection con = (Connection)cIt.next();
                if (con.getPortInst().getPortProto() != this || newPP.connectsTo(con.getArc().getProto())) continue;
                System.out.println(con.getArc().describe() + " arc in cell " + ni.getParent().describe() + " cannot connect to port " + this.getName());
                return true;
            }
            Iterator eIt = ni.getExports();
            while (eIt.hasNext()) {
                Export oPP = (Export)eIt.next();
                if (oPP.getOriginalPort().getPortProto() != this || !oPP.doesntConnect(newPP)) continue;
                return true;
            }
        }
        return false;
    }

    private void changeallports() {
        Export opp;
        this.recursivelyChangeAllPorts();
        if (this.parent.isIcon()) {
            Export opp2;
            Cell onp = this.parent.contentsView();
            if (onp != null && (opp2 = this.getEquivalentPort(onp)) != null) {
                opp2.setCharacteristic(this.getCharacteristic());
                opp2.recursivelyChangeAllPorts();
            }
            return;
        }
        Cell onp = this.parent.iconView();
        if (onp != null && (opp = this.getEquivalentPort(onp)) != null) {
            opp.setCharacteristic(this.getCharacteristic());
            opp.recursivelyChangeAllPorts();
        }
    }

    private void recursivelyChangeAllPorts() {
        Iterator it = this.parent.getInstancesOf();
        while (it.hasNext()) {
            NodeInst ni = (NodeInst)it.next();
            Iterator pIt = ni.getExports();
            while (pIt.hasNext()) {
                Export upPP = (Export)pIt.next();
                if (upPP.getOriginalPort().getPortProto() != this) continue;
                if (upPP.lowLevelGetUserbits() != this.lowLevelGetUserbits()) {
                    upPP.lowLevelSetUserbits(this.lowLevelGetUserbits());
                }
                upPP.recursivelyChangeAllPorts();
            }
        }
    }

    public boolean compare(Object obj, StringBuffer buffer) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        PortProto no = (PortProto)obj;
        if (!this.getNameKey().equals(no.getNameKey())) {
            if (buffer != null) {
                buffer.append("'" + this + "' and '" + no + "' do not have same name\n");
            }
            return false;
        }
        PortCharacteristic noC = no.getCharacteristic();
        if (!this.getCharacteristic().getName().equals(noC.getName())) {
            if (buffer != null) {
                buffer.append("'" + this + "' and '" + no + "' do not have same characteristic\n");
            }
            return false;
        }
        return true;
    }

    static {
        $assertionsDisabled = !Export.class.desiredAssertionStatus();
        EXPORT_REFERENCE_NAME = ElectricObject.newKey("EXPORT_reference_name");
    }
}

