/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.input;

import com.sun.electric.database.geometry.DBMath;
import com.sun.electric.database.geometry.Geometric;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.prototype.ArcProto;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.prototype.PortCharacteristic;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitiveArc;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.tool.io.input.LEFDEF;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;

public class LEF
extends LEFDEF {
    private String lineBuffer;
    private int lineBufferPosition;

    protected boolean importALibrary(Library lib) {
        firstViaDefFromLEF = null;
        widthsFromLEF = new HashMap();
        this.lineBufferPosition = 0;
        this.lineBuffer = "";
        try {
            boolean ret = this.readFile(lib);
        }
        catch (IOException e) {
            System.out.println("ERROR reading LEF libraries");
        }
        return false;
    }

    private boolean readFile(Library lib) throws IOException {
        String key;
        while ((key = this.getKeyword()) != null) {
            if (key.equalsIgnoreCase("LAYER") && this.readLayer(lib)) {
                return true;
            }
            if (key.equalsIgnoreCase("MACRO") && this.readMacro(lib)) {
                return true;
            }
            if (!key.equalsIgnoreCase("VIA") || !this.readVia(lib)) continue;
            return true;
        }
        return false;
    }

    private boolean readVia(Library lib) throws IOException {
        String key;
        LEFDEF.ViaDef vd;
        block18: {
            String viaName = this.getKeyword();
            if (viaName == null) {
                return true;
            }
            vd = new LEFDEF.ViaDef();
            vd.viaName = viaName;
            vd.sY = 0.0;
            vd.sX = 0.0;
            vd.via = null;
            vd.lay2 = null;
            vd.lay1 = null;
            vd.nextViaDef = firstViaDefFromLEF;
            firstViaDefFromLEF = vd;
            boolean ignoreDefault = true;
            while (true) {
                if ((key = this.getKeyword()) == null) {
                    return true;
                }
                if (ignoreDefault) {
                    ignoreDefault = false;
                    if (key.equalsIgnoreCase("DEFAULT")) continue;
                }
                if (key.equalsIgnoreCase("END")) break block18;
                if (key.equalsIgnoreCase("RESISTANCE")) {
                    if (!this.ignoreToSemicolon(key)) continue;
                    return true;
                }
                if (key.equalsIgnoreCase("LAYER")) {
                    key = this.getKeyword();
                    if (key == null) {
                        return true;
                    }
                    LEFDEF.GetLayerInformation li = new LEFDEF.GetLayerInformation(key);
                    if (li.arc != null) {
                        if (vd.lay1 == null) {
                            vd.lay1 = li.arc;
                        } else {
                            vd.lay2 = li.arc;
                        }
                    }
                    if (!this.ignoreToSemicolon("LAYER")) continue;
                    return true;
                }
                if (!key.equalsIgnoreCase("RECT")) continue;
                key = this.getKeyword();
                if (key == null) {
                    return true;
                }
                double lX = this.convertLEFString(key);
                key = this.getKeyword();
                if (key == null) {
                    return true;
                }
                double lY = this.convertLEFString(key);
                key = this.getKeyword();
                if (key == null) {
                    return true;
                }
                double hX = this.convertLEFString(key);
                key = this.getKeyword();
                if (key == null) {
                    return true;
                }
                double hY = this.convertLEFString(key);
                if (hX - lX > vd.sX) {
                    vd.sX = hX - lX;
                }
                if (hY - lY > vd.sY) {
                    vd.sY = hY - lY;
                }
                if (this.ignoreToSemicolon("RECT")) break;
            }
            return true;
        }
        key = this.getKeyword();
        if (vd.lay1 != null && vd.lay2 != null) {
            Iterator it = Technology.getCurrent().getNodes();
            while (it.hasNext()) {
                PortProto pp;
                NodeProto np = (NodeProto)it.next();
                if (np.getFunction() != PrimitiveNode.Function.CONTACT || !(pp = np.getPort(0)).connectsTo(vd.lay1) || !pp.connectsTo(vd.lay2)) continue;
                vd.via = np;
                break;
            }
        }
        return false;
    }

    private boolean readMacro(Library lib) throws IOException {
        String key;
        block18: {
            block19: {
                String cellName = this.getKeyword();
                if (cellName == null) {
                    System.out.println("EOF parsing MACRO header");
                    return true;
                }
                Cell cell = Cell.makeInstance(lib, cellName = cellName + "{lay.sk}");
                if (cell == null) {
                    System.out.println("Cannot create cell '" + cellName + "'");
                    return true;
                }
                while (true) {
                    if ((key = this.getKeyword()) == null) {
                        System.out.println("EOF parsing MACRO");
                        return true;
                    }
                    if (key.equalsIgnoreCase("END")) break block18;
                    if (key.equalsIgnoreCase("SOURCE") || key.equalsIgnoreCase("FOREIGN") || key.equalsIgnoreCase("SYMMETRY") || key.equalsIgnoreCase("SITE") || key.equalsIgnoreCase("CLASS") || key.equalsIgnoreCase("LEQ") || key.equalsIgnoreCase("POWER")) {
                        if (!this.ignoreToSemicolon(key)) continue;
                        return true;
                    }
                    if (key.equalsIgnoreCase("ORIGIN")) {
                        key = this.getKeyword();
                        if (key == null) {
                            System.out.println("EOF reading ORIGIN X");
                            return true;
                        }
                        double oX = this.convertLEFString(key);
                        key = this.getKeyword();
                        if (key == null) {
                            System.out.println("EOF reading ORIGIN Y");
                            return true;
                        }
                        double oY = this.convertLEFString(key);
                        if (this.ignoreToSemicolon("ORIGIN")) {
                            return true;
                        }
                        Geometric ccNi = null;
                        Iterator it = cell.getNodes();
                        while (it.hasNext()) {
                            NodeInst ni = (NodeInst)it.next();
                            if (ni.getProto() != Generic.tech.cellCenterNode) continue;
                            ccNi = ni;
                            break;
                        }
                        if (ccNi == null) {
                            double sY;
                            double sX = Generic.tech.cellCenterNode.getDefWidth();
                            ccNi = NodeInst.makeInstance(Generic.tech.cellCenterNode, new Point2D.Double(oX, oY), sX, sY = Generic.tech.cellCenterNode.getDefHeight(), cell);
                            if (ccNi == null) {
                                System.out.println("Line " + this.lineReader.getLineNumber() + ": Cannot create cell center node");
                                return true;
                            }
                            ((NodeInst)ccNi).setHardSelect();
                            ((NodeInst)ccNi).setVisInside();
                            continue;
                        }
                        double dX = oX - ccNi.getTrueCenterX();
                        double dY = oY - ccNi.getTrueCenterY();
                        ((NodeInst)ccNi).modifyInstance(dX, dY, 0.0, 0.0, 0);
                        continue;
                    }
                    if (key.equalsIgnoreCase("SIZE")) {
                        key = this.getKeyword();
                        if (key == null) {
                            System.out.println("EOF reading SIZE X");
                            return true;
                        }
                        double sX = this.convertLEFString(key);
                        key = this.getKeyword();
                        if (key == null) {
                            System.out.println("EOF reading SIZE 'BY'");
                            return true;
                        }
                        if (!key.equalsIgnoreCase("BY")) {
                            System.out.println("Line " + this.lineReader.getLineNumber() + ": Expected 'by' in SIZE");
                            return true;
                        }
                        key = this.getKeyword();
                        if (key == null) {
                            System.out.println("EOF reading SIZE Y");
                            return true;
                        }
                        double sY = this.convertLEFString(key);
                        if (!this.ignoreToSemicolon("SIZE")) continue;
                        return true;
                    }
                    if (key.equalsIgnoreCase("PIN")) {
                        if (!this.readPin(cell)) continue;
                        return true;
                    }
                    if (!key.equalsIgnoreCase("OBS")) break block19;
                    if (this.readObs(cell)) break;
                }
                return true;
            }
            System.out.println("Line " + this.lineReader.getLineNumber() + ": Unknown MACRO keyword (" + key + ")");
            return true;
        }
        key = this.getKeyword();
        return false;
    }

    private boolean readObs(Cell cell) throws IOException {
        block12: {
            NodeProto np = null;
            while (true) {
                double sY;
                String key;
                if ((key = this.getKeyword()) == null) {
                    System.out.println("EOF parsing OBS");
                    return true;
                }
                if (key.equalsIgnoreCase("END")) break block12;
                if (key.equalsIgnoreCase("LAYER")) {
                    key = this.getKeyword();
                    if (key == null) {
                        System.out.println("EOF reading LAYER clause");
                        return true;
                    }
                    LEFDEF.GetLayerInformation li = new LEFDEF.GetLayerInformation(key);
                    if (li.layerFun == Layer.Function.UNKNOWN) {
                        System.out.println("Line " + this.lineReader.getLineNumber() + ": Unknown layer name (" + key + ")");
                        return true;
                    }
                    np = li.pure;
                    if (np == null) {
                        return true;
                    }
                    if (!this.ignoreToSemicolon("LAYER")) continue;
                    return true;
                }
                if (!key.equalsIgnoreCase("RECT")) continue;
                if (np == null) {
                    System.out.println("Line " + this.lineReader.getLineNumber() + ": No layers for RECT");
                    return true;
                }
                key = this.getKeyword();
                if (key == null) {
                    System.out.println("EOF reading RECT low X");
                    return true;
                }
                double lX = this.convertLEFString(key);
                key = this.getKeyword();
                if (key == null) {
                    System.out.println("EOF reading RECT low Y");
                    return true;
                }
                double lY = this.convertLEFString(key);
                key = this.getKeyword();
                if (key == null) {
                    System.out.println("EOF reading RECT high X");
                    return true;
                }
                double hX = this.convertLEFString(key);
                key = this.getKeyword();
                if (key == null) {
                    System.out.println("EOF reading RECT high Y");
                    return true;
                }
                double hY = this.convertLEFString(key);
                if (this.ignoreToSemicolon("RECT")) {
                    return true;
                }
                Point2D.Double ctr = new Point2D.Double((lX + hX) / 2.0, (lY + hY) / 2.0);
                double sX = Math.abs(hX - lX);
                NodeInst ni = NodeInst.makeInstance(np, ctr, sX, sY = Math.abs(hY - lY), cell);
                if (ni == null) break;
            }
            System.out.println("Line " + this.lineReader.getLineNumber() + ": Cannot create node for RECT");
            return true;
        }
        return false;
    }

    private boolean readPin(Cell cell) throws IOException {
        String key;
        block21: {
            block22: {
                key = this.getKeyword();
                if (key == null) {
                    System.out.println("EOF parsing PIN name");
                    return true;
                }
                String pinName = key;
                PortCharacteristic useCharacteristics = PortCharacteristic.UNKNOWN;
                PortCharacteristic portCharacteristics = PortCharacteristic.UNKNOWN;
                while (true) {
                    if ((key = this.getKeyword()) == null) {
                        System.out.println("EOF parsing PIN");
                        return true;
                    }
                    if (key.equalsIgnoreCase("END")) break block21;
                    if (key.equalsIgnoreCase("SHAPE") || key.equalsIgnoreCase("CAPACITANCE") || key.equalsIgnoreCase("ANTENNASIZE")) {
                        if (!this.ignoreToSemicolon(key)) continue;
                        return true;
                    }
                    if (key.equalsIgnoreCase("USE")) {
                        key = this.getKeyword();
                        if (key == null) {
                            System.out.println("EOF reading USE clause");
                            return true;
                        }
                        if (key.equalsIgnoreCase("POWER")) {
                            useCharacteristics = PortCharacteristic.PWR;
                        } else if (key.equalsIgnoreCase("GROUND")) {
                            useCharacteristics = PortCharacteristic.GND;
                        } else if (key.equalsIgnoreCase("CLOCK")) {
                            useCharacteristics = PortCharacteristic.CLK;
                        } else {
                            System.out.println("Line " + this.lineReader.getLineNumber() + ": Unknown USE keyword (" + key + ")");
                        }
                        if (!this.ignoreToSemicolon("USE")) continue;
                        return true;
                    }
                    if (key.equalsIgnoreCase("DIRECTION")) {
                        key = this.getKeyword();
                        if (key == null) {
                            System.out.println("EOF reading DIRECTION clause");
                            return true;
                        }
                        if (key.equalsIgnoreCase("INPUT")) {
                            portCharacteristics = PortCharacteristic.IN;
                        } else if (key.equalsIgnoreCase("OUTPUT")) {
                            portCharacteristics = PortCharacteristic.OUT;
                        } else if (key.equalsIgnoreCase("INOUT")) {
                            portCharacteristics = PortCharacteristic.BIDIR;
                        } else {
                            System.out.println("Line " + this.lineReader.getLineNumber() + ": Unknown DIRECTION keyword (" + key + ")");
                        }
                        if (!this.ignoreToSemicolon("DIRECTION")) continue;
                        return true;
                    }
                    if (!key.equalsIgnoreCase("PORT")) break block22;
                    if (useCharacteristics != PortCharacteristic.UNKNOWN) {
                        portCharacteristics = useCharacteristics;
                    }
                    if (this.readPort(cell, pinName, portCharacteristics)) break;
                }
                return true;
            }
            System.out.println("Line " + this.lineReader.getLineNumber() + ": Unknown PIN keyword (" + key + ")");
            return true;
        }
        key = this.getKeyword();
        return false;
    }

    private boolean readPort(Cell cell, String portname, PortCharacteristic portCharacteristics) throws IOException {
        LEFPath lefPaths;
        block36: {
            String key;
            block37: {
                ArcProto ap = null;
                NodeProto pureNp = null;
                lefPaths = null;
                boolean first = true;
                double intWidth = 0.0;
                double lastIntX = 0.0;
                double lastIntY = 0.0;
                block0: while (true) {
                    double sY;
                    if ((key = this.getKeyword()) == null) {
                        System.out.println("EOF parsing PORT");
                        return true;
                    }
                    if (key.equalsIgnoreCase("END")) break block36;
                    if (key.equalsIgnoreCase("LAYER")) {
                        key = this.getKeyword();
                        if (key == null) {
                            System.out.println("EOF reading LAYER clause");
                            return true;
                        }
                        LEFDEF.GetLayerInformation li = new LEFDEF.GetLayerInformation(key);
                        ap = li.arc;
                        pureNp = li.pure;
                        if (!this.ignoreToSemicolon("LAYER")) continue;
                        return true;
                    }
                    if (key.equalsIgnoreCase("WIDTH")) {
                        key = this.getKeyword();
                        if (key == null) {
                            System.out.println("EOF reading WIDTH clause");
                            return true;
                        }
                        intWidth = this.convertLEFString(key);
                        if (!this.ignoreToSemicolon("WIDTH")) continue;
                        return true;
                    }
                    if (key.equalsIgnoreCase("RECT")) {
                        double sY2;
                        if (pureNp == null) {
                            System.out.println("Line " + this.lineReader.getLineNumber() + ": No layers for RECT");
                            return true;
                        }
                        key = this.getKeyword();
                        if (key == null) {
                            System.out.println("EOF reading RECT low X");
                            return true;
                        }
                        double lX = this.convertLEFString(key);
                        key = this.getKeyword();
                        if (key == null) {
                            System.out.println("EOF reading RECT low Y");
                            return true;
                        }
                        double lY = this.convertLEFString(key);
                        key = this.getKeyword();
                        if (key == null) {
                            System.out.println("EOF reading RECT high X");
                            return true;
                        }
                        double hX = this.convertLEFString(key);
                        key = this.getKeyword();
                        if (key == null) {
                            System.out.println("EOF reading RECT high Y");
                            return true;
                        }
                        double hY = this.convertLEFString(key);
                        if (this.ignoreToSemicolon("RECT")) {
                            return true;
                        }
                        Point2D.Double ctr = new Point2D.Double((lX + hX) / 2.0, (lY + hY) / 2.0);
                        double sX = Math.abs(hX - lX);
                        NodeInst ni = NodeInst.makeInstance(pureNp, ctr, sX, sY2 = Math.abs(hY - lY), cell);
                        if (ni == null) {
                            System.out.println("Line " + this.lineReader.getLineNumber() + ": Cannot create pin for RECT");
                            return true;
                        }
                        if (!first) continue;
                        first = false;
                        Export pp = this.newPort(cell, ni, pureNp.getPort(0), portname);
                        pp.setCharacteristic(portCharacteristics);
                        continue;
                    }
                    if (key.equalsIgnoreCase("PATH")) {
                        if (ap == null) {
                            System.out.println("Line " + this.lineReader.getLineNumber() + ": No layers for PATH");
                            return true;
                        }
                        int i = 0;
                        while (true) {
                            if ((key = this.getKeyword()) == null) {
                                System.out.println("EOF reading PATH clause");
                                return true;
                            }
                            if (key.equals(";")) continue block0;
                            double intx = this.convertLEFString(key);
                            key = this.getKeyword();
                            if (key == null) {
                                System.out.println("EOF reading PATH clause");
                                return true;
                            }
                            double inty = this.convertLEFString(key);
                            if (i != 0) {
                                LEFPath lp = new LEFPath();
                                ((LEFPath)lp).pt[0] = new Point2D.Double(lastIntX, lastIntY);
                                ((LEFPath)lp).pt[1] = new Point2D.Double(intx, inty);
                                ((LEFPath)lp).ni[0] = null;
                                ((LEFPath)lp).ni[1] = null;
                                lp.width = intWidth;
                                lp.arc = ap;
                                lp.nextLEFPath = lefPaths;
                                lefPaths = lp;
                            }
                            lastIntX = intx;
                            lastIntY = inty;
                            ++i;
                        }
                    }
                    if (!key.equalsIgnoreCase("VIA")) break block37;
                    key = this.getKeyword();
                    if (key == null) {
                        System.out.println("EOF reading VIA clause");
                        return true;
                    }
                    double intX = this.convertLEFString(key);
                    key = this.getKeyword();
                    if (key == null) {
                        System.out.println("EOF reading VIA clause");
                        return true;
                    }
                    double intY = this.convertLEFString(key);
                    key = this.getKeyword();
                    LEFDEF.GetLayerInformation li = new LEFDEF.GetLayerInformation(key);
                    if (li.pin == null) {
                        System.out.println("Line " + this.lineReader.getLineNumber() + ": No Via in current technology for '" + key + "'");
                        return true;
                    }
                    if (this.ignoreToSemicolon("VIA")) {
                        return true;
                    }
                    double sX = li.pin.getDefWidth();
                    NodeInst ni = NodeInst.makeInstance(li.pin, new Point2D.Double(intX, intY), sX, sY = li.pin.getDefHeight(), cell);
                    if (ni == null) break;
                }
                System.out.println("Line " + this.lineReader.getLineNumber() + ": Cannot create VIA for PATH");
                return true;
            }
            System.out.println("Line " + this.lineReader.getLineNumber() + ": Unknown PORT keyword (" + key + ")");
            return true;
        }
        LEFPath lp = lefPaths;
        while (lp != null) {
            for (int i = 0; i < 2; ++i) {
                if (lp.ni[i] != null) continue;
                Rectangle2D.Double bounds = new Rectangle2D.Double(lp.pt[i].getX(), lp.pt[i].getY(), 0.0, 0.0);
                Geometric.Search sea = new Geometric.Search(bounds, cell);
                while (sea.hasNext()) {
                    NodeInst ni;
                    Geometric geom = (Geometric)sea.next();
                    if (!(geom instanceof NodeInst) || !DBMath.pointsClose((ni = (NodeInst)geom).getTrueCenter(), lp.pt[i])) continue;
                    ((LEFPath)lp).ni[i] = ni;
                    break;
                }
                if (lp.ni[i] == null) continue;
                LEFPath oLp = lefPaths;
                while (oLp != null) {
                    for (int j = 0; j < 2; ++j) {
                        if (oLp.ni[j] != null || !DBMath.pointsClose(oLp.pt[j], lp.pt[i])) continue;
                        ((LEFPath)oLp).ni[j] = lp.ni[i];
                    }
                    oLp = oLp.nextLEFPath;
                }
            }
            lp = lp.nextLEFPath;
        }
        lp = lefPaths;
        while (lp != null) {
            for (int i = 0; i < 2; ++i) {
                PrimitiveNode pin;
                if (lp.ni[i] != null || (pin = ((PrimitiveArc)lp.arc).findPinProto()) == null) continue;
                double sX = pin.getDefWidth();
                double sY = pin.getDefHeight();
                ((LEFPath)lp).ni[i] = NodeInst.makeInstance(pin, lp.pt[i], sX, sY, cell);
                if (lp.ni[i] == null) {
                    System.out.println("Line " + this.lineReader.getLineNumber() + ": Cannot create pin for PATH");
                    return true;
                }
                LEFPath oLp = lefPaths;
                while (oLp != null) {
                    for (int j = 0; j < 2; ++j) {
                        if (oLp.ni[j] != null || !DBMath.pointsClose(oLp.pt[j], lp.pt[i])) continue;
                        ((LEFPath)oLp).ni[j] = lp.ni[i];
                    }
                    oLp = oLp.nextLEFPath;
                }
            }
            lp = lp.nextLEFPath;
        }
        lp = lefPaths;
        while (lp != null) {
            PortInst head = lp.ni[0].getPortInst(0);
            PortInst tail = lp.ni[1].getPortInst(0);
            Point2D headPt = lp.pt[0];
            Point2D tailPt = lp.pt[1];
            ArcInst ai = ArcInst.makeInstance(lp.arc, lp.width, head, tail, headPt, tailPt, null);
            if (ai == null) {
                System.out.println("Line " + this.lineReader.getLineNumber() + ": Cannot create arc for PATH");
                return true;
            }
            lp = lp.nextLEFPath;
        }
        return false;
    }

    private Export newPort(Cell cell, NodeInst ni, PortProto pp, String thename) {
        String portName = thename;
        String newName = null;
        int i = 0;
        while (true) {
            Export e;
            if ((e = (Export)cell.findPortProto(portName)) == null) {
                PortInst pi = ni.findPortInstFromProto(pp);
                return Export.newInstance(cell, pi, portName);
            }
            portName = newName = thename + "-" + i;
            ++i;
        }
    }

    private boolean readLayer(Library lib) throws IOException {
        String key;
        block6: {
            String layerName = this.getKeyword();
            if (layerName == null) {
                System.out.println("EOF parsing LAYER header");
                return true;
            }
            LEFDEF.GetLayerInformation li = new LEFDEF.GetLayerInformation(layerName);
            ArcProto ap = li.arc;
            while (true) {
                if ((key = this.getKeyword()) == null) {
                    System.out.println("EOF parsing LAYER");
                    return true;
                }
                if (key.equalsIgnoreCase("END")) break block6;
                if (key.equalsIgnoreCase("WIDTH")) {
                    key = this.getKeyword();
                    if (key == null) {
                        System.out.println("EOF reading WIDTH");
                        return true;
                    }
                    if (ap != null) {
                        double defwidth = this.convertLEFString(key);
                        widthsFromLEF.put(ap, new Double(defwidth));
                    }
                    if (!this.ignoreToSemicolon("WIDTH")) continue;
                    return true;
                }
                if ((key.equalsIgnoreCase("TYPE") || key.equalsIgnoreCase("SPACING") || key.equalsIgnoreCase("PITCH") || key.equalsIgnoreCase("DIRECTION") || key.equalsIgnoreCase("CAPACITANCE") || key.equalsIgnoreCase("RESISTANCE")) && this.ignoreToSemicolon(key)) break;
            }
            return true;
        }
        key = this.getKeyword();
        return false;
    }

    private boolean ignoreToSemicolon(String command) throws IOException {
        String key;
        do {
            if ((key = this.getKeyword()) != null) continue;
            System.out.println("EOF parsing " + command);
            return true;
        } while (!key.equals(";"));
        return false;
    }

    private double convertLEFString(String key) {
        double v = TextUtils.atof(key) / 2.0;
        return TextUtils.convertFromDistance(v, Technology.getCurrent(), TextUtils.UnitScale.MICRO);
    }

    private String getKeyword() throws IOException {
        char chr;
        while (true) {
            char chr2;
            if (this.lineBuffer == null) {
                return null;
            }
            if (this.lineBufferPosition >= this.lineBuffer.length()) {
                this.lineBuffer = this.lineReader.readLine();
                this.lineBufferPosition = 0;
                continue;
            }
            int sharpPos = this.lineBuffer.indexOf(35);
            if (sharpPos >= 0) {
                this.lineBuffer = this.lineBuffer.substring(0, sharpPos);
            }
            while (this.lineBufferPosition < this.lineBuffer.length() && ((chr2 = this.lineBuffer.charAt(this.lineBufferPosition)) == ' ' || chr2 == '\t')) {
                ++this.lineBufferPosition;
            }
            if (this.lineBufferPosition < this.lineBuffer.length()) break;
        }
        int start = this.lineBufferPosition;
        while (this.lineBufferPosition < this.lineBuffer.length() && (chr = this.lineBuffer.charAt(this.lineBufferPosition)) != ' ' && chr != '\t') {
            ++this.lineBufferPosition;
        }
        return this.lineBuffer.substring(start, this.lineBufferPosition);
    }

    private static class LEFPath {
        private Point2D[] pt = new Point2D[2];
        private NodeInst[] ni = new NodeInst[2];
        private double width;
        private ArcProto arc;
        private LEFPath nextLEFPath;

        private LEFPath() {
        }
    }
}

