/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.ncc;

import com.sun.electric.database.hierarchy.HierarchyEnumerator;
import com.sun.electric.database.network.Network;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.tool.generator.layout.LayoutLib;
import com.sun.electric.tool.ncc.InstancePathToNccContext;
import com.sun.electric.tool.ncc.NccContext;
import java.util.Iterator;

public class NetEquivalence {
    private final HierarchyEnumerator.NetNameProxy[][] equivNets;
    private final int numDesigns;
    private final int numNets;
    private InstancePathToNccContext[] instToIndices;
    private int lastDesignHit;

    private boolean nameMatch(HierarchyEnumerator.NetNameProxy prox, Network net) {
        Iterator it = prox.leafNames();
        while (it.hasNext()) {
            String proxNm = (String)it.next();
            if (!net.hasName(proxNm)) continue;
            return true;
        }
        return false;
    }

    public NetEquivalence(HierarchyEnumerator.NetNameProxy[][] equivNets) {
        this.equivNets = equivNets;
        this.numDesigns = equivNets.length;
        this.numNets = equivNets[0].length;
        this.instToIndices = new InstancePathToNccContext[this.numDesigns];
        for (int i = 0; i < this.numDesigns; ++i) {
            LayoutLib.error(equivNets[i].length != this.numNets, "designs don't have same numbers of nets?");
            this.instToIndices[i] = new InstancePathToNccContext(equivNets[i]);
        }
    }

    private HierarchyEnumerator.NetNameProxy findEquivalent(VarContext vc, Network net, int designIndex) {
        LayoutLib.error(designIndex != 0 && designIndex != 1, "designIndex must be 0 or 1");
        InstancePathToNccContext nameIndex = this.instToIndices[designIndex];
        NccContext nc = nameIndex.findNccContext(vc);
        if (nc == null) {
            return null;
        }
        if (nc.getCell() != net.getParent()) {
            return null;
        }
        if (!nc.getContext().equals(vc)) {
            return null;
        }
        Iterator it = nc.getIndices();
        while (it.hasNext()) {
            int index = (Integer)it.next();
            HierarchyEnumerator.NetNameProxy prox = this.equivNets[designIndex][index];
            if (!this.nameMatch(prox, net)) continue;
            int equivDesign = designIndex == 0 ? 1 : 0;
            return this.equivNets[equivDesign][index];
        }
        return null;
    }

    public HierarchyEnumerator.NetNameProxy findEquivalent(VarContext vc, Network net) {
        HierarchyEnumerator.NetNameProxy nnp = this.findEquivalent(vc, net, this.lastDesignHit);
        if (nnp != null) {
            return nnp;
        }
        int otherDesign = this.lastDesignHit == 0 ? 1 : 0;
        nnp = this.findEquivalent(vc, net, otherDesign);
        if (nnp != null) {
            this.lastDesignHit = otherDesign;
            return nnp;
        }
        return null;
    }

    public int regressionTest() {
        LayoutLib.error(this.numDesigns != 2, "we must have exactly two designs");
        int numErrors = 0;
        for (int desNdx = 0; desNdx < this.numDesigns; ++desNdx) {
            int otherDesign = desNdx == 0 ? 1 : 0;
            for (int netNdx = 0; netNdx < this.numNets; ++netNdx) {
                Network fromNet;
                HierarchyEnumerator.NetNameProxy from = this.equivNets[desNdx][netNdx];
                VarContext fromVc = from.getContext();
                HierarchyEnumerator.NetNameProxy to = this.findEquivalent(fromVc, fromNet = from.getNet());
                if (to == this.equivNets[otherDesign][netNdx]) continue;
                ++numErrors;
            }
        }
        System.out.print("  Net equivalence regression " + (numErrors == 0 ? "passed. " : "failed. "));
        System.out.print(this.numNets + " matched Networks. ");
        if (numErrors != 0) {
            System.out.print(numErrors + " errors.");
        }
        System.out.println();
        return numErrors;
    }
}

