/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.ncc.strategy;

import com.sun.electric.tool.generator.layout.LayoutLib;
import com.sun.electric.tool.ncc.NccGlobals;
import com.sun.electric.tool.ncc.basic.NccUtils;
import com.sun.electric.tool.ncc.jemNets.NetObject;
import com.sun.electric.tool.ncc.jemNets.Transistor;
import com.sun.electric.tool.ncc.lists.LeafList;
import com.sun.electric.tool.ncc.strategy.OutlierRecord;
import com.sun.electric.tool.ncc.strategy.OutlierTrans;
import com.sun.electric.tool.ncc.strategy.Strategy;
import com.sun.electric.tool.ncc.trees.Circuit;
import com.sun.electric.tool.ncc.trees.EquivRecord;
import java.util.ArrayList;
import java.util.Iterator;

public class StratSizes
extends Strategy {
    private static final Integer CODE_OUTLIER = new Integer(1);
    private static final Integer CODE_REST = new Integer(2);
    private OutlierRecord outlierRecord;

    private StratSizes(NccGlobals globals) {
        super(globals);
    }

    private boolean widthsMatch(OutlierTrans o1, OutlierTrans o2) {
        return NccUtils.sizesMatch(o1.outlier.getWidth(), o2.outlier.getWidth(), this.globals.getOptions());
    }

    private OutlierTrans[] findSmallLargeOutliers(Circuit c) {
        double minSz = Double.MAX_VALUE;
        double maxSz = Double.MIN_VALUE;
        double sumSz = 0.0;
        int numTrans = 0;
        Transistor minT = null;
        Transistor maxT = null;
        Iterator it = c.getNetObjs();
        while (it.hasNext()) {
            NetObject no = (NetObject)it.next();
            if (!(no instanceof Transistor)) {
                return null;
            }
            Transistor t = (Transistor)no;
            double sz = t.getWidth();
            if (sz < minSz) {
                minT = t;
                minSz = sz;
            }
            if (sz > maxSz) {
                maxT = t;
                maxSz = sz;
            }
            sumSz += sz;
            ++numTrans;
        }
        LayoutLib.error(numTrans == 0, "Empty circuit?");
        if (sumSz == 0.0) {
            return null;
        }
        double avgSz = sumSz / (double)numTrans;
        double smallDev = (avgSz - minSz) / avgSz;
        double largeDev = (maxSz - avgSz) / avgSz;
        return new OutlierTrans[]{new OutlierTrans(minT, smallDev), new OutlierTrans(maxT, largeDev)};
    }

    private OutlierRecord maxDeviation(OutlierRecord o1, OutlierRecord o2) {
        return o1.deviation() >= o2.deviation() ? o1 : o2;
    }

    private OutlierRecord buildOutlierRecord(EquivRecord r) {
        Object first = null;
        ArrayList<OutlierTrans> small = new ArrayList<OutlierTrans>();
        ArrayList<OutlierTrans> big = new ArrayList<OutlierTrans>();
        Iterator it = r.getCircuits();
        while (it.hasNext()) {
            Circuit c = (Circuit)it.next();
            OutlierTrans[] o = this.findSmallLargeOutliers(c);
            if (o == null) {
                return null;
            }
            small.add(o[0]);
            big.add(o[1]);
        }
        return this.maxDeviation(new OutlierRecord(small), new OutlierRecord(big));
    }

    private OutlierRecord findOutlierRecordWithLargestDeviation() {
        OutlierRecord furthestOut = null;
        Iterator frontier = this.globals.getPartLeafEquivRecs().getUnmatched();
        while (frontier.hasNext()) {
            OutlierRecord farOut;
            EquivRecord r = (EquivRecord)frontier.next();
            if (r.isMismatched() || (farOut = this.buildOutlierRecord(r)) == null) continue;
            if (furthestOut == null) {
                furthestOut = farOut;
                continue;
            }
            furthestOut = this.maxDeviation(furthestOut, farOut);
        }
        return furthestOut;
    }

    private LeafList doYourJob() {
        OutlierRecord r = this.findOutlierRecordWithLargestDeviation();
        if (r == null) {
            return new LeafList();
        }
        this.outlierRecord = r;
        return this.doFor(r.getEquivRecord());
    }

    public Integer doFor(NetObject n) {
        Transistor t = (Transistor)n;
        return this.outlierRecord.isOutlier(t) ? CODE_OUTLIER : CODE_REST;
    }

    public static LeafList doYourJob(NccGlobals globals) {
        StratSizes ss = new StratSizes(globals);
        return ss.doYourJob();
    }
}

