/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.ncc.trees;

import com.sun.electric.tool.generator.layout.LayoutLib;
import com.sun.electric.tool.ncc.NccGlobals;
import com.sun.electric.tool.ncc.jemNets.NetObject;
import com.sun.electric.tool.ncc.lists.LeafList;
import com.sun.electric.tool.ncc.lists.RecordList;
import com.sun.electric.tool.ncc.strategy.Strategy;
import com.sun.electric.tool.ncc.trees.Circuit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class EquivRecord {
    private EquivRecord parent;
    private int randCode;
    private int value;
    private String partitionReason;
    private RecordList offspring;
    private List circuits;

    private static void error(boolean pred, String msg) {
        LayoutLib.error(pred, msg);
    }

    private ArrayList getOneMapPerCircuit(Strategy js) {
        ArrayList<HashMap> mapPerCkt = new ArrayList<HashMap>();
        Iterator it = this.getCircuits();
        while (it.hasNext()) {
            Circuit ckt = (Circuit)it.next();
            HashMap codeToNetObjs = js.doFor(ckt);
            mapPerCkt.add(codeToNetObjs);
        }
        return mapPerCkt;
    }

    private Set getKeysFromAllMaps(ArrayList mapPerCkt) {
        HashSet keys = new HashSet();
        Iterator it = mapPerCkt.iterator();
        while (it.hasNext()) {
            HashMap map = (HashMap)it.next();
            keys.addAll(map.keySet());
        }
        return keys;
    }

    private EquivRecord makeEquivRecForKey(ArrayList mapPerCkt, Integer key, NccGlobals globals) {
        ArrayList<Circuit> ckts = new ArrayList<Circuit>();
        Iterator it = mapPerCkt.iterator();
        while (it.hasNext()) {
            HashMap map = (HashMap)it.next();
            ArrayList netObjs = (ArrayList)map.get(key);
            if (netObjs == null) {
                netObjs = new ArrayList();
            }
            ckts.add(Circuit.please(netObjs));
        }
        return EquivRecord.newLeafRecord(key, ckts, globals);
    }

    private EquivRecord() {
    }

    private void addOffspring(EquivRecord r) {
        this.offspring.add(r);
        r.setParent(this);
    }

    private LeafList applyToLeaf(Strategy js) {
        ArrayList mapPerCkt = this.getOneMapPerCircuit(js);
        Set keys = this.getKeysFromAllMaps(mapPerCkt);
        EquivRecord.error(keys.size() == 0, "must have at least one key");
        if (keys.size() == 1) {
            return new LeafList();
        }
        this.circuits = null;
        this.offspring = new RecordList();
        Iterator it = keys.iterator();
        while (it.hasNext()) {
            Integer key = (Integer)it.next();
            EquivRecord er = this.makeEquivRecForKey(mapPerCkt, key, js.globals);
            this.addOffspring(er);
        }
        LeafList el = new LeafList();
        el.addAll(this.offspring);
        return el;
    }

    private LeafList applyToInternal(Strategy js) {
        LeafList offspring = new LeafList();
        Iterator it = this.getOffspring();
        while (it.hasNext()) {
            EquivRecord jr = (EquivRecord)it.next();
            offspring.addAll(js.doFor(jr));
        }
        return offspring;
    }

    public EquivRecord getParent() {
        return this.parent;
    }

    public int getCode() {
        return this.randCode;
    }

    public void checkMe(EquivRecord parent) {
        EquivRecord.error(this.getParent() != parent, "wrong parent");
        EquivRecord.error(!(this.offspring == null ^ this.circuits == null), "bad lists");
    }

    public void setParent(EquivRecord x) {
        this.parent = x;
    }

    public int getValue() {
        return this.value;
    }

    public Iterator getCircuits() {
        return this.circuits.iterator();
    }

    public int numCircuits() {
        return this.circuits.size();
    }

    public void addCircuit(Circuit c) {
        this.circuits.add(c);
        c.setParent(this);
    }

    public NetObject.Type getNetObjType() {
        Iterator ci = this.getCircuits();
        while (ci.hasNext()) {
            Circuit c = (Circuit)ci.next();
            Iterator ni = c.getNetObjs();
            if (!ni.hasNext()) continue;
            NetObject no = (NetObject)ni.next();
            return no.getNetObjType();
        }
        EquivRecord.error(true, "no NetObjects in a leaf EquivRecord?");
        return null;
    }

    public int numNetObjs() {
        int sum = 0;
        Iterator ci = this.getCircuits();
        while (ci.hasNext()) {
            Circuit c = (Circuit)ci.next();
            sum += c.numNetObjs();
        }
        return sum;
    }

    public String sizeString() {
        if (this.numCircuits() == 0) {
            return "0";
        }
        String s = "";
        Iterator it = this.getCircuits();
        while (it.hasNext()) {
            Circuit jc = (Circuit)it.next();
            s = s + " " + jc.numNetObjs();
        }
        return s;
    }

    public int maxSizeDiff() {
        int out = 0;
        int max = this.maxSize();
        Iterator it = this.getCircuits();
        while (it.hasNext()) {
            Circuit j = (Circuit)it.next();
            int diff = max - j.numNetObjs();
            if (diff <= out) continue;
            out = diff;
        }
        return out;
    }

    public int maxSize() {
        int out = 0;
        Iterator it = this.getCircuits();
        while (it.hasNext()) {
            Circuit j = (Circuit)it.next();
            out = Math.max(out, j.numNetObjs());
        }
        return out;
    }

    public boolean isActive() {
        EquivRecord.error(this.numCircuits() == 0, "leaf record with no circuits?");
        Iterator it = this.getCircuits();
        while (it.hasNext()) {
            Circuit c = (Circuit)it.next();
            if (c.numNetObjs() == 0) {
                return false;
            }
            if (c.numNetObjs() <= 1) continue;
            return true;
        }
        return false;
    }

    public boolean isMatched() {
        Iterator it = this.getCircuits();
        while (it.hasNext()) {
            Circuit c = (Circuit)it.next();
            if (c.numNetObjs() == 1) continue;
            return false;
        }
        return true;
    }

    public boolean isMismatched() {
        boolean first = true;
        int sz = 0;
        Iterator it = this.getCircuits();
        while (it.hasNext()) {
            Circuit c = (Circuit)it.next();
            if (first) {
                sz = c.numNetObjs();
                first = false;
                continue;
            }
            if (c.numNetObjs() == sz) continue;
            return true;
        }
        return false;
    }

    public Iterator getOffspring() {
        return this.offspring.iterator();
    }

    public int numOffspring() {
        return this.offspring.size();
    }

    public LeafList apply(Strategy js) {
        return this.isLeaf() ? this.applyToLeaf(js) : this.applyToInternal(js);
    }

    public String nameString() {
        String name = "";
        if (this.isLeaf()) {
            name = this.isMatched() ? "Matched" : (this.isMismatched() ? "Mismatched" : "Active");
            name = name + " leaf";
        } else {
            name = "Internal";
        }
        name = name + " Record randCode=" + this.randCode + " value=" + this.value;
        name = name + (this.isLeaf() ? " maxSize=" + this.maxSize() : " #offspring=" + this.numOffspring());
        return name;
    }

    public boolean isLeaf() {
        return this.offspring == null;
    }

    public void setPartitionReason(String s) {
        this.partitionReason = s;
    }

    public String getPartitionReason() {
        return this.partitionReason;
    }

    public List getPartitionReasonsFromRootToMe() {
        LinkedList<String> reasons = new LinkedList<String>();
        for (EquivRecord r = this; r != null; r = r.getParent()) {
            String reason = r.getPartitionReason();
            if (reason == null) continue;
            reasons.addFirst(reason);
        }
        return reasons;
    }

    public static EquivRecord newLeafRecord(int key, List ckts, NccGlobals globals) {
        EquivRecord r = new EquivRecord();
        r.circuits = new ArrayList();
        r.value = key;
        r.randCode = globals.getRandom();
        Iterator it = ckts.iterator();
        while (it.hasNext()) {
            r.addCircuit((Circuit)it.next());
        }
        EquivRecord.error(r.maxSize() == 0, "invalid leaf EquivRecord: all Circuits are empty");
        return r;
    }

    public static EquivRecord newRootRecord(List offspring) {
        if (offspring.size() == 0) {
            return null;
        }
        EquivRecord r = new EquivRecord();
        r.offspring = new RecordList();
        Iterator it = offspring.iterator();
        while (it.hasNext()) {
            r.addOffspring((EquivRecord)it.next());
        }
        return r;
    }
}

