/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user;

import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.HierarchyEnumerator;
import com.sun.electric.database.hierarchy.Nodable;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.network.Network;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.tool.user.Highlight;
import com.sun.electric.tool.user.Highlighter;
import java.awt.Color;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class NetworkHighlighter
extends HierarchyEnumerator.Visitor {
    private Cell cell;
    private Netlist netlist;
    private Network net;
    private int netID;
    private int startDepth;
    private int endDepth;
    private int currentDepth;
    private Highlighter highlighter;

    private NetworkHighlighter(Cell cell, Netlist netlist, Network net, int startDepth, int endDepth) {
        this.cell = cell;
        this.netlist = netlist;
        this.net = net;
        this.startDepth = startDepth;
        this.endDepth = endDepth;
        this.currentDepth = 0;
        this.highlighter = new Highlighter(0, null);
    }

    public static synchronized List getHighlights(Cell cell, Netlist netlist, Network net, int startDepth, int endDepth) {
        NetworkHighlighter networkHighlighter = new NetworkHighlighter(cell, netlist, net, startDepth, endDepth);
        HierarchyEnumerator.enumerateCell(cell, VarContext.globalContext, netlist, networkHighlighter);
        return networkHighlighter.highlighter.getHighlights();
    }

    public boolean enterCell(HierarchyEnumerator.CellInfo info) {
        if (this.currentDepth == 0) {
            this.netID = info.getNetID(this.net);
        }
        if (this.cell.isSchematic() && this.currentDepth > 0) {
            return false;
        }
        if (this.currentDepth >= this.startDepth) {
            if (this.currentDepth > this.endDepth) {
                return false;
            }
            if (this.currentDepth == 0) {
                this.addNetworkObjects();
            } else {
                this.addNetworkPolys(info);
            }
        }
        ++this.currentDepth;
        return true;
    }

    public void exitCell(HierarchyEnumerator.CellInfo info) {
        --this.currentDepth;
    }

    public boolean visitNodeInst(Nodable ni, HierarchyEnumerator.CellInfo info) {
        return true;
    }

    private static void getNetworkObjects(Cell cell, Netlist netlist, Network net, List arcs, List ports, List exports) {
        if (arcs != null) {
            ArrayList<PortInst> nodesAdded = new ArrayList<PortInst>();
            Iterator aIt = cell.getArcs();
            block0: while (aIt.hasNext()) {
                ArcInst ai = (ArcInst)aIt.next();
                int width = netlist.getBusWidth(ai);
                for (int i = 0; i < width; ++i) {
                    Network oNet = netlist.getNetwork(ai, i);
                    if (oNet != net) continue;
                    arcs.add(ai);
                    if (ports == null) continue;
                    PortInst pi = ai.getHead().getPortInst();
                    if (pi.getNodeInst().getProto() instanceof PrimitiveNode && pi.getNodeInst().getProto().getFunction() != PrimitiveNode.Function.PIN && !nodesAdded.contains(pi)) {
                        ports.add(pi);
                        nodesAdded.add(pi);
                    }
                    if (!((pi = ai.getTail().getPortInst()).getNodeInst().getProto() instanceof PrimitiveNode) || pi.getNodeInst().getProto().getFunction() == PrimitiveNode.Function.PIN || nodesAdded.contains(pi)) continue block0;
                    ports.add(pi);
                    nodesAdded.add(pi);
                    continue block0;
                }
            }
        }
        if (exports != null) {
            Iterator pIt = cell.getPorts();
            block2: while (pIt.hasNext()) {
                Export pp = (Export)pIt.next();
                int width = netlist.getBusWidth(pp);
                for (int i = 0; i < width; ++i) {
                    Network oNet = netlist.getNetwork(pp, i);
                    if (oNet != net) continue;
                    exports.add(pp);
                    continue block2;
                }
            }
        }
    }

    private void addNetworkObjects() {
        ArrayList arcs = new ArrayList();
        ArrayList ports = new ArrayList();
        ArrayList exports = new ArrayList();
        NetworkHighlighter.getNetworkObjects(this.cell, this.netlist, this.net, arcs, ports, exports);
        Iterator it = arcs.iterator();
        while (it.hasNext()) {
            ArcInst ai = (ArcInst)it.next();
            this.highlighter.addElectricObject(ai, this.cell, false);
        }
        it = ports.iterator();
        while (it.hasNext()) {
            PortInst pi = (PortInst)it.next();
            this.highlighter.addElectricObject(pi, this.cell, false);
        }
        it = exports.iterator();
        while (it.hasNext()) {
            Export ep = (Export)it.next();
            this.highlighter.addElectricObject(ep, this.cell, false);
        }
    }

    private void addNetworkPolys(HierarchyEnumerator.CellInfo info) {
        Netlist netlist = info.getNetlist();
        Iterator it = netlist.getNetworks();
        while (it.hasNext()) {
            Network aNet = (Network)it.next();
            if (info.getNetID(aNet) != this.netID) continue;
            this.addNetworkPolys(aNet, info);
        }
    }

    private void addNetworkPolys(Network localNet, HierarchyEnumerator.CellInfo info) {
        Netlist netlist = info.getNetlist();
        if (localNet == null) {
            return;
        }
        Cell currentCell = info.getCell();
        ArrayList arcs = new ArrayList();
        ArrayList ports = new ArrayList();
        ArrayList exports = new ArrayList();
        NetworkHighlighter.getNetworkObjects(currentCell, netlist, localNet, arcs, ports, exports);
        AffineTransform trans = info.getTransformToRoot();
        Iterator it = arcs.iterator();
        while (it.hasNext()) {
            ArcInst ai = (ArcInst)it.next();
            Poly poly = ai.makePoly(ai.getLength(), ai.getWidth() - ai.getProto().getWidthOffset(), Poly.Type.CLOSED);
            poly.transform(trans);
            this.highlighter.addPoly(poly, this.cell, null);
        }
        it = ports.iterator();
        while (it.hasNext()) {
            PortInst pi = (PortInst)it.next();
            NodeInst ni = pi.getNodeInst();
            Poly poly = Highlight.getNodeInstOutline(ni);
            poly.transform(trans);
            this.highlighter.addPoly(poly, this.cell, null);
        }
        it = exports.iterator();
        while (it.hasNext()) {
            Export ep = (Export)it.next();
            PortInst pi = ep.getOriginalPort();
            NodeInst ni = pi.getNodeInst();
            Poly poly = ni.getShapeOfPort(pi.getPortProto());
            poly.transform(trans);
            this.highlighter.addPoly(poly, this.cell, Color.YELLOW);
        }
    }
}

