/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.logicaleffort;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.HierarchyEnumerator;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.hierarchy.Nodable;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.logicaleffort.LESizer;
import com.sun.electric.tool.logicaleffort.LETool;
import com.sun.electric.tool.user.ErrorLogger;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public abstract class LENetlister
extends HierarchyEnumerator.Visitor {
    public static final Variable.Key ATTR_su;
    public static final Variable.Key ATTR_le;
    public static final Variable.Key ATTR_wire_ratio;
    public static final Variable.Key ATTR_epsilon;
    public static final Variable.Key ATTR_max_iter;
    public static final Variable.Key ATTR_gate_cap;
    public static final Variable.Key ATTR_alpha;
    public static final Variable.Key ATTR_keeper_ratio;
    static final /* synthetic */ boolean $assertionsDisabled;

    public abstract boolean netlist(Cell var1, VarContext var2, boolean var3);

    public abstract void done();

    public abstract boolean size(LESizer.Alg var1);

    public abstract void updateSizes();

    public abstract ErrorLogger getErrorLogger();

    public abstract NetlisterConstants getConstants();

    public abstract boolean printResults(Nodable var1, VarContext var2);

    public abstract float getTotalLESize();

    protected NetlisterConstants getSettings(Cell cell) {
        Iterator instIt = cell.getNodes();
        while (instIt.hasNext()) {
            NodeInst ni = (NodeInst)instIt.next();
            if (ni.isIconOfParent() || !(ni.getProto() instanceof Cell) || ni.getVar("ATTR_LESETTINGS") == null) continue;
            float su = (float)LETool.getGlobalFanout();
            float epsilon = (float)LETool.getConvergenceEpsilon();
            int maxIterations = LETool.getMaxIterations();
            float gateCap = (float)LETool.getGateCapacitance();
            float wireRatio = (float)LETool.getWireRatio();
            float alpha = (float)LETool.getDiffAlpha();
            float keeperRatio = (float)LETool.getKeeperRatio();
            VarContext context = VarContext.globalContext;
            Variable var = ni.getVar(ATTR_su);
            if (var != null) {
                su = VarContext.objectToFloat(context.evalVar(var), su);
            }
            if ((var = ni.getVar(ATTR_wire_ratio)) != null) {
                wireRatio = VarContext.objectToFloat(context.evalVar(var), wireRatio);
            }
            if ((var = ni.getVar(ATTR_epsilon)) != null) {
                epsilon = VarContext.objectToFloat(context.evalVar(var), epsilon);
            }
            if ((var = ni.getVar(ATTR_max_iter)) != null) {
                maxIterations = VarContext.objectToInt(context.evalVar(var), maxIterations);
            }
            if ((var = ni.getVar(ATTR_gate_cap)) != null) {
                gateCap = VarContext.objectToFloat(context.evalVar(var), gateCap);
            }
            if ((var = ni.getVar(ATTR_alpha)) != null) {
                alpha = VarContext.objectToFloat(context.evalVar(var), alpha);
            }
            if ((var = ni.getVar(ATTR_keeper_ratio)) != null) {
                keeperRatio = VarContext.objectToFloat(context.evalVar(var), keeperRatio);
            }
            return new NetlisterConstants(su, wireRatio, epsilon, maxIterations, gateCap, alpha, keeperRatio);
        }
        return null;
    }

    protected boolean isSettingsConflict(NetlisterConstants current, Cell topLevelCell, VarContext context, Cell localCell) {
        if (!$assertionsDisabled && current == null) {
            throw new AssertionError();
        }
        NetlisterConstants local = this.getSettings(localCell);
        if (local == null) {
            return false;
        }
        if (!current.equals(local)) {
            System.out.println("Error: Global settings from " + topLevelCell + " do not match global settings from \"" + context.getInstPath("/") + ": " + localCell.noLibDescribe() + "\"");
            System.out.println("       Global settings are by definition global, and differences may indicate an inconsistency in your design.");
            System.out.println("       Note that step-up, \"su\", can be made local by defining a \"su\" parameter on an instance.");
            System.out.println("\tglobal/parent vs local:");
            if (current.su != local.su) {
                System.out.println("su:\t" + current.su + " vs " + local.su);
            }
            if (current.wireRatio != local.wireRatio) {
                System.out.println("wireRatio:\t" + current.wireRatio + " vs " + local.wireRatio);
            }
            if (current.epsilon != local.epsilon) {
                System.out.println("epsilon:\t" + current.epsilon + " vs " + local.epsilon);
            }
            if (current.maxIterations != local.maxIterations) {
                System.out.println("maxIterations:\t" + current.maxIterations + " vs " + local.maxIterations);
            }
            if (current.gateCap != local.gateCap) {
                System.out.println("gateCap:\t" + current.gateCap + " vs " + local.gateCap);
            }
            if (current.alpha != local.alpha) {
                System.out.println("alpha:\t" + current.alpha + " vs " + local.alpha);
            }
            if (current.keeperRatio != local.keeperRatio) {
                System.out.println("keeperRatio:\t" + current.keeperRatio + " vs " + local.keeperRatio);
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    JOptionPane.showMessageDialog(null, "Conflicting global parameter settings were found, please see message window for details", "Settings Conflict Found!!", 0);
                }
            });
            return true;
        }
        return false;
    }

    protected boolean saveSettings(NetlisterConstants constants, Cell cell) {
        if (this.getSettings(cell) != null) {
            return false;
        }
        Cell settings = null;
        Iterator it = Library.getLibraries();
        while (it.hasNext()) {
            Library lib = (Library)it.next();
            Iterator it2 = lib.getCells();
            while (it2.hasNext()) {
                Cell c = (Cell)it2.next();
                if (c.getVar("ATTR_LESETTINGS") == null) continue;
                settings = c;
                break;
            }
            if (settings == null) continue;
            break;
        }
        if (settings == null) {
            System.out.println("Could not find LESETTINGS cell in order to save settings to " + cell);
            return false;
        }
        System.out.println("Creating new LESETTINGS box on " + cell + " from User Preferences because none found. Logical effort requires this box");
        SaveSettings job = new SaveSettings(cell, settings, constants);
        return true;
    }

    static {
        $assertionsDisabled = !LENetlister.class.desiredAssertionStatus();
        ATTR_su = ElectricObject.newKey("ATTR_su");
        ATTR_le = ElectricObject.newKey("ATTR_le");
        ATTR_wire_ratio = ElectricObject.newKey("ATTR_wire_ratio");
        ATTR_epsilon = ElectricObject.newKey("ATTR_epsilon");
        ATTR_max_iter = ElectricObject.newKey("ATTR_max_iter");
        ATTR_gate_cap = ElectricObject.newKey("ATTR_gate_cap");
        ATTR_alpha = ElectricObject.newKey("ATTR_alpha");
        ATTR_keeper_ratio = ElectricObject.newKey("ATTR_keeper_ratio");
    }

    protected static class LECellInfo
    extends HierarchyEnumerator.CellInfo {
        private float mFactor;
        private float cellsu;
        private NetlisterConstants localSettings;

        protected LECellInfo() {
        }

        protected void leInit(NetlisterConstants constants) {
            HierarchyEnumerator.CellInfo parent = this.getParentInfo();
            this.mFactor = parent == null ? 1.0f : ((LECellInfo)parent).getMFactor();
            this.cellsu = parent == null ? constants.su : ((LECellInfo)parent).getSU();
            Nodable ni = this.getContext().getNodable();
            if (ni != null) {
                float su;
                Variable suvar;
                Object mval;
                Variable mvar = LETool.getMFactor(ni);
                if (mvar != null && (mval = this.getContext().evalVar(mvar, null)) != null) {
                    this.mFactor *= VarContext.objectToFloat(mval, 1.0f);
                }
                if ((suvar = ni.getVar(ATTR_su)) != null && (su = VarContext.objectToFloat(this.getContext().evalVar(suvar, null), -1.0f)) != -1.0f) {
                    this.cellsu = su;
                }
            }
            this.localSettings = new NetlisterConstants(this.cellsu, constants.wireRatio, constants.epsilon, constants.maxIterations, constants.gateCap, constants.alpha, constants.keeperRatio);
        }

        protected float getMFactor() {
            return this.mFactor;
        }

        protected float getSU() {
            return this.cellsu;
        }

        protected NetlisterConstants getSettings() {
            return this.localSettings;
        }
    }

    private static class SaveSettings
    extends Job {
        private Cell cell;
        private Cell settings;
        private NetlisterConstants constants;

        public SaveSettings(Cell cell, Cell settings, NetlisterConstants constants) {
            super("Clear LE Sizes", LETool.getLETool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.cell = cell;
            this.settings = settings;
            this.constants = constants;
            this.startJob();
        }

        public boolean doIt() {
            NodeInst ni;
            Rectangle2D bounds = this.cell.getBounds();
            int x = (int)bounds.getMaxX();
            int y = (int)bounds.getMinY();
            Cell temp = this.settings.iconView();
            if (temp != null) {
                this.settings = temp;
            }
            if ((ni = NodeInst.makeInstance(this.settings, new Point2D.Double(x, y), this.settings.getDefWidth(), this.settings.getDefHeight(), this.cell)) == null) {
                System.out.println("Could not make instance of LESETTINGS in " + this.cell + " to save settings.");
                return false;
            }
            ni.updateVar(ATTR_su, (Object)new Float(this.constants.su));
            ni.updateVar(ATTR_wire_ratio, (Object)new Float(this.constants.wireRatio));
            ni.updateVar(ATTR_epsilon, (Object)new Float(this.constants.epsilon));
            ni.updateVar(ATTR_max_iter, (Object)new Integer(this.constants.maxIterations));
            ni.updateVar(ATTR_gate_cap, (Object)new Float(this.constants.gateCap));
            ni.updateVar(ATTR_alpha, (Object)new Float(this.constants.alpha));
            ni.updateVar(ATTR_keeper_ratio, (Object)new Float(this.constants.keeperRatio));
            return true;
        }
    }

    public static class NetlisterConstants {
        public final float su;
        public final float wireRatio;
        public final float epsilon;
        public final int maxIterations;
        public final float gateCap;
        public final float alpha;
        public final float keeperRatio;

        public NetlisterConstants(float su, float wireRatio, float epsilon, int maxIterations, float gateCap, float alpha, float keeperRatio) {
            this.su = su;
            this.wireRatio = wireRatio;
            this.epsilon = epsilon;
            this.maxIterations = maxIterations;
            this.gateCap = gateCap;
            this.alpha = alpha;
            this.keeperRatio = keeperRatio;
        }

        public NetlisterConstants() {
            this.su = (float)LETool.getGlobalFanout();
            this.epsilon = (float)LETool.getConvergenceEpsilon();
            this.maxIterations = LETool.getMaxIterations();
            this.gateCap = (float)LETool.getGateCapacitance();
            this.wireRatio = (float)LETool.getWireRatio();
            this.alpha = (float)LETool.getDiffAlpha();
            this.keeperRatio = (float)LETool.getKeeperRatio();
        }

        public boolean equals(NetlisterConstants other) {
            if (this.su != other.su) {
                return false;
            }
            if (this.wireRatio != other.wireRatio) {
                return false;
            }
            if (this.epsilon != other.epsilon) {
                return false;
            }
            if (this.maxIterations != other.maxIterations) {
                return false;
            }
            if (this.gateCap != other.gateCap) {
                return false;
            }
            if (this.alpha != other.alpha) {
                return false;
            }
            return this.keeperRatio == other.keeperRatio;
        }
    }
}

