/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.ncc.strategy;

import com.sun.electric.tool.ncc.NccGlobals;
import com.sun.electric.tool.ncc.NccOptions;
import com.sun.electric.tool.ncc.basic.NccUtils;
import com.sun.electric.tool.ncc.lists.LeafList;
import com.sun.electric.tool.ncc.netlist.Mos;
import com.sun.electric.tool.ncc.netlist.NetObject;
import com.sun.electric.tool.ncc.netlist.Part;
import com.sun.electric.tool.ncc.netlist.Resistor;
import com.sun.electric.tool.ncc.netlist.Subcircuit;
import com.sun.electric.tool.ncc.strategy.Strategy;
import com.sun.electric.tool.ncc.trees.Circuit;
import com.sun.electric.tool.ncc.trees.EquivRecord;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class StratCheckSizes
extends Strategy {
    private NccOptions options;
    private double minWidth;
    private double maxWidth;
    private double minLength;
    private double maxLength;
    private Part minWidPart;
    private Part maxWidPart;
    private Part minLenPart;
    private Part maxLenPart;
    private List mismatches = new ArrayList();
    private int cktNdx;
    private int minWidNdx;
    private int maxWidNdx;
    private int minLenNdx;
    private int maxLenNdx;

    private StratCheckSizes(NccGlobals globals) {
        super(globals);
        this.options = globals.getOptions();
    }

    private void checkWidthMismatch() {
        if (!NccUtils.sizesMatch(this.maxWidth, this.minWidth, this.options)) {
            this.mismatches.add(new WidthMismatch(this.minWidth, this.minWidPart, this.minWidNdx, this.maxWidth, this.maxWidPart, this.maxWidNdx));
        }
    }

    private void checkLengthMismatch() {
        if (!NccUtils.sizesMatch(this.maxLength, this.minLength, this.options)) {
            this.mismatches.add(new LengthMismatch(this.minLength, this.minLenPart, this.minLenNdx, this.maxLength, this.maxLenPart, this.maxLenNdx));
        }
    }

    private void summary() {
        if (this.mismatches.size() == 0) {
            return;
        }
        Collections.sort(this.mismatches, new MismatchComparator());
        System.out.println("  There are " + this.mismatches.size() + " size mismatches.");
        Iterator it = this.mismatches.iterator();
        while (it.hasNext()) {
            Mismatch m = (Mismatch)it.next();
            System.out.print(m.toString());
        }
        this.globals.getComparisonResult().setSizeMismatches(this.mismatches);
    }

    private boolean matches() {
        return this.mismatches.size() == 0;
    }

    private double getWidth(Part p) {
        return p instanceof Mos ? ((Mos)p).getWidth() : ((Resistor)p).getWidth();
    }

    private double getLength(Part p) {
        return p instanceof Mos ? ((Mos)p).getLength() : ((Resistor)p).getLength();
    }

    public LeafList doFor(EquivRecord j) {
        if (j.isLeaf()) {
            if (j.isMatched()) {
                this.minLength = Double.MAX_VALUE;
                this.minWidth = Double.MAX_VALUE;
                this.maxLength = Double.MIN_VALUE;
                this.maxWidth = Double.MIN_VALUE;
                this.cktNdx = 0;
                super.doFor(j);
                this.checkWidthMismatch();
                this.checkLengthMismatch();
            }
        } else {
            super.doFor(j);
        }
        return new LeafList();
    }

    public HashMap doFor(Circuit c) {
        HashMap result = super.doFor(c);
        ++this.cktNdx;
        return result;
    }

    public Integer doFor(NetObject n) {
        Part p = (Part)n;
        if (p instanceof Subcircuit) {
            this.maxLength = 1.0;
            this.minLength = 1.0;
            this.maxWidth = 1.0;
            this.minWidth = 1.0;
        } else {
            double l;
            this.globals.error(!(p instanceof Mos) && !(p instanceof Resistor), "part with no width & length");
            double w = this.getWidth(p);
            if (w < this.minWidth) {
                this.minWidth = w;
                this.minWidPart = p;
                this.minWidNdx = this.cktNdx;
            }
            if (w > this.maxWidth) {
                this.maxWidth = w;
                this.maxWidPart = p;
                this.maxWidNdx = this.cktNdx;
            }
            if ((l = this.getLength(p)) < this.minLength) {
                this.minLength = l;
                this.minLenPart = p;
                this.minLenNdx = this.cktNdx;
            }
            if (l > this.maxLength) {
                this.maxLength = l;
                this.maxLenPart = p;
                this.maxLenNdx = this.cktNdx;
            }
        }
        return CODE_NO_CHANGE;
    }

    public static boolean doYourJob(NccGlobals globals) {
        NccOptions options = globals.getOptions();
        if (!options.checkSizes) {
            return true;
        }
        EquivRecord parts = globals.getParts();
        if (parts == null) {
            return true;
        }
        StratCheckSizes jsf = new StratCheckSizes(globals);
        jsf.doFor(parts);
        jsf.summary();
        return jsf.matches();
    }

    private static class MismatchComparator
    implements Comparator {
        private MismatchComparator() {
        }

        public int compare(Object o1, Object o2) {
            Mismatch m1 = (Mismatch)o1;
            Mismatch m2 = (Mismatch)o2;
            double diff = m1.relErr() - m2.relErr();
            if (diff == 0.0) {
                return 0;
            }
            return diff < 0.0 ? 1 : -1;
        }
    }

    public static class WidthMismatch
    extends Mismatch {
        public String widLen() {
            return "width";
        }

        public String wl() {
            return "W";
        }

        public WidthMismatch(double min, Part minPart, int minNdx, double max, Part maxPart, int maxNdx) {
            super(min, minPart, minNdx, max, maxPart, maxNdx);
        }
    }

    public static class LengthMismatch
    extends Mismatch {
        public String widLen() {
            return "length";
        }

        public String wl() {
            return "L";
        }

        public LengthMismatch(double min, Part minPart, int minNdx, double max, Part maxPart, int maxNdx) {
            super(min, minPart, minNdx, max, maxPart, maxNdx);
        }
    }

    public static abstract class Mismatch {
        private StringBuffer sb = new StringBuffer();
        public final double min;
        public final double max;
        public final Part minPart;
        public final Part maxPart;
        public final int minNdx;
        public final int maxNdx;

        private void aln(String s) {
            this.sb.append(s);
            this.sb.append("\n");
        }

        Mismatch(double min, Part minPart, int minNdx, double max, Part maxPart, int maxNdx) {
            this.min = min;
            this.max = max;
            this.minPart = minPart;
            this.maxPart = maxPart;
            this.minNdx = minNdx;
            this.maxNdx = maxNdx;
        }

        public double relErr() {
            return (this.max - this.min) / this.min;
        }

        public double absErr() {
            return this.max - this.min;
        }

        public abstract String widLen();

        public abstract String wl();

        public String toString() {
            double maxSz;
            double minSz;
            double absErr;
            double relErr;
            if (this.relErr() * 100.0 < 0.1 || this.absErr() < 0.1) {
                relErr = this.relErr() * 100.0;
                absErr = this.absErr();
                minSz = this.min;
                maxSz = this.max;
            } else {
                relErr = NccUtils.round(this.relErr() * 100.0, 1);
                absErr = NccUtils.round(this.absErr(), 2);
                minSz = NccUtils.round(this.min, 2);
                maxSz = NccUtils.round(this.max, 2);
            }
            this.aln("    " + this.minPart.typeString() + " " + this.widLen() + "s don't match. " + " relativeError=" + relErr + "%" + " absoluteError=" + absErr);
            this.aln("      " + this.wl() + "=" + minSz + " for " + this.minPart.fullDescription());
            this.aln("      " + this.wl() + "=" + maxSz + " for " + this.maxPart.fullDescription());
            return this.sb.toString();
        }
    }
}

