/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.routing;

import com.sun.electric.database.geometry.DBMath;
import com.sun.electric.database.geometry.GenMath;
import com.sun.electric.database.geometry.Geometric;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.geometry.PolyMerge;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.network.Network;
import com.sun.electric.database.prototype.PortOriginal;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Connection;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.routing.InteractiveRouter;
import com.sun.electric.tool.routing.Route;
import com.sun.electric.tool.routing.RouteElement;
import com.sun.electric.tool.routing.RouteElementArc;
import com.sun.electric.tool.routing.RouteElementPort;
import com.sun.electric.tool.routing.Router;
import com.sun.electric.tool.routing.Routing;
import com.sun.electric.tool.routing.SimpleWirer;
import com.sun.electric.tool.user.CircuitChanges;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.tool.user.ui.WindowFrame;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class AutoStitch {
    private static ArcProto preferredArc;
    private static InteractiveRouter router;
    private static List allRoutes;
    private static Pairs intendedPairs;
    private static HashSet possibleInlinePins;
    private static HashSet nodeMark;

    public static void autoStitch(boolean highlighted, boolean forced) {
        AutoStitchJob job = new AutoStitchJob(highlighted, forced);
    }

    public static void runAutoStitch(Cell cell, boolean highlighted, boolean forced, PolyMerge stayInside) {
        Netlist netlist;
        ArcProto curAp;
        NodeInst ni;
        ArrayList<NodeInst> nodesToStitch = new ArrayList<NodeInst>();
        ArrayList<ArcInst> arcsToStitch = new ArrayList<ArcInst>();
        if (highlighted) {
            EditWindow wnd = EditWindow.getCurrent();
            if (wnd == null) {
                return;
            }
            List highs = wnd.getHighlighter().getHighlightedEObjs(true, true);
            Iterator it = highs.iterator();
            while (it.hasNext()) {
                ElectricObject eObj = (ElectricObject)it.next();
                if (eObj instanceof PortInst) {
                    eObj = ((PortInst)eObj).getNodeInst();
                }
                if (eObj instanceof NodeInst) {
                    PrimitiveNode pnp;
                    ni = (NodeInst)eObj;
                    if (ni.getProto() instanceof PrimitiveNode && ((pnp = (PrimitiveNode)ni.getProto()).getTechnology() == Generic.tech || pnp.getFunction() == PrimitiveNode.Function.NODE)) continue;
                    nodesToStitch.add((NodeInst)eObj);
                    continue;
                }
                if (!(eObj instanceof ArcInst)) continue;
                arcsToStitch.add((ArcInst)eObj);
            }
        } else {
            Iterator it = cell.getNodes();
            while (it.hasNext()) {
                PrimitiveNode pnp;
                NodeInst ni2 = (NodeInst)it.next();
                if (ni2.isIconOfParent() || ni2.getProto() instanceof PrimitiveNode && ((pnp = (PrimitiveNode)ni2.getProto()).getTechnology() == Generic.tech || pnp.getFunction() == PrimitiveNode.Function.NODE)) continue;
                nodesToStitch.add(ni2);
            }
            it = cell.getArcs();
            while (it.hasNext()) {
                ArcInst ai = (ArcInst)it.next();
                arcsToStitch.add(ai);
            }
        }
        if (nodesToStitch.size() == 0 && arcsToStitch.size() == 0) {
            if (forced) {
                System.out.println("Nothing selected to auto-route");
            }
            return;
        }
        allRoutes = new ArrayList();
        intendedPairs = new Pairs();
        possibleInlinePins = new HashSet();
        HashSet<Cell> cellMark = new HashSet<Cell>();
        nodeMark = new HashSet();
        int count = 0;
        HashMap<NodeInst, Rectangle2D[]> nodeBounds = new HashMap<NodeInst, Rectangle2D[]>();
        Iterator it = nodesToStitch.iterator();
        while (it.hasNext()) {
            NodeInst nodeToStitch = (NodeInst)it.next();
            if (cellMark.contains(cell)) continue;
            cellMark.add(cell);
            Iterator nIt = cell.getNodes();
            while (nIt.hasNext()) {
                NodeInst ni3 = (NodeInst)nIt.next();
                nodeMark.remove(ni3);
                int total = ni3.getProto().getNumPorts();
                Rectangle2D[] bbArray = new Rectangle2D[total];
                nodeBounds.put(ni3, bbArray);
                int i = 0;
                Iterator pIt = ni3.getProto().getPorts();
                while (pIt.hasNext()) {
                    PortProto pp = (PortProto)pIt.next();
                    PortOriginal fp = new PortOriginal(ni3, pp);
                    AffineTransform trans = fp.getTransformToTop();
                    NodeInst rNi = fp.getBottomNodeInst();
                    Rectangle2D.Double bounds = new Rectangle2D.Double(rNi.getAnchorCenterX() - rNi.getXSize() / 2.0, rNi.getAnchorCenterY() - rNi.getYSize() / 2.0, rNi.getXSize(), rNi.getYSize());
                    DBMath.transformRect(bounds, trans);
                    bbArray[i++] = bounds;
                }
            }
        }
        it = nodesToStitch.iterator();
        while (it.hasNext()) {
            ni = (NodeInst)it.next();
            nodeMark.add(ni);
        }
        preferredArc = null;
        String preferredName = Routing.getPreferredRoutingArc();
        if (preferredName.length() > 0) {
            preferredArc = ArcProto.findArcProto(preferredName);
        }
        if (preferredArc == null && (curAp = User.getUserTool().getCurrentArcProto()) != null) {
            preferredArc = curAp;
        }
        HashMap arcLayers = new HashMap();
        HashMap arcCount = new HashMap();
        Iterator it2 = nodesToStitch.iterator();
        while (it2.hasNext()) {
            NodeInst ni4 = (NodeInst)it2.next();
            if (cell.isAllLocked()) continue;
            netlist = cell.acquireUserNetlist();
            if (netlist == null) {
                System.out.println("Sorry, a deadlock aborted auto-routing (network information unavailable).  Please try again");
                break;
            }
            count += AutoStitch.checkStitching(ni4, arcCount, nodeBounds, arcLayers, stayInside, netlist);
        }
        it2 = arcsToStitch.iterator();
        while (it2.hasNext()) {
            ArcInst ai = (ArcInst)it2.next();
            if (!ai.isLinked() || cell.isAllLocked() || !AutoStitch.arcTooWide(ai)) continue;
            netlist = cell.acquireUserNetlist();
            if (netlist == null) {
                System.out.println("Sorry, a deadlock aborted auto-routing (network information unavailable).  Please try again");
                break;
            }
            count += AutoStitch.checkStitching(ai, arcCount, nodeBounds, arcLayers, stayInside, netlist);
        }
        if (forced) {
            if (count != 0) {
                StringBuffer buf = new StringBuffer();
                buf.append("AUTO ROUTING: added ");
                boolean first = true;
                Iterator it3 = arcCount.keySet().iterator();
                while (it3.hasNext()) {
                    ArcProto ap = (ArcProto)it3.next();
                    if (!first) {
                        buf.append("; ");
                    }
                    Integer c = (Integer)arcCount.get(ap);
                    buf.append(c + " " + ap.describe() + " wires");
                    first = false;
                }
                System.out.println(buf.toString());
            } else {
                System.out.println("No arcs added");
            }
        }
        it2 = Library.getLibraries();
        while (it2.hasNext()) {
            Library lib = (Library)it2.next();
            Iterator cIt = lib.getCells();
            while (cIt.hasNext()) {
                Cell c = (Cell)cIt.next();
                if (cellMark.contains(c)) continue;
            }
        }
        cellMark = null;
        nodeMark = null;
        it2 = allRoutes.iterator();
        while (it2.hasNext()) {
            Route route = (Route)it2.next();
            RouteElement re = (RouteElement)route.get(0);
            Cell c = re.getCell();
            RouteElementPort start = route.getStart();
            RouteElementPort end = route.getEnd();
            PortInst startPi = start.getPortInst();
            PortInst endPi = end.getPortInst();
            if (startPi != null && endPi != null) {
                boolean already = false;
                Iterator cIt = startPi.getConnections();
                while (cIt.hasNext()) {
                    Connection con = (Connection)cIt.next();
                    ArcInst existingAI = con.getArc();
                    if (existingAI.getHead() == con) {
                        if (existingAI.getTail().getPortInst() != endPi) continue;
                        already = true;
                        break;
                    }
                    if (existingAI.getHead().getPortInst() != endPi) continue;
                    already = true;
                    break;
                }
                if (already) continue;
            }
            if (stayInside != null) {
                Iterator rIt = route.iterator();
                while (rIt.hasNext()) {
                    RouteElementArc reArc;
                    Object obj = rIt.next();
                    if (!(obj instanceof RouteElementArc) || (reArc = (RouteElementArc)obj).getAction() == RouteElement.RouteElementAction.deleteArc) continue;
                    Point2D head = reArc.getHeadConnPoint();
                    Point2D tail = reArc.getTailConnPoint();
                    ArcProto ap = reArc.getArcProto();
                    Layer arcLayer = ap.getLayers()[0].getLayer();
                    double width = ap.getDefaultWidth();
                    if (AutoStitch.arcInMerge(head, tail, reArc.getArcWidth(), stayInside, arcLayer)) continue;
                    double tinyAmountLess = reArc.getArcWidth() - DBMath.getEpsilon();
                    if (AutoStitch.arcInMerge(head, tail, tinyAmountLess, stayInside, arcLayer)) {
                        reArc.setArcWidth(tinyAmountLess);
                        continue;
                    }
                    if (AutoStitch.arcInMerge(head, tail, ap.getDefaultWidth(), stayInside, arcLayer)) {
                        reArc.setArcWidth(ap.getDefaultWidth());
                        continue;
                    }
                    reArc.setArcWidth(ap.getWidthOffset());
                }
            }
            Router.createRouteNoJob(route, c, false, false, null);
        }
        ArrayList<CircuitChanges.Reconnect> pinsToPassThrough = new ArrayList<CircuitChanges.Reconnect>();
        Iterator it4 = possibleInlinePins.iterator();
        while (it4.hasNext()) {
            CircuitChanges.Reconnect re;
            NodeInst ni5 = (NodeInst)it4.next();
            if (!ni5.isInlinePin() || (re = CircuitChanges.Reconnect.erasePassThru(ni5, false)) == null) continue;
            pinsToPassThrough.add(re);
        }
        if (pinsToPassThrough.size() > 0) {
            CircuitChanges.CleanupChanges job = new CircuitChanges.CleanupChanges(cell, true, new ArrayList(), pinsToPassThrough, new HashMap(), new ArrayList(), new HashSet(), 0, 0, 0);
            job.doIt();
        }
    }

    private static boolean arcTooWide(ArcInst ai) {
        boolean headTooWide = true;
        NodeInst hNi = ai.getHeadPortInst().getNodeInst();
        if (hNi.getProto() instanceof Cell) {
            headTooWide = false;
        } else if (ai.getWidth() <= hNi.getXSize() && ai.getWidth() <= hNi.getYSize()) {
            headTooWide = false;
        }
        boolean tailTooWide = true;
        NodeInst tNi = ai.getTailPortInst().getNodeInst();
        if (tNi.getProto() instanceof Cell) {
            tailTooWide = false;
        } else if (ai.getWidth() <= tNi.getXSize() && ai.getWidth() <= tNi.getYSize()) {
            tailTooWide = false;
        }
        return headTooWide || tailTooWide;
    }

    private static boolean arcInMerge(Point2D head, Point2D tail, double width, PolyMerge stayInside, Layer layer) {
        Poly arcPoly;
        Rectangle2D.Double arcRect;
        return head.equals(tail) ? stayInside.contains(layer, arcRect = new Rectangle2D.Double(head.getX() - width / 2.0, head.getY() - width / 2.0, width, width)) : stayInside.contains(layer, arcPoly = Poly.makeEndPointPoly(head.distance(tail), width, GenMath.figureAngle(head, tail), head, width / 2.0, tail, width / 2.0));
    }

    private static int checkStitching(Geometric geom, HashMap arcCount, HashMap nodeBounds, HashMap arcLayers, PolyMerge stayInside, Netlist netlist) {
        Cell cell = geom.getParent();
        NodeInst ni = null;
        if (geom instanceof NodeInst) {
            ni = (NodeInst)geom;
        }
        ArrayList geomsInArea = new ArrayList();
        Rectangle2D geomBounds = geom.getBounds();
        double epsilon = DBMath.getEpsilon();
        Rectangle2D.Double searchBounds = new Rectangle2D.Double(geomBounds.getMinX() - epsilon, geomBounds.getMinY() - epsilon, geomBounds.getWidth() + epsilon * 2.0, geomBounds.getHeight() + epsilon * 2.0);
        Iterator it = cell.searchIterator(searchBounds);
        while (it.hasNext()) {
            geomsInArea.add(it.next());
        }
        int count = 0;
        Iterator it2 = geomsInArea.iterator();
        while (it2.hasNext()) {
            PrimitiveNode pnp;
            Geometric oGeom = (Geometric)it2.next();
            if (oGeom instanceof ArcInst) {
                ArcInst oAi = (ArcInst)oGeom;
                if (!AutoStitch.arcTooWide(oAi)) continue;
                if (ni == null) {
                    count += AutoStitch.compareTwoArcs((ArcInst)geom, oAi, stayInside, netlist);
                    continue;
                }
                count += AutoStitch.compareNodeWithArc(ni, oAi, stayInside, netlist);
                continue;
            }
            NodeInst oNi = (NodeInst)oGeom;
            if (oNi.getProto() instanceof PrimitiveNode && ((pnp = (PrimitiveNode)oNi.getProto()).getTechnology() == Generic.tech || pnp.getFunction() == PrimitiveNode.Function.NODE)) continue;
            if (ni == null) {
                count += AutoStitch.compareNodeWithArc(oNi, (ArcInst)geom, stayInside, netlist);
                continue;
            }
            count += AutoStitch.compareTwoNodes(ni, oNi, arcCount, nodeBounds, arcLayers, stayInside, netlist);
        }
        return count;
    }

    private static int compareTwoNodes(NodeInst ni, NodeInst oNi, HashMap arcCount, HashMap nodeBounds, HashMap arcLayers, PolyMerge stayInside, Netlist netlist) {
        int count = 0;
        if (nodeMark.contains(oNi) && oNi.getNodeIndex() <= ni.getNodeIndex()) {
            return count;
        }
        Rectangle2D oBounds = oNi.getBounds();
        if (ni.getProto() instanceof Cell) {
            Rectangle2D[] boundArray = (Rectangle2D[])nodeBounds.get(ni);
            int bbp = 0;
            Iterator pIt = ni.getProto().getPorts();
            block0: while (pIt.hasNext()) {
                Rectangle2D bounds;
                PortProto pp = (PortProto)pIt.next();
                if (boundArray != null && ((bounds = boundArray[bbp++]).getMinX() > oBounds.getMaxX() || bounds.getMaxX() < oBounds.getMinX() || bounds.getMinY() > oBounds.getMaxY() || bounds.getMaxY() < oBounds.getMinY())) continue;
                AffineTransform trans = ni.rotateOut();
                NodeInst rNi = ni;
                PortProto rPp = pp;
                while (rNi.getProto() instanceof Cell) {
                    AffineTransform temp = rNi.translateOut();
                    temp.preConcatenate(trans);
                    Export e = (Export)rPp;
                    rNi = e.getOriginalPort().getNodeInst();
                    rPp = e.getOriginalPort().getPortProto();
                    trans = rNi.rotateOut();
                    trans.preConcatenate(temp);
                }
                ArcProto[] connections = pp.getBasePort().getConnections();
                for (int i = 0; i < connections.length; ++i) {
                    AutoStitch.findSmallestLayer(connections[i], arcLayers);
                }
                boolean usePortPoly = false;
                Poly[] nodePolys = AutoStitch.shapeOfNode(rNi);
                int tot = nodePolys.length;
                if (tot == 0 || rNi.getProto() == Generic.tech.simProbeNode) {
                    usePortPoly = true;
                    tot = 1;
                }
                Netlist subNetlist = rNi.getParent().getUserNetlist();
                for (int j = 0; j < tot; ++j) {
                    Layer layer = null;
                    Poly poly = null;
                    if (usePortPoly) {
                        poly = ni.getShapeOfPort(pp);
                        layer = poly.getLayer();
                    } else {
                        poly = nodePolys[j];
                        if (poly.getPort() == null || !subNetlist.portsConnected(rNi, rPp, poly.getPort())) continue;
                        poly.transform(trans);
                        layer = poly.getLayer();
                        if (layer != null) {
                            layer = layer.getNonPseudoLayer();
                        }
                    }
                    boolean connected = false;
                    for (int pass = 0; pass < 2; ++pass) {
                        for (int i = 0; i < connections.length; ++i) {
                            ArcProto ap = connections[i];
                            if (pass != 0 ? ap == preferredArc || ap.getTechnology() != rNi.getProto().getTechnology() : ap != preferredArc) continue;
                            if (!usePortPoly) {
                                Layer oLayer = (Layer)arcLayers.get(ap);
                                if (!layer.getTechnology().sameLayer(oLayer, layer)) continue;
                            }
                            if (!(connected = AutoStitch.testPoly(ni, pp, ap, poly, oNi, netlist, nodeBounds, arcLayers, stayInside))) continue;
                            Integer c = (Integer)arcCount.get(ap);
                            if (c == null) {
                                c = new Integer(0);
                            }
                            c = new Integer(c + 1);
                            arcCount.put(ap, c);
                            ++count;
                            break;
                        }
                        if (connected) break;
                    }
                    if (connected) continue block0;
                }
            }
        } else {
            AffineTransform trans = ni.rotateOut();
            double oX = oNi.getAnchorCenterX();
            double oY = oNi.getAnchorCenterY();
            boolean usePortPoly = false;
            Poly[] polys = AutoStitch.shapeOfNode(ni);
            int tot = polys.length;
            if (tot == 0 || ni.getProto() == Generic.tech.simProbeNode) {
                usePortPoly = true;
                tot = 1;
            }
            for (int j = 0; j < tot; ++j) {
                double dist;
                double y;
                Iterator pIt;
                double bestDist;
                PortProto bestPp;
                PortProto rPp = null;
                Poly polyPtr = null;
                if (usePortPoly) {
                    bestPp = null;
                    bestDist = 0.0;
                    pIt = ni.getProto().getPorts();
                    while (pIt.hasNext()) {
                        PortProto tPp = (PortProto)pIt.next();
                        Poly portPoly = ni.getShapeOfPort(tPp);
                        double x = portPoly.getCenterX();
                        y = portPoly.getCenterY();
                        dist = Math.abs(x - oX) + Math.abs(y - oY);
                        if (bestPp == null) {
                            bestDist = dist;
                            bestPp = tPp;
                        }
                        if (dist > bestDist) continue;
                        bestPp = tPp;
                        bestDist = dist;
                    }
                    if (bestPp == null) continue;
                    rPp = bestPp;
                    polyPtr = ni.getShapeOfPort(rPp);
                } else {
                    polyPtr = polys[j];
                    if (polyPtr.getPort() == null) continue;
                    bestPp = null;
                    bestDist = 0.0;
                    pIt = ni.getProto().getPorts();
                    while (pIt.hasNext()) {
                        PortProto tPp = (PortProto)pIt.next();
                        if (!netlist.portsConnected(ni, tPp, polyPtr.getPort())) continue;
                        Poly portPoly = ni.getShapeOfPort(tPp);
                        double x = portPoly.getCenterX();
                        y = portPoly.getCenterY();
                        dist = Math.abs(x - oX) + Math.abs(y - oY);
                        if (bestPp == null) {
                            bestDist = dist;
                        }
                        if (dist > bestDist) continue;
                        bestPp = tPp;
                        bestDist = dist;
                    }
                    if (bestPp == null) continue;
                    rPp = bestPp;
                    polyPtr.transform(trans);
                }
                Layer layer = polyPtr.getLayer();
                if (layer != null) {
                    layer = layer.getNonPseudoLayer();
                }
                boolean found = false;
                Iterator cIt = ni.getConnections();
                while (cIt.hasNext()) {
                    Connection con = (Connection)cIt.next();
                    PortInst pi = con.getPortInst();
                    if (!netlist.portsConnected(ni, rPp, pi.getPortProto()) || con.getArc().getHeadPortInst().getNodeInst() != oNi && con.getArc().getTailPortInst().getNodeInst() != oNi) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                boolean connected = false;
                ArcProto[] connections = rPp.getBasePort().getConnections();
                for (int pass = 0; pass < 2; ++pass) {
                    for (int i = 0; i < connections.length; ++i) {
                        ArcProto ap = connections[i];
                        if (pass != 0 ? ap == preferredArc : ap != preferredArc) continue;
                        if (ap.getTechnology() != ni.getProto().getTechnology()) break;
                        AutoStitch.findSmallestLayer(ap, arcLayers);
                        if (!usePortPoly) {
                            Layer oLayer = (Layer)arcLayers.get(ap);
                            if (!ap.getTechnology().sameLayer(oLayer, layer)) continue;
                        }
                        if (!(connected = AutoStitch.testPoly(ni, rPp, ap, polyPtr, oNi, netlist, nodeBounds, arcLayers, stayInside))) continue;
                        Integer c = (Integer)arcCount.get(ap);
                        if (c == null) {
                            c = new Integer(0);
                        }
                        c = new Integer(c + 1);
                        arcCount.put(ap, c);
                        ++count;
                        break;
                    }
                    if (connected) break;
                }
                if (!connected) {
                    continue;
                }
                break;
            }
        }
        return count;
    }

    private static int compareTwoArcs(ArcInst ai1, ArcInst ai2, PolyMerge stayInside, Netlist nl) {
        Network net2;
        if (ai1.getProto() != ai2.getProto()) {
            return 0;
        }
        Network net1 = nl.getNetwork(ai1, 0);
        if (net1 == (net2 = nl.getNetwork(ai2, 0))) {
            return 0;
        }
        boolean usePortPoly = false;
        Poly[] polys1 = ai1.getProto().getTechnology().getShapeOfArc(ai1);
        int tot1 = polys1.length;
        Poly[] polys2 = ai2.getProto().getTechnology().getShapeOfArc(ai1);
        int tot2 = polys2.length;
        for (int i1 = 0; i1 < tot1; ++i1) {
            Poly poly1 = polys1[i1];
            Layer layer1 = poly1.getLayer();
            Rectangle2D bounds1 = poly1.getBounds2D();
            for (int i2 = 0; i2 < tot2; ++i2) {
                Rectangle2D bounds2;
                Poly poly2 = polys2[i2];
                if (layer1 != poly2.getLayer() || !bounds1.intersects(bounds2 = poly2.getBounds2D())) continue;
                Rectangle2D.Double intersection = new Rectangle2D.Double();
                Rectangle2D.intersect(bounds1, bounds2, intersection);
                double x = intersection.getCenterX();
                double y = intersection.getCenterY();
                AutoStitch.connectObjects(ai1, net1, ai2, net2, ai1.getParent(), new Point2D.Double(x, y), stayInside);
                return 1;
            }
        }
        return 0;
    }

    private static int compareNodeWithArc(NodeInst ni, ArcInst ai, PolyMerge stayInside, Netlist nl) {
        if (ni.getProto() instanceof Cell) {
            return 0;
        }
        Network arcNet = nl.getNetwork(ai, 0);
        Poly[] arcPolys = ai.getProto().getTechnology().getShapeOfArc(ai);
        int aTot = arcPolys.length;
        for (int i = 0; i < aTot; ++i) {
            Poly arcPoly = arcPolys[i];
            Layer arcLayer = arcPoly.getLayer();
            Rectangle2D arcBounds = arcPoly.getBounds2D();
            double aCX = arcBounds.getCenterX();
            double aCY = arcBounds.getCenterY();
            Poly[] nodePolys = AutoStitch.shapeOfNode(ni);
            int nTot = nodePolys.length;
            for (int j = 0; j < nTot; ++j) {
                PortInst pi;
                Network nodeNet;
                Poly nodePoly = nodePolys[j];
                if (nodePoly.getLayer() != arcLayer || arcPoly.separation(nodePoly) > 0.0 || nodePoly.getPort() == null) continue;
                PortProto bestPp = null;
                double bestDist = 0.0;
                Iterator pIt = ni.getProto().getPorts();
                while (pIt.hasNext()) {
                    PortProto tPp = (PortProto)pIt.next();
                    if (!nl.portsConnected(ni, tPp, nodePoly.getPort())) continue;
                    Poly portPoly = ni.getShapeOfPort(tPp);
                    double x = portPoly.getCenterX();
                    double y = portPoly.getCenterY();
                    double dist = Math.abs(x - aCX) + Math.abs(y - aCY);
                    if (bestPp == null) {
                        bestDist = dist;
                    }
                    if (dist > bestDist) continue;
                    bestPp = tPp;
                    bestDist = dist;
                }
                if (bestPp == null || arcNet == (nodeNet = nl.getNetwork(pi = ni.findPortInstFromProto(bestPp)))) continue;
                AutoStitch.connectObjects(ai, arcNet, pi, nodeNet, ai.getParent(), new Point2D.Double(aCX, aCY), stayInside);
                return 1;
            }
        }
        return 0;
    }

    private static boolean connectObjects(ElectricObject eobj1, Network net1, ElectricObject eobj2, Network net2, Cell cell, Point2D ctr, PolyMerge stayInside) {
        if (intendedPairs.contains(net1, net2)) {
            return false;
        }
        intendedPairs.add(net1, net2);
        NodeInst ni1 = null;
        if (eobj1 instanceof NodeInst) {
            ni1 = (NodeInst)eobj1;
        } else if (eobj1 instanceof PortInst) {
            ni1 = ((PortInst)eobj1).getNodeInst();
        }
        NodeInst ni2 = null;
        if (eobj2 instanceof NodeInst) {
            ni2 = (NodeInst)eobj2;
        } else if (eobj2 instanceof PortInst) {
            ni2 = ((PortInst)eobj2).getNodeInst();
        }
        Route route = router.planRoute(cell, eobj1, eobj2, ctr, stayInside);
        if (route.size() == 0) {
            return false;
        }
        allRoutes.add(route);
        if (ni1 != null && ni1.getFunction() == PrimitiveNode.Function.PIN && ni1.getNumExports() == 0 && ni1.getNumConnections() == 0) {
            possibleInlinePins.add(ni1);
        }
        if (ni2 != null && ni2.getFunction() == PrimitiveNode.Function.PIN && ni2.getNumExports() == 0 && ni2.getNumConnections() == 0) {
            possibleInlinePins.add(ni2);
        }
        return true;
    }

    private static boolean testPoly(NodeInst ni, PortProto pp, ArcProto ap, Poly poly, NodeInst oNi, Netlist netlist, HashMap nodeBounds, HashMap arcLayers, PolyMerge stayInside) {
        PortInst pi = ni.findPortInstFromProto(pp);
        Network net = netlist.getNetwork(pi);
        if (oNi.getProto() instanceof Cell) {
            Rectangle2D[] boundArray = (Rectangle2D[])nodeBounds.get(oNi);
            int bbp = 0;
            Rectangle2D bounds = poly.getBounds2D();
            Iterator it = oNi.getProto().getPorts();
            while (it.hasNext()) {
                Rectangle2D oBounds;
                PortProto mPp = (PortProto)it.next();
                if (boundArray != null && ((oBounds = boundArray[bbp++]).getMinX() > bounds.getMaxX() || oBounds.getMaxX() < bounds.getMinX() || oBounds.getMinY() > bounds.getMaxY() || oBounds.getMaxY() < bounds.getMinY()) || !mPp.getBasePort().connectsTo(ap)) continue;
                Network oNet = netlist.getNetwork(oNi.findPortInstFromProto(mPp));
                if (net != null && oNet == net) continue;
                PortInst oPi = oNi.findPortInstFromProto(mPp);
                boolean ignore = false;
                Iterator piit = oPi.getConnections();
                while (piit.hasNext()) {
                    Connection conn = (Connection)piit.next();
                    ArcInst ai = conn.getArc();
                    if (ai.getHeadPortInst() == pi) {
                        ignore = true;
                    }
                    if (ai.getTailPortInst() != pi) continue;
                    ignore = true;
                }
                if (ignore) continue;
                AffineTransform trans = oNi.rotateOut();
                NodeInst rNi = oNi;
                PortProto rPp = mPp;
                while (rNi.getProto() instanceof Cell) {
                    AffineTransform temp = rNi.translateOut();
                    temp.preConcatenate(trans);
                    Export e = (Export)rPp;
                    rNi = e.getOriginalPort().getNodeInst();
                    rPp = e.getOriginalPort().getPortProto();
                    trans = rNi.rotateOut();
                    trans.preConcatenate(temp);
                }
                Poly[] polys = AutoStitch.shapeOfNode(rNi);
                int tot = polys.length;
                if (tot == 0) {
                    Poly oPoly = oNi.getShapeOfPort(mPp);
                    if (!AutoStitch.comparePoly(oNi, mPp, oPoly, oNet, ni, pp, poly, net, ap, stayInside, netlist)) continue;
                    return true;
                }
                Netlist subNetlist = rNi.getParent().getUserNetlist();
                for (int j = 0; j < tot; ++j) {
                    Poly oPoly = polys[j];
                    if (oPoly.getPort() == null || !subNetlist.portsConnected(rNi, rPp, oPoly.getPort())) continue;
                    if (ni.getProto() != Generic.tech.simProbeNode) {
                        Layer oLayer = oPoly.getLayer();
                        if (oLayer != null) {
                            oLayer = oLayer.getNonPseudoLayer();
                        }
                        Layer apLayer = (Layer)arcLayers.get(ap);
                        if (!oLayer.getTechnology().sameLayer(oLayer, apLayer)) continue;
                    }
                    oPoly.transform(trans);
                    if (!AutoStitch.comparePoly(oNi, mPp, oPoly, oNet, ni, pp, poly, net, ap, stayInside, netlist)) continue;
                    return true;
                }
            }
        } else {
            AffineTransform trans = oNi.rotateOut();
            double ox = poly.getCenterX();
            double oy = poly.getCenterY();
            Poly[] polys = AutoStitch.shapeOfNode(oNi);
            int tot = polys.length;
            if (tot == 0) {
                PortProto bestPp = null;
                double bestDist = 0.0;
                Iterator pIt = oNi.getProto().getPorts();
                while (pIt.hasNext()) {
                    PortProto rPp = (PortProto)pIt.next();
                    Poly portPoly = oNi.getShapeOfPort(rPp);
                    double dist = Math.abs(portPoly.getCenterX() - ox) + Math.abs(portPoly.getCenterY() - oy);
                    if (bestPp == null) {
                        bestDist = dist;
                        bestPp = rPp;
                    }
                    if (dist > bestDist) continue;
                    bestPp = rPp;
                    bestDist = dist;
                }
                if (bestPp != null) {
                    Poly oPoly;
                    PortProto rPp = bestPp;
                    Network oNet = netlist.getNetwork(oNi.findPortInstFromProto(bestPp));
                    if ((net == null || oNet != net) && rPp.getBasePort().connectsTo(ap) && AutoStitch.comparePoly(oNi, rPp, oPoly = oNi.getShapeOfPort(rPp), oNet, ni, pp, poly, net, ap, stayInside, netlist)) {
                        return true;
                    }
                }
            } else {
                for (int j = 0; j < tot; ++j) {
                    PortProto rPp;
                    Layer apLayer;
                    Poly oPoly = polys[j];
                    if (oPoly.getPort() == null) continue;
                    Layer oLayer = oPoly.getLayer();
                    if (oLayer != null) {
                        oLayer = oLayer.getNonPseudoLayer();
                    }
                    if (!(apLayer = (Layer)arcLayers.get(ap)).getTechnology().sameLayer(apLayer, oLayer)) continue;
                    PortInst oPi = oNi.findPortInstFromProto(oPoly.getPort());
                    Network oNet = netlist.getNetwork(oPi);
                    if (net != null && oNet == net) continue;
                    PortProto bestPp = null;
                    double bestDist = 0.0;
                    Iterator pIt = oNi.getProto().getPorts();
                    while (pIt.hasNext()) {
                        PortProto rPp2 = (PortProto)pIt.next();
                        if (!netlist.portsConnected(oNi, rPp2, oPoly.getPort())) continue;
                        Poly portPoly = oNi.getShapeOfPort(rPp2);
                        double dist = Math.abs(ox - portPoly.getCenterX()) + Math.abs(oy - portPoly.getCenterY());
                        if (bestPp == null) {
                            bestDist = dist;
                        }
                        if (dist > bestDist) continue;
                        bestPp = rPp2;
                        bestDist = dist;
                    }
                    if (bestPp == null || !(rPp = bestPp).getBasePort().connectsTo(ap)) continue;
                    oPoly.transform(trans);
                    if (!AutoStitch.comparePoly(oNi, rPp, oPoly, oNet, ni, pp, poly, net, ap, stayInside, netlist)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean comparePoly(NodeInst oNi, PortProto opp, Poly oPoly, Network oNet, NodeInst ni, PortProto pp, Poly poly, Network net, ArcProto ap, PolyMerge stayInside, Netlist netlist) {
        Point2D.Double tPortCenter;
        double tDist;
        PortProto tPp;
        if (poly.separation(oPoly) > 0.0) {
            return false;
        }
        Poly portPoly = ni.getShapeOfPort(pp);
        Point2D.Double portCenter = new Point2D.Double(portPoly.getCenterX(), portPoly.getCenterY());
        portPoly = oNi.getShapeOfPort(opp);
        Point2D.Double oPortCenter = new Point2D.Double(portPoly.getCenterX(), portPoly.getCenterY());
        double dist = portCenter.distance(oPortCenter);
        Iterator it = oNi.getProto().getPorts();
        while (it.hasNext()) {
            tPp = (PortProto)it.next();
            if (tPp == opp || !netlist.portsConnected(oNi, tPp, opp) || (tDist = portCenter.distance(tPortCenter = new Point2D.Double((portPoly = oNi.getShapeOfPort(tPp)).getCenterX(), portPoly.getCenterY()))) >= dist) continue;
            dist = tDist;
            opp = tPp;
            oPortCenter.setLocation(tPortCenter);
        }
        it = ni.getProto().getPorts();
        while (it.hasNext()) {
            tPp = (PortProto)it.next();
            if (tPp == pp || !netlist.portsConnected(ni, tPp, pp) || (tDist = oPortCenter.distance(tPortCenter = new Point2D.Double((portPoly = ni.getShapeOfPort(tPp)).getCenterX(), portPoly.getCenterY()))) >= dist) continue;
            dist = tDist;
            pp = tPp;
            portCenter.setLocation(tPortCenter);
        }
        double x = (((Point2D)oPortCenter).getX() + ((Point2D)portCenter).getX()) / 2.0;
        double y = (((Point2D)oPortCenter).getY() + ((Point2D)portCenter).getY()) / 2.0;
        PortInst pi = ni.findPortInstFromProto(pp);
        PortInst opi = oNi.findPortInstFromProto(opp);
        return AutoStitch.connectObjects(pi, net, opi, oNet, ni.getParent(), new Point2D.Double(x, y), stayInside);
    }

    private static Poly[] shapeOfNode(NodeInst ni) {
        Technology tech = ni.getProto().getTechnology();
        Poly[] nodePolys = tech.getShapeOfNode(ni, null, null, true, true, null);
        if (nodePolys.length == 0) {
            return nodePolys;
        }
        if (ni.getFunction() == PrimitiveNode.Function.PIN) {
            boolean gotOne = false;
            Rectangle2D coverage = null;
            Rectangle2D polyBounds = nodePolys[0].getBounds2D();
            Iterator it = ni.getConnections();
            while (it.hasNext()) {
                Connection con = (Connection)it.next();
                ArcInst ai = con.getArc();
                if (ai.getWidth() >= ni.getXSize() && ai.getWidth() >= ni.getYSize() && ai.isHeadExtended() && ai.isTailExtended()) {
                    gotOne = true;
                    break;
                }
                Poly[] arcPolys = ai.getProto().getTechnology().getShapeOfArc(ai);
                if (arcPolys.length == 0) continue;
                Rectangle2D arcBounds = arcPolys[0].getBounds2D();
                arcBounds.intersects(polyBounds);
                if (coverage == null) {
                    coverage = arcBounds;
                    continue;
                }
                if (coverage.getMinX() == arcBounds.getMinX() && coverage.getMaxX() == arcBounds.getMaxX() && coverage.getMinY() >= arcBounds.getMaxY() && coverage.getMaxY() <= arcBounds.getMinY()) {
                    double lX = Math.min(coverage.getMinX(), arcBounds.getMinX());
                    double hX = Math.max(coverage.getMaxX(), arcBounds.getMaxX());
                    coverage.setRect(lX, coverage.getMinY(), hX - lX, coverage.getHeight());
                    continue;
                }
                if (coverage.getMinY() == arcBounds.getMinY() && coverage.getMaxY() == arcBounds.getMaxY()) {
                    if (!(coverage.getMinX() >= arcBounds.getMaxX()) || !(coverage.getMaxX() <= arcBounds.getMinX())) continue;
                    double lY = Math.min(coverage.getMinY(), arcBounds.getMinY());
                    double hY = Math.max(coverage.getMaxY(), arcBounds.getMaxY());
                    coverage.setRect(coverage.getMinX(), lY, coverage.getWidth(), hY - lY);
                    continue;
                }
                coverage.intersects(arcBounds);
            }
            if (!gotOne) {
                if (coverage == null) {
                    return new Poly[0];
                }
                Poly newPoly = new Poly(coverage);
                newPoly.setStyle(nodePolys[0].getStyle());
                newPoly.setLayer(nodePolys[0].getLayer());
                newPoly.setPort(nodePolys[0].getPort());
                nodePolys[0] = newPoly;
            }
        }
        return nodePolys;
    }

    public static void findSmallestLayer(ArcProto ap, HashMap arcLayers) {
        if (arcLayers.get(ap) != null) {
            return;
        }
        ArcInst ai = ArcInst.makeDummyInstance(ap, 100.0);
        boolean bestFound = false;
        double bestArea = 0.0;
        Technology tech = ap.getTechnology();
        Poly[] polys = tech.getShapeOfArc(ai);
        int tot = polys.length;
        for (int i = 0; i < tot; ++i) {
            Poly poly = polys[i];
            double area = poly.getArea();
            if (bestFound && area >= bestArea) continue;
            bestArea = area;
            bestFound = true;
            arcLayers.put(ap, poly.getLayer());
        }
    }

    static {
        router = new SimpleWirer();
    }

    private static class Pairs {
        private HashMap first = new HashMap();

        Pairs() {
        }

        void add(Object o1, Object o2) {
            if (this.contains(o1, o2)) {
                return;
            }
            HashSet<Object> other1 = (HashSet<Object>)this.first.get(o1);
            if (other1 != null) {
                other1.add(o2);
                return;
            }
            HashSet other2 = (HashSet)this.first.get(o2);
            if (other2 != null) {
                other2.add(o1);
                return;
            }
            other1 = new HashSet<Object>();
            this.first.put(o1, other1);
            other1.add(o2);
        }

        boolean contains(Object o1, Object o2) {
            HashSet other1 = (HashSet)this.first.get(o1);
            if (other1 != null && other1.contains(o2)) {
                return true;
            }
            HashSet other2 = (HashSet)this.first.get(o2);
            return other2 != null && other2.contains(o1);
        }
    }

    private static class AutoStitchJob
    extends Job {
        private boolean highlighted;
        private boolean forced;

        protected AutoStitchJob(boolean highlighted, boolean forced) {
            super("Auto-Stitch", Routing.getRoutingTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.highlighted = highlighted;
            this.forced = forced;
            this.setReportExecutionFlag(true);
            this.startJob();
        }

        public boolean doIt() {
            Cell cell = WindowFrame.needCurCell();
            if (cell == null) {
                return false;
            }
            AutoStitch.runAutoStitch(cell, this.highlighted, this.forced, null);
            return true;
        }
    }
}

