/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.ncc;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.text.CellName;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.tool.user.Highlighter;
import com.sun.electric.tool.user.ncc.ExportConflict;
import com.sun.electric.tool.user.ncc.ExportConflictTable;
import com.sun.electric.tool.user.ncc.ExportTableModel;
import com.sun.electric.tool.user.ncc.HighlightTools;
import java.awt.Color;
import javax.swing.BorderFactory;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

abstract class ExportConflictTableModel
extends ExportTableModel {
    protected ExportConflict[] conflicts;
    protected int[][] cellPrefHeights;
    protected int[][] cellPrefWidths;
    protected static String href = "<a style=\"text-decoration: none\" href=\"";

    protected ExportConflictTableModel(ExportConflictTable parent) {
        super(parent);
        this.cellPrefHeights = this.parent.cellPrefHeights;
        this.cellPrefWidths = this.parent.cellPrefWidths;
        this.conflicts = parent.conflicts;
        this.cellPrefHeights = parent.cellPrefHeights;
        this.cellPrefWidths = parent.cellPrefWidths;
        StringBuffer txtBuf = new StringBuffer(64);
        for (int col = 0; col < this.numCols; ++col) {
            for (int row = 0; row < this.height; ++row) {
                txtBuf.setLength(0);
                txtBuf.append("<html><font size=3><font face=\"Helvetica, TimesRoman\">");
                switch (col) {
                    case 0: {
                        CellName cellName = this.conflicts[row].getCell().getCellName();
                        txtBuf.append(cellName.getName() + " {" + cellName.getView().getAbbreviation() + "}");
                        break;
                    }
                    case 1: {
                        txtBuf.append(this.conflicts[row].getName());
                        break;
                    }
                    case 2: 
                    case 3: {
                        this.appendText(row, col, txtBuf);
                    }
                }
                txtBuf.append("</font></html>");
                int[] nArray = this.cellPrefHeights[row];
                int n = col;
                nArray[n] = nArray[n] + 17;
                JEditorPane htmlPane = new JEditorPane();
                htmlPane.setEditable(false);
                htmlPane.addHyperlinkListener(this);
                htmlPane.setContentType("text/html");
                htmlPane.setText(txtBuf.toString());
                htmlPane.setMargin(this.insets);
                htmlPane.addMouseListener(this.mouseAdapter);
                htmlPane.moveCaretPosition(0);
                this.cellPrefWidths[row][col] = htmlPane.getPreferredSize().width + 11;
                if (this.cellPrefHeights[row][col] > 118) {
                    this.cellPrefHeights[row][col] = 118;
                }
                JPanel panel = new JPanel();
                panel.setBackground(Color.WHITE);
                panel.add(htmlPane);
                this.panes[row][col] = new JScrollPane(panel);
                this.panes[row][col].setBorder(BorderFactory.createEmptyBorder());
            }
        }
    }

    protected abstract void appendText(int var1, int var2, StringBuffer var3);

    protected void highlight(int index) {
        VarContext context;
        int col = index % 10;
        int row = index / 10;
        if (col != 2 && col != 3) {
            return;
        }
        ExportConflict nc = this.conflicts[row];
        Cell cell = nc.getCell();
        Highlighter highlighter = HighlightTools.getHighlighter(cell, context = nc.getContext());
        if (highlighter == null) {
            return;
        }
        this.addToHighlighter(row, col, highlighter);
        highlighter.finished();
    }

    protected abstract void addToHighlighter(int var1, int var2, Highlighter var3);

    protected static class CharacteristicsTableModel
    extends ExportConflictTableModel {
        protected static String[] colNames = new String[]{"Cell", "Conflicting Name", "Global Characteristics", "Export Characteristics"};

        protected CharacteristicsTableModel(ExportConflictTable parent) {
            super(parent);
        }

        protected void appendText(int row, int col, StringBuffer buf) {
            if (row < 0 || row > this.conflicts.length || col != 2 && col != 3) {
                return;
            }
            String text = this.conflicts[row].getDescription(col - 2);
            if (col == 2) {
                buf.append(text);
            } else if (col == 3) {
                buf.append(href + (row * 10 + col) + "\">" + text + "</a>");
            }
        }

        protected void addToHighlighter(int row, int col, Highlighter highlighter) {
            if (col != 3) {
                return;
            }
            ExportConflict.CharactConflict cc = (ExportConflict.CharactConflict)this.conflicts[row];
            highlighter.addText(cc.getLocalExport(), cc.getCell(), null);
        }

        public String getColumnName(int col) {
            return colNames[col];
        }
    }

    protected static class NetworkTableModel
    extends ExportConflictTableModel {
        protected static String[] colNames = new String[]{"Cell", "Conflicting Name", "Global Network", "Export Network"};

        protected NetworkTableModel(ExportConflictTable parent) {
            super(parent);
        }

        protected void appendText(int row, int col, StringBuffer buf) {
            if (row < 0 || row > this.conflicts.length || col != 2 && col != 3) {
                return;
            }
            buf.append(href + (row * 10 + col) + "\">" + this.conflicts[row].getDescription(col - 2) + "</a>");
        }

        protected void addToHighlighter(int row, int col, Highlighter highlighter) {
            if (col != 2 && col != 3) {
                return;
            }
            ExportConflict.NetworkConflict nc = (ExportConflict.NetworkConflict)this.conflicts[row];
            highlighter.addNetwork(nc.getNetwork(col - 2), nc.getCell());
        }

        public String getColumnName(int col) {
            return colNames[col];
        }
    }
}

