/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.menus;

import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.lib.LibFile;
import com.sun.electric.tool.Client;
import com.sun.electric.tool.io.FileType;
import com.sun.electric.tool.user.dialogs.About;
import com.sun.electric.tool.user.help.ManualViewer;
import com.sun.electric.tool.user.menus.EMenu;
import com.sun.electric.tool.user.menus.EMenuItem;
import com.sun.electric.tool.user.menus.FileMenu;
import com.sun.electric.tool.user.menus.MenuCommands;
import com.sun.electric.tool.user.ui.TopLevel;
import java.net.URL;

public class HelpMenu {
    static EMenu makeMenu() {
        return new EMenu("_Help", !Client.isOSMac() ? new EMenuItem("_About Electric..."){

            public void run() {
                HelpMenu.aboutCommand();
            }
        } : null, !Client.isOSMac() ? EMenuItem.SEPARATOR : null, new EMenuItem("_User's Manual..."){

            public void run() {
                ManualViewer.userManualCommand();
            }
        }, ManualViewer.hasRussianManual() ? new EMenuItem("User's Manual (_Russian)..."){

            public void run() {
                ManualViewer.userManualRussianCommand();
            }
        } : null, new EMenuItem("Show _Key Bindings"){

            public void run() {
                MenuCommands.menuBar().keyBindingManager.printKeyBindings();
            }
        }, new EMenu("_3D Showcase", new EMenuItem("_Load Library"){

            public void run() {
                ManualViewer.loadSamplesLibrary("floatingGates", "topCell");
            }
        }, new EMenuItem("_3D View of Cage Cell"){

            public void run() {
                ManualViewer.open3DSample("floatingGates", "topCell", "3D ShowCase");
            }
        }, new EMenuItem("_Animate Cage Cell"){

            public void run() {
                ManualViewer.animate3DSample("demoCage.j3d");
            }
        }), new EMenu("_Load Built-in Libraries", new EMenuItem("_Sample Cells"){

            public void run() {
                ManualViewer.loadSamplesLibrary("samples", "tech-MOSISCMOS");
            }
        }, new EMenuItem("_MOSIS CMOS Pads"){

            public void run() {
                HelpMenu.loadBuiltInLibraryCommand("pads4u");
            }
        }, new EMenuItem("MI_PS Cells"){

            public void run() {
                HelpMenu.loadBuiltInLibraryCommand("mipscells");
            }
        }));
    }

    public static void aboutCommand() {
        About dialog = new About(TopLevel.getCurrentJFrame());
        dialog.setVisible(true);
    }

    private static void loadBuiltInLibraryCommand(String libName) {
        if (Library.findLibrary(libName) != null) {
            return;
        }
        URL url = LibFile.getLibFile(libName + ".jelib");
        new FileMenu.ReadLibrary(url, FileType.JELIB, null, null);
    }
}

