/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.ui;

import com.sun.electric.database.geometry.Dimension2D;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.JobException;
import com.sun.electric.tool.user.CircuitChangeJobs;
import com.sun.electric.tool.user.Highlight2;
import com.sun.electric.tool.user.Highlighter;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.menus.EditMenu;
import com.sun.electric.tool.user.ui.ClickZoomWireListener;
import com.sun.electric.tool.user.ui.EditWindow;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;

public class OutlineListener
implements MouseMotionListener,
MouseListener,
MouseWheelListener,
KeyListener {
    public static OutlineListener theOne = new OutlineListener();
    private double oldX;
    private double oldY;
    private boolean doingMotionDrag;
    private int point;
    private NodeInst outlineNode;
    private Highlight2 high;

    private OutlineListener() {
    }

    public void setNode(NodeInst ni) {
        EditWindow wnd = EditWindow.getCurrent();
        Highlighter highlighter = wnd.getHighlighter();
        this.high = highlighter.getOneHighlight();
        this.point = 0;
        this.outlineNode = ni;
        Point2D[] origPoints = this.outlineNode.getTrace();
        if (origPoints == null && ni.getFunction() == PrimitiveNode.Function.NODE) {
            new InitializePoints(this, ni);
            return;
        }
        this.high.setPoint(0);
        if (wnd != null) {
            wnd.fullRepaint();
        }
    }

    public void mousePressed(MouseEvent evt) {
        int x = evt.getX();
        int y = evt.getY();
        EditWindow wnd = (EditWindow)evt.getSource();
        Highlighter highlighter = wnd.getHighlighter();
        if (evt.getClickCount() == 2 && highlighter.getNumHighlights() >= 1) {
            EditMenu.getInfoCommand(true);
            return;
        }
        if (ClickZoomWireListener.isRightMouse(evt)) {
            AffineTransform trans = this.outlineNode.rotateOutAboutTrueCenter();
            Point2D[] origPoints = this.outlineNode.getTrace();
            if (origPoints == null) {
                Point2D[] newPoints = new Point2D[]{new Point2D.Double(this.outlineNode.getAnchorCenterX(), this.outlineNode.getAnchorCenterY())};
                EditWindow.gridAlign(newPoints[0]);
                this.setNewPoints(newPoints, 0);
                this.point = 0;
                this.oldX = newPoints[this.point].getX();
                this.oldY = newPoints[this.point].getY();
            } else if (origPoints.length == 1) {
                Point2D[] newPoints = new Point2D[2];
                newPoints[0] = new Point2D.Double(this.outlineNode.getAnchorCenterX() + origPoints[0].getX(), this.outlineNode.getAnchorCenterY() + origPoints[0].getY());
                trans.transform(newPoints[0], newPoints[0]);
                EditWindow.gridAlign(newPoints[0]);
                newPoints[1] = new Point2D.Double(newPoints[0].getX() + 2.0, newPoints[0].getY() + 2.0);
                EditWindow.gridAlign(newPoints[1]);
                this.setNewPoints(newPoints, 1);
                this.point = 1;
                this.oldX = newPoints[this.point].getX();
                this.oldY = newPoints[this.point].getY();
            } else {
                Point2D[] newPoints = new Point2D[origPoints.length + 1];
                int j = 0;
                for (int i = 0; i < origPoints.length; ++i) {
                    if (origPoints[i] != null) {
                        newPoints[j] = new Point2D.Double(this.outlineNode.getAnchorCenterX() + origPoints[i].getX(), this.outlineNode.getAnchorCenterY() + origPoints[i].getY());
                    }
                    ++j;
                    if (i != this.point) continue;
                    newPoints[j] = wnd.screenToDatabase(x, y);
                    EditWindow.gridAlign(newPoints[j]);
                    ++j;
                }
                trans.transform(newPoints, 0, newPoints, 0, newPoints.length);
                this.setNewPoints(newPoints, this.point + 1);
                this.oldX = newPoints[this.point + 1].getX();
                this.oldY = newPoints[this.point + 1].getY();
            }
            this.doingMotionDrag = true;
            wnd.repaint();
            return;
        }
        Point2D pt = wnd.screenToDatabase(x, y);
        Highlight2 found = highlighter.findObject(pt, wnd, true, false, false, false, true, false, false);
        this.doingMotionDrag = false;
        if (found != null) {
            this.high = highlighter.getOneHighlight();
            assert (this.high == found);
            this.outlineNode = (NodeInst)highlighter.getOneElectricObject(NodeInst.class);
            if (this.high != null && this.outlineNode != null) {
                this.point = this.high.getPoint();
                Point2D[] origPoints = this.outlineNode.getTrace();
                if (origPoints != null) {
                    this.doingMotionDrag = true;
                    EditWindow.gridAlign(pt);
                    this.oldX = pt.getX();
                    this.oldY = pt.getY();
                }
            }
        }
        wnd.repaint();
    }

    public void mouseReleased(MouseEvent evt) {
        EditWindow wnd = (EditWindow)evt.getSource();
        if (wnd == null) {
            return;
        }
        Highlighter highlighter = wnd.getHighlighter();
        if (this.doingMotionDrag) {
            this.doingMotionDrag = false;
            int newX = evt.getX();
            int newY = evt.getY();
            Point2D curPt = wnd.screenToDatabase(newX, newY);
            EditWindow.gridAlign(curPt);
            highlighter.setHighlightOffset(0, 0);
            this.moveSelectedPoint(curPt.getX() - this.oldX, curPt.getY() - this.oldY);
            wnd.fullRepaint();
        }
    }

    public void mouseClicked(MouseEvent evt) {
    }

    public void mouseEntered(MouseEvent evt) {
    }

    public void mouseExited(MouseEvent evt) {
    }

    public void mouseMoved(MouseEvent evt) {
    }

    public void mouseDragged(MouseEvent evt) {
        EditWindow wnd = (EditWindow)evt.getSource();
        if (wnd == null) {
            return;
        }
        Highlighter highlighter = wnd.getHighlighter();
        int newX = evt.getX();
        int newY = evt.getY();
        Point2D curPt = wnd.screenToDatabase(newX, newY);
        EditWindow.gridAlign(curPt);
        Point pt = wnd.databaseToScreen(curPt.getX(), curPt.getY());
        Point gridPt = wnd.databaseToScreen(this.oldX, this.oldY);
        if (this.doingMotionDrag) {
            highlighter.setHighlightOffset(pt.x - gridPt.x, pt.y - gridPt.y);
            wnd.repaint();
            return;
        }
        wnd.repaint();
    }

    public void mouseWheelMoved(MouseWheelEvent evt) {
    }

    public void keyPressed(KeyEvent evt) {
        int chr = evt.getKeyCode();
        EditWindow wnd = (EditWindow)evt.getSource();
        Cell cell = wnd.getCell();
        if (cell == null) {
            return;
        }
        if (chr == 127 || chr == 8) {
            Point2D[] origPoints = this.outlineNode.getTrace();
            if (origPoints.length <= 2) {
                System.out.println("Cannot delete the last point on an outline");
                return;
            }
            AffineTransform trans = this.outlineNode.rotateOutAboutTrueCenter();
            Point2D[] newPoints = new Point2D[origPoints.length - 1];
            int pt = this.point;
            int j = 0;
            for (int i = 0; i < origPoints.length; ++i) {
                if (i == pt) continue;
                if (origPoints[j] != null) {
                    newPoints[j] = new Point2D.Double(this.outlineNode.getAnchorCenterX() + origPoints[i].getX(), this.outlineNode.getAnchorCenterY() + origPoints[i].getY());
                    trans.transform(newPoints[j], newPoints[j]);
                }
                ++j;
            }
            if (pt > 0) {
                --pt;
            }
            this.setNewPoints(newPoints, pt);
        } else if (chr == 37) {
            Dimension2D arrowDistance = User.getAlignmentToGrid();
            this.moveSelectedPoint(-arrowDistance.getWidth(), 0.0);
        } else if (chr == 39) {
            Dimension2D arrowDistance = User.getAlignmentToGrid();
            this.moveSelectedPoint(arrowDistance.getWidth(), 0.0);
        } else if (chr == 38) {
            Dimension2D arrowDistance = User.getAlignmentToGrid();
            this.moveSelectedPoint(0.0, arrowDistance.getHeight());
        } else if (chr == 40) {
            Dimension2D arrowDistance = User.getAlignmentToGrid();
            this.moveSelectedPoint(0.0, -arrowDistance.getHeight());
        } else if (chr == 46) {
            int nextPoint = this.point + 1;
            Point2D[] origPoints = this.outlineNode.getTrace();
            if (nextPoint >= origPoints.length) {
                nextPoint = 0;
            }
            this.point = nextPoint;
            this.high.setPoint(this.point);
            wnd.repaint();
        } else if (chr == 44) {
            Point2D[] origPoints = this.outlineNode.getTrace();
            int prevPoint = this.point - 1;
            if (prevPoint < 0) {
                prevPoint = origPoints.length - 1;
            }
            this.point = prevPoint;
            this.high.setPoint(this.point);
            wnd.repaint();
        }
    }

    public void keyReleased(KeyEvent evt) {
    }

    public void keyTyped(KeyEvent evt) {
    }

    private void moveSelectedPoint(double dx, double dy) {
        Point2D[] origPoints = this.outlineNode.getTrace();
        if (origPoints == null) {
            return;
        }
        Point2D[] newPoints = new Point2D[origPoints.length];
        for (int i = 0; i < origPoints.length; ++i) {
            if (origPoints[i] == null) continue;
            newPoints[i] = new Point2D.Double(this.outlineNode.getAnchorCenterX() + origPoints[i].getX(), this.outlineNode.getAnchorCenterY() + origPoints[i].getY());
        }
        AffineTransform trans = this.outlineNode.rotateOutAboutTrueCenter();
        for (int i = 0; i < newPoints.length; ++i) {
            if (newPoints[i] == null) continue;
            trans.transform(newPoints[i], newPoints[i]);
        }
        if (newPoints[this.point] != null) {
            newPoints[this.point].setLocation(newPoints[this.point].getX() + dx, newPoints[this.point].getY() + dy);
        }
        this.setNewPoints(newPoints, this.point);
    }

    private void setNewPoints(Point2D[] newPoints, int newPoint) {
        EPoint[] pts = new EPoint[newPoints.length];
        for (int i = 0; i < newPoints.length; ++i) {
            if (newPoints[i] == null) continue;
            pts[i] = new EPoint(newPoints[i].getX(), newPoints[i].getY());
        }
        new SetPoints(this, this.outlineNode, pts, newPoint);
    }

    private static class SetPoints
    extends Job {
        private transient OutlineListener listener;
        private NodeInst ni;
        private EPoint[] pts;
        private int newPoint;

        protected SetPoints(OutlineListener listener, NodeInst ni, EPoint[] pts, int newPoint) {
            super("Change Outline Points", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.listener = listener;
            this.ni = ni;
            this.pts = pts;
            this.newPoint = newPoint;
            this.startJob();
        }

        public boolean doIt() throws JobException {
            if (CircuitChangeJobs.cantEdit(this.ni.getParent(), this.ni, true, false, true) != 0) {
                return false;
            }
            this.ni.setTrace(this.pts);
            return true;
        }

        public void terminateOK() {
            this.listener.high.setPoint(this.listener.point = this.newPoint);
        }
    }

    private static class InitializePoints
    extends Job {
        private transient OutlineListener listener;
        private NodeInst ni;

        protected InitializePoints(OutlineListener listener, NodeInst ni) {
            super("Initialize Outline Points", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.listener = listener;
            this.ni = ni;
            this.startJob();
        }

        public boolean doIt() throws JobException {
            Point2D[] points = new EPoint[4];
            double halfWid = this.ni.getXSize() / 2.0;
            double halfHei = this.ni.getYSize() / 2.0;
            double cX = this.ni.getAnchorCenterX();
            double cY = this.ni.getAnchorCenterY();
            points[0] = new EPoint(cX - halfWid, cY - halfHei);
            points[1] = new EPoint(cX - halfWid, cY + halfHei);
            points[2] = new EPoint(cX + halfWid, cY + halfHei);
            points[3] = new EPoint(cX + halfWid, cY - halfHei);
            this.ni.setTrace(points);
            return true;
        }

        public void terminateOK() {
            this.listener.high.setPoint(0);
            EditWindow wnd = EditWindow.getCurrent();
            if (wnd != null) {
                wnd.fullRepaint();
            }
        }
    }
}

