/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.placement.simulatedAnnealing1.metrics;

import com.sun.electric.tool.placement.PlacementFrame;
import com.sun.electric.tool.placement.simulatedAnnealing1.SimulatedAnnealing;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BoundingBoxMetric {
    private double[] netScoreCache;
    private List<PlacementFrame.PlacementNetwork> allNetworks;
    private List<PlacementFrame.PlacementNode> allNodes;
    private SimulatedAnnealing.IncrementalState incState;
    private double currentScore;

    public BoundingBoxMetric(List<PlacementFrame.PlacementNode> allNodes, List<PlacementFrame.PlacementNetwork> allNetworks, SimulatedAnnealing.IncrementalState finalState) {
        this.netScoreCache = new double[allNetworks.size()];
        this.allNodes = allNodes;
        this.allNetworks = allNetworks;
        this.incState = finalState;
    }

    public double init(List<PlacementFrame.PlacementNetwork> allNetworks) {
        this.currentScore = 0.0;
        for (int i = 0; i < allNetworks.size(); ++i) {
            PlacementFrame.PlacementNetwork n = allNetworks.get(i);
            this.netScoreCache[i] = 0.0;
            this.calculateBoundingBoxScore(n);
        }
        return this.currentScore;
    }

    public double getCurrentScore() {
        return this.currentScore;
    }

    public double getScoreForNetwork(PlacementFrame.PlacementNetwork n) {
        return this.netScoreCache[this.allNetworks.indexOf(n)];
    }

    protected double calculateBoundingBoxScore(PlacementFrame.PlacementNetwork n) {
        List<PlacementFrame.PlacementPort> l = n.getPortsOnNet();
        if (l.size() == 0) {
            return 0.0;
        }
        double xMin = Double.MAX_VALUE;
        double xMax = Double.MIN_VALUE;
        double yMin = Double.MAX_VALUE;
        double yMax = Double.MIN_VALUE;
        for (PlacementFrame.PlacementPort p : l) {
            PlacementFrame.PlacementNode originalPlacementNode = p.getPlacementNode();
            int originalPlacementNodeIndex = this.allNodes.indexOf(originalPlacementNode);
            double movedX = 0.0;
            double movedY = 0.0;
            if (this.incState.isNodeChanged(originalPlacementNodeIndex)) {
                SimulatedAnnealing.PlacementNodePosition changedNode = this.incState.getNodeFromState(originalPlacementNodeIndex);
                movedX = changedNode.getPlacementX() - originalPlacementNode.getPlacementX();
                movedY = changedNode.getPlacementY() - originalPlacementNode.getPlacementY();
            }
            p.computeRotatedOffset();
            double x = movedX + originalPlacementNode.getPlacementX();
            double y = movedY + originalPlacementNode.getPlacementY();
            if (x < xMin) {
                xMin = x;
            }
            if (x > xMax) {
                xMax = x;
            }
            if (y < yMin) {
                yMin = y;
            }
            if (!(y > yMax)) continue;
            yMax = y;
        }
        double score = xMax - xMin + (yMax - yMin);
        int netIndex = this.allNetworks.indexOf(n);
        double oldScore = this.netScoreCache[netIndex];
        if (!(oldScore > 0.0) || Math.abs(oldScore - score) > 0.001) {
            // empty if block
        }
        this.netScoreCache[netIndex] = score;
        this.currentScore = this.currentScore - oldScore + score;
        return score;
    }

    public double getNetworkScoreForNode(PlacementFrame.PlacementNode n) {
        double score = 0.0;
        List<PlacementFrame.PlacementPort> ports = this.allNodes.get(this.allNodes.indexOf(n)).getPorts();
        for (PlacementFrame.PlacementPort p : ports) {
            PlacementFrame.PlacementNetwork net;
            if (p == null || (net = p.getPlacementNetwork()) == null) continue;
            score += this.getScoreForNetwork(net);
        }
        return score;
    }

    public double update(int index) {
        double BeforeIncUpdate = this.currentScore;
        List<PlacementFrame.PlacementPort> ports = this.allNodes.get(index).getPorts();
        for (PlacementFrame.PlacementPort p : ports) {
            PlacementFrame.PlacementNetwork net;
            if (p == null || (net = p.getPlacementNetwork()) == null) continue;
            this.calculateBoundingBoxScore(net);
        }
        double incScore = this.currentScore;
        double newScore = this.currentScore;
        if (Math.abs(incScore - newScore) > 1.0E-4) {
            System.out.println("BeforeIncUpdate=" + BeforeIncUpdate + ", after update: incScore=" + incScore + ", correctScore=" + newScore);
        }
        return this.currentScore;
    }
}

