/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.ui;

import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.View;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.JobException;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.ui.TextWindow;
import com.sun.electric.tool.user.ui.WindowFrame;
import com.sun.electric.util.ClientOS;
import com.sun.electric.util.TextUtils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.SwingUtilities;

public class ExternalEditing {
    private String cellName;
    private String fileName;
    private long lastModified;
    private static List<ExternalEditing> activeExternalEditors = new ArrayList<ExternalEditing>();

    ExternalEditing(String cellName, String fileName) {
        this.cellName = cellName;
        this.fileName = fileName;
        File f2 = new File(fileName);
        this.lastModified = f2.lastModified();
        activeExternalEditors.add(this);
    }

    void finishedEditing() {
        activeExternalEditors.remove(this);
    }

    public static void updateEditors() {
        for (ExternalEditing ee : activeExternalEditors) {
            File f2 = new File(ee.fileName);
            long lastModified = f2.lastModified();
            if (ee.lastModified >= lastModified) continue;
            System.out.println("Cell " + ee.cellName + " changed in the external text editor");
            ee.updateFromExternalEditor(false);
            ee.lastModified = lastModified;
        }
    }

    public static void editExternally() {
        TextWindow tw = null;
        WindowFrame wf = WindowFrame.getCurrentWindowFrame();
        if (wf != null && wf.getContent() instanceof TextWindow) {
            tw = (TextWindow)wf.getContent();
        }
        if (tw == null) {
            Job.getUserInterface().showErrorMessage("You must be editing a text cell before editing it externally", "No Text To Edit");
            return;
        }
        Cell cell = tw.getCell();
        String externalEditor = User.getDefaultTextExternalEditor();
        if (externalEditor.length() == 0) {
            Job.getUserInterface().showErrorMessage("No external text editor is defined.  Use the Display/Text Preferences to set one", "No External Text Editor Set");
            return;
        }
        String fileName = cell.getName() + "tmp";
        File f2 = null;
        try {
            f2 = File.createTempFile(fileName, ExternalEditing.getExtension(cell));
        }
        catch (Exception e) {
            Job.getUserInterface().showErrorMessage("Error creating temporary file: " + fileName + " (" + e.getMessage() + ")", "Error Creating Temporary Text File");
        }
        if (f2 == null) {
            return;
        }
        fileName = f2.getPath();
        if (!tw.writeTextCell(fileName)) {
            Job.getUserInterface().showErrorMessage("Could not write temporary file " + fileName, "Error Writing Temporary Text File");
            return;
        }
        new EditExternally(cell.describe(false), externalEditor, fileName).start();
    }

    public static void editTextCellExternally(Cell cell) {
        String externalEditor = User.getDefaultTextExternalEditor();
        if (externalEditor.length() == 0) {
            Job.getUserInterface().showErrorMessage("No external text editor is defined.  Use the Display/Text Preferences to set one", "No Text Editor Set");
            return;
        }
        File f2 = null;
        String fileName = cell.getName() + "tmp";
        try {
            f2 = File.createTempFile(fileName, ExternalEditing.getExtension(cell));
        }
        catch (Exception e) {
            Job.getUserInterface().showErrorMessage("Error creating temporary file: " + fileName + " (" + e.getMessage() + ")", "Error Creating Temporary Text File");
        }
        if (f2 == null) {
            return;
        }
        fileName = f2.getPath();
        String[] lines2 = cell.getTextViewContents();
        try {
            PrintWriter printWriter = new PrintWriter(new BufferedWriter(new FileWriter(f2)));
            for (int i = 0; i < lines2.length; ++i) {
                printWriter.println(lines2[i]);
            }
            printWriter.close();
        }
        catch (IOException e) {
            Job.getUserInterface().showErrorMessage("Could not write temporary file " + fileName, "Error Writing Temporary Text File");
            return;
        }
        new EditExternally(cell.describe(false), externalEditor, fileName).start();
    }

    private static String getExtension(Cell cell) {
        if (cell.getView() == View.VERILOG) {
            return ".v";
        }
        if (cell.getView() == View.DOC) {
            return ".doc";
        }
        if (cell.getView() == View.VHDL) {
            return ".vhdl";
        }
        return ".tmp";
    }

    private void endExternalEditing() {
        this.finishedEditing();
        this.updateFromExternalEditor(true);
    }

    private void updateFromExternalEditor(boolean deleteTempFile) {
        Cell cell = (Cell)Cell.findNodeProto(this.cellName);
        if (cell == null) {
            Job.getUserInterface().showErrorMessage("Could not find the text cell " + this.cellName + " so external edits are being ignored", "Error Recovering Temporary Text File");
            return;
        }
        Iterator<WindowFrame> it = WindowFrame.getWindows();
        while (it.hasNext()) {
            WindowFrame wf = it.next();
            if (wf.getContent().getCell() != cell) continue;
            new UpdateTextWindow(this.fileName, cell, deleteTempFile);
            return;
        }
        new UpdateTextCell(this.fileName, cell, deleteTempFile);
    }

    private static class UpdateTextCell
    extends Job {
        private String fileName;
        private Cell cell;
        private boolean deleteTempFile;

        private UpdateTextCell(String fileName, Cell cell, boolean deleteTempFile) {
            super("Update text cell after external editing", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.fileName = fileName;
            this.cell = cell;
            this.deleteTempFile = deleteTempFile;
            this.startJob();
        }

        @Override
        public boolean doIt() throws JobException {
            File f2;
            EditingPreferences ep = this.getEditingPreferences();
            ArrayList<String> linesInFile = new ArrayList<String>();
            URL fileURL = TextUtils.makeURLToFile(this.fileName);
            InputStream stream = TextUtils.getURLStream(fileURL);
            if (stream == null) {
                Job.getUserInterface().showErrorMessage("Could not find temporary file: " + fileURL.getFile(), "Error Retrieving Temporary File");
                return true;
            }
            try {
                String buf;
                fileURL.openConnection();
                InputStreamReader is = new InputStreamReader(stream);
                LineNumberReader lineReader = new LineNumberReader(is);
                while ((buf = lineReader.readLine()) != null) {
                    linesInFile.add(buf);
                }
            }
            catch (IOException e) {
                Job.getUserInterface().showErrorMessage("Could not read back temporary file: " + fileURL.getFile() + " (" + e.getMessage() + ")", "Error Retrieving Temporary File");
                return true;
            }
            String[] lines2 = new String[linesInFile.size()];
            for (int i = 0; i < linesInFile.size(); ++i) {
                lines2[i] = (String)linesInFile.get(i);
            }
            this.cell.setTextViewContents(lines2, ep);
            if (this.deleteTempFile && !(f2 = new File(this.fileName)).delete()) {
                System.out.println("WARNING: Failed to delete temporary file " + this.fileName);
            }
            return true;
        }
    }

    private static class UpdateTextWindow
    extends Job {
        private String fileName;
        private Cell cell;
        private boolean deleteTempFile;

        private UpdateTextWindow(String fileName, Cell cell, boolean deleteTempFile) {
            super("Update text window after external editing", User.getUserTool(), Job.Type.CLIENT_EXAMINE, null, null, Job.Priority.USER);
            this.fileName = fileName;
            this.cell = cell;
            this.deleteTempFile = deleteTempFile;
            this.startJob();
        }

        @Override
        public boolean doIt() throws JobException {
            Iterator<WindowFrame> it = WindowFrame.getWindows();
            while (it.hasNext()) {
                File f2;
                WindowFrame wf = it.next();
                if (wf.getContent().getCell() != this.cell) continue;
                TextWindow tw = (TextWindow)wf.getContent();
                tw.readTextCell(this.fileName);
                tw.goToLineNumber(1);
                if (!this.deleteTempFile || (f2 = new File(this.fileName)).delete()) break;
                System.out.println("WARNING: Failed to delete temporary file " + this.fileName);
                break;
            }
            return true;
        }
    }

    private static class EditExternally
    extends Thread {
        private ExternalEditing ee;
        private String externalEditor;

        EditExternally(String cellName, String externalEditor, String fileName) {
            this.ee = new ExternalEditing(cellName, fileName);
            this.externalEditor = externalEditor;
        }

        @Override
        public void run() {
            String commandString;
            if (ClientOS.isOSWindows()) {
                commandString = "cmd /c \"" + this.externalEditor + "\" " + this.ee.fileName;
            } else if (ClientOS.isOSMac()) {
                int index = this.externalEditor.indexOf(".app");
                if (index != -1) {
                    String rootName = this.externalEditor.substring(0, index);
                    int ind2 = rootName.lastIndexOf("/");
                    if (ind2 != -1) {
                        rootName = rootName.substring(ind2, rootName.length());
                    }
                    commandString = this.externalEditor + "/Contents/MacOS/" + rootName + " " + this.ee.fileName;
                } else {
                    commandString = this.externalEditor + " " + this.ee.fileName;
                }
            } else {
                commandString = this.externalEditor + " " + this.ee.fileName;
            }
            try {
                Process p = Runtime.getRuntime().exec(commandString);
                try {
                    p.waitFor();
                }
                catch (InterruptedException e) {
                    System.out.println("External text editor interrupted: " + e.getMessage());
                }
            }
            catch (IOException e) {
                System.out.println("Error running command: " + commandString + " (" + e.getMessage() + ")");
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    EditExternally.this.ee.endExternalEditing();
                }
            });
        }
    }
}

