/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.plugins.j3d.ui;

import com.sun.electric.api.movie.MovieCreator;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.plugins.j3d.View3DWindow;
import com.sun.electric.plugins.j3d.ui.J3DDemoDialog;
import com.sun.electric.tool.user.Resources;
import com.sun.electric.tool.user.menus.EMenu;
import com.sun.electric.tool.user.menus.EMenuItem;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.tool.user.ui.TopLevel;
import com.sun.electric.tool.user.ui.WindowContent;
import com.sun.electric.tool.user.ui.WindowFrame;
import java.awt.GraphicsConfigTemplate;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.util.Map;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.GraphicsConfigTemplate3D;
import javax.media.j3d.VirtualUniverse;

public class J3DMenu {
    private static boolean movieCreatorChecked = false;
    private static MovieCreator movieCreatorInstance = null;

    public static EMenu makeMenu() {
        return new EMenu("_3D Window", new EMenuItem("_3D View"){

            @Override
            public void run() {
                if (J3DMenu.isJava3DAvailable()) {
                    J3DMenu.create3DViewCommand(false);
                }
            }
        }, J3DMenu.getMovieCreator() != null ? new EMenuItem("_Capture Frame/Animate"){

            @Override
            public void run() {
                if (J3DMenu.isJava3DAvailable()) {
                    J3DDemoDialog.create3DDemoDialog(TopLevel.getCurrentJFrame(), null);
                }
            }
        } : null, EMenuItem.SEPARATOR, new EMenuItem("_Test Hardware"){

            @Override
            public void run() {
                if (J3DMenu.isJava3DAvailable()) {
                    J3DMenu.runHardwareTest();
                }
            }
        });
    }

    private static boolean isJava3DAvailable() {
        Class<?> j3DUtilsClass = Resources.get3DClass("utils.J3DUtils");
        if (j3DUtilsClass == null) {
            System.out.println("Java3D is not available.");
            return false;
        }
        return true;
    }

    public static MovieCreator getMovieCreator() {
        if (!movieCreatorChecked) {
            movieCreatorChecked = true;
            try {
                Class<?> clz = Class.forName("com.sun.electric.plugins.JMF.MovieCreatorJMF");
                if (clz != null) {
                    movieCreatorInstance = (MovieCreator)clz.newInstance();
                }
            }
            catch (Exception e) {
            }
            catch (Error error) {
                // empty catch block
            }
            if (movieCreatorInstance == null) {
                TextUtils.recordMissingComponent("MovieCreator");
            }
        }
        return movieCreatorInstance;
    }

    public static void create3DViewCommand(Boolean transPerNode) {
        Cell curCell = WindowFrame.needCurCell();
        if (curCell == null) {
            return;
        }
        if (!curCell.isLayout()) {
            System.out.println("3D View only available for Layout views");
            return;
        }
        WindowContent view2D = WindowFrame.getCurrentWindowFrame(false).getContent();
        if (!(view2D instanceof EditWindow)) {
            return;
        }
        WindowFrame frame = new WindowFrame();
        View3DWindow.create3DWindow(curCell, frame, view2D, transPerNode);
    }

    private static void runHardwareTest() {
        for (Map.Entry e : VirtualUniverse.getProperties().entrySet()) {
            System.out.println(e.getKey() + "=" + e.getValue());
        }
        System.out.println();
        GraphicsDevice screenDevice = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
        GraphicsConfiguration config = screenDevice.getBestConfiguration((GraphicsConfigTemplate)new GraphicsConfigTemplate3D());
        for (Map.Entry e : new Canvas3D(config).queryProperties().entrySet()) {
            System.out.println(e.getKey() + "=" + e.getValue());
        }
    }
}

