/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.generator.layout;

import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.DRCTemplate;
import com.sun.electric.technology.EdgeH;
import com.sun.electric.technology.EdgeV;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.PrimitivePort;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.XMLRules;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.generator.layout.LayoutLib;
import com.sun.electric.tool.generator.layout.TechTypeMoCMOS;
import com.sun.electric.tool.generator.layout.TechTypeWizard;
import com.sun.electric.util.math.ECoord;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Iterator;

public abstract class TechType
implements Serializable {
    private static final Variable.Key ATTR_X = Variable.newKey("ATTR_X");
    private static final Variable.Key ATTR_S = Variable.newKey("ATTR_S");
    private static final Variable.Key ATTR_SN = Variable.newKey("ATTR_SN");
    private static final Variable.Key ATTR_SP = Variable.newKey("ATTR_SP");
    private final Technology generic = Technology.findTechnology("generic");
    private final Technology technology;
    private final XMLRules drcRules;
    private final PrimitiveNode essentialBounds = this.generic.findNodeProto("Essential-Bounds");
    private final PrimitiveNode facetCenter = this.generic.findNodeProto("Facet-Center");
    private final int nbLay;
    private Layer lgate;
    private final Layer lp1;
    private final Layer[] lmets;
    private final ArcProto[] arcs;
    private final PrimitiveNode[] vias;
    private final HashMap<ArcPair, PrimitiveNode> viaMap = new HashMap();
    private final ArcProto pdiff;
    private final ArcProto ndiff;
    private final ArcProto p1;
    private final ArcProto m1;
    private final ArcProto m2;
    private final ArcProto m3;
    private final ArcProto m4;
    private final ArcProto m5;
    private final ArcProto m6;
    private final ArcProto m7;
    private final ArcProto m8;
    private final ArcProto m9;
    private final ArcProto ndiff18;
    private final ArcProto pdiff18;
    private final ArcProto ndiff25;
    private final ArcProto pdiff25;
    private final ArcProto ndiff33;
    private final ArcProto pdiff33;
    private final PrimitiveNode ndpin;
    private final PrimitiveNode pdpin;
    private final PrimitiveNode p1pin;
    private final PrimitiveNode m1pin;
    private final PrimitiveNode m2pin;
    private final PrimitiveNode m3pin;
    private final PrimitiveNode m4pin;
    private final PrimitiveNode m5pin;
    private final PrimitiveNode m6pin;
    private final PrimitiveNode m7pin;
    private final PrimitiveNode m8pin;
    private final PrimitiveNode m9pin;
    private final PrimitiveNode nwm1;
    private final PrimitiveNode pwm1;
    private final PrimitiveNode nwm1Y;
    private final PrimitiveNode pwm1Y;
    private final PrimitiveNode ndm1;
    private final PrimitiveNode pdm1;
    private final PrimitiveNode p1m1;
    private final PrimitiveNode m1m2;
    private final PrimitiveNode m2m3;
    private final PrimitiveNode m3m4;
    private final PrimitiveNode m4m5;
    private final PrimitiveNode m5m6;
    private final PrimitiveNode m6m7;
    private final PrimitiveNode m7m8;
    private final PrimitiveNode m8m9;
    private final boolean rotateTransistors;
    private final Transistor nmos;
    private final Transistor pmos;
    private final Transistor nmos18;
    private final Transistor pmos18;
    private final Transistor nmos25;
    private final Transistor pmos25;
    private final Transistor nmos33;
    private final Transistor pmos33;
    private final PrimitiveNode nmos18contact;
    private final PrimitiveNode pmos18contact;
    private final PrimitiveNode nmos25contact;
    private final PrimitiveNode pmos25contact;
    private final PrimitiveNode nmos33contact;
    private final PrimitiveNode pmos33contact;
    private final PrimitiveNode nwellNode;
    private final PrimitiveNode pwellNode;
    private final PrimitiveNode m1Node;
    private final PrimitiveNode m2Node;
    private final PrimitiveNode m3Node;
    private final PrimitiveNode m4Node;
    private final PrimitiveNode m5Node;
    private final PrimitiveNode m6Node;
    private final PrimitiveNode m7Node;
    private final PrimitiveNode m8Node;
    private final PrimitiveNode m9Node;
    private final PrimitiveNode p1Node;
    private final PrimitiveNode pdNode;
    private final PrimitiveNode ndNode;
    private final PrimitiveNode pselNode;
    private final PrimitiveNode nselNode;
    private final PrimitiveNode od18Node;
    private final PrimitiveNode od25Node;
    private final PrimitiveNode od33Node;
    private final PrimitiveNode vthNode;
    private final PrimitiveNode vtlNode;
    protected double gateLength;
    protected double offsetLShapePolyContact;
    protected double offsetTShapePolyContact;
    protected double selectSpace;
    protected double selectSurroundDiffInTrans;
    protected double selectSurroundDiffAlongGateInTrans;
    protected double selectSurround;
    protected double wellSurroundDiff;
    protected double gateExtendPastMOS;
    protected double p1Width;
    protected double p1ToP1Space;
    protected double gateToGateSpace;
    protected double gateToDiffContSpace;
    protected double gateToDiffContSpaceDogBone;
    protected double selectSurroundDiffInWellContact;
    protected double selectSurroundDiffInActiveContact;
    protected double m1MinArea;
    protected double polyContWidth;
    protected double wellContWidth;
    protected double diffContWidth;
    protected double diffCont_m1Width;
    protected double diffContIncr;
    private static TechType techTypeMoCMOS;
    private static TechType techTypeTSMC180;
    private static TechType techTypeCMOS90;

    private static void error(boolean pred, String msg) {
        Job.error(pred, msg);
    }

    private Layer getMetalLayer(int l) {
        return l <= this.lmets.length ? this.lmets[l - 1] : null;
    }

    private ECoord getSpacing(Layer layer1, Layer layer2) {
        DRCTemplate rule = this.drcRules.getSpacingRule(layer1, null, layer2, null, false, -1, -1.0, -1.0);
        double lambda = rule != null ? rule.getValue(0) : 0.0;
        return ECoord.fromLambdaRoundGrid(lambda);
    }

    private ArcProto getArc(int n) {
        return n > this.arcs.length - 1 ? null : this.arcs[n];
    }

    private ArcProto findArc(Layer ... layers) {
        Iterator<ArcProto> it = this.technology.getArcs();
        while (it.hasNext()) {
            ArcProto ap = it.next();
            boolean allLayersFound = true;
            for (Layer layer : layers) {
                if (ap.indexOf(layer) >= 0) continue;
                allLayersFound = false;
            }
            if (!allLayersFound) continue;
            return ap;
        }
        return null;
    }

    private PrimitiveNode findPureNode(Layer layer) {
        return layer != null ? layer.getPureLayerNode() : null;
    }

    private Technology.NodeLayer findNodeLayer(PrimitiveNode pn, Layer l) {
        Technology.NodeLayer[] nls;
        if (pn == null) {
            return null;
        }
        for (Technology.NodeLayer nl : nls = pn.getNodeLayers()) {
            if (nl.getLayer() != l) continue;
            return nl;
        }
        return null;
    }

    private Technology.NodeLayer findMulticut(PrimitiveNode pn) {
        Technology.NodeLayer[] nls;
        if (pn == null) {
            return null;
        }
        for (Technology.NodeLayer nl : nls = pn.getNodeLayers()) {
            if (nl.getRepresentation() != 3) continue;
            return nl;
        }
        return null;
    }

    private static ECoord dist(EdgeH right, EdgeH left) {
        return right.getAdder().subtract(left.getAdder());
    }

    private static ECoord dist(EdgeV top, EdgeV bottom) {
        return top.getAdder().subtract(bottom.getAdder());
    }

    private static ECoord width(Technology.NodeLayer nl) {
        return TechType.dist(nl.getRightEdge(), nl.getLeftEdge());
    }

    private static ECoord height(Technology.NodeLayer nl) {
        return TechType.dist(nl.getTopEdge(), nl.getBottomEdge());
    }

    private PrimitiveNode getVia(int n) {
        return n > this.vias.length - 1 ? null : this.vias[n];
    }

    private PrimitiveNode findNode(PrimitiveNode.Function type, ArcProto ... arcs) {
        Iterator<PrimitiveNode> it = this.technology.getNodes();
        while (it.hasNext()) {
            PrimitiveNode pn = it.next();
            boolean found = true;
            if (pn.getFunction() != type) continue;
            for (int j = 0; j < arcs.length; ++j) {
                if (pn.connectsTo(arcs[j]) != null) continue;
                found = false;
                break;
            }
            if (!found) continue;
            return pn;
        }
        return null;
    }

    private Transistor findTransistor(PrimitiveNode.Function type) {
        PrimitiveNode pn = this.findNode(type, new ArcProto[0]);
        if (pn == null) {
            return null;
        }
        return new Transistor(pn);
    }

    private PrimitiveNode findPin(ArcProto arc) {
        return arc == null ? null : arc.findPinProto();
    }

    private void putViaMap(ArcProto arc1, ArcProto arc2, PrimitiveNode via) {
        if (arc1 == null || arc2 == null || via == null) {
            return;
        }
        ArcPair ap = new ArcPair(arc1, arc2);
        TechType.error(this.viaMap.containsKey(ap), "two contacts for same pair of arcs?");
        this.viaMap.put(ap, via);
    }

    private void initViaMap() {
        this.putViaMap(this.m1, this.m2, this.m1m2);
        this.putViaMap(this.m2, this.m3, this.m2m3);
        this.putViaMap(this.m3, this.m4, this.m3m4);
        this.putViaMap(this.m4, this.m5, this.m4m5);
        this.putViaMap(this.m5, this.m6, this.m5m6);
        this.putViaMap(this.m6, this.m7, this.m6m7);
        this.putViaMap(this.m7, this.m8, this.m7m8);
        this.putViaMap(this.m8, this.m9, this.m8m9);
        this.putViaMap(this.ndiff, this.m1, this.ndm1);
        this.putViaMap(this.pdiff, this.m1, this.pdm1);
        this.putViaMap(this.p1, this.m1, this.p1m1);
    }

    protected TechType(Technology techy) {
        ECoord diffExtendAlongMos;
        TechType.error(techy == null, "Null technology in TechType constructor");
        this.lmets = new Layer[techy.getNumMetals()];
        this.nbLay = 1 + this.lmets.length;
        this.technology = techy;
        this.drcRules = this.technology.getFactoryDesignRules();
        this.arcs = new ArcProto[this.nbLay];
        this.lp1 = techy.findLayerFromFunction(Layer.Function.POLY1, -1);
        this.lgate = techy.findLayerFromFunction(Layer.Function.GATE, -1);
        if (this.lgate == null) {
            this.lgate = this.lp1;
        }
        this.arcs[0] = this.findArc(this.lp1);
        for (int i = 1; i < this.nbLay; ++i) {
            Layer lm;
            this.lmets[i - 1] = lm = techy.findLayerFromFunction(Layer.Function.getMetal(i), -1);
            this.arcs[i] = this.findArc(lm);
            TechType.error(this.arcs[i] == null, "No such arc: " + (Object)((Object)Layer.Function.getMetal(i)) + " in technology " + techy.getTechName());
        }
        Layer lnwell = techy.findLayerFromFunction(Layer.Function.WELLN, 0);
        Layer lpwell = techy.findLayerFromFunction(Layer.Function.WELLP, 0);
        Layer lnd = techy.findLayerFromFunction(Layer.Function.DIFFN, 0);
        if (lnd == null) {
            lnd = techy.findLayerFromFunction(Layer.Function.DIFF, 0);
        }
        Layer lpd = techy.findLayerFromFunction(Layer.Function.DIFFP, 0);
        Layer lnsel = techy.findLayerFromFunction(Layer.Function.IMPLANTN, 0);
        Layer lpsel = techy.findLayerFromFunction(Layer.Function.IMPLANTP, 0);
        Layer lod18 = techy.findLayer("OD18");
        Layer lod25 = techy.findLayer("OD25");
        Layer lod33 = techy.findLayer("OD33");
        this.p1 = this.getArc(0);
        this.m1 = this.getArc(1);
        this.m2 = this.getArc(2);
        this.m3 = this.getArc(3);
        this.m4 = this.getArc(4);
        this.m5 = this.getArc(5);
        this.m6 = this.getArc(6);
        this.m7 = this.getArc(7);
        this.m8 = this.getArc(8);
        this.m9 = this.getArc(9);
        this.ndiff = this.findArc(lnd);
        this.pdiff = this.findArc(lpd);
        this.ndiff18 = this.findArc(lnd, lod18);
        this.pdiff18 = this.findArc(lpd, lod18);
        this.ndiff25 = this.findArc(lnd, lod25);
        this.pdiff25 = this.findArc(lpd, lod25);
        this.ndiff33 = this.findArc(lnd, lod33);
        this.pdiff33 = this.findArc(lpd, lod33);
        this.nwellNode = this.findPureNode(lnwell);
        this.pwellNode = this.findPureNode(lpwell);
        this.m1Node = this.findPureNode(this.getMetalLayer(1));
        this.m2Node = this.findPureNode(this.getMetalLayer(2));
        this.m3Node = this.findPureNode(this.getMetalLayer(3));
        this.m4Node = this.findPureNode(this.getMetalLayer(4));
        this.m5Node = this.findPureNode(this.getMetalLayer(5));
        this.m6Node = this.findPureNode(this.getMetalLayer(6));
        this.m7Node = this.findPureNode(this.getMetalLayer(7));
        this.m8Node = this.findPureNode(this.getMetalLayer(8));
        this.m9Node = this.findPureNode(this.getMetalLayer(9));
        this.p1Node = this.findPureNode(this.lp1);
        this.pdNode = this.findPureNode(lpd);
        this.ndNode = this.findPureNode(lnd);
        this.nselNode = this.findPureNode(lnsel);
        this.pselNode = this.findPureNode(lpsel);
        this.od18Node = this.findPureNode(lod18);
        this.od25Node = this.findPureNode(lod25);
        this.od33Node = this.findPureNode(lod33);
        this.vthNode = null;
        this.vtlNode = null;
        this.pdpin = this.findPin(this.pdiff);
        this.ndpin = this.findPin(this.ndiff);
        this.p1pin = this.findPin(this.p1);
        this.m1pin = this.findPin(this.m1);
        this.m2pin = this.findPin(this.m2);
        this.m3pin = this.findPin(this.m3);
        this.m4pin = this.findPin(this.m4);
        this.m5pin = this.findPin(this.m5);
        this.m6pin = this.findPin(this.m6);
        this.m7pin = this.findPin(this.m7);
        this.m8pin = this.findPin(this.m8);
        this.m9pin = this.findPin(this.m9);
        this.vias = new PrimitiveNode[this.nbLay - 1];
        for (int i = 0; i < this.nbLay - 1; ++i) {
            this.vias[i] = this.findNode(PrimitiveNode.Function.CONTACT, this.arcs[i], this.arcs[i + 1]);
            TechType.error(this.vias[i] == null, "No via for layer: " + this.arcs[i]);
        }
        this.p1m1 = this.getVia(0);
        this.m1m2 = this.getVia(1);
        this.m2m3 = this.getVia(2);
        this.m3m4 = this.getVia(3);
        this.m4m5 = this.getVia(4);
        this.m5m6 = this.getVia(5);
        this.m6m7 = this.getVia(6);
        this.m7m8 = this.getVia(7);
        this.m8m9 = this.getVia(8);
        this.ndm1 = this.findNode(PrimitiveNode.Function.CONTACT, this.ndiff, this.arcs[1]);
        this.pdm1 = this.findNode(PrimitiveNode.Function.CONTACT, this.pdiff, this.arcs[1]);
        this.nwm1 = this.findNode(PrimitiveNode.Function.WELL, this.arcs[1]);
        this.pwm1 = this.findNode(PrimitiveNode.Function.SUBSTRATE, this.arcs[1]);
        this.nwm1Y = techy.findNodeProto("Y-Metal-1-N-Well-Con");
        this.pwm1Y = techy.findNodeProto("Y-Metal-1-P-Well-Con");
        this.nmos18contact = this.findNode(PrimitiveNode.Function.CONTACT, this.ndiff18, this.arcs[1]);
        this.pmos18contact = this.findNode(PrimitiveNode.Function.CONTACT, this.pdiff18, this.arcs[1]);
        this.nmos25contact = this.findNode(PrimitiveNode.Function.CONTACT, this.ndiff25, this.arcs[1]);
        this.pmos25contact = this.findNode(PrimitiveNode.Function.CONTACT, this.pdiff25, this.arcs[1]);
        this.nmos33contact = this.findNode(PrimitiveNode.Function.CONTACT, this.ndiff33, this.arcs[1]);
        this.pmos33contact = this.findNode(PrimitiveNode.Function.CONTACT, this.pdiff33, this.arcs[1]);
        this.initViaMap();
        this.nmos = this.findTransistor(PrimitiveNode.Function.TRANMOS);
        this.pmos = this.findTransistor(PrimitiveNode.Function.TRAPMOS);
        this.nmos18 = this.findTransistor(PrimitiveNode.Function.TRANMOSHV1);
        this.pmos18 = this.findTransistor(PrimitiveNode.Function.TRAPMOSHV1);
        this.nmos25 = this.findTransistor(PrimitiveNode.Function.TRANMOSHV2);
        this.pmos25 = this.findTransistor(PrimitiveNode.Function.TRAPMOSHV2);
        this.nmos33 = this.findTransistor(PrimitiveNode.Function.TRANMOSHV3);
        this.pmos33 = this.findTransistor(PrimitiveNode.Function.TRAPMOSHV3);
        Technology.NodeLayer nmos_gate = this.findNodeLayer(this.nmos.pn, this.lgate);
        if (nmos_gate == null) {
            nmos_gate = this.findNodeLayer(this.nmos.pn, this.lp1);
        }
        Technology.NodeLayer nmos_nd = this.findNodeLayer(this.nmos.pn, lnd);
        Technology.NodeLayer nmos_nsel = this.findNodeLayer(this.nmos.pn, lnsel);
        boolean bl = this.rotateTransistors = TechType.height(nmos_gate).compareTo(TechType.width(nmos_gate)) < 0;
        if (this.rotateTransistors) {
            this.p1Width = this.gateLength = TechType.height(nmos_gate).getLambda();
            this.gateExtendPastMOS = TechType.dist(nmos_gate.getRightEdge(), nmos_nd.getRightEdge()).getLambda();
            diffExtendAlongMos = TechType.dist(nmos_nd.getTopEdge(), nmos_gate.getTopEdge());
            this.selectSurroundDiffInTrans = TechType.dist(nmos_nsel.getTopEdge(), nmos_nd.getTopEdge()).getLambda();
            this.selectSurroundDiffAlongGateInTrans = TechType.dist(nmos_nsel.getRightEdge(), nmos_nd.getRightEdge()).getLambda();
        } else {
            this.p1Width = this.gateLength = TechType.width(nmos_gate).getLambda();
            this.gateExtendPastMOS = TechType.dist(nmos_gate.getTopEdge(), nmos_nd.getTopEdge()).getLambda();
            diffExtendAlongMos = TechType.dist(nmos_nd.getRightEdge(), nmos_gate.getRightEdge());
            this.selectSurroundDiffInTrans = TechType.dist(nmos_nsel.getRightEdge(), nmos_nd.getRightEdge()).getLambda();
            this.selectSurroundDiffAlongGateInTrans = TechType.dist(nmos_nsel.getTopEdge(), nmos_nd.getTopEdge()).getLambda();
        }
        this.wellContWidth = Double.NaN;
        this.selectSurroundDiffInWellContact = Double.NaN;
        this.wellSurroundDiff = Double.NaN;
        if (this.nwm1Y == null) {
            Technology.NodeLayer nwm1_nwell = this.findNodeLayer(this.nwm1, lnwell);
            Technology.NodeLayer nwm1_nsel = this.findNodeLayer(this.nwm1, lnsel);
            Technology.NodeLayer nwm1_nd = this.findNodeLayer(this.nwm1, lnd);
            if (nwm1_nwell != null && nwm1_nd != null) {
                this.wellContWidth = TechType.height(nwm1_nd).getLambda();
                this.selectSurroundDiffInWellContact = TechType.dist(nwm1_nsel.getTopEdge(), nwm1_nd.getTopEdge()).getLambda();
                this.wellSurroundDiff = TechType.dist(nwm1_nwell.getTopEdge(), nwm1_nd.getTopEdge()).getLambda();
            }
        }
        this.p1ToP1Space = this.getSpacing(this.lp1, this.lp1).getLambda();
        this.gateToGateSpace = this.getSpacing(this.lgate, this.lgate).max(diffExtendAlongMos).getLambda();
        this.selectSpace = this.getSpacing(lnsel, lnsel).getLambda();
        DRCTemplate m1MinAreaRule = this.drcRules.getMinValue(this.lmets[0], DRCTemplate.DRCRuleType.MINAREA);
        this.m1MinArea = m1MinAreaRule != null ? m1MinAreaRule.getValue(0) : 0.0;
        Technology.NodeLayer ndm1_nd = this.findNodeLayer(this.ndm1, lnd);
        Technology.NodeLayer ndm1_nsel = this.findNodeLayer(this.ndm1, lnsel);
        Technology.NodeLayer ndm1_m1 = this.findNodeLayer(this.ndm1, this.lmets[0]);
        Technology.NodeLayer ndm1_multicut = this.findMulticut(this.ndm1);
        this.diffContWidth = TechType.width(ndm1_nd).getLambda();
        this.diffCont_m1Width = TechType.width(ndm1_m1).getLambda();
        this.selectSurroundDiffInActiveContact = TechType.dist(ndm1_nsel.getRightEdge(), ndm1_nd.getRightEdge()).getLambda();
        this.diffContIncr = ndm1_multicut.getMulticutSizeX().add(ndm1_multicut.getMulticutSep1D()).getLambda();
        if (this.drcRules.isAnySpacingRule(ndm1_multicut.getLayer(), this.lgate)) {
            this.gateToDiffContSpace = this.gateToDiffContSpaceDogBone = this.getSpacing(ndm1_multicut.getLayer(), this.lgate).subtract(TechType.width(ndm1_nd).subtract(ndm1_multicut.getMulticutSizeX()).multiply(0.5)).getLambda();
        } else {
            this.gateToDiffContSpaceDogBone = 0.0;
            this.gateToDiffContSpace = 0.0;
        }
        Technology.NodeLayer p1m1_p1 = this.findNodeLayer(this.p1m1, this.lp1);
        this.polyContWidth = TechType.width(p1m1_p1).getLambda();
        this.offsetLShapePolyContact = p1m1_p1.getRightEdge().getAdder().subtract(this.p1.getLayerExtend(this.lp1)).getLambda();
        this.offsetTShapePolyContact = p1m1_p1.getRightEdge().getAdder().add(this.p1.getLayerExtend(this.lp1)).getLambda();
        this.selectSurround = Double.NaN;
    }

    public static TechType getTechType(Technology technology) {
        if (technology == Technology.getMocmosTechnology()) {
            return TechType.getMOCMOS();
        }
        if (technology == Technology.getTSMC180Technology()) {
            return TechType.getTSMC180();
        }
        if (technology == Technology.getCMOS90Technology()) {
            return TechType.getCMOS90();
        }
        return new TechTypeWizard(technology);
    }

    public static TechType getMOCMOS() {
        if (techTypeMoCMOS == null) {
            techTypeMoCMOS = new TechTypeMoCMOS();
        }
        return techTypeMoCMOS;
    }

    public static TechType getTSMC180() {
        block3: {
            if (techTypeTSMC180 == null) {
                try {
                    Class<?> tsmc180Class = Class.forName("com.sun.electric.plugins.tsmc.TechTypeTSMC180");
                    Constructor<?> techConstr = tsmc180Class.getConstructor(new Class[0]);
                    techTypeTSMC180 = (TechType)techConstr.newInstance(new Object[0]);
                }
                catch (Exception e) {
                    if ($assertionsDisabled) break block3;
                    throw new AssertionError();
                }
            }
        }
        return techTypeTSMC180;
    }

    public static TechType getCMOS90() {
        block3: {
            if (techTypeCMOS90 == null) {
                try {
                    Class<?> cmos90Class = Class.forName("com.sun.electric.plugins.tsmc.TechTypeCMOS90");
                    Constructor<?> techConstr = cmos90Class.getConstructor(new Class[0]);
                    techTypeCMOS90 = (TechType)techConstr.newInstance(new Object[0]);
                }
                catch (Exception e) {
                    if ($assertionsDisabled) break block3;
                    throw new AssertionError();
                }
            }
        }
        return techTypeCMOS90;
    }

    public int getNumMetals() {
        return this.lmets.length;
    }

    public Technology getTechnology() {
        return this.technology;
    }

    public ArcProto pdiff() {
        return this.pdiff;
    }

    public ArcProto ndiff() {
        return this.ndiff;
    }

    public ArcProto p1() {
        return this.p1;
    }

    public ArcProto m1() {
        return this.m1;
    }

    public ArcProto m2() {
        return this.m2;
    }

    public ArcProto m3() {
        return this.m3;
    }

    public ArcProto m4() {
        return this.m4;
    }

    public ArcProto m5() {
        return this.m5;
    }

    public ArcProto m6() {
        return this.m6;
    }

    public ArcProto m7() {
        return this.m7;
    }

    public ArcProto m8() {
        return this.m8;
    }

    public ArcProto m9() {
        return this.m9;
    }

    public ArcProto ndiff18() {
        return this.ndiff18;
    }

    public ArcProto pdiff18() {
        return this.pdiff18;
    }

    public ArcProto ndiff25() {
        return this.ndiff25;
    }

    public ArcProto pdiff25() {
        return this.pdiff25;
    }

    public ArcProto ndiff33() {
        return this.ndiff33;
    }

    public ArcProto pdiff33() {
        return this.pdiff33;
    }

    public PrimitiveNode ndpin() {
        return this.ndpin;
    }

    public PrimitiveNode pdpin() {
        return this.pdpin;
    }

    public PrimitiveNode p1pin() {
        return this.p1pin;
    }

    public PrimitiveNode m1pin() {
        return this.m1pin;
    }

    public PrimitiveNode m2pin() {
        return this.m2pin;
    }

    public PrimitiveNode m3pin() {
        return this.m3pin;
    }

    public PrimitiveNode m4pin() {
        return this.m4pin;
    }

    public PrimitiveNode m5pin() {
        return this.m5pin;
    }

    public PrimitiveNode m6pin() {
        return this.m6pin;
    }

    public PrimitiveNode m7pin() {
        return this.m7pin;
    }

    public PrimitiveNode m8pin() {
        return this.m8pin;
    }

    public PrimitiveNode m9pin() {
        return this.m9pin;
    }

    public PrimitiveNode nwm1() {
        return this.nwm1;
    }

    public PrimitiveNode pwm1() {
        return this.pwm1;
    }

    public PrimitiveNode nwm1Y() {
        return this.nwm1Y;
    }

    public PrimitiveNode pwm1Y() {
        return this.pwm1Y;
    }

    public PrimitiveNode ndm1() {
        return this.ndm1;
    }

    public PrimitiveNode pdm1() {
        return this.pdm1;
    }

    public PrimitiveNode p1m1() {
        return this.p1m1;
    }

    public PrimitiveNode m1m2() {
        return this.m1m2;
    }

    public PrimitiveNode m2m3() {
        return this.m2m3;
    }

    public PrimitiveNode m3m4() {
        return this.m3m4;
    }

    public PrimitiveNode m4m5() {
        return this.m4m5;
    }

    public PrimitiveNode m5m6() {
        return this.m5m6;
    }

    public PrimitiveNode m6m7() {
        return this.m6m7;
    }

    public PrimitiveNode m7m8() {
        return this.m7m8;
    }

    public PrimitiveNode m8m9() {
        return this.m8m9;
    }

    public PrimitiveNode nmos() {
        return this.nmos != null ? this.nmos.pn : null;
    }

    public PrimitiveNode pmos() {
        return this.pmos != null ? this.pmos.pn : null;
    }

    public PrimitiveNode nmos18() {
        return this.nmos18 != null ? this.nmos18.pn : null;
    }

    public PrimitiveNode pmos18() {
        return this.pmos18 != null ? this.pmos18.pn : null;
    }

    public PrimitiveNode nmos25() {
        return this.nmos25 != null ? this.nmos25.pn : null;
    }

    public PrimitiveNode pmos25() {
        return this.pmos25 != null ? this.pmos25.pn : null;
    }

    public PrimitiveNode nmos33() {
        return this.nmos33 != null ? this.nmos33.pn : null;
    }

    public PrimitiveNode pmos33() {
        return this.pmos33 != null ? this.pmos33.pn : null;
    }

    public PrimitiveNode nmos18contact() {
        return this.nmos18contact;
    }

    public PrimitiveNode pmos18contact() {
        return this.pmos18contact;
    }

    public PrimitiveNode nmos25contact() {
        return this.nmos25contact;
    }

    public PrimitiveNode pmos25contact() {
        return this.pmos25contact;
    }

    public PrimitiveNode nmos33contact() {
        return this.nmos33contact;
    }

    public PrimitiveNode pmos33contact() {
        return this.pmos33contact;
    }

    public PrimitiveNode nwell() {
        return this.nwellNode;
    }

    public PrimitiveNode pwell() {
        return this.pwellNode;
    }

    public PrimitiveNode m1Node() {
        return this.m1Node;
    }

    public PrimitiveNode m2Node() {
        return this.m2Node;
    }

    public PrimitiveNode m3Node() {
        return this.m3Node;
    }

    public PrimitiveNode m4Node() {
        return this.m4Node;
    }

    public PrimitiveNode m5Node() {
        return this.m5Node;
    }

    public PrimitiveNode m6Node() {
        return this.m6Node;
    }

    public PrimitiveNode m7Node() {
        return this.m7Node;
    }

    public PrimitiveNode m8Node() {
        return this.m8Node;
    }

    public PrimitiveNode m9Node() {
        return this.m9Node;
    }

    public PrimitiveNode p1Node() {
        return this.p1Node;
    }

    public PrimitiveNode pdNode() {
        return this.pdNode;
    }

    public PrimitiveNode ndNode() {
        return this.ndNode;
    }

    public PrimitiveNode pselNode() {
        return this.pselNode;
    }

    public PrimitiveNode nselNode() {
        return this.nselNode;
    }

    public PrimitiveNode od18() {
        return this.od18Node;
    }

    public PrimitiveNode od25() {
        return this.od25Node;
    }

    public PrimitiveNode od33() {
        return this.od33Node;
    }

    public PrimitiveNode vth() {
        return this.vthNode;
    }

    public PrimitiveNode vtl() {
        return this.vtlNode;
    }

    public PrimitiveNode essentialBounds() {
        return this.essentialBounds;
    }

    public PrimitiveNode facetCenter() {
        return this.facetCenter;
    }

    public PrimitiveNode getViaFor(ArcProto a1, ArcProto a2) {
        return this.viaMap.get(new ArcPair(a1, a2));
    }

    public int layerHeight(ArcProto p) {
        for (int i = 0; i < this.nbLay; ++i) {
            if (this.arcs[i] != p) continue;
            return i;
        }
        TechType.error(true, "Can't find layer: " + p);
        return -1;
    }

    public ArcProto closestLayer(PortProto port, ArcProto layer) {
        int h = this.layerHeight(layer);
        for (int dist = 0; dist < this.nbLay; ++dist) {
            ArcProto lay;
            int lookUp = h + dist;
            int lookDn = h - dist;
            if (lookUp < this.nbLay && port.connectsTo(lay = this.layerAtHeight(lookUp))) {
                return lay;
            }
            if (lookDn < 0 || !port.connectsTo(lay = this.layerAtHeight(lookDn))) continue;
            return lay;
        }
        TechType.error(true, "port can't connect to any layer?!!");
        return null;
    }

    public ArcProto highestLayer(PortProto port) {
        for (int h = this.arcs.length - 1; h >= 0; --h) {
            if (!port.connectsTo(this.arcs[h])) continue;
            return this.arcs[h];
        }
        TechType.error(true, "port can't connect to any layer?!!");
        return null;
    }

    public ArcProto layerAtHeight(int layHeight) {
        return this.arcs[layHeight];
    }

    public PrimitiveNode viaAbove(int layHeight) {
        return this.vias[layHeight];
    }

    public PrimitiveNode viaBelow(int layHeight) {
        return this.vias[layHeight - 1];
    }

    public double roundToGrid(double x2) {
        return x2;
    }

    public MosInst newNmosInst(double x2, double y, double w, double l, Cell parent, EditingPreferences ep) {
        return new MosInst('n', x2, y, w, l, this, ep, parent);
    }

    public MosInst newPmosInst(double x2, double y, double w, double l, Cell parent, EditingPreferences ep) {
        return new MosInst('p', x2, y, w, l, this, ep, parent);
    }

    public abstract String name();

    public abstract double reservedToLambda(int var1, double var2);

    public double getWellWidth() {
        return this.nwm1.getMinSizeRule().getWidth();
    }

    public double getWellSurroundDiffInWellContact() {
        return this.wellSurroundDiff;
    }

    public double getGateExtendPastMOS() {
        return this.gateExtendPastMOS;
    }

    public double getP1Width() {
        return this.p1Width;
    }

    public double getP1ToP1Space() {
        return this.p1ToP1Space;
    }

    public double getGateToGateSpace() {
        return this.gateToGateSpace;
    }

    public double getGateToDiffContSpace() {
        return this.gateToDiffContSpace;
    }

    public double getGateToDiffContSpaceDogBone() {
        return this.gateToDiffContSpaceDogBone;
    }

    public double getWellContWidth() {
        return this.wellContWidth;
    }

    public double getDiffContWidth() {
        return this.diffContWidth;
    }

    public double getP1M1Width() {
        return this.polyContWidth;
    }

    public double getGateLength() {
        return this.gateLength;
    }

    public double selectSurroundDiffInWellContact() {
        return this.selectSurroundDiffInWellContact;
    }

    public double selectSurroundDiffInDiffContact() {
        return this.selectSurroundDiffInActiveContact;
    }

    public double selectSurroundDiffAlongGateInTrans() {
        return this.selectSurroundDiffAlongGateInTrans;
    }

    public double getPolyLShapeOffset() {
        return this.offsetLShapePolyContact;
    }

    public double getPolyTShapeOffset() {
        return this.offsetTShapePolyContact;
    }

    public double getSelectSpacingRule() {
        return this.selectSpace;
    }

    public double getSelectSurroundDiffInTrans() {
        return this.selectSurroundDiffInTrans;
    }

    public double getSelectSurroundOverPoly() {
        return this.selectSurround;
    }

    public double getM1MinArea() {
        return this.m1MinArea;
    }

    public double getDiffCont_m1Width() {
        return this.diffCont_m1Width;
    }

    public double getDiffContIncr() {
        return this.diffContIncr;
    }

    public Variable.Key getAttrX() {
        return ATTR_X;
    }

    public Variable.Key getAttrS() {
        return ATTR_S;
    }

    public Variable.Key getAttrSP() {
        return ATTR_SP;
    }

    public Variable.Key getAttrSN() {
        return ATTR_SN;
    }

    public static class MosInst {
        private final NodeInst mos;
        private final String leftDiff;
        private final String rightDiff;
        private final String topPoly;
        private final String botPoly;

        private static void error(boolean pred, String msg) {
            Job.error(pred, msg);
        }

        private MosInst(char np, double x2, double y, double width, double length, TechType tech, EditingPreferences ep, Cell parent) {
            Transistor t = np == 'n' ? tech.nmos : tech.pmos;
            this.leftDiff = t.leftDiff.getName();
            this.rightDiff = t.rightDiff.getName();
            this.topPoly = t.topPoly.getName();
            this.botPoly = t.bottomPoly.getName();
            this.mos = tech.rotateTransistors ? LayoutLib.newNodeInst(t.pn, ep, x2, y, width, length, 90.0, parent) : LayoutLib.newNodeInst(t.pn, ep, x2, y, length, width, 0.0, parent);
        }

        private PortInst getPort(String portNm) {
            PortInst pi = this.mos.findPortInst(portNm);
            MosInst.error(pi == null, "MosInst can't find port!");
            return pi;
        }

        public PortInst leftDiff() {
            return this.getPort(this.leftDiff);
        }

        public PortInst rightDiff() {
            return this.getPort(this.rightDiff);
        }

        public PortInst topPoly() {
            return this.getPort(this.topPoly);
        }

        public PortInst botPoly() {
            return this.getPort(this.botPoly);
        }
    }

    private class Transistor {
        private final PrimitiveNode pn;
        private PrimitivePort topPoly;
        private PrimitivePort bottomPoly;
        private PrimitivePort leftDiff;
        private PrimitivePort rightDiff;

        private Transistor(PrimitiveNode pn) {
            this.pn = pn;
            Technology.NodeLayer nmos_gate = TechType.this.findNodeLayer(pn, TechType.this.lgate);
            if (nmos_gate == null) {
                nmos_gate = TechType.this.findNodeLayer(pn, TechType.this.lp1);
            }
            boolean rotate = nmos_gate.getTopEdge().getAdder().subtract(nmos_gate.getBottomEdge().getAdder()).compareTo(nmos_gate.getRightEdge().getAdder().subtract(nmos_gate.getLeftEdge().getAdder())) < 0;
            Iterator<PrimitivePort> it = pn.getPrimitivePorts();
            while (it.hasNext()) {
                PrimitivePort pp = it.next();
                if (pp.getConnection().getFunction().isPoly()) {
                    if (rotate) {
                        if (pp.getRight().getAdder().signum() > 0) {
                            this.topPoly = pp;
                            continue;
                        }
                        this.bottomPoly = pp;
                        continue;
                    }
                    if (pp.getBottom().getAdder().signum() > 0) {
                        this.topPoly = pp;
                        continue;
                    }
                    this.bottomPoly = pp;
                    continue;
                }
                if (!pp.getConnection().getFunction().isDiffusion()) continue;
                if (rotate) {
                    if (pp.getTop().getAdder().signum() > 0) {
                        this.leftDiff = pp;
                        continue;
                    }
                    this.rightDiff = pp;
                    continue;
                }
                if (pp.getRight().getAdder().signum() > 0) {
                    this.rightDiff = pp;
                    continue;
                }
                this.leftDiff = pp;
            }
            assert (this.topPoly != null && this.bottomPoly != null && this.leftDiff != null && this.rightDiff != null);
        }
    }

    private static class ArcPair
    implements Serializable {
        private static final long serialVersionUID = 0L;
        private ArcProto arc1;
        private ArcProto arc2;

        public ArcPair(ArcProto a1, ArcProto a2) {
            this.arc1 = a1;
            this.arc2 = a2;
        }

        public boolean equals(Object o) {
            if (!(o instanceof ArcPair)) {
                return false;
            }
            ArcPair ap = (ArcPair)o;
            if (ap.arc1 == this.arc1 && ap.arc2 == this.arc2) {
                return true;
            }
            return ap.arc1 == this.arc2 && ap.arc2 == this.arc1;
        }

        public int hashCode() {
            return this.arc1.hashCode() * this.arc2.hashCode();
        }
    }
}

