/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.simulation.sctiming;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.text.Version;
import com.sun.electric.tool.io.input.spicenetlist.SpiceNetlistReader;
import com.sun.electric.tool.io.input.spicenetlist.SpiceSubckt;
import com.sun.electric.tool.ncc.basic.NccCellAnnotations;
import com.sun.electric.tool.simulation.sctiming.Arc;
import com.sun.electric.tool.simulation.sctiming.LibData;
import com.sun.electric.tool.simulation.sctiming.PinEdge;
import com.sun.electric.tool.simulation.sctiming.SCRunBase;
import com.sun.electric.tool.simulation.sctiming.SCSettings;
import com.sun.electric.tool.simulation.sctiming.SCTimingException;
import com.sun.electric.tool.simulation.sctiming.Table2D;
import com.sun.electric.tool.simulation.sctiming.TableData;
import com.sun.electric.tool.user.Exec;
import com.sun.electric.tool.user.MessagesStream;
import com.sun.electric.util.TextUtils;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.TreeSet;

public class SCTiming {
    private String inputFile = null;
    private Cell topCell = null;
    public String topCellName = null;
    private String topCellNameLiberty = null;
    public String outputDir = ".";
    private String topCellParams = "";
    private double scaleLoadSweep = 1.0;
    public SCSettings settings;
    private String inbufStr = "inbufStr";
    private String outloadStr = "outloadStr";
    private String clkbufStr = "clkbufStr";
    private String setupTimeName = "tmsetup";
    private String setupTimeSweep = "tmsetupsweep";
    private String holdTimeSweep = "tmholdsweep";
    private String holdTimeName = "tmhold";
    private String clk2q = "clk2q";
    private String setupclk2q = "setupclk2q";
    private SpiceSubckt dutSubckt;
    private SpiceSubckt bufferSubckt;
    private SpiceSubckt clkbufSubckt;
    private SpiceSubckt loadSubckt;
    private List<Arc> timingArcs;
    private List<SweepParam> sweeps;
    private Map<String, String> combinationalFunctions;
    private FlipFlopFunction functionFlipFlop = null;
    private FlipFlopFunctionSDRtoDDR functionFlipFlopSDRtoDDR = null;
    private FlipFlopFunctionDDRtoSDR functionFlipFlopDDRtoSDR = null;
    private LatchFunction functionLatch = null;
    private TestCell testCell = null;
    private PrintWriter out;
    private PrintStream msg = System.out;
    private SpiceNetlistReader netlistReader = null;
    private boolean interfaceTiming = false;
    private List<String> ignorableSubckts;
    private String threeStatePin = null;
    private boolean threeStatePinStateForOutputZ = false;
    private List<String> unusedPins = null;
    private ResetPin resetPin = null;
    private boolean setDontTouch = false;
    private boolean setDontUse = false;
    private boolean verbose = true;
    private boolean printStatistics = true;
    public boolean characterizationFailed = false;
    private boolean useAutoStop = true;
    private boolean noTiming = false;
    private static final String lineComment = "*****************************************************";

    public SCTiming() {
        this.timingArcs = new ArrayList<Arc>();
        this.sweeps = new ArrayList<SweepParam>();
        this.combinationalFunctions = new HashMap<String, String>();
        this.ignorableSubckts = new ArrayList<String>();
        this.unusedPins = new ArrayList<String>();
    }

    public void setSettings(SCSettings settings) {
        this.settings = settings;
    }

    public void setInputFile(String inputFile) {
        this.inputFile = inputFile;
    }

    public void setTopCell(Cell topCell) {
        this.topCell = topCell;
    }

    public void setTopCellName(String topCellName) {
        this.topCellName = topCellName;
    }

    public void setTopCellNameLiberty(String topCellName) {
        this.topCellNameLiberty = topCellName;
    }

    public void setTopCellParams(String list) {
        this.topCellParams = list;
    }

    public void setOutputDir(String dir) {
        this.outputDir = dir;
    }

    public void addTimingArc(Arc arc) {
        this.timingArcs.add(arc);
    }

    public void setFunctionCombinational(String outputPin, String function) {
        this.combinationalFunctions.put(outputPin, function);
    }

    public void setFunctionFlipFlop(String outputPosPin, String outputNegPin, String inputPin, String clockedOnPin) {
        this.functionFlipFlop = new FlipFlopFunction(outputPosPin, outputNegPin, inputPin, clockedOnPin, false);
        this.combinationalFunctions.put(outputPosPin, "i" + outputPosPin);
    }

    public void setFunctionFlipFlopDDR(String outputPosPin, String outputNegPin, String inputPin, String clockedOnPin) {
        this.functionFlipFlop = new FlipFlopFunction(outputPosPin, outputNegPin, inputPin, clockedOnPin, true);
        this.combinationalFunctions.put(outputPosPin, "i" + outputPosPin);
    }

    public void setFunctionFlipFlopSDRtoDDR(String outputPosPin, String outputNegPin, String inputRise, String inputFall, String clockedOnPin) {
        this.functionFlipFlopSDRtoDDR = new FlipFlopFunctionSDRtoDDR(outputPosPin, outputNegPin, inputRise, inputFall, clockedOnPin);
        this.combinationalFunctions.put(outputPosPin, "i" + outputPosPin);
    }

    public void setFunctionFlipFlopDDRtoSDR(String outputRise, String outputFall, String inputPin, String clockedOnPin) {
        this.functionFlipFlopDDRtoSDR = new FlipFlopFunctionDDRtoSDR(outputRise, outputFall, inputPin, clockedOnPin);
        this.combinationalFunctions.put(outputRise, "i" + outputRise);
        this.combinationalFunctions.put(outputFall, "i" + outputFall);
    }

    public void setFunctionLatch(String outputPosPin, String outputNegPin, String inputPin, String enablePin) {
        this.functionLatch = new LatchFunction(outputPosPin, outputNegPin, inputPin, enablePin);
        this.combinationalFunctions.put(outputPosPin, "i" + outputPosPin);
    }

    public void setFunctionInterfaceTiming() {
        this.interfaceTiming = true;
    }

    public void setTestCell(String scanInPin, String scanOutPin, String scanEnPin) {
        this.testCell = new TestCell(scanInPin, scanOutPin, scanEnPin);
    }

    public void setAutoStop(boolean t) {
        this.useAutoStop = t;
    }

    public void addIgnorableSubckt(String subcktName) {
        this.ignorableSubckts.add(subcktName);
    }

    public void addUnusedPin(String pin) {
        this.unusedPins.add(pin);
    }

    public void addResetPin(String pin, boolean activeHigh, boolean resetState) {
        this.resetPin = new ResetPin(pin, activeHigh, resetState);
    }

    public void setNoTimingMode() {
        this.noTiming = true;
    }

    public void setThreeStateEnable(String pin, boolean enableStateForOutputZ) {
        this.threeStatePin = pin;
        this.threeStatePinStateForOutputZ = enableStateForOutputZ;
    }

    public void setDontTouch() {
        this.setDontTouch = true;
    }

    public void setDontUse() {
        this.setDontUse = true;
    }

    public boolean characterize(SCRunBase.DelayType delayType) {
        try {
            this.characterize_(delayType);
        }
        catch (SCTimingException e) {
            System.out.println("SCTiming: Exception: " + e.getMessage());
            this.characterizationFailed = true;
            return false;
        }
        return true;
    }

    public void characterize_(SCRunBase.DelayType delayType) throws SCTimingException {
        MessagesStream.getMessagesStream().save(new File(this.outputDir, "SCTiming.log").getPath());
        this.err(this.inputFile == null, "Input spice file not specified");
        this.err(this.topCellName == null, "Top (Test) cell not specified");
        this.err(this.timingArcs.size() == 0, "No timing arcs specified");
        boolean sequentialTest = false;
        for (Arc a : this.timingArcs) {
            if (a.clk == null) continue;
            sequentialTest = true;
        }
        this.settings.checkSettings(sequentialTest);
        if (this.settings.scaleLoadCellSweepWithXSize) {
            this.scaleLoadSweep = SCRunBase.getCellSize(this.topCellName);
            System.out.println("Scale for " + this.topCellName + " is " + this.scaleLoadSweep);
        }
        this.msg.println("--------------------------------------------------------");
        this.msg.println("Characterization:");
        this.msg.println("   Cell \"" + this.topCellName + "\"");
        this.msg.println("   " + new Date(System.currentTimeMillis()));
        this.msg.println();
        this.msg.println("--------------------------------------------------------");
        this.msg.println("Reading spice netlist '" + this.inputFile + "'...");
        this.netlistReader = new SpiceNetlistReader();
        try {
            this.netlistReader.readFile(this.inputFile, false);
        }
        catch (FileNotFoundException e) {
            throw new SCTimingException(e.getMessage());
        }
        this.msg.println();
        this.msg.println("Spice netlist read complete. Checking netlist...");
        this.dutSubckt = this.netlistReader.getSubckt(this.topCellName);
        this.err(this.dutSubckt == null, "Test Cell " + this.topCellName + " not found in spice netlist");
        this.bufferSubckt = this.netlistReader.getSubckt(this.settings.bufferCell);
        this.err(this.bufferSubckt == null, "Buffer cell " + this.settings.bufferCell + " not found in spice netlist");
        this.err(this.bufferSubckt.getParamValue(this.settings.bufferCellStrengthParam) == null, "Strength param " + this.settings.bufferCellStrengthParam + " not found in buffer cell " + this.settings.bufferCell);
        this.err(!this.bufferSubckt.hasPort(this.settings.bufferCellInputPort), "Input port " + this.settings.bufferCellInputPort + " not found in buffer cell " + this.settings.bufferCell);
        this.err(!this.bufferSubckt.hasPort(this.settings.bufferCellOutputPort), "Output port " + this.settings.bufferCellOutputPort + " not found in buffer cell " + this.settings.bufferCell);
        this.loadSubckt = this.netlistReader.getSubckt(this.settings.loadCell);
        this.err(this.loadSubckt == null, "Load cell " + this.settings.loadCell + " not found in spice netlist");
        this.err(this.loadSubckt.getParamValue(this.settings.loadCellStrengthParam) == null, "Strength param " + this.settings.loadCellStrengthParam + " not found in load cell " + this.settings.loadCell);
        this.err(!this.loadSubckt.hasPort(this.settings.loadCellPort), "Load port " + this.settings.loadCellPort + " not found in load cell " + this.settings.loadCell);
        this.clkbufSubckt = null;
        if (sequentialTest) {
            this.clkbufSubckt = this.netlistReader.getSubckt(this.settings.clkBufferCell);
            this.err(this.clkbufSubckt == null, "Clock buffer cell" + this.settings.clkBufferCell + " not found in spice netlist");
            this.err(this.clkbufSubckt.getParamValue(this.settings.clkBufferCellStrengthParam) == null, "Strength param " + this.settings.clkBufferCellStrengthParam + " not found in clock buffer cell " + this.settings.clkBufferCell);
            this.err(!this.clkbufSubckt.hasPort(this.settings.clkBufferCellInputPort), "Input port " + this.settings.clkBufferCellInputPort + " not found in buffer cell " + this.settings.clkBufferCell);
            this.err(!this.clkbufSubckt.hasPort(this.settings.clkBufferCellOutputPort), "Output port " + this.settings.clkBufferCellOutputPort + " not found in buffer cell " + this.settings.clkBufferCell);
        }
        this.msg.println("   Netlist OK");
        for (Arc arc : this.timingArcs) {
            this.verifyPorts(this.topCell, this.dutSubckt, arc, this.netlistReader.getGlobalNets());
        }
        if (this.noTiming) {
            return;
        }
        for (Arc arc : this.timingArcs) {
            if (arc.clk == null) {
                this.runCombinational(arc);
                continue;
            }
            if (this.settings.simpleSequentialCharacterization) {
                this.runSequentialSimple(arc, delayType);
                continue;
            }
            this.runSequential(arc);
        }
    }

    private void writeHeader(PrintWriter out) {
        out.println(lineComment);
        out.println("* Date: " + new Date(System.currentTimeMillis()));
        out.println("* Written by Electric " + Version.getVersion());
        out.println(lineComment);
        out.println();
        this.writeCommentHeader("Spice Netlist");
        out.println(".include '" + this.inputFile + "'");
        out.println();
        this.writeCommentHeader("Options");
        out.println("* VDD = " + this.settings.vdd);
        out.println("* temp = " + this.settings.temp);
        out.println("* Input ramp time (ps) = " + this.settings.inputRampTimePS);
        out.println("* Sim resolution time (ps) = " + this.settings.simResolutionPS);
        out.println("* Sim duration (ps) = " + this.settings.simTimePS);
        out.println("* input low threshold (%) = " + this.settings.inputLow);
        out.println("* input high threshold (%) = " + this.settings.inputHigh);
        out.println("* input delay threshold (%) = " + this.settings.inputDelayThresh);
        out.println("* output low threshold (%) = " + this.settings.outputLow);
        out.println("* output high threshold (%) = " + this.settings.outputHigh);
        out.println("* output delay threshold (%) = " + this.settings.outputDelayThresh);
        out.println("* edge cap measure start (%) = " + this.settings.edgePercentForCapStart);
        out.println("* edge cap measure end (%) = " + this.settings.edgePercentForCapEnd);
        out.println("* setup time range min (ps) = " + this.settings.tmsetupMinGuessPS);
        out.println("* setup time range guess (ps) = " + this.settings.tmsetupGuessPS);
        out.println("* setup time range max (ps) = " + this.settings.tmsetupMaxGuessPS);
        out.println(lineComment);
        out.println();
        this.writeCommentHeader("Option statements");
        out.println(".option post");
        out.println(".option optlst=1");
        if (this.useAutoStop) {
            out.println(".option autostop");
        }
        out.println();
        this.writeCommentHeader("Power Supplies");
        out.println(".global vdd gnd");
        out.println(".param vsupply=" + this.settings.vdd);
        out.println(".temp " + this.settings.temp);
        out.println();
    }

    private void runCombinational(Arc arc) throws SCTimingException {
        TableData data;
        String arcDesc = arc.toString();
        String outputFileName = this.topCellName + "_delay_" + arcDesc;
        File outputFile = new File(this.outputDir, outputFileName + ".sp");
        this.msg.println();
        this.msg.println("--------------------------------------------------------");
        this.msg.println("Characterizing timing arc \"" + arcDesc + "\":");
        this.msg.println();
        this.msg.println("Writing spice netlist to");
        this.msg.println("   '" + outputFile.getPath() + "'...");
        try {
            this.out = new PrintWriter(new FileOutputStream(outputFile));
        }
        catch (FileNotFoundException e) {
            throw new SCTimingException(e.getMessage());
        }
        this.out.println("* " + arc.toString() + " *");
        this.writeHeader(this.out);
        this.out.println(lineComment);
        this.out.println("* Delay Arc");
        this.out.print("* ");
        this.out.println(arcDesc);
        this.out.println(lineComment);
        this.out.println();
        this.writeCommentHeader("Parameters");
        this.out.println(".param " + this.inbufStr + "=1");
        this.out.println(".param " + this.outloadStr + "=1");
        this.out.println(".param " + this.clkbufStr + "=1");
        this.out.println();
        this.writeCommentHeader("Test Bench");
        for (PinEdge in : arc.stableInputs) {
            this.writeVoltSource(in);
        }
        this.writeVoltSource(arc.input);
        this.writeBuffer(arc.input, this.bufferSubckt);
        this.out.println("Vcurrent_in " + arc.input.pin + " " + arc.input.pin + "_i 0");
        this.out.println("Vcurrent_out " + arc.output.pin + " " + arc.output.pin + "_i 0");
        this.out.print("Xdut ");
        for (String port : this.dutSubckt.getPorts()) {
            if (port.equalsIgnoreCase(arc.input.pin) || port.equalsIgnoreCase(arc.output.pin)) {
                this.out.print(port + "_i ");
                continue;
            }
            this.out.print(port + " ");
        }
        this.out.print(this.topCellName);
        this.out.println(" " + this.topCellParams);
        this.writeLoad(arc.output, this.loadSubckt);
        this.writeIC(arc.output);
        this.out.println();
        this.sweeps.clear();
        String outputLoads = this.settings.loadCellSweep;
        String inputBuffers = this.settings.bufferCellSweep;
        if (arc.getOutputLoadSweep() != null) {
            outputLoads = arc.getOutputLoadSweep();
        }
        if (arc.getInputBufferSweep() != null) {
            inputBuffers = arc.getInputBufferSweep();
        }
        this.sweeps.add(new SweepParam(this.inbufStr, inputBuffers));
        this.sweeps.add(new SweepParam(this.outloadStr, outputLoads, this.scaleLoadSweep));
        this.writeCommentHeader("Transient statement");
        this.out.println(".tran " + this.settings.simResolutionPS + "ps " + this.settings.simTimePS + "ps SWEEP DATA = DATA_TIM");
        this.out.println();
        this.writeSweepData();
        this.out.println();
        this.writeCommentHeader("Measure statements");
        String inputSlew = arc.input.pin + "_slew";
        String propDelay = "prop_delay";
        String outputSlew = arc.output.pin + "_slew";
        String inputCap = arc.input.pin + "_cap";
        String outputCap = arc.output.pin + "_cap";
        this.writeMeasDelay(propDelay, arc.input, arc.output);
        this.writeMeasSlew(inputSlew, arc.input, this.settings.inputLow, this.settings.inputHigh);
        this.writeMeasSlew(outputSlew, arc.output, this.settings.outputLow, this.settings.outputHigh);
        this.writeMeasCap(inputCap, arc.input, "Vcurrent_in");
        this.writeMeasCap(outputCap, arc.output, "Vcurrent_out");
        this.out.println();
        this.out.println(".END");
        this.out.close();
        this.msg.println("   Finished writing netlist.");
        this.runSpice(outputFileName, true);
        File mt0file = new File(this.outputDir, outputFileName + ".mt0");
        this.msg.println("Reading measurements file " + outputFileName + ".mt0...");
        arc.data = data = TableData.readSpiceMeasResults(mt0file.getPath());
        arc.data2d_inbuf_outload = data.getTable2D(this.inbufStr.toLowerCase(), this.outloadStr.toLowerCase(), null, null);
        if (this.verbose) {
            this.msg.println();
            this.msg.println("   Read data:");
            data.printData();
            if (arc.data2d_inbuf_outload != null) {
                arc.data2d_inbuf_outload.print();
            }
        }
        if (this.printStatistics) {
            this.msg.println();
            this.msg.println("Statistical checks:");
            this.msg.println("-------------------");
            this.msg.println();
            this.msg.println("Input slew should depend only on input buffer strength:");
            SCTiming.printRowMeanStdDev(arc.data2d_inbuf_outload, arc.input.pin + "_slew", this.msg, 1.0E12, "ps");
            this.msg.println();
            this.msg.println("Output capacitance should depend only on output load size");
            SCTiming.printColumnMeanStdDev(arc.data2d_inbuf_outload, arc.output.pin + "_cap", this.msg, 1.0E15, "fF");
            this.msg.println();
            this.msg.println("Input capacitance should not depend on either input buffer strength or output load:");
            SCTiming.printMeanStdDev(arc.data2d_inbuf_outload, arc.input.pin + "_cap", this.msg, 1.0E15, "fF");
        }
        this.msg.println();
        this.msg.println("Characterization of arc \"" + arc + "\" complete.");
    }

    private void runSequential(Arc arc) throws SCTimingException {
        String arcDesc = arc.toString();
        this.msg.println();
        this.msg.println("--------------------------------------------------------");
        this.msg.println("Characterizing timing arc \"" + arcDesc + "\":");
        this.msg.println();
        this.msg.println("Finding minimum setup, hold, and clk-to-Q time for \"" + arcDesc + "\"");
        String bufStrSweep = this.settings.bufferCellSweep;
        String loadStrSweep = this.settings.loadCellSweep;
        if (arc.getInputBufferSweep() != null) {
            bufStrSweep = arc.getInputBufferSweep();
        }
        if (arc.getOutputLoadSweep() != null) {
            loadStrSweep = arc.getOutputLoadSweep();
        }
        String[] bufStrs = bufStrSweep.trim().split("\\s+");
        String[] loadStrs = SCTiming.scaleSweep(loadStrSweep, this.scaleLoadSweep);
        String[] clkStrs = this.settings.clkBufferCellSweep.trim().split("\\s+");
        this.err(bufStrs.length == 0, "Buffer cell strength values empty");
        this.err(loadStrs.length == 0, "Load cell strength values empty");
        this.err(clkStrs.length == 0, "Clock buffer cell strength values empty");
        String fileName = this.topCellName + "_setup_" + arcDesc;
        String fileNameHold = this.topCellName + "_hold_" + arcDesc;
        int maxSpiceIterations = 30;
        TableData allData = null;
        boolean runHold = true;
        if (this.resetPin != null && arc.input.pin.equals(this.resetPin.name)) {
            runHold = false;
        }
        for (int c = 0; c < clkStrs.length; ++c) {
            for (int l = 0; l < loadStrs.length; ++l) {
                for (int b = 0; b < bufStrs.length; ++b) {
                    double tmsetupPS;
                    TableData data = this.runSetupTimeSpiceTest(fileName, arc, bufStrs[b], clkStrs[c], loadStrs[l], this.settings.tmsetupMinGuessPS, this.settings.tmsetupMaxGuessPS, this.settings.tmsetupGuessPS, this.verbose, maxSpiceIterations, 0);
                    double tmsetupValidminPS = data.getValue(0, this.setupTimeSweep);
                    this.err(Double.isNaN(tmsetupValidminPS), "Error running spice simulation to get minimum setup time");
                    tmsetupValidminPS *= 1.0E12;
                    tmsetupValidminPS += Math.abs(0.1 * tmsetupValidminPS);
                    if (this.verbose) {
                        this.msg.println();
                        this.msg.println("Bufstr=" + bufStrs[b] + ", Clkstr=" + clkStrs[c] + ", Loadstr=" + loadStrs[l]);
                        this.msg.println("Using minimum setup time of " + tmsetupValidminPS + "ps");
                        this.msg.println();
                    }
                    if ((tmsetupPS = this.settings.tmsetupGuessPS) < tmsetupValidminPS) {
                        tmsetupPS = tmsetupValidminPS;
                    }
                    data = this.runSetupTimeSpiceTest(fileName + "_1", arc, bufStrs[b], clkStrs[c], loadStrs[l], tmsetupValidminPS, this.settings.tmsetupMaxGuessPS, tmsetupPS, this.verbose, maxSpiceIterations, 1);
                    if (this.verbose) {
                        this.msg.println();
                        data.printData();
                        this.msg.println();
                    }
                    if (data.getNumRows() == maxSpiceIterations) {
                        throw new SCTimingException("Max number of iterations of optimization in spice reached, result may not be valid");
                    }
                    double tmholdValidMaxPS = 1.0E-12;
                    if (runHold) {
                        TableData dataHold = this.runHoldTimeSpiceTest(fileNameHold, arc, bufStrs[b], clkStrs[c], loadStrs[l], this.settings.tmsetupMinGuessPS, this.settings.tmsetupMaxGuessPS, this.settings.tmsetupGuessPS, this.verbose, maxSpiceIterations);
                        tmholdValidMaxPS = dataHold.getValue(0, this.holdTimeSweep);
                        this.err(Double.isNaN(tmholdValidMaxPS), "Error running spice simulation to get maximum hold time");
                        if (this.verbose) {
                            this.msg.println();
                            this.msg.println("Bufstr=" + bufStrs[b] + ", Clkstr=" + clkStrs[c] + ", Loadstr=" + loadStrs[l]);
                            this.msg.println("Hold time is " + tmholdValidMaxPS * 1.0E12 + "ps");
                            this.msg.println();
                        }
                    }
                    TableData latchClk2Q = null;
                    if (this.functionLatch != null) {
                        latchClk2Q = this.runLatchClk2QSpiceTest(fileName + "_q", arc, bufStrs[b], clkStrs[c], loadStrs[l], this.verbose);
                    }
                    if (allData == null) {
                        ArrayList<String> headers = new ArrayList<String>();
                        headers.add(this.inbufStr);
                        headers.add(this.clkbufStr);
                        headers.add(this.outloadStr);
                        headers.add(this.holdTimeName);
                        headers.addAll(data.getHeaders());
                        allData = new TableData(headers);
                    }
                    if (data.getNumRows() <= 0) continue;
                    double[] datarow = data.getRow(data.getNumRows() - 1);
                    double[] newrow = new double[datarow.length + 4];
                    newrow[0] = Double.parseDouble(bufStrs[b]);
                    newrow[1] = Double.parseDouble(clkStrs[c]);
                    newrow[2] = Double.parseDouble(loadStrs[l]);
                    newrow[3] = tmholdValidMaxPS;
                    for (int i = 4; i < newrow.length; ++i) {
                        newrow[i] = datarow[i - 4];
                    }
                    if (latchClk2Q != null) {
                        int cc = allData.getHeaders().indexOf("clk2q");
                        int cc2 = latchClk2Q.getHeaders().indexOf("clk2q");
                        newrow[cc] = latchClk2Q.getRow(latchClk2Q.getNumRows() - 1)[cc2];
                    }
                    allData.addRow(newrow);
                }
            }
        }
        this.msg.println();
        arc.data = allData;
        Table2D data2d = allData.getTable2D(this.inbufStr.toLowerCase(), this.outloadStr.toLowerCase(), null, null);
        Table2D data2d_clkbuf_outload = allData.getTable2D(this.clkbufStr.toLowerCase(), this.outloadStr.toLowerCase(), this.inbufStr.toLowerCase(), this.settings.bufferCellSweepExcludeFromAveraging);
        Table2D data2d_inbuf_clkbuf = allData.getTable2D(this.inbufStr.toLowerCase(), this.clkbufStr.toLowerCase(), this.outloadStr.toLowerCase(), this.settings.loadCellSweepExcludeFromAveraging);
        arc.data2d_inbuf_outload = data2d;
        arc.data2d_clkbuf_outload = data2d_clkbuf_outload;
        arc.data2d_inbuf_clkbuf = data2d_inbuf_clkbuf;
        if (this.verbose) {
            allData.printData();
            System.out.println("----------------------------------------------------------------------------");
            System.out.println("----------------------------------------------------------------------------");
            System.out.println("-------------------- Input Slew vs Output Load Table2D ---------------------");
            System.out.println("----------------------------------------------------------------------------");
            System.out.println("----------------------------------------------------------------------------");
            data2d.print();
            System.out.println("----------------------------------------------------------------------------");
            System.out.println("----------------------------------------------------------------------------");
            System.out.println("-------------------- Clock Slew vs Output Load Table2D ---------------------");
            System.out.println("----------------------------------------------------------------------------");
            System.out.println("----------------------------------------------------------------------------");
            data2d_clkbuf_outload.print();
            System.out.println("----------------------------------------------------------------------------");
            System.out.println("----------------------------------------------------------------------------");
            System.out.println("-------------------- Input Slew vs Clk Slew Table2D ------------------------");
            System.out.println("----------------------------------------------------------------------------");
            System.out.println("----------------------------------------------------------------------------");
            data2d_inbuf_clkbuf.print();
            this.msg.println();
        }
        if (this.printStatistics) {
            this.msg.println("Statistical checks:");
            this.msg.println("-------------------");
            this.msg.println();
            this.msg.println("Clock-to-Q should depend only on clock buffer and output load size:");
            SCTiming.print2DMeanStdDev(data2d_clkbuf_outload, this.clk2q, this.msg, 1.0E12, "ps");
            this.msg.println();
            this.msg.println("Setup time should depend only on input buffer strength and clock buffer strength:");
            SCTiming.print2DMeanStdDev(data2d_inbuf_clkbuf, this.setupTimeName, this.msg, 1.0E12, "ps");
            this.msg.println();
            this.msg.println("Input slew should depend only on input buffer strength:");
            SCTiming.printRowMeanStdDev(data2d, arc.input.pin + "_slew", this.msg, 1.0E12, "ps");
            this.msg.println();
            this.msg.println("Output capacitance should depend only on output load size");
            SCTiming.printColumnMeanStdDev(data2d, arc.output.pin + "_cap", this.msg, 1.0E15, "fF");
            this.msg.println();
            this.msg.println("Input capacitance should not be dependent on either input slew or output load");
            SCTiming.printMeanStdDev(data2d, arc.input.pin + "_cap", this.msg, 1.0E15, "fF");
            this.msg.println();
            this.msg.println("Hold time should depend only on input buffer strength and clock buffer strength:");
            SCTiming.print2DMeanStdDev(data2d_inbuf_clkbuf, this.holdTimeName, this.msg, 1.0E12, "ps");
            this.msg.println();
        }
        this.msg.println();
        this.msg.println("Characterization of arc \"" + arc + "\" complete.");
    }

    private TableData runSetupTimeSpiceTest(String outputFileName, Arc arc, String inputStr, String clkStr, String outputLoad, double tmsetupminPS, double tmsetupmaxPS, double tmsetupguessPS, boolean verbose, int maxSpiceIterations, int optphase) throws SCTimingException {
        String arcDesc = arc.toString();
        if (verbose) {
            this.msg.println();
            this.msg.println("Writing spice netlist to:");
            this.msg.println("   '" + outputFileName + ".sp'...");
            this.msg.println("   in directory: " + this.outputDir);
        }
        try {
            this.out = new PrintWriter(new FileOutputStream(new File(this.outputDir, outputFileName + ".sp")));
        }
        catch (FileNotFoundException e) {
            throw new SCTimingException(e.getMessage());
        }
        this.out.println("* " + arc.toString() + " *");
        this.writeHeader(this.out);
        this.out.println(lineComment);
        this.out.println("* Setup Time plus Clock-to-Q measurement");
        this.out.print("* ");
        this.out.println(arcDesc);
        this.out.println(lineComment);
        this.out.println();
        this.writeCommentHeader("Parameters");
        this.out.println(".param " + this.inbufStr + "=" + inputStr);
        this.out.println(".param " + this.outloadStr + "=" + outputLoad);
        this.out.println(".param " + this.clkbufStr + "=" + clkStr);
        this.out.println(".param " + this.setupTimeSweep + "=0ps");
        this.out.println();
        this.writeCommentHeader("Test Bench");
        for (PinEdge stable : arc.stableInputs) {
            this.writeVoltSource(stable);
        }
        this.writeBuffer(arc.input, this.bufferSubckt);
        this.writeClkBuffer(arc.clk, this.clkbufSubckt);
        this.writeVoltSource(arc.input);
        this.writeVoltSource(arc.clk, this.setupTimeSweep);
        if (arc.clkFalse != null) {
            this.writeClkBuffer(arc.clkFalse, this.clkbufSubckt);
            this.writeVoltSource(arc.clkFalse, this.setupTimeSweep);
        }
        this.out.println("Vcurrent_in " + arc.input.pin + " " + arc.input.pin + "_i 0");
        this.out.println("Vcurrent_out " + arc.output.pin + " " + arc.output.pin + "_i 0");
        this.out.println("Vcurrent_clk " + arc.clk.pin + " " + arc.clk.pin + "_i 0");
        this.out.print("Xdut ");
        for (String port : this.dutSubckt.getPorts()) {
            if (port.equalsIgnoreCase(arc.input.pin) || port.equalsIgnoreCase(arc.output.pin) || port.equalsIgnoreCase(arc.clk.pin)) {
                this.out.print(port + "_i ");
                continue;
            }
            this.out.print(port + " ");
        }
        this.out.print(this.topCellName);
        this.out.println(" " + this.topCellParams);
        this.writeLoad(arc.output, this.loadSubckt);
        this.writeIC(arc.output);
        for (PinEdge ic : arc.initialConditions) {
            this.writeIC(new PinEdge("Xdut." + ic.pin, ic.stableVoltage));
        }
        this.out.println();
        this.writeCommentHeader("Measure statements");
        String inputSlew = arc.input.pin + "_slew";
        String clkslew = arc.clk.pin + "_slew";
        String outputSlew = arc.output.pin + "_slew";
        String inputCap = arc.input.pin + "_cap";
        String clkCap = arc.clk.pin + "_cap";
        String outputCap = arc.output.pin + "_cap";
        this.writeMeasSlew(clkslew, arc.clk, this.settings.inputLow, this.settings.inputHigh);
        this.writeMeasSlew(inputSlew, arc.input, this.settings.inputLow, this.settings.inputHigh);
        this.writeMeasSlew(outputSlew, arc.output, this.settings.outputLow, this.settings.outputHigh);
        this.writeMeasCap(clkCap, arc.clk, "Vcurrent_clk");
        this.writeMeasCap(inputCap, arc.input, "Vcurrent_in");
        this.writeMeasCap(outputCap, arc.output, "Vcurrent_out");
        this.writeMeasDelay(this.clk2q, arc.clk, arc.output, "0");
        this.writeMeasDelay(this.setupTimeName, arc.input, arc.clk);
        this.out.println(".meas TRAN " + this.setupclk2q + " PARAM='" + this.clk2q + "+" + this.setupTimeName + "' goal=0");
        this.out.println();
        this.sweeps.clear();
        this.writeCommentHeader("Transient simulation");
        this.out.println("*.tran " + this.settings.simResolutionPS + "ps " + this.settings.simTimePS + "ps SWEEP " + this.setupTimeSweep + " LIN 20 " + tmsetupminPS + "ps " + tmsetupmaxPS + "ps");
        this.out.println(".param " + this.setupTimeSweep + "=optrange(" + tmsetupguessPS + "ps, " + tmsetupminPS + "ps, " + tmsetupmaxPS + "ps)");
        if (optphase == 0) {
            this.out.println(".model optmod OPT method=passfail");
            this.out.println(".tran " + this.settings.simResolutionPS + "ps " + this.settings.simTimePS + "ps SWEEP OPTIMIZE=optrange RESULTS=" + this.clk2q + " MODEL=optmod");
        } else {
            this.out.println(".model optmod OPT itropt=" + maxSpiceIterations + " relin=0.001 relout=0.001");
            this.out.println(".tran " + this.settings.simResolutionPS + "ps " + this.settings.simTimePS + "ps SWEEP OPTIMIZE=optrange RESULTS=" + this.setupclk2q + " MODEL=optmod");
        }
        this.out.println();
        this.out.println(".END");
        this.out.close();
        if (verbose) {
            this.msg.println("   Finished writing netlist.");
        }
        this.runSpice(outputFileName, verbose);
        File mt0file = new File(this.outputDir, outputFileName + ".mt0");
        if (verbose) {
            this.msg.println("Reading measurements file " + mt0file.getName() + "...");
        }
        return TableData.readSpiceMeasResults(mt0file.getPath());
    }

    private TableData runLatchClk2QSpiceTest(String outputFileName, Arc arc, String inputStr, String clkStr, String outputLoad, boolean verbose) throws SCTimingException {
        String arcDesc = arc.toString();
        if (verbose) {
            this.msg.println();
            this.msg.println("Writing spice netlist to:");
            this.msg.println("   '" + outputFileName + ".sp'...");
            this.msg.println("   in directory: " + this.outputDir);
        }
        try {
            this.out = new PrintWriter(new FileOutputStream(new File(this.outputDir, outputFileName + ".sp")));
        }
        catch (FileNotFoundException e) {
            throw new SCTimingException(e.getMessage());
        }
        this.out.println("* " + arc.toString() + " *");
        this.writeHeader(this.out);
        this.out.println(lineComment);
        this.out.println("* Latch Clock-to-Q measurement");
        this.out.print("* ");
        this.out.println(arcDesc);
        this.out.println(lineComment);
        this.out.println();
        this.writeCommentHeader("Parameters");
        this.out.println(".param " + this.inbufStr + "=" + inputStr);
        this.out.println(".param " + this.outloadStr + "=" + outputLoad);
        this.out.println(".param " + this.clkbufStr + "=" + clkStr);
        this.out.println(".param " + this.setupTimeSweep + "=0ps");
        this.out.println();
        this.writeCommentHeader("Test Bench");
        for (PinEdge stable : arc.stableInputs) {
            this.writeVoltSource(stable);
        }
        this.writeClkBuffer(arc.clk, this.clkbufSubckt);
        this.writeVoltSource(arc.input.getFinalState());
        this.writeVoltSource(arc.clk.getOpposite(), this.setupTimeSweep);
        if (arc.clkFalse != null) {
            this.writeClkBuffer(arc.clkFalse, this.clkbufSubckt);
            this.writeVoltSource(arc.clkFalse.getOpposite(), this.setupTimeSweep);
        }
        this.out.println("Vcurrent_in " + arc.input.pin + " " + arc.input.pin + "_i 0");
        this.out.println("Vcurrent_out " + arc.output.pin + " " + arc.output.pin + "_i 0");
        this.out.println("Vcurrent_clk " + arc.clk.pin + " " + arc.clk.pin + "_i 0");
        this.out.print("Xdut ");
        for (String port : this.dutSubckt.getPorts()) {
            if (port.equalsIgnoreCase(arc.input.pin) || port.equalsIgnoreCase(arc.output.pin) || port.equalsIgnoreCase(arc.clk.pin)) {
                this.out.print(port + "_i ");
                continue;
            }
            this.out.print(port + " ");
        }
        this.out.print(this.topCellName);
        this.out.println(" " + this.topCellParams);
        this.writeLoad(arc.output, this.loadSubckt);
        this.writeIC(arc.output);
        for (PinEdge ic : arc.initialConditions) {
            this.writeIC(new PinEdge("Xdut." + ic.pin, ic.stableVoltage));
        }
        this.out.println();
        this.writeCommentHeader("Measure statements");
        String inputSlew = arc.input.pin + "_slew";
        String clkslew = arc.clk.pin + "_slew";
        String outputSlew = arc.output.pin + "_slew";
        String inputCap = arc.input.pin + "_cap";
        String clkCap = arc.clk.pin + "_cap";
        String outputCap = arc.output.pin + "_cap";
        this.writeMeasSlew(clkslew, arc.clk, this.settings.inputLow, this.settings.inputHigh);
        this.writeMeasSlew(inputSlew, arc.input, this.settings.inputLow, this.settings.inputHigh);
        this.writeMeasSlew(outputSlew, arc.output, this.settings.outputLow, this.settings.outputHigh);
        this.writeMeasCap(clkCap, arc.clk, "Vcurrent_clk");
        this.writeMeasCap(inputCap, arc.input, "Vcurrent_in");
        this.writeMeasCap(outputCap, arc.output, "Vcurrent_out");
        this.writeMeasDelay(this.clk2q, arc.clk, arc.output, "0");
        this.writeMeasDelay(this.setupTimeName, arc.input, arc.clk);
        this.out.println(".meas TRAN " + this.setupclk2q + " PARAM='" + this.clk2q + "+" + this.setupTimeName + "' goal=0");
        this.out.println();
        this.sweeps.clear();
        this.writeCommentHeader("Transient simulation");
        this.out.println(".tran " + this.settings.simResolutionPS + "ps " + this.settings.simTimePS + "ps");
        this.out.println();
        this.out.println(".END");
        this.out.close();
        if (verbose) {
            this.msg.println("   Finished writing netlist.");
        }
        this.runSpice(outputFileName, verbose);
        File mt0file = new File(this.outputDir, outputFileName + ".mt0");
        if (verbose) {
            this.msg.println("Reading measurements file " + mt0file.getName() + "...");
        }
        return TableData.readSpiceMeasResults(mt0file.getPath());
    }

    private TableData runHoldTimeSpiceTest(String outputFileName, Arc arc, String inputStr, String clkStr, String outputLoad, double tmholdminPS, double tmholdmaxPS, double tmholdguessPS, boolean verbose, int maxSpiceIterations) throws SCTimingException {
        boolean optphase = false;
        String arcDesc = arc.toString();
        if (verbose) {
            this.msg.println();
            this.msg.println("Writing spice netlist to:");
            this.msg.println("   '" + outputFileName + ".sp'...");
            this.msg.println("   in directory: " + this.outputDir);
        }
        try {
            this.out = new PrintWriter(new FileOutputStream(new File(this.outputDir, outputFileName + ".sp")));
        }
        catch (FileNotFoundException e) {
            throw new SCTimingException(e.getMessage());
        }
        this.out.println("* " + arc.toString() + " *");
        this.writeHeader(this.out);
        this.out.println(lineComment);
        this.out.println("* Hold Time measurement");
        this.out.print("* ");
        this.out.println(arcDesc);
        this.out.println(lineComment);
        this.out.println();
        this.writeCommentHeader("Parameters");
        this.out.println(".param " + this.inbufStr + "=" + inputStr);
        this.out.println(".param " + this.outloadStr + "=" + outputLoad);
        this.out.println(".param " + this.clkbufStr + "=" + clkStr);
        this.out.println(".param " + this.holdTimeSweep + "=0ps");
        this.out.println();
        this.writeCommentHeader("Test Bench");
        for (PinEdge stable : arc.stableInputs) {
            this.writeVoltSource(stable);
        }
        this.writeBuffer(arc.input, this.bufferSubckt);
        this.writeClkBuffer(arc.clk, this.clkbufSubckt);
        this.writeVoltSource(arc.input, this.holdTimeSweep);
        this.writeVoltSource(arc.clk);
        if (arc.clkFalse != null) {
            this.writeClkBuffer(arc.clkFalse, this.clkbufSubckt);
            this.writeVoltSource(arc.clkFalse);
        }
        this.out.println("Vcurrent_in " + arc.input.pin + " " + arc.input.pin + "_i 0");
        this.out.println("Vcurrent_out " + arc.output.pin + " " + arc.output.pin + "_i 0");
        this.out.println("Vcurrent_clk " + arc.clk.pin + " " + arc.clk.pin + "_i 0");
        this.out.print("Xdut ");
        for (String port : this.dutSubckt.getPorts()) {
            if (port.equalsIgnoreCase(arc.input.pin) || port.equalsIgnoreCase(arc.output.pin) || port.equalsIgnoreCase(arc.clk.pin)) {
                this.out.print(port + "_i ");
                continue;
            }
            this.out.print(port + " ");
        }
        this.out.print(this.topCellName);
        this.out.println(" " + this.topCellParams);
        this.writeLoad(arc.output, this.loadSubckt);
        if (this.functionFlipFlop != null) {
            this.writeIC(arc.output.getOpposite());
            for (PinEdge ic : arc.initialConditions) {
                ic = ic.getOpposite();
                this.writeIC(new PinEdge("Xdut." + ic.pin, this.settings.vdd - ic.stableVoltage));
            }
        } else {
            this.writeIC(arc.output);
            for (PinEdge ic : arc.initialConditions) {
                this.writeIC(new PinEdge("Xdut." + ic.pin, ic.stableVoltage));
            }
        }
        this.out.println();
        this.writeCommentHeader("Measure statements");
        String inputSlew = arc.input.pin + "_slew";
        String clkslew = arc.clk.pin + "_slew";
        String outputSlew = arc.output.pin + "_slew";
        String inputCap = arc.input.pin + "_cap";
        String clkCap = arc.clk.pin + "_cap";
        String outputCap = arc.output.pin + "_cap";
        this.writeMeasSlew(clkslew, arc.clk, this.settings.inputLow, this.settings.inputHigh);
        this.writeMeasSlew(inputSlew, arc.input, this.settings.inputLow, this.settings.inputHigh);
        this.writeMeasSlew(outputSlew, arc.output.getOpposite(), this.settings.outputLow, this.settings.outputHigh);
        this.writeMeasCap(clkCap, arc.clk, "Vcurrent_clk");
        this.writeMeasCap(inputCap, arc.input, "Vcurrent_in");
        this.writeMeasCap(outputCap, arc.output.getOpposite(), "Vcurrent_out");
        this.writeMeasDelay(this.clk2q, arc.clk, arc.output.getOpposite(), "0");
        this.writeMeasDelay(this.holdTimeName, arc.clk, arc.input);
        this.out.println();
        this.sweeps.clear();
        this.writeCommentHeader("Transient simulation");
        this.out.println("*.tran " + this.settings.simResolutionPS + "ps " + this.settings.simTimePS + "ps SWEEP " + this.holdTimeSweep + " LIN 20 " + tmholdminPS + "ps " + tmholdmaxPS + "ps");
        this.out.println(".param " + this.holdTimeSweep + "=optrange(" + tmholdguessPS + "ps, " + tmholdminPS + "ps, " + tmholdmaxPS + "ps)");
        if (!optphase) {
            this.out.println(".model optmod OPT method=passfail");
            this.out.println(".tran " + this.settings.simResolutionPS + "ps " + this.settings.simTimePS + "ps SWEEP OPTIMIZE=optrange RESULTS=" + this.clk2q + " MODEL=optmod");
        } else {
            this.out.println(".model optmod OPT itropt=" + maxSpiceIterations + " relin=0.001 relout=0.001");
            this.out.println(".tran " + this.settings.simResolutionPS + "ps " + this.settings.simTimePS + "ps SWEEP OPTIMIZE=optrange RESULTS=" + this.setupclk2q + " MODEL=optmod");
        }
        this.out.println();
        this.out.println(".END");
        this.out.close();
        if (verbose) {
            this.msg.println("   Finished writing netlist.");
        }
        this.runSpice(outputFileName, verbose);
        File mt0file = new File(this.outputDir, outputFileName + ".mt0");
        if (verbose) {
            this.msg.println("Reading measurements file " + mt0file.getName() + "...");
        }
        return TableData.readSpiceMeasResults(mt0file.getPath());
    }

    private void runSequentialSimple(Arc arc, SCRunBase.DelayType delayType) throws SCTimingException {
        String arcDesc = arc.toString();
        this.msg.println();
        this.msg.println("--------------------------------------------------------");
        this.msg.println("Characterizing timing arc \"" + arcDesc + "\":");
        this.msg.println();
        this.msg.println("Finding setup, hold, and clk-to-Q time for \"" + arcDesc + "\"");
        String bufStrSweep = this.settings.bufferCellSweep;
        String loadStrSweep = this.settings.loadCellSweep;
        String loadStrSweepSetupHold = this.settings.loadCellSweepForSetupHold;
        String clkStrSweep = this.settings.clkBufferCellSweep;
        if (delayType == SCRunBase.DelayType.MIN) {
            bufStrSweep = this.settings.bufferCellSweepMinTime;
            loadStrSweep = this.settings.loadCellSweepMinTime;
            loadStrSweepSetupHold = this.settings.loadCellSweepForSetupHoldMinTime;
            clkStrSweep = this.settings.clkBufferCellSweepMinTime;
        }
        if (arc.getInputBufferSweep() != null) {
            bufStrSweep = arc.getInputBufferSweep();
        }
        if (arc.getOutputLoadSweep() != null) {
            loadStrSweep = arc.getOutputLoadSweep();
            loadStrSweepSetupHold = arc.getOutputLoadSweep();
        }
        String[] bufStrs = bufStrSweep.trim().split("\\s+");
        String[] loadStrs = SCTiming.scaleSweep(loadStrSweep, this.scaleLoadSweep);
        String[] loadStrsSetupHold = loadStrSweepSetupHold.trim().split("\\s+");
        String[] clkStrs = clkStrSweep.trim().split("\\s+");
        this.err(bufStrs.length == 0, "Buffer cell strength values empty");
        this.err(loadStrs.length == 0, "Load cell strength values empty");
        this.err(loadStrsSetupHold.length == 0, "Load cell strength values for Setup and Hold empty");
        this.err(clkStrs.length == 0, "Clock buffer cell strength values empty");
        String fileNameClk2q = this.topCellName + "_clk2q_" + arcDesc;
        String fileNameSetup = this.topCellName + "_setup_" + arcDesc;
        String fileNameHold = this.topCellName + "_hold_" + arcDesc;
        int maxSpiceIterations = 30;
        TableData setupHoldData = null;
        boolean runHold = true;
        if (this.resetPin != null && arc.input.pin.equals(this.resetPin.name)) {
            runHold = false;
        }
        TableData clk2qData = null;
        for (int c = 0; c < clkStrs.length; ++c) {
            TableData data = this.runSimpleClk2Q(fileNameClk2q, arc, clkStrs[c], loadStrSweep, this.settings.tmsetupMaxGuessPS, this.verbose);
            if (clk2qData == null) {
                ArrayList<String> headers = new ArrayList<String>();
                headers.add(this.clkbufStr);
                headers.add(this.outloadStr);
                headers.addAll(data.getHeaders());
                clk2qData = new TableData(headers);
            }
            for (int row = 0; row < data.getNumRows(); ++row) {
                double[] datarow = data.getRow(row);
                double[] newrow = new double[datarow.length + 2];
                newrow[0] = Double.parseDouble(clkStrs[c]);
                newrow[1] = Double.parseDouble(loadStrs[row]);
                for (int i = 2; i < newrow.length; ++i) {
                    newrow[i] = datarow[i - 2];
                }
                clk2qData.addRow(newrow);
            }
        }
        Table2D data2d_clkbuf_outload = clk2qData.getTable2D(this.clkbufStr.toLowerCase(), this.outloadStr.toLowerCase(), null, null);
        for (int c = 0; c < clkStrs.length; ++c) {
            for (int l = 0; l < loadStrsSetupHold.length; ++l) {
                for (int b = 0; b < bufStrs.length; ++b) {
                    TableData data = this.runSimpleSetupTimeSpiceTest(fileNameSetup, arc, bufStrs[b], clkStrs[c], loadStrsSetupHold[l], this.settings.tmsetupMinGuessPS, this.settings.tmsetupMaxGuessPS, this.settings.tmsetupGuessPS, this.verbose, maxSpiceIterations);
                    if (this.verbose) {
                        this.msg.println();
                        data.printData();
                        this.msg.println();
                    }
                    if (data.getNumRows() == maxSpiceIterations) {
                        throw new SCTimingException("Max number of iterations of optimization in spice reached, result may not be valid");
                    }
                    double tmholdValidMaxPS = 1.0E-12;
                    if (runHold) {
                        TableData dataHold = this.runHoldGlitchTimeSpiceTest(fileNameHold, arc, bufStrs[b], clkStrs[c], loadStrs[l], this.settings.tmsetupMinGuessPS, this.settings.tmsetupMaxGuessPS, this.settings.tmsetupGuessPS, this.verbose, maxSpiceIterations);
                        tmholdValidMaxPS = dataHold.getValue(0, this.holdTimeName);
                        this.err(Double.isNaN(tmholdValidMaxPS), "Error running spice simulation to get maximum hold time");
                        if (this.verbose) {
                            this.msg.println();
                            this.msg.println("Bufstr=" + bufStrs[b] + ", Clkstr=" + clkStrs[c] + ", Loadstr=" + loadStrs[l]);
                            this.msg.println("Hold time is " + tmholdValidMaxPS * 1.0E12 + "ps");
                            this.msg.println();
                        }
                    }
                    TableData latchClk2Q = null;
                    if (this.functionLatch != null) {
                        latchClk2Q = this.runLatchClk2QSpiceTest(fileNameSetup + "_q", arc, bufStrs[b], clkStrs[c], loadStrs[l], this.verbose);
                    }
                    if (setupHoldData == null) {
                        ArrayList<String> headers = new ArrayList<String>();
                        headers.add(this.inbufStr);
                        headers.add(this.clkbufStr);
                        headers.add(this.outloadStr);
                        headers.add(this.holdTimeName);
                        headers.addAll(data.getHeaders());
                        setupHoldData = new TableData(headers);
                    }
                    if (data.getNumRows() <= 0) continue;
                    double[] datarow = data.getRow(data.getNumRows() - 1);
                    double[] newrow = new double[datarow.length + 4];
                    newrow[0] = Double.parseDouble(bufStrs[b]);
                    newrow[1] = Double.parseDouble(clkStrs[c]);
                    newrow[2] = Double.parseDouble(loadStrs[l]);
                    newrow[3] = tmholdValidMaxPS;
                    for (int i = 4; i < newrow.length; ++i) {
                        newrow[i] = datarow[i - 4];
                    }
                    if (latchClk2Q != null) {
                        int cc = setupHoldData.getHeaders().indexOf("clk2q");
                        int cc2 = latchClk2Q.getHeaders().indexOf("clk2q");
                        newrow[cc] = latchClk2Q.getRow(latchClk2Q.getNumRows() - 1)[cc2];
                    }
                    setupHoldData.addRow(newrow);
                }
            }
        }
        this.msg.println();
        arc.data = setupHoldData;
        Table2D data2d_inbuf_clkbuf = setupHoldData.getTable2D(this.inbufStr.toLowerCase(), this.clkbufStr.toLowerCase(), null, null);
        arc.data2d_inbuf_outload = null;
        arc.data2d_clkbuf_outload = data2d_clkbuf_outload;
        arc.data2d_inbuf_clkbuf = data2d_inbuf_clkbuf;
        if (this.verbose) {
            clk2qData.printData();
            setupHoldData.printData();
            System.out.println("----------------------------------------------------------------------------");
            System.out.println("----------------------------------------------------------------------------");
            System.out.println("-------------------- Clock Slew vs Output Load Table2D ---------------------");
            System.out.println("----------------------------------------------------------------------------");
            System.out.println("----------------------------------------------------------------------------");
            data2d_clkbuf_outload.print();
            System.out.println("----------------------------------------------------------------------------");
            System.out.println("----------------------------------------------------------------------------");
            System.out.println("-------------------- Input Slew vs Clk Slew Table2D ------------------------");
            System.out.println("----------------------------------------------------------------------------");
            System.out.println("----------------------------------------------------------------------------");
            data2d_inbuf_clkbuf.print();
            this.msg.println();
        }
        if (this.printStatistics) {
            this.msg.println("Statistical checks:");
            this.msg.println("-------------------");
            this.msg.println();
            this.msg.println("Clock-to-Q should depend only on clock buffer and output load size:");
            SCTiming.print2DMeanStdDev(data2d_clkbuf_outload, this.clk2q, this.msg, 1.0E12, "ps");
            this.msg.println();
            this.msg.println("Pushed-out Clock-to-Q should depend only on clock buffer and output load size:");
            SCTiming.printColumnMeanStdDev(data2d_inbuf_clkbuf, this.clk2q, this.msg, 1.0E12, "ps");
            this.msg.println();
            this.msg.println("Setup time should depend only on input buffer strength and clock buffer strength:");
            SCTiming.print2DMeanStdDev(data2d_inbuf_clkbuf, this.setupTimeName, this.msg, 1.0E12, "ps");
            this.msg.println();
            this.msg.println("Input slew should depend only on input buffer strength:");
            SCTiming.printRowMeanStdDev(data2d_inbuf_clkbuf, arc.input.pin + "_slew", this.msg, 1.0E12, "ps");
            this.msg.println();
            this.msg.println("Output capacitance should depend only on output load size");
            SCTiming.printColumnMeanStdDev(data2d_clkbuf_outload, arc.output.pin + "_cap", this.msg, 1.0E15, "fF");
            this.msg.println();
            this.msg.println("Input capacitance should not be dependent on either input slew or output load");
            SCTiming.printMeanStdDev(data2d_inbuf_clkbuf, arc.input.pin + "_cap", this.msg, 1.0E15, "fF");
            this.msg.println();
            this.msg.println("Hold time should depend only on input buffer strength and clock buffer strength:");
            SCTiming.print2DMeanStdDev(data2d_inbuf_clkbuf, this.holdTimeName, this.msg, 1.0E12, "ps");
            this.msg.println();
        }
        this.msg.println();
        this.msg.println("Characterization of arc \"" + arc + "\" complete.");
    }

    private TableData runSimpleClk2Q(String outputFileName, Arc arc, String clkStr, String outputLoadSweep, double clkPulseTime, boolean verbose) throws SCTimingException {
        String[] loads = outputLoadSweep.split("\\s+");
        if (loads.length == 0) {
            throw new SCTimingException("No output load sweep in runSimpleClk2q");
        }
        String arcDesc = arc.toString();
        if (verbose) {
            this.msg.println();
            this.msg.println("Writing spice netlist to:");
            this.msg.println("   '" + outputFileName + ".sp'...");
            this.msg.println("   in directory: " + this.outputDir);
        }
        try {
            this.out = new PrintWriter(new FileOutputStream(new File(this.outputDir, outputFileName + ".sp")));
        }
        catch (FileNotFoundException e) {
            throw new SCTimingException(e.getMessage());
        }
        this.out.println("* " + arc.toString() + " *");
        this.writeHeader(this.out);
        this.out.println(lineComment);
        this.out.println("* Clock-to-Q measurement");
        this.out.print("* ");
        this.out.println(arcDesc);
        this.out.println(lineComment);
        this.out.println();
        this.writeCommentHeader("Parameters");
        this.out.println(".param " + this.outloadStr + "=" + loads[0]);
        this.out.println(".param " + this.clkbufStr + "=" + clkStr);
        this.out.println(".param " + this.setupTimeSweep + "=" + clkPulseTime + "ps");
        this.out.println();
        this.writeCommentHeader("Test Bench");
        for (PinEdge stable : arc.stableInputs) {
            this.writeVoltSource(stable);
        }
        this.writeClkBuffer(arc.clk, this.clkbufSubckt);
        this.writeVoltSource(arc.input.getFinalState());
        this.writeVoltSource(arc.clk, this.setupTimeSweep);
        if (arc.clkFalse != null) {
            this.writeClkBuffer(arc.clkFalse, this.clkbufSubckt);
            this.writeVoltSource(arc.clkFalse, this.setupTimeSweep);
        }
        this.out.println("Vcurrent_in " + arc.input.pin + " " + arc.input.pin + "_i 0");
        this.out.println("Vcurrent_out " + arc.output.pin + " " + arc.output.pin + "_i 0");
        this.out.println("Vcurrent_clk " + arc.clk.pin + " " + arc.clk.pin + "_i 0");
        this.out.print("Xdut ");
        for (String port : this.dutSubckt.getPorts()) {
            if (port.equalsIgnoreCase(arc.input.pin) || port.equalsIgnoreCase(arc.output.pin) || port.equalsIgnoreCase(arc.clk.pin)) {
                this.out.print(port + "_i ");
                continue;
            }
            this.out.print(port + " ");
        }
        this.out.print(this.topCellName);
        this.out.println(" " + this.topCellParams);
        this.writeLoad(arc.output, this.loadSubckt);
        this.writeIC(arc.output);
        for (PinEdge ic : arc.initialConditions) {
            this.writeIC(new PinEdge("Xdut." + ic.pin, ic.stableVoltage));
        }
        this.out.println();
        this.writeCommentHeader("Measure statements");
        String clkslew = arc.clk.pin + "_slew";
        String outputSlew = arc.output.pin + "_slew";
        String clkCap = arc.clk.pin + "_cap";
        String outputCap = arc.output.pin + "_cap";
        this.writeMeasSlew(clkslew, arc.clk, this.settings.inputLow, this.settings.inputHigh);
        this.writeMeasSlew(outputSlew, arc.output, this.settings.outputLow, this.settings.outputHigh);
        this.writeMeasCap(clkCap, arc.clk, "Vcurrent_clk");
        this.writeMeasCap(outputCap, arc.output, "Vcurrent_out");
        this.writeMeasDelay(this.clk2q, arc.clk, arc.output, "0");
        this.out.println();
        this.sweeps.clear();
        this.writeCommentHeader("Transient simulation");
        this.out.println(".tran " + this.settings.simResolutionPS + "ps " + this.settings.simTimePS + "ps SWEEP " + this.outloadStr + " POI " + loads.length + " " + outputLoadSweep);
        this.out.println();
        this.out.println(".END");
        this.out.close();
        if (verbose) {
            this.msg.println("   Finished writing netlist.");
        }
        this.runSpice(outputFileName, verbose);
        File mt0file = new File(this.outputDir, outputFileName + ".mt0");
        if (verbose) {
            this.msg.println("Reading measurements file " + mt0file.getName() + "...");
        }
        return TableData.readSpiceMeasResults(mt0file.getPath());
    }

    private TableData runSimpleSetupTimeSpiceTest(String outputFileName, Arc arc, String inputStr, String clkStr, String outputLoad, double tmsetupminPS, double tmsetupmaxPS, double tmsetupguessPS, boolean verbose, int maxSpiceIterations) throws SCTimingException {
        String arcDesc = arc.toString();
        if (verbose) {
            this.msg.println();
            this.msg.println("Writing spice netlist to:");
            this.msg.println("   '" + outputFileName + ".sp'...");
            this.msg.println("   in directory: " + this.outputDir);
        }
        try {
            this.out = new PrintWriter(new FileOutputStream(new File(this.outputDir, outputFileName + ".sp")));
        }
        catch (FileNotFoundException e) {
            throw new SCTimingException(e.getMessage());
        }
        this.out.println("* " + arc.toString() + " *");
        this.writeHeader(this.out);
        this.out.println(lineComment);
        this.out.println("* Setup Time plus Clock-to-Q measurement");
        this.out.print("* ");
        this.out.println(arcDesc);
        this.out.println(lineComment);
        this.out.println();
        this.writeCommentHeader("Parameters");
        this.out.println(".param " + this.inbufStr + "=" + inputStr);
        this.out.println(".param " + this.outloadStr + "=" + outputLoad);
        this.out.println(".param " + this.clkbufStr + "=" + clkStr);
        this.out.println(".param " + this.setupTimeSweep + "=0ps");
        this.out.println();
        this.writeCommentHeader("Test Bench");
        for (PinEdge stable : arc.stableInputs) {
            this.writeVoltSource(stable);
        }
        this.writeBuffer(arc.input, this.bufferSubckt);
        this.writeClkBuffer(arc.clk, this.clkbufSubckt);
        this.writeVoltSource(arc.input, this.setupTimeSweep);
        this.writeVoltSource(arc.clk);
        if (arc.clkFalse != null) {
            this.writeClkBuffer(arc.clkFalse, this.clkbufSubckt);
            this.writeVoltSource(arc.clkFalse);
        }
        this.out.println("Vcurrent_in " + arc.input.pin + " " + arc.input.pin + "_i 0");
        this.out.println("Vcurrent_out " + arc.output.pin + " " + arc.output.pin + "_i 0");
        this.out.println("Vcurrent_clk " + arc.clk.pin + " " + arc.clk.pin + "_i 0");
        this.out.print("Xdut ");
        for (String port : this.dutSubckt.getPorts()) {
            if (port.equalsIgnoreCase(arc.input.pin) || port.equalsIgnoreCase(arc.output.pin) || port.equalsIgnoreCase(arc.clk.pin)) {
                this.out.print(port + "_i ");
                continue;
            }
            this.out.print(port + " ");
        }
        this.out.print(this.topCellName);
        this.out.println(" " + this.topCellParams);
        this.writeLoad(arc.output, this.loadSubckt);
        this.writeIC(arc.output);
        for (PinEdge ic : arc.initialConditions) {
            this.writeIC(new PinEdge("Xdut." + ic.pin, ic.stableVoltage));
        }
        this.out.println();
        this.writeCommentHeader("Measure statements");
        String inputSlew = arc.input.pin + "_slew";
        String clkslew = arc.clk.pin + "_slew";
        String outputSlew = arc.output.pin + "_slew";
        String inputCap = arc.input.pin + "_cap";
        String clkCap = arc.clk.pin + "_cap";
        String outputCap = arc.output.pin + "_cap";
        String pushout = "pushout";
        this.writeMeasSlew(clkslew, arc.clk, this.settings.inputLow, this.settings.inputHigh);
        this.writeMeasSlew(inputSlew, arc.input, this.settings.inputLow, this.settings.inputHigh);
        this.writeMeasSlew(outputSlew, arc.output, this.settings.outputLow, this.settings.outputHigh);
        this.writeMeasCap(clkCap, arc.clk, "Vcurrent_clk");
        this.writeMeasCap(inputCap, arc.input, "Vcurrent_in");
        this.writeMeasCap(outputCap, arc.output, "Vcurrent_out");
        this.writeMeasDelay(this.clk2q, arc.clk, arc.output);
        this.writeMeasDelay(this.setupTimeName, arc.input, arc.clk);
        this.writeMeasPushout(pushout, arc.output, this.settings.clk2qpushout);
        this.out.println();
        this.sweeps.clear();
        this.writeCommentHeader("Transient simulation");
        this.out.println("*.tran " + this.settings.simResolutionPS + "ps " + this.settings.simTimePS + "ps SWEEP " + this.setupTimeSweep + " LIN 20 " + tmsetupminPS + "ps " + tmsetupmaxPS + "ps");
        this.out.println(".param " + this.setupTimeSweep + "=optrange(" + tmsetupguessPS + "ps, " + tmsetupminPS + "ps, " + tmsetupmaxPS + "ps)");
        this.out.println(".model optmod OPT method=passfail itropt=" + maxSpiceIterations + " relin=0.0001 relout=0.001");
        this.out.println(".tran " + this.settings.simResolutionPS + "ps " + this.settings.simTimePS + "ps SWEEP OPTIMIZE=optrange RESULTS=" + pushout + " MODEL=optmod");
        this.out.println();
        this.out.println(".END");
        this.out.close();
        if (verbose) {
            this.msg.println("   Finished writing netlist.");
        }
        this.runSpice(outputFileName, verbose);
        File mt0file = new File(this.outputDir, outputFileName + ".mt0");
        if (verbose) {
            this.msg.println("Reading measurements file " + mt0file.getName() + "...");
        }
        return TableData.readSpiceMeasResults(mt0file.getPath());
    }

    private TableData runHoldGlitchTimeSpiceTest(String outputFileName, Arc arc, String inputStr, String clkStr, String outputLoad, double tmholdminPS, double tmholdmaxPS, double tmholdguessPS, boolean verbose, int maxSpiceIterations) throws SCTimingException {
        boolean optphase = false;
        String arcDesc = arc.toString();
        if (verbose) {
            this.msg.println();
            this.msg.println("Writing spice netlist to:");
            this.msg.println("   '" + outputFileName + ".sp'...");
            this.msg.println("   in directory: " + this.outputDir);
        }
        try {
            this.out = new PrintWriter(new FileOutputStream(new File(this.outputDir, outputFileName + ".sp")));
        }
        catch (FileNotFoundException e) {
            throw new SCTimingException(e.getMessage());
        }
        this.out.println("* " + arc.toString() + " *");
        this.writeHeader(this.out);
        this.out.println(lineComment);
        this.out.println("* Hold Time measurement");
        this.out.print("* ");
        this.out.println(arcDesc);
        this.out.println(lineComment);
        this.out.println();
        this.writeCommentHeader("Parameters");
        this.out.println(".param " + this.inbufStr + "=" + inputStr);
        this.out.println(".param " + this.outloadStr + "=" + outputLoad);
        this.out.println(".param " + this.clkbufStr + "=" + clkStr);
        this.out.println(".param " + this.holdTimeSweep + "=0ps");
        this.out.println();
        this.writeCommentHeader("Test Bench");
        for (PinEdge stable : arc.stableInputs) {
            this.writeVoltSource(stable);
        }
        this.writeBuffer(arc.input, this.bufferSubckt);
        this.writeClkBuffer(arc.clk, this.clkbufSubckt);
        this.writeVoltSource(arc.input, this.holdTimeSweep);
        this.writeVoltSource(arc.clk);
        if (arc.clkFalse != null) {
            this.writeClkBuffer(arc.clkFalse, this.clkbufSubckt);
            this.writeVoltSource(arc.clkFalse);
        }
        this.out.println("Vcurrent_in " + arc.input.pin + " " + arc.input.pin + "_i 0");
        this.out.println("Vcurrent_out " + arc.output.pin + " " + arc.output.pin + "_i 0");
        this.out.println("Vcurrent_clk " + arc.clk.pin + " " + arc.clk.pin + "_i 0");
        this.out.print("Xdut ");
        for (String port : this.dutSubckt.getPorts()) {
            if (port.equalsIgnoreCase(arc.input.pin) || port.equalsIgnoreCase(arc.output.pin) || port.equalsIgnoreCase(arc.clk.pin)) {
                this.out.print(port + "_i ");
                continue;
            }
            this.out.print(port + " ");
        }
        this.out.print(this.topCellName);
        this.out.println(" " + this.topCellParams);
        this.writeLoad(arc.output, this.loadSubckt);
        this.writeIC(new PinEdge("Xdut." + arc.glitchNode.pin, arc.glitchNode.getInitialState().transition));
        this.out.println();
        this.writeCommentHeader("Measure statements");
        String inputSlew = arc.input.pin + "_slew";
        String clkslew = arc.clk.pin + "_slew";
        String outputSlew = arc.output.pin + "_slew";
        String inputCap = arc.input.pin + "_cap";
        String clkCap = arc.clk.pin + "_cap";
        String outputCap = arc.output.pin + "_cap";
        String glitch = "glitch";
        this.writeMeasSlew(clkslew, arc.clk, this.settings.inputLow, this.settings.inputHigh);
        this.writeMeasSlew(inputSlew, arc.input, this.settings.inputLow, this.settings.inputHigh);
        this.writeMeasSlew(outputSlew, arc.output.getOpposite(), this.settings.outputLow, this.settings.outputHigh);
        this.writeMeasCap(clkCap, arc.clk, "Vcurrent_clk");
        this.writeMeasCap(inputCap, arc.input, "Vcurrent_in");
        this.writeMeasCap(outputCap, arc.output.getOpposite(), "Vcurrent_out");
        this.writeMeasDelay(this.clk2q, arc.clk, arc.output, "0");
        this.writeMeasDelay(this.holdTimeName, arc.clk, arc.input);
        this.writeMeasGlitch(glitch, arc.glitchNode);
        this.out.println();
        this.sweeps.clear();
        this.writeCommentHeader("Transient simulation");
        this.out.println("*.tran " + this.settings.simResolutionPS + "ps " + this.settings.simTimePS + "ps SWEEP " + this.holdTimeSweep + " LIN 20 " + tmholdminPS + "ps " + tmholdmaxPS + "ps");
        this.out.println(".param " + this.holdTimeSweep + "=optrange(" + tmholdguessPS + "ps, " + tmholdminPS + "ps, " + tmholdmaxPS + "ps)");
        this.out.println(".model optmod OPT method=passfail itropt=" + maxSpiceIterations + " relin=0.0001 relout=0.001");
        this.out.println(".tran " + this.settings.simResolutionPS + "ps " + this.settings.simTimePS + "ps SWEEP OPTIMIZE=optrange RESULTS=" + glitch + " MODEL=optmod");
        this.out.println();
        this.out.println(".END");
        this.out.close();
        if (verbose) {
            this.msg.println("   Finished writing netlist.");
        }
        this.runSpice(outputFileName, verbose);
        File mt0file = new File(this.outputDir, outputFileName + ".mt0");
        if (verbose) {
            this.msg.println("Reading measurements file " + mt0file.getName() + "...");
        }
        return TableData.readSpiceMeasResults(mt0file.getPath());
    }

    private void runSpice(String outputFileName, boolean verbose) throws SCTimingException {
        String command = this.settings.simulator + " " + outputFileName + ".sp";
        if (verbose) {
            this.msg.println();
            this.msg.println("Running spice: " + command);
            this.msg.println("   In directory " + this.outputDir);
            this.msg.println("   Logging output to " + outputFileName + ".out");
            this.msg.println("   " + new Date(System.currentTimeMillis()));
            this.msg.println();
        }
        this.msg.flush();
        BufferedOutputStream outlog = null;
        try {
            outlog = new BufferedOutputStream(new FileOutputStream(new File(this.outputDir, outputFileName + ".out")));
        }
        catch (FileNotFoundException e) {
            throw new SCTimingException(e.getMessage());
        }
        SpiceResultChecker checker = new SpiceResultChecker(verbose ? System.out : null);
        Exec exec2 = new Exec(command, null, new File(this.outputDir), (OutputStream)outlog, (OutputStream)checker);
        exec2.run();
        try {
            ((OutputStream)outlog).close();
        }
        catch (IOException e) {
            throw new SCTimingException(e.getMessage());
        }
        if (exec2.getExitVal() != 0 || checker.getFailed()) {
            this.msg.println();
            this.msg.println("Spice job Aborted");
            this.msg.println("   " + new Date(System.currentTimeMillis()));
            throw new SCTimingException("Spice run failed, please check output file");
        }
        if (verbose) {
            this.msg.println();
            this.msg.println("Spice job completed");
            this.msg.println("   " + new Date(System.currentTimeMillis()));
            this.msg.println();
        }
    }

    private void writeCommentHeader(String msg) {
        this.out.println(lineComment);
        this.out.print("* ");
        this.out.println(msg);
        this.out.println(lineComment);
    }

    private void writeVoltSource(PinEdge edge) {
        this.writeVoltSource(edge, null);
    }

    private void writeVoltSource(PinEdge edge, String timeStartParam) {
        int numPeriods = 1;
        double vhigh = this.settings.vdd;
        double vlow = 0.0;
        switch (edge.transition) {
            case STABLE0: {
                this.out.println("V" + edge.pin + " " + edge.pin + " gnd 0");
                break;
            }
            case STABLE1: {
                this.out.println("V" + edge.pin + " " + edge.pin + " gnd vsupply");
                break;
            }
            case STABLEV: {
                this.out.println("V" + edge.pin + " " + edge.pin + " gnd " + edge.stableVoltage);
                break;
            }
            case RISE: {
                double temp = vlow;
                vlow = vhigh;
                vhigh = temp;
            }
            case FALL: {
                this.out.println("V" + edge.pin + "_pre " + edge.pin + "_pre gnd ");
                this.out.print("+  PWL ");
                this.out.print("0.0 " + vhigh + " ");
                double timeStart = this.settings.timeStartPS;
                if (timeStart + this.settings.tmsetupMinGuessPS < 0.0) {
                    timeStart = -1.0 * this.settings.tmsetupMinGuessPS;
                }
                for (int i = 0; i < numPeriods; ++i) {
                    double t = timeStart + (double)i * this.settings.periodPS;
                    if (timeStartParam != null) {
                        this.out.print("'" + timeStartParam + "+" + t + "ps' " + vhigh + " ");
                        this.out.print("'" + timeStartParam + "+" + (t + this.settings.inputRampTimePS) + "ps' " + vlow + " ");
                        continue;
                    }
                    this.out.print(t + "ps " + vhigh + " ");
                    this.out.print(t + this.settings.inputRampTimePS + "ps " + vlow + " ");
                }
                this.out.print(this.settings.periodPS * (double)numPeriods + this.settings.simTimePS + "ps " + vlow);
                this.out.println();
                break;
            }
        }
    }

    private void writeIC(PinEdge edge) {
        this.out.print(".ic V(" + edge.pin + ") = ");
        switch (edge.transition) {
            case STABLE0: 
            case RISE: {
                this.out.println(0);
                break;
            }
            case STABLE1: 
            case FALL: {
                this.out.println("vsupply");
                break;
            }
            case STABLEV: {
                this.out.println(edge.stableVoltage);
            }
        }
    }

    private void writeBuffer(PinEdge edge, SpiceSubckt bufferSubckt) {
        if (SCTiming.isStable(edge.transition)) {
            return;
        }
        this.out.print("Xbuf" + edge.pin);
        this.out.print(" ");
        for (String port : bufferSubckt.getPorts()) {
            if (port.equalsIgnoreCase(this.settings.bufferCellInputPort)) {
                this.out.print(edge.pin + "_pre ");
                continue;
            }
            if (port.equalsIgnoreCase(this.settings.bufferCellOutputPort)) {
                this.out.print(edge.pin + " ");
                continue;
            }
            this.out.print("0 ");
        }
        this.out.print(this.settings.bufferCell + " ");
        this.out.println(this.settings.bufferCellStrengthParam + "=" + this.inbufStr);
    }

    private void writeClkBuffer(PinEdge edge, SpiceSubckt clkbufSubckt) {
        if (SCTiming.isStable(edge.transition)) {
            return;
        }
        this.out.print("Xbuf" + edge.pin);
        this.out.print(" ");
        for (String port : clkbufSubckt.getPorts()) {
            if (port.equalsIgnoreCase(this.settings.clkBufferCellInputPort)) {
                this.out.print(edge.pin + "_pre ");
                continue;
            }
            if (port.equalsIgnoreCase(this.settings.clkBufferCellOutputPort)) {
                this.out.print(edge.pin + " ");
                continue;
            }
            this.out.print("0 ");
        }
        this.out.print(this.settings.clkBufferCell + " ");
        this.out.println(this.settings.clkBufferCellStrengthParam + "=" + this.clkbufStr);
    }

    private void writeLoad(PinEdge edge, SpiceSubckt loadSubckt) {
        this.out.print("Xload ");
        for (String port : loadSubckt.getPorts()) {
            if (port.equalsIgnoreCase(this.settings.loadCellPort)) {
                this.out.print(edge.pin + " ");
                continue;
            }
            this.out.print("0 ");
        }
        this.out.print(this.settings.loadCell + " ");
        this.out.println(this.settings.loadCellStrengthParam + "=" + this.outloadStr);
    }

    private void writeSweepData() {
        this.out.println(".DATA DATA_TIM");
        Stack<String> pvals = new Stack<String>();
        this.out.print("+");
        for (int i = 0; i < this.sweeps.size(); ++i) {
            SweepParam sp2 = this.sweeps.get(i);
            this.out.print(" " + sp2.param);
        }
        this.out.println();
        this.iterateList(this.sweeps, 0, pvals);
        this.out.println(".ENDDATA");
    }

    private void iterateList(List<SweepParam> list, int index, Stack<String> stack) {
        if (index >= list.size()) {
            index = 0;
        }
        SweepParam sp2 = list.get(index);
        for (int i = 0; i < sp2.sweep.length; ++i) {
            stack.push(sp2.sweep[i]);
            if (list.size() - 1 == index) {
                this.out.print("+ ");
                for (String s2 : stack) {
                    this.out.print(s2 + " ");
                }
                this.out.println();
            } else {
                this.iterateList(list, index + 1, stack);
            }
            stack.pop();
        }
    }

    private void writeMeasDelay(String measname, PinEdge in, PinEdge output) {
        this.writeMeasDelay(measname, in, output, null);
    }

    private void writeMeasDelay(String measname, PinEdge in, PinEdge output, String goal) {
        if (SCTiming.isStable(in.transition)) {
            return;
        }
        this.out.println(".meas TRAN " + measname);
        this.out.println("+  TRIG V(" + in.pin + ") VAL='" + this.settings.inputDelayThresh + "*vsupply' CROSS=1");
        this.out.println("+  TARG V(" + output.pin + ") VAL='" + this.settings.outputDelayThresh + "*vsupply' CROSS=1");
        if (goal != null) {
            this.out.println("+  goal=" + goal);
        }
    }

    private void writeMeasSlew(String measname, PinEdge edge, double low, double high) {
        if (SCTiming.isStable(edge.transition)) {
            return;
        }
        double start = low;
        double end = high;
        if (edge.transition == PinEdge.Transition.FALL) {
            start = high;
            end = low;
        }
        this.out.println(".meas TRAN " + measname);
        this.out.println("+  TRIG V(" + edge.pin + ") VAL='" + start + "*vsupply' CROSS=1");
        this.out.println("+  TARG V(" + edge.pin + ") VAL='" + end + "*vsupply' CROSS=1");
    }

    private void writeMeasCap(String measname, PinEdge edge, String voltageSource) {
        if (SCTiming.isStable(edge.transition)) {
            return;
        }
        double start = this.settings.edgePercentForCapStart;
        double end = this.settings.edgePercentForCapEnd;
        if (edge.transition == PinEdge.Transition.FALL) {
            start = 1.0 - this.settings.edgePercentForCapStart;
            end = 1.0 - this.settings.edgePercentForCapEnd;
        }
        String vstart = measname + "vstart";
        String vend = measname + "vend";
        String tstart = measname + "tstart";
        String tend = measname + "tend";
        this.out.println(".param " + vstart + "='" + start + "*vsupply'");
        this.out.println(".param " + vend + "='" + end + "*vsupply'");
        this.out.println(".meas TRAN " + tstart + " WHEN V(" + edge.pin + ") = '" + vstart + "'");
        this.out.println(".meas TRAN " + tend + " WHEN V(" + edge.pin + ") = '" + vend + "'");
        this.out.println(".meas TRAN " + measname + "_avgi");
        this.out.println("+  AVG i(" + voltageSource + ") FROM='" + tstart + "' TO='" + tend + "'");
        this.out.println(".meas TRAN " + measname);
        this.out.println("+  PARAM='abs(" + measname + "_avgi*(" + tend + "-" + tstart + ")/(" + vend + "-" + vstart + "))'");
    }

    private void writeMeasPushout(String measname, PinEdge edge, double pushoutPS) {
        if (SCTiming.isStable(edge.transition)) {
            return;
        }
        this.out.println(".meas TRAN " + measname + " WHEN V(" + edge.pin + ") = '" + this.settings.outputDelayThresh + "*vsupply' CROSS=1 pushout='" + pushoutPS + "ps'");
    }

    private void writeMeasGlitch(String measname, PinEdge edge) {
        if (SCTiming.isStable(edge.transition)) {
            return;
        }
        if (edge.transition == PinEdge.Transition.RISE) {
            this.out.println(".meas TRAN " + measname + " WHEN V(Xdut." + edge.pin + ") = '" + this.settings.holdGlitchLowPercent + "*vsupply' RISE=1");
        }
        if (edge.transition == PinEdge.Transition.FALL) {
            this.out.println(".meas TRAN " + measname + " WHEN V(Xdut." + edge.pin + ") = '" + this.settings.holdGlitchHighPercent + "*vsupply' FALL=1");
        }
    }

    public static List<String> getPorts(Cell cell, List<String> unusedPorts) {
        ArrayList<String> ports = new ArrayList<String>();
        Netlist netlist = cell.getNetlist(Netlist.ShortResistors.ALL);
        NccCellAnnotations anno = NccCellAnnotations.getAnnotations(cell);
        if (anno == null) {
            return ports;
        }
        HashMap exportNameMap = new HashMap();
        Iterator<List<NccCellAnnotations.NamePattern>> nit = anno.getExportsConnected();
        while (nit.hasNext()) {
            List<NccCellAnnotations.NamePattern> nplist = nit.next();
            TreeSet<String> connectedExports = new TreeSet<String>();
            for (NccCellAnnotations.NamePattern np : nplist) {
                Iterator<Export> eit = cell.getExports();
                while (eit.hasNext()) {
                    Export ex = eit.next();
                    String name = netlist.getNetwork(ex, 0).getName();
                    if (unusedPorts != null && unusedPorts.contains(name) || !np.matches(name)) continue;
                    connectedExports.add(name);
                    exportNameMap.put(name, connectedExports);
                }
            }
        }
        Iterator<Export> it = cell.getExports();
        while (it.hasNext()) {
            Export ex = it.next();
            String name = netlist.getNetwork(ex, 0).getName();
            if (unusedPorts != null && unusedPorts.contains(name)) continue;
            if (exportNameMap.containsKey(name)) {
                name = (String)((Set)exportNameMap.get(name)).iterator().next();
            }
            if (ports.contains(name)) continue;
            ports.add(name);
        }
        return ports;
    }

    private static boolean findAndRemove(List<String> list, String n) {
        int before = list.size();
        boolean removed = false;
        for (String p : list) {
            if (!n.equalsIgnoreCase(p)) continue;
            removed = true;
        }
        list.remove(n);
        int after = list.size();
        if (removed && after == before) {
            System.out.println("Err here");
        }
        return removed;
    }

    private void verifyPorts(Cell topCell, SpiceSubckt testCell, Arc arc, List<String> globalNets) throws SCTimingException {
        List<String> ports = SCTiming.getPorts(topCell, this.unusedPins);
        for (PinEdge p : arc.stableInputs) {
            if (!testCell.hasPortCaseInsensitive(p.pin)) {
                throw new SCTimingException("Pin " + p.pin + " not found on test cell " + testCell.getName() + " for arc " + arc);
            }
            ports.remove(p.pin);
        }
        if (!testCell.hasPortCaseInsensitive(arc.output.pin)) {
            throw new SCTimingException("Pin " + arc.output.pin + " not found on test cell " + testCell.getName() + " for arc " + arc + " insensitive ");
        }
        if (!testCell.hasPortCaseInsensitive(arc.input.pin)) {
            throw new SCTimingException("Pin " + arc.input.pin + " not found on test cell " + testCell.getName() + " for arc " + arc);
        }
        if (arc.clk != null) {
            if (!testCell.hasPortCaseInsensitive(arc.clk.pin)) {
                throw new SCTimingException("Pin " + arc.clk.pin + " not found on test cell " + testCell.getName() + " for arc " + arc);
            }
            if (arc.clk.transition != PinEdge.Transition.RISE && arc.clk.transition != PinEdge.Transition.FALL) {
                throw new SCTimingException("Clock pin " + arc.clk.pin + " transition must be RISE or FALL for arc " + arc);
            }
            ports.remove(arc.clk.pin);
        }
        if (arc.clkFalse != null) {
            if (!testCell.hasPortCaseInsensitive(arc.clkFalse.pin)) {
                throw new SCTimingException("Pin " + arc.clkFalse.pin + " not found on test cell " + testCell.getName() + " for arc " + arc);
            }
            if (arc.clkFalse.transition != PinEdge.Transition.RISE && arc.clkFalse.transition != PinEdge.Transition.FALL) {
                throw new SCTimingException("Clock pin " + arc.clkFalse.pin + " transition must be RISE or FALL for arc " + arc);
            }
            ports.remove(arc.clkFalse.pin);
        }
        SCTiming.findAndRemove(ports, arc.output.pin);
        SCTiming.findAndRemove(ports, arc.input.pin);
        for (String s2 : globalNets) {
            SCTiming.findAndRemove(ports, s2);
        }
        for (String s2 : arc.unusedOutputs) {
            SCTiming.findAndRemove(ports, s2);
        }
        if (ports.size() > 0) {
            StringBuffer pins = new StringBuffer();
            for (String s3 : ports) {
                pins.append(s3 + " ");
            }
            throw new SCTimingException("Pins " + pins + " on test cell " + testCell.getName() + " not specified on arc " + arc);
        }
        if (arc.input.transition != PinEdge.Transition.RISE && arc.input.transition != PinEdge.Transition.FALL) {
            throw new SCTimingException("Input pin " + arc.input.pin + " transition must be RISE or FALL for arc " + arc);
        }
        if (arc.output.transition != PinEdge.Transition.RISE && arc.output.transition != PinEdge.Transition.FALL) {
            throw new SCTimingException("Output pin " + arc.output.pin + " transition must be RISE or FALL for arc " + arc);
        }
        for (PinEdge p : arc.stableInputs) {
            if (SCTiming.isStable(p.transition)) continue;
            throw new SCTimingException("Stable Input pin " + p.pin + " transition must be STABLE0 or STABLE1 for arc " + arc);
        }
    }

    private static void printColumnMeanStdDev(Table2D data2d, String key, PrintStream msg, double scaleFactor, String units) {
        double[] colIndexVals = data2d.getColIndexVals();
        for (int i = 0; i < colIndexVals.length; ++i) {
            double[] colVals = data2d.getColumnValues(key, i);
            if (colVals == null) {
                System.out.println("Cannot find col vals for key: " + key);
                return;
            }
            double avg = Table2D.getAverage(colVals) * scaleFactor;
            double stddev = Table2D.getStandardDeviation(colVals) * scaleFactor;
            double stddevp = stddev / avg * 100.0;
            msg.println(key + " for " + data2d.getColName() + "=" + colIndexVals[i] + ": mean=" + TextUtils.formatDouble(avg, 4) + units + "  stddev=" + TextUtils.formatDouble(stddev, 4) + units + "  stddev%=" + TextUtils.formatDouble(stddevp, 4) + "%");
        }
    }

    private static void printRowMeanStdDev(Table2D data2d, String key, PrintStream msg, double scaleFactor, String units) {
        double[] rowIndexVals = data2d.getRowIndexVals();
        for (int i = 0; i < rowIndexVals.length; ++i) {
            double[] rowVals = data2d.getRowValues(key, i);
            if (rowVals == null) {
                System.out.println("Cannot find row vals for key: " + key);
                return;
            }
            double avg = Table2D.getAverage(rowVals) * scaleFactor;
            double stddev = Table2D.getStandardDeviation(rowVals) * scaleFactor;
            double stddevp = stddev / avg * 100.0;
            msg.println(key + " for " + data2d.getRowName() + "=" + rowIndexVals[i] + ": mean=" + TextUtils.formatDouble(avg, 4) + units + "  stddev=" + TextUtils.formatDouble(stddev, 4) + units + "  stddev%=" + TextUtils.formatDouble(stddevp, 4) + "%");
        }
    }

    private static void printMeanStdDev(Table2D data2d, String key, PrintStream msg, double scaleFactor, String units) {
        double[][] values = data2d.getValues(key);
        if (values == null) {
            System.out.println("Cannot find values for key: " + key);
            return;
        }
        double avg = Table2D.getAverage(data2d.getValues(key)) * scaleFactor;
        double stddev = Table2D.getStandardDeviation(data2d.getValues(key)) * scaleFactor;
        double stddevp = stddev / avg * 100.0;
        msg.println(key + ": mean=" + TextUtils.formatDouble(avg, 4) + units + "  stddev=" + TextUtils.formatDouble(stddev, 4) + units + "  stddev%=" + TextUtils.formatDouble(stddevp, 4) + "%");
    }

    private static void print2DMeanStdDev(Table2D data2d, String key, PrintStream msg, double scaleFactor, String units) {
        double[] rowIndexVals = data2d.getRowIndexVals();
        double[] colIndexVals = data2d.getColIndexVals();
        double[][] values = data2d.getValues(key);
        double[][] stddev = data2d.getValues(key + "_stddev");
        if (values == null) {
            System.out.println("Cannot find values for key: " + key);
            return;
        }
        if (stddev == null) {
            System.out.println("Cannot find values for key: " + key + "_stddev");
        }
        for (int r = 0; r < rowIndexVals.length; ++r) {
            for (int c = 0; c < colIndexVals.length; ++c) {
                double avg = values[r][c] * scaleFactor;
                double dev = stddev == null ? 0.0 : stddev[r][c] * scaleFactor;
                double devp = stddev == null ? 0.0 : dev / avg * 100.0;
                msg.println(key + " for " + data2d.getRowName() + "=" + rowIndexVals[r] + ", " + data2d.getColName() + "=" + colIndexVals[c] + ": mean=" + TextUtils.formatDouble(avg, 4) + units + "  stddev=" + TextUtils.formatDouble(dev, 4) + units + "  stddev%=" + TextUtils.formatDouble(devp, 4) + "%");
            }
        }
    }

    static boolean isStable(PinEdge.Transition tran) {
        return tran == PinEdge.Transition.STABLE0 || tran == PinEdge.Transition.STABLE1 || tran == PinEdge.Transition.STABLEV;
    }

    void err(boolean print, String msg) throws SCTimingException {
        if (print) {
            throw new SCTimingException(msg);
        }
    }

    private static String[] scaleSweep(String sweep, double scale) {
        String[] temp = sweep.trim().split("\\s+");
        for (int i = 0; i < temp.length; ++i) {
            String s2 = temp[i];
            try {
                double d = Double.parseDouble(s2);
                temp[i] = String.valueOf(d *= scale);
                continue;
            }
            catch (NumberFormatException e) {
                System.out.println("Cannot convert " + s2 + " to a number in sweep param");
            }
        }
        return temp;
    }

    public LibData.Group getCellLibData(LibData.Group library) {
        LibData.Group ff;
        String ffname;
        List<LibData.Group> groups;
        if (this.characterizationFailed) {
            return null;
        }
        String libertyCellName = this.topCellNameLiberty;
        if (libertyCellName == null) {
            libertyCellName = this.topCellName;
        }
        if ((groups = library.getGroups("cell", libertyCellName)).size() > 0) {
            System.out.println("Warning, cell for " + libertyCellName + " already present in liberty data, replacing it with new data");
            for (LibData.Group g : groups) {
                library.removeGroup(g);
            }
        }
        LibData.Group cell = new LibData.Group("cell", libertyCellName, library);
        if (this.interfaceTiming) {
            cell.putAttribute("timing_model_type", "abstracted");
        }
        if (this.setDontTouch) {
            cell.putAttribute("dont_touch", "true");
        }
        if (this.setDontUse) {
            cell.putAttribute("dont_use", "true");
        }
        HashMap<String, LibData.Group> pinMap = new HashMap<String, LibData.Group>();
        HashMap<String, LibData.Group> pinTimingMap = new HashMap<String, LibData.Group>();
        List<String> ports = SCTiming.getPorts(this.topCell, this.unusedPins);
        HashMap<String, Integer> pinTypes = new HashMap<String, Integer>();
        for (String s2 : ports) {
            if (this.netlistReader != null && this.netlistReader.getGlobalNets().contains(s2)) continue;
            LibData.Group pin = new LibData.Group("pin", s2, cell);
            pinMap.put(s2, pin);
            int type = 0;
            for (Arc arc : this.timingArcs) {
                if (arc.input.pin.equalsIgnoreCase(s2)) break;
                if (arc.output.pin.equalsIgnoreCase(s2)) {
                    type = 1;
                    break;
                }
                if (arc.clk == null || !arc.clk.pin.equalsIgnoreCase(s2)) continue;
                type = 2;
                break;
            }
            pinTypes.put(s2, type);
            if (type == 1) {
                pin.putAttribute("direction", "output");
                String function = this.combinationalFunctions.get(s2);
                if (function != null) {
                    function = "\"" + function + "\"";
                    pin.putAttribute("function", function);
                }
                if (this.threeStatePin != null) {
                    pin.putAttribute("three_state", this.threeStatePinStateForOutputZ ? this.threeStatePin : "!" + this.threeStatePin);
                }
            } else {
                pin.putAttribute("direction", "input");
            }
            if (this.testCell != null) {
                if (this.testCell.isScanIn(s2)) {
                    pin.putAttribute("nextstate_type", "scan_in");
                }
                if (this.testCell.isScanEn(s2)) {
                    pin.putAttribute("nextstate_type", "scan_enable");
                }
                if (this.functionFlipFlop != null && this.testCell.isScanOut(s2)) {
                    pin.putAttribute("function", "i" + this.functionFlipFlop.getOutputPosPin());
                }
                if (this.functionFlipFlopSDRtoDDR != null && this.functionFlipFlopSDRtoDDR.getInputFall().equals(s2)) {
                    pin.putAttribute("nextstate_type", "data");
                }
                if (this.functionFlipFlopSDRtoDDR != null && this.functionFlipFlopSDRtoDDR.getInputRise().equals(s2)) {
                    pin.putAttribute("nextstate_type", "data");
                }
                if (this.functionFlipFlopDDRtoSDR != null && this.functionFlipFlopDDRtoSDR.getInput().equals(s2)) {
                    pin.putAttribute("nextstate_type", "data");
                }
            }
            if (type == 2) {
                pin.putAttribute("clock", "true");
            }
            pin.putAttribute("connection_class", "universal");
            if (type != 0 && type != 2) continue;
            double cap = 0.0;
            int count2 = 0;
            for (Arc arc : this.timingArcs) {
                int col = this.getColumn(arc, s2 + "_cap");
                if (col <= 0) continue;
                cap += arc.data.getAverage(col);
                ++count2;
            }
            if (count2 == 0) continue;
            pin.putAttribute("capacitance", cap / (double)count2 / this.settings.capUnit);
        }
        for (Arc arc : this.timingArcs) {
            String inputPin = arc.input.pin;
            String outputPin = arc.output.pin;
            LibData.Group inpin = (LibData.Group)pinMap.get(inputPin);
            LibData.Group outpin = (LibData.Group)pinMap.get(outputPin);
            if (arc.clk == null) {
                LibData.Group timing;
                String timingkey = arc.output.pin + "_" + arc.input.pin;
                if (arc.dependentStableInputs.size() > 0) {
                    for (PinEdge p : arc.dependentStableInputs) {
                        timingkey = timingkey + "_" + (p.transition == PinEdge.Transition.STABLE0 ? "!" : "") + p.pin;
                    }
                }
                if ((timing = (LibData.Group)pinTimingMap.get(timingkey)) == null) {
                    timing = new LibData.Group("timing", "", outpin);
                    pinTimingMap.put(timingkey, timing);
                    timing.putAttribute("related_pin", inputPin);
                    String sense = "negative_unate";
                    if (arc.input.transition == arc.output.transition) {
                        sense = "positive_unate";
                    }
                    if (inputPin == this.threeStatePin && !this.threeStatePinStateForOutputZ) {
                        if (arc.input.transition == PinEdge.Transition.RISE) {
                            timing.putAttribute("timing_type", "three_state_enable");
                            sense = "positive_unate";
                        }
                        if (arc.input.transition == PinEdge.Transition.FALL) {
                            timing.putAttribute("timing_type", "three_state_disable");
                            sense = "negative_unate";
                        }
                    } else if (inputPin == this.threeStatePin && this.threeStatePinStateForOutputZ) {
                        if (arc.input.transition == PinEdge.Transition.FALL) {
                            timing.putAttribute("timing_type", "three_state_enable");
                            sense = "negative_unate";
                        }
                        if (arc.input.transition == PinEdge.Transition.RISE) {
                            timing.putAttribute("timing_type", "three_state_disable");
                            sense = "positive_unate";
                        }
                    }
                    timing.putAttribute("timing_sense", sense);
                    if (this.resetPin != null && inputPin.equals(this.resetPin.name)) {
                        if (this.resetPin.resetState) {
                            timing.putAttribute("timing_type", "preset");
                        } else {
                            timing.putAttribute("timing_type", "reset");
                        }
                    }
                }
                if (arc.dependentStableInputs.size() > 0) {
                    StringBuffer whenPins = new StringBuffer();
                    StringBuffer sdf = new StringBuffer();
                    for (PinEdge p : arc.dependentStableInputs) {
                        whenPins.append(p.transition == PinEdge.Transition.STABLE0 ? "!" : "");
                        whenPins.append(p.pin);
                        whenPins.append(" & ");
                        sdf.append(p.pin);
                        sdf.append(" == ");
                        sdf.append(p.transition == PinEdge.Transition.STABLE0 ? "1'B0" : "1'B1");
                        sdf.append(" & ");
                    }
                    whenPins.setLength(whenPins.length() - 2);
                    sdf.setLength(sdf.length() - 2);
                    timing.putAttribute("when", "\"" + whenPins.toString().trim() + "\"");
                    timing.putAttribute("sdf_cond", "\"" + sdf.toString().trim() + "\"");
                }
                if (this.noTiming) {
                    timing.putAttribute("intrinsic_rise", "0.02");
                    timing.putAttribute("intrinsic_fall", "0.02");
                    timing.putAttribute("rise_resistance", "0.01");
                    timing.putAttribute("fall_resistance", "0.01");
                    continue;
                }
                String delay = "cell_fall";
                String trans = "fall_transition";
                if (arc.output.transition == PinEdge.Transition.RISE) {
                    delay = "cell_rise";
                    trans = "rise_transition";
                }
                Table2D data2D = arc.data2d_inbuf_outload;
                LibData.Group delayg = new LibData.Group(delay, this.settings.tableSlewVsLoads, timing);
                double[] inslew = data2D.getAvgRowValues(inputPin + "_slew");
                double[] outload = data2D.getAvgColumnValues(outputPin + "_cap");
                String index_1 = this.toStringQuote(inslew, this.settings.timeUnit);
                String index_2 = this.toStringQuote(outload, this.settings.capUnit);
                double[][] propdelay = data2D.getValues("prop_delay");
                delayg.putAttributeComplex("index_1", index_1);
                delayg.putAttributeComplex("index_2", index_2);
                ArrayList<String> delays = new ArrayList<String>();
                for (int i = 0; i < propdelay.length; ++i) {
                    delays.add(this.toStringQuote(propdelay[i], this.settings.timeUnit));
                }
                delayg.putAttribute("values", delays);
                LibData.Group transg = new LibData.Group(trans, this.settings.tableSlewVsLoads, timing);
                double[][] transtime = data2D.getValues(outputPin + "_slew");
                transg.putAttributeComplex("index_1", index_1);
                transg.putAttributeComplex("index_2", index_2);
                ArrayList<String> ttimes = new ArrayList<String>();
                for (int i = 0; i < transtime.length; ++i) {
                    ttimes.add(this.toStringQuote(transtime[i], this.settings.timeUnit));
                }
                transg.putAttribute("values", ttimes);
                continue;
            }
            if (this.noTiming) continue;
            String clkPin = arc.clk.pin;
            String edge = "R";
            if (arc.clk.transition == PinEdge.Transition.FALL) {
                edge = "F";
            }
            boolean resetPinArc = false;
            if (this.resetPin != null && this.resetPin.name.equals(arc.input.pin)) {
                resetPinArc = true;
            }
            String intimingkeySetup = arc.input.pin + "_" + arc.clk.pin + edge + "_Setup";
            String intimingkeyHold = arc.input.pin + "_" + arc.clk.pin + edge + "_Hold";
            LibData.Group intimingSetup = (LibData.Group)pinTimingMap.get(intimingkeySetup);
            LibData.Group intimingHold = (LibData.Group)pinTimingMap.get(intimingkeyHold);
            if (intimingSetup == null) {
                intimingSetup = new LibData.Group("timing", "", inpin);
                pinTimingMap.put(intimingkeySetup, intimingSetup);
                intimingSetup.putAttribute("related_pin", clkPin);
                if (arc.clk.transition == PinEdge.Transition.FALL) {
                    intimingSetup.putAttribute("timing_type", "setup_falling");
                } else {
                    intimingSetup.putAttribute("timing_type", "setup_rising");
                }
            }
            if (intimingHold == null) {
                intimingHold = new LibData.Group("timing", "", inpin);
                if (!resetPinArc) {
                    pinTimingMap.put(intimingkeyHold, intimingHold);
                }
                intimingHold.putAttribute("related_pin", clkPin);
                if (arc.clk.transition == PinEdge.Transition.FALL) {
                    intimingHold.putAttribute("timing_type", "hold_falling");
                } else {
                    intimingHold.putAttribute("timing_type", "hold_rising");
                }
            }
            Table2D data2D_clkbuf_outload = arc.data2d_clkbuf_outload;
            Table2D data2D_inbuf_clkbuf = arc.data2d_inbuf_clkbuf;
            String trans = "fall_constraint";
            if (arc.input.transition == PinEdge.Transition.RISE) {
                trans = "rise_constraint";
            }
            LibData.Group setup = new LibData.Group(trans, this.settings.tableSetupHold, intimingSetup);
            LibData.Group hold = new LibData.Group(trans, this.settings.tableSetupHold, intimingHold);
            double[] inslew = data2D_inbuf_clkbuf.getAvgRowValues(inputPin + "_slew");
            setup.putAttributeComplex("index_1", this.toStringQuote(inslew, this.settings.timeUnit));
            hold.putAttributeComplex("index_1", this.toStringQuote(inslew, this.settings.timeUnit));
            double[] clkslew = data2D_inbuf_clkbuf.getAvgColumnValues(clkPin + "_slew");
            if (clkslew.length > 1) {
                setup.putAttributeComplex("index_2", this.toStringQuote(clkslew, this.settings.timeUnit));
                hold.putAttributeComplex("index_2", this.toStringQuote(clkslew, this.settings.timeUnit));
            }
            double[][] setups = data2D_inbuf_clkbuf.getValues(this.setupTimeName);
            ArrayList<String> setupVals = new ArrayList<String>();
            for (int i = 0; i < setups.length; ++i) {
                setupVals.add(this.toStringQuote(setups[i], this.settings.timeUnit));
            }
            if (clkslew.length > 1) {
                setup.putAttribute("values", setupVals);
            } else {
                setup.putAttributeComplex("values", this.toStringQuote(setups[0], this.settings.timeUnit));
            }
            double[][] holds = data2D_inbuf_clkbuf.getValues(this.holdTimeName);
            ArrayList<String> holdVals = new ArrayList<String>();
            for (int i = 0; i < holds.length; ++i) {
                holdVals.add(this.toStringQuote(holds[i], this.settings.timeUnit));
            }
            if (clkslew.length > 1) {
                hold.putAttribute("values", holdVals);
            } else {
                hold.putAttributeComplex("values", this.toStringQuote(holds[0], this.settings.timeUnit));
            }
            if (resetPinArc) continue;
            String outtimingkey = arc.output.pin + "_" + arc.clk.pin + edge;
            LibData.Group outtiming = (LibData.Group)pinTimingMap.get(outtimingkey);
            if (outtiming == null) {
                outtiming = new LibData.Group("timing", "", outpin);
                pinTimingMap.put(outtimingkey, outtiming);
                outtiming.putAttribute("related_pin", clkPin);
                outtiming.putAttribute("timing_sense", "non_unate");
                PinEdge.Transition clkTrans = arc.clk.transition;
                if (this.functionLatch != null) {
                    clkTrans = arc.clk.getOpposite().transition;
                }
                if (clkTrans == PinEdge.Transition.FALL) {
                    outtiming.putAttribute("timing_type", "falling_edge");
                } else {
                    outtiming.putAttribute("timing_type", "rising_edge");
                }
            }
            String clk2qname = "cell_fall";
            String outtrans = "fall_transition";
            if (arc.output.transition == PinEdge.Transition.RISE) {
                clk2qname = "cell_rise";
                outtrans = "rise_transition";
            }
            LibData.Group clk2q = new LibData.Group(clk2qname, this.settings.tableClk2Q, outtiming);
            clkslew = data2D_clkbuf_outload.getAvgRowValues(clkPin + "_slew");
            if (clkslew.length > 1) {
                clk2q.putAttributeComplex("index_1", this.toStringQuote(clkslew, this.settings.timeUnit));
            }
            double[] outload = data2D_clkbuf_outload.getAvgColumnValues(outputPin + "_cap");
            if (clkslew.length > 1) {
                clk2q.putAttributeComplex("index_2", this.toStringQuote(outload, this.settings.capUnit));
            } else {
                clk2q.putAttributeComplex("index_1", this.toStringQuote(outload, this.settings.capUnit));
            }
            double[][] clk2qVals = data2D_clkbuf_outload.getValues(this.clk2q);
            ArrayList<String> clk2qStrings = new ArrayList<String>();
            for (int i = 0; i < clk2qVals.length; ++i) {
                clk2qStrings.add(this.toStringQuote(clk2qVals[i], this.settings.timeUnit));
            }
            if (clkslew.length > 1) {
                clk2q.putAttribute("values", clk2qStrings);
            } else {
                clk2q.putAttributeComplex("values", this.toStringQuote(clk2qVals[0], this.settings.timeUnit));
            }
            LibData.Group outslew = new LibData.Group(outtrans, this.settings.tableClk2Q, outtiming);
            if (clkslew.length > 1) {
                outslew.putAttributeComplex("index_1", this.toStringQuote(clkslew, this.settings.timeUnit));
            }
            if (clkslew.length > 1) {
                outslew.putAttributeComplex("index_2", this.toStringQuote(outload, this.settings.capUnit));
            } else {
                outslew.putAttributeComplex("index_1", this.toStringQuote(outload, this.settings.capUnit));
            }
            double[][] outslewVals = data2D_clkbuf_outload.getValues(outputPin + "_slew");
            ArrayList<String> outslewStrings = new ArrayList<String>();
            for (int i = 0; i < outslewVals.length; ++i) {
                outslewStrings.add(this.toStringQuote(outslewVals[i], this.settings.timeUnit));
            }
            if (clkslew.length > 1) {
                outslew.putAttribute("values", outslewStrings);
            } else {
                outslew.putAttributeComplex("values", this.toStringQuote(outslewVals[0], this.settings.timeUnit));
            }
            String ffname2 = "i" + outputPin + ", i" + outputPin + "b";
            List<LibData.Group> ffs = cell.getGroups("ff", ffname2);
            if (ffs.size() != 0) continue;
        }
        if (this.functionFlipFlop != null) {
            ffname = "i" + this.functionFlipFlop.getOutputPosPin() + ", i" + this.functionFlipFlop.getOutputNegPin();
            ff = new LibData.Group("ff", ffname, cell);
            if (this.testCell != null) {
                ff.putAttribute("next_state", "\"(" + this.testCell.getScanEnPin() + "&" + this.testCell.getScanInPin() + ")|(!" + this.testCell.getScanEnPin() + "&" + this.functionFlipFlop.getInputPin() + ")\" ");
            } else {
                ff.putAttribute("next_state", this.functionFlipFlop.getInputPin());
            }
            ff.putAttribute("clocked_on", this.functionFlipFlop.getClockedOnPin());
            if (this.resetPin != null) {
                if (this.resetPin.resetState) {
                    ff.putAttribute("preset", this.resetPin.activeHigh ? this.resetPin.name : "\"!" + this.resetPin.name + "\"");
                } else {
                    ff.putAttribute("reset", this.resetPin.activeHigh ? this.resetPin.name : "\"!" + this.resetPin.name + "\"");
                }
            }
        }
        if (this.functionFlipFlopSDRtoDDR != null) {
            ffname = "i" + this.functionFlipFlopSDRtoDDR.getOutputPos() + ", i" + this.functionFlipFlopSDRtoDDR.getOutputNeg();
            ff = new LibData.Group("ff", ffname, cell);
            if (this.testCell != null) {
                ff.putAttribute("next_state", "\"(" + this.testCell.getScanEnPin() + "&" + this.testCell.getScanInPin() + ")|(!" + this.testCell.getScanEnPin() + "&(" + this.functionFlipFlopSDRtoDDR.getInputRise() + "|" + this.functionFlipFlopSDRtoDDR.getInputFall() + "))\" ");
            } else {
                ff.putAttribute("next_state", "\"" + this.functionFlipFlopSDRtoDDR.getInputRise() + "|" + this.functionFlipFlopSDRtoDDR.getInputFall() + "\" ");
            }
            ff.putAttribute("clocked_on", this.functionFlipFlopSDRtoDDR.getClockedOnPin());
            if (this.resetPin != null) {
                if (this.resetPin.resetState) {
                    ff.putAttribute("preset", this.resetPin.activeHigh ? this.resetPin.name : "\"!" + this.resetPin.name + "\"");
                } else {
                    ff.putAttribute("reset", this.resetPin.activeHigh ? this.resetPin.name : "\"!" + this.resetPin.name + "\"");
                }
            }
        }
        if (this.functionFlipFlopDDRtoSDR != null) {
            ffname = "i" + this.functionFlipFlopDDRtoSDR.getOutputRisePos() + ", i" + this.functionFlipFlopDDRtoSDR.getOutputRiseNeg();
            ff = new LibData.Group("ff", ffname, cell);
            if (this.testCell != null) {
                ff.putAttribute("next_state", "\"(" + this.testCell.getScanEnPin() + "&" + this.testCell.getScanInPin() + ")|(!" + this.testCell.getScanEnPin() + "&" + this.functionFlipFlopDDRtoSDR.getInput() + ")\" ");
            } else {
                ff.putAttribute("next_state", this.functionFlipFlopDDRtoSDR.getInput());
            }
            ff.putAttribute("clocked_on", this.functionFlipFlopDDRtoSDR.getClockedOnPin());
            if (this.resetPin != null) {
                if (this.resetPin.resetState) {
                    ff.putAttribute("preset", this.resetPin.activeHigh ? this.resetPin.name : "\"!" + this.resetPin.name + "\"");
                } else {
                    ff.putAttribute("reset", this.resetPin.activeHigh ? this.resetPin.name : "\"!" + this.resetPin.name + "\"");
                }
            }
        }
        if (this.testCell != null) {
            LibData.Group tcell = new LibData.Group("test_cell", "", cell);
            if (this.functionFlipFlop != null) {
                String ffname3 = "i" + this.functionFlipFlop.getOutputPosPin() + ", i" + this.functionFlipFlop.getOutputNegPin();
                LibData.Group ff2 = new LibData.Group("ff", ffname3, tcell);
                ff2.putAttribute("next_state", this.functionFlipFlop.getInputPin());
                ff2.putAttribute("clocked_on", this.functionFlipFlop.getClockedOnPin());
                if (this.resetPin != null) {
                    if (this.resetPin.resetState) {
                        ff2.putAttribute("preset", this.resetPin.activeHigh ? this.resetPin.name : "\"!" + this.resetPin.name + "\"");
                    } else {
                        ff2.putAttribute("reset", this.resetPin.activeHigh ? this.resetPin.name : "\"!" + this.resetPin.name + "\"");
                    }
                }
            }
            for (String s3 : ports) {
                if (this.netlistReader != null && this.netlistReader.getGlobalNets().contains(s3)) continue;
                LibData.Group pin = new LibData.Group("pin", s3, tcell);
                Integer type = (Integer)pinTypes.get(s3);
                if (type != null) {
                    if (type == 0 || type == 2) {
                        pin.putAttribute("direction", "input");
                    }
                    if (type == 1) {
                        pin.putAttribute("direction", "output");
                    }
                }
                if (this.testCell.isScanIn(s3)) {
                    pin.putAttribute("signal_type", "test_scan_in");
                }
                if (this.testCell.isScanOut(s3)) {
                    pin.putAttribute("signal_type", "test_scan_out");
                    pin.putAttribute("function", "i" + this.functionFlipFlop.getOutputPosPin());
                    pin.putAttribute("test_output_only", "true");
                }
                if (this.testCell.isScanEn(s3)) {
                    pin.putAttribute("signal_type", "test_scan_enable");
                }
                if (this.functionFlipFlop == null) continue;
                if (s3.equals(this.functionFlipFlop.getOutputPosPin())) {
                    pin.putAttribute("function", "i" + this.functionFlipFlop.getOutputPosPin());
                }
                if (!s3.equals(this.functionFlipFlop.getOutputNegPin())) continue;
                pin.putAttribute("function", "i" + this.functionFlipFlop.getOutputNegPin());
            }
        }
        if (this.functionLatch != null && !this.interfaceTiming) {
            ffname = "i" + this.functionLatch.getOutputPosPin() + ", i" + this.functionLatch.getOutputNegPin();
            ff = new LibData.Group("latch", ffname, cell);
            ff.putAttribute("data_in", this.functionLatch.getInputPin());
            ff.putAttribute("enable", this.functionLatch.getEnablePin());
        }
        return cell;
    }

    private String toStringQuote(double val, double scale) {
        double[] a = new double[]{val};
        return this.toStringQuote(a, scale);
    }

    private String toStringQuote(double[] vals, double scale) {
        StringBuffer buf = new StringBuffer("\"");
        for (double d : vals) {
            buf.append(TextUtils.formatDouble(d / scale, 5));
            buf.append(" ");
        }
        buf.append("\"");
        return buf.toString();
    }

    private int getColumn(Arc arc, String name) {
        if (arc.data == null) {
            return -1;
        }
        return arc.data.getColumn(name);
    }

    private static class TestCell {
        private String scanInPin;
        private String scanOutPin;
        private String scanEnPin;

        public TestCell(String scanInPin, String scanOutPin, String scanEnPin) {
            this.scanInPin = scanInPin;
            this.scanOutPin = scanOutPin;
            this.scanEnPin = scanEnPin;
        }

        public String getScanInPin() {
            return this.scanInPin;
        }

        public String getScanOutPin() {
            return this.scanOutPin;
        }

        public String getScanEnPin() {
            return this.scanEnPin;
        }

        public boolean isScanIn(String s2) {
            return this.scanInPin != null && s2.equals(this.scanInPin);
        }

        public boolean isScanOut(String s2) {
            return this.scanOutPin != null && s2.equals(this.scanOutPin);
        }

        public boolean isScanEn(String s2) {
            return this.scanEnPin != null && s2.equals(this.scanEnPin);
        }
    }

    private static class LatchFunction {
        private String outputPos;
        private String outputNeg;
        private String inputPin;
        private String enablePin;

        public LatchFunction(String outputPin, String outputNegPin, String inputPin, String enablePin) {
            this.outputPos = outputPin;
            this.outputNeg = outputNegPin;
            this.inputPin = inputPin;
            this.enablePin = enablePin;
        }

        public String getOutputPosPin() {
            return this.outputPos;
        }

        public String getOutputNegPin() {
            return this.outputNeg;
        }

        public String getInputPin() {
            return this.inputPin;
        }

        public String getEnablePin() {
            return this.enablePin;
        }
    }

    private static class FlipFlopFunctionDDRtoSDR {
        private String outputRisePos;
        private String outputRiseNeg;
        private String outputFallPos;
        private String outputFallNeg;
        private String input;
        private String clockedOnPin;

        public FlipFlopFunctionDDRtoSDR(String outputRisePos, String outputRiseNeg, String outputFallPos, String outputFallNeg, String input2, String clockedOnPin) {
            this.outputRisePos = outputRisePos;
            this.outputRiseNeg = outputRiseNeg;
            this.outputFallPos = outputFallPos;
            this.outputFallNeg = outputFallNeg;
            this.input = input2;
            this.clockedOnPin = clockedOnPin;
        }

        public FlipFlopFunctionDDRtoSDR(String outputRise, String outputFall, String input2, String clockedOnPin) {
            this(outputRise, outputRise + "_n", outputFall, outputFall + "_n", input2, clockedOnPin);
        }

        public String getOutputRisePos() {
            return this.outputRisePos;
        }

        public String getOutputRiseNeg() {
            return this.outputRiseNeg;
        }

        public String getOutputFallPos() {
            return this.outputFallPos;
        }

        public String getOutputFallNeg() {
            return this.outputFallNeg;
        }

        public String getInput() {
            return this.input;
        }

        public String getClockedOnPin() {
            return this.clockedOnPin;
        }
    }

    private static class FlipFlopFunctionSDRtoDDR {
        private String outputPos;
        private String outputNeg;
        private String inputRise;
        private String inputFall;
        private String clockedOnPin;

        public FlipFlopFunctionSDRtoDDR(String outputPos, String outputNeg, String inputRise, String inputFall, String clockedOnPin) {
            this.outputPos = outputPos;
            this.outputNeg = outputNeg;
            this.inputRise = inputRise;
            this.inputFall = inputFall;
            this.clockedOnPin = clockedOnPin;
        }

        public String getOutputPos() {
            return this.outputPos;
        }

        public String getOutputNeg() {
            return this.outputNeg;
        }

        public String getInputRise() {
            return this.inputRise;
        }

        public String getInputFall() {
            return this.inputFall;
        }

        public String getClockedOnPin() {
            return this.clockedOnPin;
        }
    }

    private static class FlipFlopFunction {
        private String outputPos;
        private String outputNeg;
        private String inputPin;
        private String clockedOnPin;
        private boolean ddr = false;

        public FlipFlopFunction(String outputPin, String outputNegPin, String inputPin, String clockedOnPin, boolean ddr) {
            this.outputPos = outputPin;
            this.outputNeg = outputNegPin;
            this.inputPin = inputPin;
            this.clockedOnPin = clockedOnPin;
            this.ddr = ddr;
        }

        public String getOutputPosPin() {
            return this.outputPos;
        }

        public String getOutputNegPin() {
            return this.outputNeg;
        }

        public String getInputPin() {
            return this.inputPin;
        }

        public String getClockedOnPin() {
            return this.clockedOnPin;
        }

        public boolean isDDR() {
            return this.ddr;
        }
    }

    private static class SpiceResultChecker
    extends OutputStream {
        private byte[] buf = new byte[256];
        private int count;
        private boolean failed = false;
        private OutputStream out;

        public SpiceResultChecker(OutputStream out) {
            this.out = out;
        }

        @Override
        public void write(int b) throws IOException {
            if (b == 10 || b == 13) {
                this.checkLine();
                this.count = 0;
            } else {
                if (this.count > this.buf.length) {
                    this.count = 0;
                }
                this.buf[this.count] = (byte)b;
                ++this.count;
            }
            if (this.out != null) {
                this.out.write(b);
            }
        }

        private void checkLine() {
            String line = new String(this.buf, 0, this.count);
            if (line.indexOf("***** hspice job aborted") != -1) {
                this.failed = true;
            }
        }

        private boolean getFailed() {
            return this.failed;
        }

        @Override
        public void close() throws IOException {
            if (this.out != null) {
                this.out.close();
            }
        }

        @Override
        public void flush() throws IOException {
            if (this.out != null) {
                this.out.flush();
            }
        }
    }

    private static class ResetPin {
        String name;
        boolean activeHigh;
        boolean resetState;

        ResetPin(String name, boolean activeHigh, boolean resetState) {
            this.name = name;
            this.activeHigh = activeHigh;
            this.resetState = resetState;
        }
    }

    private static class SweepParam {
        String param;
        String[] sweep;

        SweepParam(String param2, String sweep) {
            this(param2, sweep, 1.0);
        }

        SweepParam(String param2, String sweep, double scale) {
            this.param = param2;
            this.sweep = SCTiming.scaleSweep(sweep, scale);
        }
    }
}

