/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.routing.experimentalAStar1;

import com.sun.electric.tool.routing.experimentalAStar1.AStarRoutingFrame;
import com.sun.electric.tool.routing.experimentalAStar1.Map;
import com.sun.electric.tool.routing.experimentalAStar1.Net;
import com.sun.electric.tool.routing.experimentalAStar1.Path;
import java.util.List;

public class Goal {
    private boolean DEBUG = false;
    int[] startX;
    int[] startY;
    int[] finishX;
    int[] finishY;
    int currentStartZ = -1;
    int currentFinishZ = -1;
    int index = -1;
    private Net net;
    private Map map;
    private int scalingFactor;
    private static final int[] xValuesArea = new int[]{-1, 0, -1, 0};
    private static final int[] yValuesArea = new int[]{-1, -1, 0, 0};
    private static final int[] xValuesSurrounding = new int[]{-2, -1, 0, 1, -2, 1, -2, 1, -2, -1, 0, 1};
    private static final int[] yValuesSurrounding = new int[]{-2, -2, -2, -2, -1, -1, 0, 0, 1, 1, 1, 1};
    public static final int LAYER_TRAVERSL_COST = 20;

    public Goal(Net net, Map map2) {
        int i;
        List<Path> paths = net.getPaths();
        int n = paths.size();
        this.startX = new int[n];
        this.startY = new int[n];
        this.finishX = new int[n];
        this.finishY = new int[n];
        this.net = net;
        this.map = map2;
        this.scalingFactor = (int)map2.getScalingFactor();
        for (i = 0; i < n; ++i) {
            this.startX[i] = paths.get((int)i).startX;
            this.startY[i] = paths.get((int)i).startY;
            this.finishX[i] = paths.get((int)i).finishX;
            this.finishY[i] = paths.get((int)i).finishY;
        }
        this.DEBUG &= AStarRoutingFrame.getInstance().isOutputEnabled();
        if (this.DEBUG) {
            for (i = 0; i < paths.size(); ++i) {
                System.out.printf("Goal: finishX/Y/Z is (%d : %d), dispX:%d, dispY:%d\n", this.finishX[i], this.finishY[i], map2.getDispX(), map2.getDispY());
            }
        }
    }

    private boolean insideStartOrFinishArea(int x, int y, int z, int i) {
        Path path = this.net.getPaths().get(i);
        int startDiffX = path.startRight ? 1 : 0;
        int startDiffY = path.startAbove ? 1 : 0;
        int finishDiffX = path.finishRight ? 1 : 0;
        int finishDiffY = path.finishAbove ? 1 : 0;
        return x >= this.startX[i] - 1 + startDiffX && x <= this.startX[i] + startDiffX && y >= this.startY[i] - 1 + startDiffY && y <= this.startY[i] + startDiffY || x >= this.finishX[i] - 1 + finishDiffX && x <= this.finishX[i] + finishDiffX && y >= this.finishY[i] - 1 + finishDiffY && y <= this.finishY[i] + finishDiffY;
    }

    public boolean isTileOK(int fromX, int fromY, int fromZ, int toX, int toY, int toZ) {
        int netID = this.net.getNetID();
        int fromStatus = this.map.getStatus(fromX, fromY, fromZ);
        int toStatus = this.map.getStatus(toX, toY, toZ);
        if (fromStatus == 0 && toStatus == 0) {
            return true;
        }
        if (fromStatus == netID && (toStatus == 0 || toStatus == netID) || toStatus == netID && (fromStatus == 0 || fromStatus == netID)) {
            if (this.insideStartOrFinishArea(toX, toY, toZ, this.index) || this.insideStartOrFinishArea(fromX, fromY, fromZ, this.index)) {
                return toZ == fromZ;
            }
            for (int i = 0; i < this.net.getPaths().size(); ++i) {
                if (i == this.index || !this.insideStartOrFinishArea(toX, toY, toZ, i) && !this.insideStartOrFinishArea(fromX, fromY, fromZ, i)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int getTileCost(int fromX, int fromY, int fromZ, int toX, int toY, int toZ) {
        return this.scalingFactor * (Math.abs(toX - fromX) + Math.abs(toY - fromY)) + 20 * Math.abs(toZ - fromZ);
    }

    public int distanceToGoal(int x, int y, int z) {
        return this.scalingFactor * (Math.abs(this.finishX[this.index] - x) + Math.abs(this.finishY[this.index] - y)) + 20 * Math.abs(this.currentFinishZ - z);
    }

    public boolean isFinishPosition(int x, int y, int z) {
        return x == this.finishX[this.index] && y == this.finishY[this.index] && z == this.currentFinishZ;
    }

    public int getFinishPositionStatus() {
        return this.map.getStatus(this.finishX[this.index], this.finishY[this.index], this.currentFinishZ);
    }

    public int[] getNextStart() {
        String debug = "";
        do {
            debug = debug + this.index + " ";
            assert (this.index < this.startX.length - 1) : debug + "/" + this.startX.length;
            ++this.index;
        } while (this.net.pathDone[this.index]);
        Path path = this.net.getPaths().get(this.index);
        int maxStartOpenness = -1;
        this.currentStartZ = -1;
        for (int i = 0; i < path.startZ.length; ++i) {
            int openness = this.getSurroundingOpenness(path.startX, path.startY, path.startZ[i], path.startRight, path.startAbove);
            if (openness <= maxStartOpenness) continue;
            this.currentStartZ = path.startZ[i];
            maxStartOpenness = openness;
        }
        int maxFinishOpenness = -1;
        this.currentFinishZ = -1;
        for (int i = 0; i < path.finishZ.length; ++i) {
            int openness = this.getSurroundingOpenness(path.finishX, path.finishY, path.finishZ[i], path.finishRight, path.finishAbove);
            if (path.finishZ[i] == this.currentStartZ && Math.abs(path.finishX - path.startX) <= 1 && Math.abs(path.finishY - path.startY) <= 1) {
                openness = 0;
            }
            if (openness <= maxFinishOpenness) continue;
            this.currentFinishZ = path.finishZ[i];
            maxFinishOpenness = openness;
        }
        return new int[]{this.startX[this.index], this.startY[this.index], this.currentStartZ};
    }

    public boolean isRoutingComplete() {
        for (int i = this.index + 1; i < this.net.pathDone.length; ++i) {
            if (this.net.pathDone[i]) continue;
            return false;
        }
        return true;
    }

    private int getSurroundingOpenness(int x, int y, int z, boolean right, boolean above) {
        int diffX = right ? 1 : 0;
        int diffY = above ? 1 : 0;
        for (int i = 0; i < 4; ++i) {
            int testX = x + xValuesArea[i] + diffX;
            int testY = y + yValuesArea[i] + diffY;
            for (int j = 0; j < this.net.getPaths().size(); ++j) {
                if (j == this.index || !this.insideStartOrFinishArea(testX, testY, z, j)) continue;
                Path otherPath = this.net.getPaths().get(j);
                if (otherPath.startX == this.startX[this.index] && otherPath.startY == this.startY[this.index] || otherPath.finishX == this.startX[this.index] && otherPath.finishY == this.startY[this.index] || otherPath.startX == this.finishX[this.index] && otherPath.startY == this.finishY[this.index] || otherPath.finishX == this.finishX[this.index] && otherPath.finishY == this.finishY[this.index]) continue;
                return 0;
            }
        }
        int sum2 = 0;
        for (int i = 0; i < 12; ++i) {
            int status = this.map.getStatus(x + xValuesSurrounding[i] + diffX, y + yValuesSurrounding[i] + diffY, z);
            if (status != 0 && status != this.net.getNetID()) continue;
            ++sum2;
        }
        return sum2;
    }
}

