/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.ncc.processing;

import com.sun.electric.tool.ncc.NccGlobals;
import com.sun.electric.tool.ncc.NccOptions;
import com.sun.electric.tool.ncc.result.EquivRecReport;
import com.sun.electric.tool.ncc.result.NetObjReport;
import com.sun.electric.tool.ncc.strategy.StratCount;
import com.sun.electric.tool.ncc.trees.EquivRecord;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ReportHashCodeFailure {
    private NccGlobals globals;
    private List<EquivRecReport> badParts = new ArrayList<EquivRecReport>();
    private List<EquivRecReport> badWires = new ArrayList<EquivRecReport>();

    private static void prln(String s) {
        System.out.println(s);
    }

    private void printNotMatched(List<EquivRecReport> notMatched) {
        if (notMatched.size() == 0) {
            return;
        }
        String type = notMatched.get(0).hasParts() ? "Part" : "Wire";
        int num = notMatched.size();
        ReportHashCodeFailure.prln("  " + num + " not-matched " + type + " equivalence classes:");
        int maxNotMatches = this.globals.getOptions().maxMismatchedEquivRecsToPrint;
        if (num > maxNotMatches) {
            ReportHashCodeFailure.prln("    Too many, I'm only printing " + maxNotMatches + ".");
        }
        int numToPrint = Math.min(num, maxNotMatches);
        for (int rptNdx = 0; rptNdx < numToPrint; ++rptNdx) {
            ReportHashCodeFailure.prln("    not-matched " + type + " equivalence class " + rptNdx);
            EquivRecReport rpt = notMatched.get(rptNdx);
            List<List<NetObjReport>> netObjs = rpt.getNotMatchedNetObjs();
            for (int desNdx = 0; desNdx < netObjs.size(); ++desNdx) {
                List<NetObjReport> noD = netObjs.get(desNdx);
                ReportHashCodeFailure.prln("      Cell " + this.globals.getRootCellNames()[desNdx] + " has " + noD.size() + " mismatched objects");
                for (NetObjReport no : noD) {
                    ReportHashCodeFailure.prln("        " + no.fullDescription());
                }
            }
        }
    }

    private void printCounts() {
        NccOptions options = this.globals.getOptions();
        int saveHowMuchStatus = options.howMuchStatus;
        options.howMuchStatus = 10;
        StratCount.doYourJob(this.globals);
        options.howMuchStatus = saveHowMuchStatus;
    }

    public ReportHashCodeFailure(NccGlobals globals) {
        this.globals = globals;
        ReportHashCodeFailure.prln("Hash Code Partitioning Failed!!!");
        this.printCounts();
        Iterator<EquivRecord> it = globals.getPartLeafEquivRecs().getNotMatched();
        while (it.hasNext()) {
            this.badParts.add(new EquivRecReport(it.next(), true));
        }
        it = globals.getWireLeafEquivRecs().getNotMatched();
        while (it.hasNext()) {
            this.badWires.add(new EquivRecReport(it.next(), true));
        }
        this.printNotMatched(this.badParts);
        this.printNotMatched(this.badWires);
    }

    public List<EquivRecReport> getWireRecReports() {
        return this.badWires;
    }

    public List<EquivRecReport> getPartRecReports() {
        return this.badParts;
    }
}

