/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.project;

import com.sun.electric.database.CellBackup;
import com.sun.electric.database.CellRevision;
import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.ImmutableCell;
import com.sun.electric.database.ImmutableElectricObject;
import com.sun.electric.database.Snapshot;
import com.sun.electric.database.change.Undo;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.hierarchy.View;
import com.sun.electric.database.id.CellId;
import com.sun.electric.database.network.NetworkTool;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.text.Pref;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.JobException;
import com.sun.electric.tool.Listener;
import com.sun.electric.tool.io.input.Input;
import com.sun.electric.tool.io.input.LibraryFiles;
import com.sun.electric.tool.io.output.Output;
import com.sun.electric.tool.project.CheckOutJob;
import com.sun.electric.tool.project.ProjectCell;
import com.sun.electric.tool.project.ProjectDB;
import com.sun.electric.tool.project.ProjectLibrary;
import com.sun.electric.tool.user.ViewChanges;
import com.sun.electric.util.TextUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.SwingUtilities;

public class Project
extends Listener {
    public static final int NOTMANAGED = 0;
    public static final int CHECKEDIN = 1;
    public static final int CHECKEDOUTTOYOU = 2;
    public static final int CHECKEDOUTTOOTHERS = 3;
    public static final int OLDVERSION = 4;
    private static final Variable.Key PROJLOCKEDKEY = Variable.newKey("PROJ_locked");
    static final Variable.Key PROJPATHKEY = Variable.newKey("PROJ_path");
    static final Variable.Key PROJLIBRARYKEY = Variable.newKey("PROJ_library");
    static final String PROJECTFILE = "project.proj";
    private static Project tool = new Project();
    private static boolean ignoreChanges;
    private static List<FCheck> fCheckList;
    static boolean pmActive;
    static ProjectDB projectDB;
    private static boolean alwaysCheckOut;
    private static Pref cacheCurrentUserName;
    private static Pref cacheRepositoryLocation;
    private static Pref cacheAuthorizationPassword;

    private Project() {
        super("project");
    }

    @Override
    public void init() {
        this.setOn();
        pmActive = false;
        ignoreChanges = false;
    }

    public static Project getProjectTool() {
        return tool;
    }

    public static boolean isLibraryManaged(Library lib) {
        ProjectLibrary pl = projectDB.findProjectLibrary(lib);
        return !pl.isEmpty();
    }

    public static int getCellStatus(Cell cell) {
        Cell newestVersion = cell.getNewestVersion();
        ProjectCell pc = projectDB.findProjectCell(newestVersion);
        if (pc == null) {
            return 0;
        }
        if (newestVersion != cell) {
            return 4;
        }
        if (pc.getOwner().length() == 0) {
            return 1;
        }
        if (pc.getOwner().equals(Project.getCurrentUserName())) {
            return 2;
        }
        return 3;
    }

    public static String getCellOwner(Cell cell) {
        ProjectCell pc = projectDB.findProjectCell(cell);
        if (pc == null) {
            return "";
        }
        return pc.getOwner();
    }

    @Override
    public void endBatch(Snapshot oldSnapshot, Snapshot newSnapshot, boolean undoRedo) {
        int batchNumber = newSnapshot.snapshotId;
        for (CellId cellId : newSnapshot.getChangedCells(oldSnapshot)) {
            CellBackup newBackup;
            CellBackup oldBackup = oldSnapshot.getCell(cellId);
            if (!this.cellChanged(oldBackup, newBackup = newSnapshot.getCell(cellId))) continue;
            Project.queueCheck(cellId, batchNumber);
        }
        Project.detectIllegalChanges();
        ignoreChanges = false;
    }

    @Override
    public void readLibrary(Library lib) {
        if (ignoreChanges) {
            return;
        }
        Iterator<Cell> it = lib.getCells();
        while (it.hasNext()) {
            Cell cell = it.next();
            if (cell.getVar(PROJLOCKEDKEY) == null) continue;
            pmActive = true;
            projectDB.findProjectLibrary(lib);
        }
    }

    private static void detectIllegalChanges() {
        if (!pmActive) {
            return;
        }
        if (fCheckList.size() == 0) {
            return;
        }
        int lowBatch = Integer.MAX_VALUE;
        ArrayList<Cell> cellsThatChanged = new ArrayList<Cell>();
        for (FCheck f : fCheckList) {
            Cell cell = Cell.inCurrentThread(f.entry);
            if (cell == null || cell.getVar(PROJLOCKEDKEY) == null) continue;
            cellsThatChanged.add(cell);
            if (f.batchNumber >= lowBatch) continue;
            lowBatch = f.batchNumber;
        }
        fCheckList.clear();
        if (cellsThatChanged.size() > 0) {
            SwingUtilities.invokeLater(new UndoRunnable(lowBatch, cellsThatChanged));
        }
    }

    private boolean cellChanged(CellBackup oldBackup, CellBackup newBackup) {
        if (oldBackup == null || newBackup == null) {
            return true;
        }
        assert (oldBackup != newBackup);
        CellRevision oldRevision = oldBackup.cellRevision;
        CellRevision newRevision = newBackup.cellRevision;
        if (oldRevision.nodes != newRevision.nodes) {
            return true;
        }
        if (oldRevision.arcs != newRevision.arcs) {
            return true;
        }
        if (oldRevision.exports != newRevision.exports) {
            return true;
        }
        ImmutableCell oldD = oldRevision.d;
        ImmutableCell newD = newRevision.d;
        if (!oldD.equalsExceptVariables(newD)) {
            return true;
        }
        int oldLength = oldD.getNumVariables();
        int newLength = newD.getNumVariables();
        int oldIndex = oldD.searchVar(PROJLOCKEDKEY);
        int newIndex = newD.searchVar(PROJLOCKEDKEY);
        if (oldLength == newLength) {
            if (oldIndex != newIndex) {
                return true;
            }
            if (oldIndex < 0) {
                return this.variablesDiffers(oldD, 0, newD, 0, oldLength);
            }
            return this.variablesDiffers(oldD, 0, newD, 0, oldIndex) || this.variablesDiffers(oldD, oldIndex + 1, newD, oldIndex + 1, oldLength - oldIndex - 1);
        }
        if (oldLength == newLength + 1) {
            if (oldIndex < 0 || oldIndex != ~newIndex) {
                return true;
            }
            return this.variablesDiffers(oldD, 0, newD, 0, oldIndex) || this.variablesDiffers(oldD, oldIndex + 1, newD, ~newIndex, oldLength - oldIndex - 1);
        }
        if (newLength == oldIndex + 1) {
            if (newIndex < 0 || newIndex != ~oldIndex) {
                return true;
            }
            return this.variablesDiffers(oldD, 0, newD, 0, newIndex) || this.variablesDiffers(oldD, newIndex, newD, newIndex + 1, newLength - newIndex - 1);
        }
        return true;
    }

    private boolean variablesDiffers(ImmutableElectricObject oldImmutable, int oldStart, ImmutableElectricObject newImmutable, int newStart, int count) {
        for (int i = 0; i < count; ++i) {
            if (oldImmutable.getVar(oldStart + i) == newImmutable.getVar(newStart + i)) continue;
            return true;
        }
        return false;
    }

    private static void queueCheck(CellId cellId, int batchNumber) {
        for (FCheck f : fCheckList) {
            if (f.entry != cellId || f.batchNumber != batchNumber) continue;
            return;
        }
        FCheck f = new FCheck();
        f.entry = cellId;
        f.batchNumber = batchNumber;
        fCheckList.add(f);
    }

    static boolean ensureRepository() {
        if (Project.getRepositoryLocation().length() == 0) {
            Job.getUserInterface().showInformationMessage("Before entering a library, set a repository location in the 'Project Management' tab under General Preferences", "Must Setup Project Management");
            return true;
        }
        return false;
    }

    static void setChangeStatus(boolean quiet) {
        if (quiet) {
            ignoreChanges = quiet;
        }
        Input.changesQuiet(quiet);
    }

    static void markLocked(Cell cell, boolean locked, EditingPreferences ep) {
        Cell.CellGroup cg = cell.getCellGroup();
        if (cg == null) {
            return;
        }
        if (!locked) {
            Iterator<Cell> it = cg.getCells();
            while (it.hasNext()) {
                Cell oCell = it.next();
                if (oCell.getView() != cell.getView() || oCell.getVar(PROJLOCKEDKEY) == null) continue;
                oCell.delVar(PROJLOCKEDKEY);
            }
        } else {
            Iterator<Cell> it = cg.getCells();
            while (it.hasNext()) {
                Cell oCell = it.next();
                if (oCell.getView() != cell.getView()) continue;
                if (oCell.getNewestVersion() == oCell) {
                    if (oCell.getVar(PROJLOCKEDKEY) != null) continue;
                    oCell.newVar(PROJLOCKEDKEY, (Object)1, ep);
                    continue;
                }
                if (oCell.getVar(PROJLOCKEDKEY) == null) continue;
                oCell.delVar(PROJLOCKEDKEY);
            }
        }
    }

    static void getCellFromRepository(ProjectDB pdb, ProjectCell pc, Library lib, boolean recursively, boolean report, EditingPreferences ep) {
        ProjectLibrary pl = pc.getProjectLibrary();
        String libName = pl.getProjectDirectory() + File.separator + pc.getCellName() + File.separator + pc.getVersion() + "-" + pc.getView().getFullName() + "." + pc.getLibExtension();
        Cell newCell = null;
        String tempLibName = Project.getTempLibraryName();
        NetworkTool.setInformationOutput(false);
        Library fLib = LibraryFiles.readLibrary(ep, TextUtils.makeURLToFile(libName), tempLibName, pc.getLibType(), true);
        NetworkTool.setInformationOutput(true);
        if (fLib == null) {
            System.out.println("Cannot read library " + libName);
        } else {
            String cellNameInRepository = pc.describe();
            Cell cur = fLib.findNodeProto(cellNameInRepository);
            if (cur == null) {
                System.out.println("Cannot find cell " + cellNameInRepository + " in library " + libName);
            } else {
                HashMap<NodeInst, NodeProto> nodePrototypes = new HashMap<NodeInst, NodeProto>();
                Iterator<NodeInst> it = cur.getNodes();
                while (it.hasNext()) {
                    NodeInst ni = it.next();
                    if (!ni.isCellInstance()) continue;
                    Cell subCell = (Cell)ni.getProto();
                    Library subLib = lib;
                    String cellName = subCell.noLibDescribe();
                    Variable var = subCell.getVar(PROJLIBRARYKEY);
                    if (var != null) {
                        String subLibName = (String)var.getObject();
                        subLib = Library.findLibrary(subLibName);
                        if (cellName.startsWith(subLibName + "__")) {
                            cellName = cellName.substring(subLibName.length() + 2);
                        }
                        if (subLib == null && recursively) {
                            subLib = Library.newInst(subLibName, null);
                            String projFile = Project.getRepositoryLocation() + File.separator + subLibName + File.separator + PROJECTFILE;
                            File pf = new File(projFile);
                            if (!pf.exists()) {
                                System.out.println("Cannot find project file '" + projFile + "'...retrieve aborted.");
                            } else {
                                subLib.newVar(PROJPATHKEY, (Object)projFile, ep);
                                ProjectLibrary subPL = pdb.findProjectLibrary(subLib);
                                String userName = Project.getCurrentUserName();
                                Iterator<ProjectCell> pIt = subPL.getProjectCells();
                                while (pIt.hasNext()) {
                                    ProjectCell recPC = pIt.next();
                                    if (!recPC.isLatestVersion()) continue;
                                    if (recPC.getCell() == null) {
                                        Project.getCellFromRepository(pdb, recPC, subLib, true, report, ep);
                                        if (recPC.getCell() == null) {
                                            System.out.println("Error retrieving cell from repository");
                                        }
                                    }
                                    if (recPC.getCell() == null) continue;
                                    boolean youOwn = userName.length() > 0 && recPC.getOwner().equals(userName);
                                    Project.markLocked(recPC.getCell(), !youOwn, ep);
                                }
                            }
                        }
                    }
                    Cell realSubCell = null;
                    if (subLib != null) {
                        realSubCell = subLib.findNodeProto(cellName);
                    }
                    if (realSubCell == null && recursively) {
                        ProjectLibrary subPL = pdb.findProjectLibrary(subLib);
                        ProjectCell subPC = subPL.findProjectCellByNameViewVersion(subCell.getName(), subCell.getView(), subCell.getVersion());
                        if (subPC == null) {
                            Iterator<ProjectCell> pIt = subPL.getProjectCells();
                            while (pIt.hasNext()) {
                                ProjectCell oPc = pIt.next();
                                if (!oPc.getCellName().equals(subCell.getName()) || oPc.getView() != subCell.getView() || subPC != null && subPC.getVersion() > oPc.getVersion()) continue;
                                subPC = oPc;
                            }
                        }
                        if (subPC != null) {
                            if (subPC.getCell() != null) {
                                System.out.println("ERROR: cell " + cellName + " does not exist, but it appears as " + subPC.getCell());
                            }
                            Project.getCellFromRepository(pdb, subPC, subLib, recursively, false, ep);
                            realSubCell = subPC.getCell();
                        }
                    }
                    if (realSubCell == null) {
                        System.out.println("Cannot find subcell " + cellName + " referenced by cell " + cellNameInRepository);
                        continue;
                    }
                    nodePrototypes.put(ni, realSubCell);
                }
                String cellName = Project.describeFullCellName(cur);
                if (report) {
                    System.out.println("Retrieving cell " + lib.getName() + ":" + cellName);
                }
                if ((newCell = Cell.copyNodeProtoUsingMapping(cur, lib, cellName, nodePrototypes)) == null) {
                    System.out.println("Cannot copy " + cur + " from new library");
                }
            }
            fLib.kill("delete");
        }
        if (newCell != null) {
            pl.linkProjectCellToCell(pc, newCell);
        }
    }

    static boolean useNewestVersion(Cell oldCell, Cell newCell, EditingPreferences ep) {
        ArrayList<NodeInst> instances = new ArrayList<NodeInst>();
        Iterator<NodeInst> it = oldCell.getInstancesOf();
        while (it.hasNext()) {
            instances.add(it.next());
        }
        for (NodeInst ni : instances) {
            NodeInst newNi = ni.replace(newCell, ep, false, false, false);
            if (newNi != null) continue;
            System.out.println("Failed to update instance of " + newCell + " in " + ni.getParent());
            return true;
        }
        oldCell.kill();
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean writeCell(Cell cell, ProjectCell pc, int backupScheme, EditingPreferences ep) throws JobException {
        String dirName = pc.getProjectLibrary().getProjectDirectory() + File.separator + cell.getName();
        File dir = new File(dirName);
        if (!dir.exists() && !dir.mkdir()) {
            System.out.println("Unable to create directory " + dirName);
            return true;
        }
        String extension = pc.getLibType().getFirstExtension();
        String libName = dirName + File.separator + cell.getVersion() + "-" + cell.getView().getFullName() + "." + extension;
        String tempLibName = Project.getTempLibraryName();
        Library fLib = Library.newInst(tempLibName, TextUtils.makeURLToFile(libName));
        if (fLib == null) {
            System.out.println("Cannot create library " + libName);
            return true;
        }
        Cell cellCopy = Project.copyRecursively(cell, fLib, ep);
        if (cellCopy == null) {
            System.out.println("Could not place " + cell + " in a library");
            fLib.kill("delete");
            return true;
        }
        fLib.setFromDisk();
        boolean error = true;
        try {
            Output.writeLibrary(fLib, pc.getLibType(), false, true, false, backupScheme);
            error = false;
        }
        finally {
            if (error) {
                System.out.println("Could not save library with " + cell + " in it");
                fLib.kill("delete");
            }
        }
        fLib.kill("delete");
        return false;
    }

    static String getTempLibraryName() {
        int i = 1;
        String libName;
        while (Library.findLibrary(libName = "projecttemp" + i) != null) {
            ++i;
        }
        return libName;
    }

    static String describeFullCellName(Cell cell) {
        String cellName = cell.getName() + ";" + cell.getVersion();
        if (cell.getView() != View.UNKNOWN) {
            cellName = cellName + cell.getView().getAbbreviationExtension();
        }
        return cellName;
    }

    private static Cell copyRecursively(Cell fromCell, Library toLib, EditingPreferences ep) {
        Cell newFromCell = toLib.findNodeProto(fromCell.noLibDescribe());
        if (newFromCell != null) {
            return newFromCell;
        }
        HashMap<NodeInst, NodeProto> nodePrototypes = new HashMap<NodeInst, NodeProto>();
        Iterator<NodeInst> it = fromCell.getNodes();
        while (it.hasNext()) {
            Cell oCell;
            Cell cell;
            NodeInst ni = it.next();
            NodeProto np = ni.getProto();
            nodePrototypes.put(ni, np);
            if (!ni.isCellInstance() || (cell = (Cell)np).getView().isTextView()) continue;
            Object subCellName = Project.describeFullCellName(cell);
            if (cell.getLibrary() != fromCell.getLibrary()) {
                subCellName = cell.getLibrary().getName() + "__" + (String)subCellName;
            }
            if ((oCell = toLib.findNodeProto((String)subCellName)) == null) {
                oCell = Cell.makeInstance(ep, toLib, (String)subCellName);
                if (oCell == null) {
                    System.out.println("Could not create subcell " + (String)subCellName);
                    continue;
                }
                if (cell.getLibrary() != fromCell.getLibrary()) {
                    oCell.newVar(PROJLIBRARYKEY, (Object)cell.getLibrary().getName(), ep);
                }
                if (ViewChanges.skeletonizeCell(cell, oCell, ep)) {
                    System.out.println("Copy of sub" + cell + " failed");
                    return null;
                }
            }
            nodePrototypes.put(ni, oCell);
        }
        newFromCell = Cell.copyNodeProtoUsingMapping(fromCell, toLib, Project.describeFullCellName(fromCell), nodePrototypes);
        return newFromCell;
    }

    public static String getCurrentUserName() {
        return cacheCurrentUserName.getString();
    }

    public static void setCurrentUserName(String u) {
        cacheCurrentUserName.setString(u);
    }

    public static String getFactoryCurrentUserName() {
        return cacheCurrentUserName.getStringFactoryValue();
    }

    public static String getRepositoryLocation() {
        return cacheRepositoryLocation.getString();
    }

    public static void setRepositoryLocation(String r) {
        boolean alter = Project.getRepositoryLocation().length() > 0;
        cacheRepositoryLocation.setString(r);
        if (alter) {
            projectDB.clearDatabase();
        }
    }

    public static String getFactoryRepositoryLocation() {
        return cacheRepositoryLocation.getStringFactoryValue();
    }

    public static String getAuthorizationPassword() {
        return cacheAuthorizationPassword.getString();
    }

    public static void setAuthorizationPassword(String a) {
        cacheAuthorizationPassword.setString(a);
    }

    static {
        fCheckList = new ArrayList<FCheck>();
        projectDB = new ProjectDB();
        alwaysCheckOut = false;
        cacheCurrentUserName = Pref.makeStringPref("CurrentUserName", Project.tool.prefs, "");
        cacheRepositoryLocation = Pref.makeStringPref("RepositoryLocation", Project.tool.prefs, "");
        cacheAuthorizationPassword = Pref.makeStringPref("e", Project.tool.prefs, "e");
    }

    private static class FCheck {
        CellId entry;
        int batchNumber;

        private FCheck() {
        }
    }

    private static class UndoRunnable
    implements Runnable {
        private int lowBatch;
        private List<Cell> cellsThatChanged;

        UndoRunnable(int lowBatch, List<Cell> cellsThatChanged) {
            this.lowBatch = lowBatch;
            this.cellsThatChanged = cellsThatChanged;
        }

        @Override
        public void run() {
            boolean undoChange = true;
            if (alwaysCheckOut) {
                undoChange = false;
            } else {
                Object errorMsg = "";
                for (Cell cell : this.cellsThatChanged) {
                    if (((String)errorMsg).length() > 0) {
                        errorMsg = (String)errorMsg + ", ";
                    }
                    errorMsg = (String)errorMsg + cell.describe(true);
                }
                int ret = 1;
                if (ret == 0) {
                    undoChange = false;
                }
                if (ret == 2) {
                    alwaysCheckOut = true;
                    undoChange = false;
                }
            }
            if (undoChange) {
                new UndoBatchesJob(this.lowBatch);
            } else {
                new CheckOutJob(this.cellsThatChanged, true);
            }
        }
    }

    private static class UndoBatchesJob
    extends Undo.UndoJob {
        private UndoBatchesJob(int lowestBatch) {
            super("Undo changes to locked cells", lowestBatch);
        }

        @Override
        public void terminateOK() {
            Undo.noRedoAllowed();
        }
    }
}

