/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs.options;

import com.sun.electric.tool.ncc.NccJob;
import com.sun.electric.tool.ncc.NccPreferences;
import com.sun.electric.tool.user.dialogs.EDialog;
import com.sun.electric.tool.user.dialogs.options.PreferencePanel;
import com.sun.electric.util.TextUtils;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class NCCTab
extends PreferencePanel {
    private JTextField absoluteSizeTolerance;
    private JPanel bodyChecking;
    private JPanel checkingAllCells;
    private JCheckBox enableBodyChecking;
    private JCheckBox enableSizeChecking;
    private JPanel errorReport;
    private JRadioButton flatTop;
    private JCheckBox haltAfterFindingFirstMismatchedCell;
    private JRadioButton hierAll;
    private JTextField howMuchStatus;
    private JCheckBox enableResistorChecking;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel75;
    private JLabel jLabel76;
    private JRadioButton listAnn;
    private JTextField maxMatched;
    private JTextField maxMembers;
    private JTextField maxMismatched;
    private JPanel ncc;
    private JPanel operation;
    private ButtonGroup operationGroup;
    private JPanel progressReport;
    private JTextField relativeSizeTolerance;
    private JPanel sizeChecking;
    private JCheckBox skipPassed;

    public NCCTab(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        EDialog.makeTextFieldSelectAllOnTab(this.relativeSizeTolerance);
        EDialog.makeTextFieldSelectAllOnTab(this.absoluteSizeTolerance);
        EDialog.makeTextFieldSelectAllOnTab(this.howMuchStatus);
        EDialog.makeTextFieldSelectAllOnTab(this.maxMatched);
        EDialog.makeTextFieldSelectAllOnTab(this.maxMismatched);
        EDialog.makeTextFieldSelectAllOnTab(this.maxMembers);
    }

    @Override
    public JPanel getUserPreferencesPanel() {
        return this.ncc;
    }

    @Override
    public String getName() {
        return "NCC";
    }

    private void setOperation(int op) {
        switch (op) {
            case 0: {
                this.hierAll.setSelected(true);
                break;
            }
            case 2: {
                this.flatTop.setSelected(true);
                break;
            }
            case 3: {
                this.listAnn.setSelected(true);
                break;
            }
            default: {
                this.hierAll.setSelected(true);
            }
        }
    }

    private int getOperation() {
        if (this.hierAll.isSelected()) {
            return 0;
        }
        if (this.flatTop.isSelected()) {
            return 2;
        }
        if (this.listAnn.isSelected()) {
            return 3;
        }
        return 0;
    }

    @Override
    public void init() {
        this.enableSizeChecking.setSelected(NccPreferences.getCheckSizes());
        this.enableResistorChecking.setSelected(NccPreferences.getCheckResistors());
        this.relativeSizeTolerance.setText(Double.toString(NccPreferences.getRelativeSizeTolerance()));
        this.absoluteSizeTolerance.setText(Double.toString(NccPreferences.getAbsoluteSizeTolerance()));
        this.enableBodyChecking.setSelected(NccPreferences.getCheckBody());
        this.haltAfterFindingFirstMismatchedCell.setSelected(NccPreferences.getHaltAfterFirstMismatch());
        this.skipPassed.setSelected(NccPreferences.getSkipPassed());
        this.maxMatched.setText(Integer.toString(NccPreferences.getMaxMatchedClasses()));
        this.maxMismatched.setText(Integer.toString(NccPreferences.getMaxMismatchedClasses()));
        this.maxMembers.setText(Integer.toString(NccPreferences.getMaxClassMembers()));
        this.setOperation(NccPreferences.getOperation());
        this.howMuchStatus.setText(Integer.toString(NccPreferences.getHowMuchStatus()));
    }

    @Override
    public void term() {
        int currInt;
        double currDouble;
        boolean currBoolean = this.enableSizeChecking.isSelected();
        if (currBoolean != NccPreferences.getCheckSizes()) {
            NccPreferences.setCheckSizes(currBoolean);
        }
        if ((currBoolean = this.enableResistorChecking.isSelected()) != NccPreferences.getCheckResistors()) {
            NccPreferences.setCheckResistors(currBoolean);
        }
        if ((currDouble = TextUtils.atof(this.relativeSizeTolerance.getText(), NccPreferences.getRelativeSizeTolerance())) != NccPreferences.getRelativeSizeTolerance()) {
            NccPreferences.setRelativeSizeTolerance(currDouble);
        }
        if ((currDouble = TextUtils.atof(this.absoluteSizeTolerance.getText(), NccPreferences.getAbsoluteSizeTolerance())) != NccPreferences.getAbsoluteSizeTolerance()) {
            NccPreferences.setAbsoluteSizeTolerance(currDouble);
        }
        if ((currBoolean = this.enableBodyChecking.isSelected()) != NccPreferences.getCheckBody()) {
            NccPreferences.setCheckBody(currBoolean);
        }
        if ((currBoolean = this.haltAfterFindingFirstMismatchedCell.isSelected()) != NccPreferences.getHaltAfterFirstMismatch()) {
            NccPreferences.setHaltAfterFirstMismatch(currBoolean);
        }
        if ((currBoolean = this.skipPassed.isSelected()) != NccPreferences.getSkipPassed()) {
            NccPreferences.setSkipPassed(currBoolean);
        }
        if ((currInt = Integer.parseInt(this.maxMatched.getText())) != NccPreferences.getMaxMatchedClasses()) {
            NccPreferences.setMaxMatchedClasses(currInt);
        }
        if ((currInt = Integer.parseInt(this.maxMismatched.getText())) != NccPreferences.getMaxMismatchedClasses()) {
            NccPreferences.setMaxMismatchedClasses(currInt);
        }
        if ((currInt = Integer.parseInt(this.maxMembers.getText())) != NccPreferences.getMaxClassMembers()) {
            NccPreferences.setMaxClassMembers(currInt);
        }
        if ((currInt = this.getOperation()) != NccPreferences.getOperation()) {
            NccPreferences.setOperation(currInt);
        }
        if ((currInt = Integer.parseInt(this.howMuchStatus.getText())) != NccPreferences.getHowMuchStatus()) {
            NccPreferences.setHowMuchStatus(currInt);
        }
        NccJob.invalidateLastNccResult();
    }

    @Override
    public void reset() {
        if (NccPreferences.getFactoryOperation() != NccPreferences.getOperation()) {
            NccPreferences.setOperation(NccPreferences.getFactoryOperation());
        }
        if (NccPreferences.getFactoryCheckSizes() != NccPreferences.getCheckSizes()) {
            NccPreferences.setCheckSizes(NccPreferences.getFactoryCheckSizes());
        }
        if (NccPreferences.getFactoryCheckResistors() != NccPreferences.getCheckResistors()) {
            NccPreferences.setCheckResistors(NccPreferences.getFactoryCheckResistors());
        }
        if (NccPreferences.getFactoryRelativeSizeTolerance() != NccPreferences.getRelativeSizeTolerance()) {
            NccPreferences.setRelativeSizeTolerance(NccPreferences.getFactoryRelativeSizeTolerance());
        }
        if (NccPreferences.getFactoryAbsoluteSizeTolerance() != NccPreferences.getAbsoluteSizeTolerance()) {
            NccPreferences.setAbsoluteSizeTolerance(NccPreferences.getFactoryAbsoluteSizeTolerance());
        }
        if (NccPreferences.getFactoryHaltAfterFirstMismatch() != NccPreferences.getHaltAfterFirstMismatch()) {
            NccPreferences.setHaltAfterFirstMismatch(NccPreferences.getFactoryHaltAfterFirstMismatch());
        }
        if (NccPreferences.getFactorySkipPassed() != NccPreferences.getSkipPassed()) {
            NccPreferences.setSkipPassed(NccPreferences.getFactorySkipPassed());
        }
        if (NccPreferences.getFactoryHowMuchStatus() != NccPreferences.getHowMuchStatus()) {
            NccPreferences.setHowMuchStatus(NccPreferences.getFactoryHowMuchStatus());
        }
        if (NccPreferences.getFactoryMaxMismatchedClasses() != NccPreferences.getMaxMismatchedClasses()) {
            NccPreferences.setMaxMatchedClasses(NccPreferences.getFactoryMaxMatchedClasses());
        }
        if (NccPreferences.getFactoryMaxMismatchedClasses() != NccPreferences.getMaxMismatchedClasses()) {
            NccPreferences.setMaxMismatchedClasses(NccPreferences.getFactoryMaxMismatchedClasses());
        }
        if (NccPreferences.getFactoryMaxClassMembers() != NccPreferences.getMaxClassMembers()) {
            NccPreferences.setMaxClassMembers(NccPreferences.getFactoryMaxClassMembers());
        }
    }

    private void initComponents() {
        this.operationGroup = new ButtonGroup();
        this.ncc = new JPanel();
        this.operation = new JPanel();
        this.hierAll = new JRadioButton();
        this.flatTop = new JRadioButton();
        this.listAnn = new JRadioButton();
        this.sizeChecking = new JPanel();
        this.enableSizeChecking = new JCheckBox();
        this.jLabel75 = new JLabel();
        this.jLabel76 = new JLabel();
        this.relativeSizeTolerance = new JTextField();
        this.absoluteSizeTolerance = new JTextField();
        this.enableResistorChecking = new JCheckBox();
        this.bodyChecking = new JPanel();
        this.enableBodyChecking = new JCheckBox();
        this.checkingAllCells = new JPanel();
        this.haltAfterFindingFirstMismatchedCell = new JCheckBox();
        this.skipPassed = new JCheckBox();
        this.progressReport = new JPanel();
        this.jLabel4 = new JLabel();
        this.howMuchStatus = new JTextField();
        this.errorReport = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.maxMatched = new JTextField();
        this.maxMismatched = new JTextField();
        this.maxMembers = new JTextField();
        this.setTitle("Tool Options");
        this.setName("");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                NCCTab.this.closeDialog(evt);
            }
        });
        this.getContentPane().setLayout(new GridBagLayout());
        this.ncc.setLayout(new GridBagLayout());
        this.operation.setBorder(BorderFactory.createTitledBorder("Operations"));
        this.operation.setLayout(new GridBagLayout());
        this.operationGroup.add(this.hierAll);
        this.hierAll.setText("Hierarchical Comparison");
        this.hierAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NCCTab.this.hierAllActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        this.operation.add((Component)this.hierAll, gridBagConstraints);
        this.operationGroup.add(this.flatTop);
        this.flatTop.setText("Flat Comparison");
        this.flatTop.setActionCommand("Flat NCC");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        this.operation.add((Component)this.flatTop, gridBagConstraints);
        this.operationGroup.add(this.listAnn);
        this.listAnn.setText("List NCC annotations");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        this.operation.add((Component)this.listAnn, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        this.ncc.add((Component)this.operation, gridBagConstraints);
        this.sizeChecking.setBorder(BorderFactory.createTitledBorder("Size Checking"));
        this.sizeChecking.setLayout(new GridBagLayout());
        this.enableSizeChecking.setText("Check component sizes");
        this.enableSizeChecking.setActionCommand("Check component Sizes");
        this.enableSizeChecking.setHorizontalTextPosition(10);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        this.sizeChecking.add((Component)this.enableSizeChecking, gridBagConstraints);
        this.jLabel75.setText("Relative size tolerance  (%):");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.sizeChecking.add((Component)this.jLabel75, gridBagConstraints);
        this.jLabel76.setText("Absolute size tolerance (units):");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.sizeChecking.add((Component)this.jLabel76, gridBagConstraints);
        this.relativeSizeTolerance.setColumns(6);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.sizeChecking.add((Component)this.relativeSizeTolerance, gridBagConstraints);
        this.absoluteSizeTolerance.setColumns(6);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.sizeChecking.add((Component)this.absoluteSizeTolerance, gridBagConstraints);
        this.enableResistorChecking.setText("Check Resistors");
        this.enableResistorChecking.setHorizontalTextPosition(10);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        this.sizeChecking.add((Component)this.enableResistorChecking, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        this.ncc.add((Component)this.sizeChecking, gridBagConstraints);
        this.bodyChecking.setBorder(BorderFactory.createTitledBorder("Body Checking"));
        this.bodyChecking.setLayout(new GridBagLayout());
        this.enableBodyChecking.setText("Check transistor body connections");
        this.enableBodyChecking.setHorizontalTextPosition(10);
        this.bodyChecking.add((Component)this.enableBodyChecking, new GridBagConstraints());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        this.ncc.add((Component)this.bodyChecking, gridBagConstraints);
        this.checkingAllCells.setBorder(BorderFactory.createTitledBorder("Checking All Cells"));
        this.checkingAllCells.setLayout(new GridBagLayout());
        this.haltAfterFindingFirstMismatchedCell.setText("Halt after finding the first mismatched cell");
        this.haltAfterFindingFirstMismatchedCell.setActionCommand("Halt on First Mismatched Cell");
        this.haltAfterFindingFirstMismatchedCell.setHorizontalTextPosition(10);
        this.checkingAllCells.add((Component)this.haltAfterFindingFirstMismatchedCell, new GridBagConstraints());
        this.skipPassed.setText("Don't recheck cells that have passed in this Electric run");
        this.skipPassed.setHorizontalTextPosition(10);
        this.skipPassed.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NCCTab.this.skipPassedActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        this.checkingAllCells.add((Component)this.skipPassed, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        this.ncc.add((Component)this.checkingAllCells, gridBagConstraints);
        this.progressReport.setBorder(BorderFactory.createTitledBorder("Reporting Progress"));
        this.progressReport.setLayout(new GridBagLayout());
        this.jLabel4.setText("How many status messages to print (0->few, 3->many):");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.progressReport.add((Component)this.jLabel4, gridBagConstraints);
        this.howMuchStatus.setColumns(6);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        this.progressReport.add((Component)this.howMuchStatus, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        this.ncc.add((Component)this.progressReport, gridBagConstraints);
        this.errorReport.setBorder(BorderFactory.createTitledBorder("Error Reporting"));
        this.errorReport.setLayout(new GridBagLayout());
        this.jLabel1.setLabelFor(this.maxMatched);
        this.jLabel1.setText("Maximum number of matched equivalence classes to print");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.errorReport.add((Component)this.jLabel1, gridBagConstraints);
        this.jLabel2.setLabelFor(this.maxMismatched);
        this.jLabel2.setText("Maximum number of mismatched equivalence classes to print");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.errorReport.add((Component)this.jLabel2, gridBagConstraints);
        this.jLabel3.setLabelFor(this.maxMembers);
        this.jLabel3.setText("Maximum number of equivalence class members to print");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.errorReport.add((Component)this.jLabel3, gridBagConstraints);
        this.maxMatched.setColumns(6);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        this.errorReport.add((Component)this.maxMatched, gridBagConstraints);
        this.maxMismatched.setColumns(6);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        this.errorReport.add((Component)this.maxMismatched, gridBagConstraints);
        this.maxMembers.setColumns(6);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        this.errorReport.add((Component)this.maxMembers, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        this.ncc.add((Component)this.errorReport, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.getContentPane().add((Component)this.ncc, gridBagConstraints);
        this.pack();
    }

    private void hierAllActionPerformed(ActionEvent evt) {
    }

    private void skipPassedActionPerformed(ActionEvent evt) {
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }
}

