/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.util.concurrent.datastructures;

import com.sun.electric.tool.util.concurrent.datastructures.IStructure;
import java.util.concurrent.atomic.AtomicReference;

public class LockFreeQueue<T>
extends IStructure<T> {
    AtomicReference<IStructure.Node<T>> head = null;
    AtomicReference<IStructure.Node<T>> tail = null;

    public LockFreeQueue() {
        IStructure.Node<Object> dummy = new IStructure.Node<Object>(null);
        this.head = new AtomicReference<IStructure.Node<Object>>(dummy);
        this.tail = new AtomicReference<IStructure.Node<Object>>(dummy);
    }

    @Override
    public void add(T item) {
        IStructure.Node<T> node = new IStructure.Node<T>(item);
        while (true) {
            IStructure.Node<T> last = this.tail.get();
            IStructure.Node next = last.next.get();
            if (last != this.tail.get()) continue;
            if (next == null) {
                if (!last.next.compareAndSet(next, node)) continue;
                this.tail.compareAndSet(last, node);
                return;
            }
            this.tail.compareAndSet(last, next);
        }
    }

    @Override
    public boolean isEmpty() {
        IStructure.Node<T> first = this.head.get();
        IStructure.Node<T> last = this.tail.get();
        IStructure.Node next = first.next.get();
        return first == this.head.get() && first == last && next == null;
    }

    @Override
    public T remove() {
        Object value;
        while (true) {
            IStructure.Node<T> first = this.head.get();
            IStructure.Node<T> last = this.tail.get();
            IStructure.Node next = first.next.get();
            if (first != this.head.get()) continue;
            if (first == last) {
                if (next == null) {
                    return null;
                }
                this.tail.compareAndSet(last, next);
                continue;
            }
            value = next.value;
            if (this.head.compareAndSet(first, next)) break;
        }
        return value;
    }
}

