#
# This file is part of the coreboot project.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License as
# published by the Free Software Foundation; version 2 of
# the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#

###############################################################################
# MIPS specific options
###############################################################################

ifeq ($(CONFIG_ARCH_RAMSTAGE_MIPS),y)
check-ramstage-overlap-regions += stack
endif

###############################################################################
# bootblock
###############################################################################

ifeq ($(CONFIG_ARCH_BOOTBLOCK_MIPS),y)

bootblock-y += boot.c
bootblock-y += bootblock.S
bootblock-y += bootblock_simple.c
bootblock-y += cache.c
bootblock-y += mmu.c
bootblock-y += stages.c
bootblock-y += ../../lib/memcpy.c
bootblock-y += ../../lib/memmove.c
bootblock-y += ../../lib/memset.c

# Much of the assembly code is generated by the compiler, and may contain
# terms which the preprocessor will happily go on to replace. For example
# "mips" would be replaced with "1". Clear all the built in definitions to
# prevent that.
bootblock-S-ccopts += -undef

$(objcbfs)/bootblock.debug: $$(bootblock-objs) $(obj)/config.h
	@printf "    LINK       $(subst $(obj)/,,$(@))\n"
	$(LD_bootblock) $(LDFLAGS_bootblock) -o $@ -L$(obj) -T $(call src-to-obj,bootblock,src/mainboard/$(MAINBOARDDIR)/memlayout.ld) --whole-archive --start-group $(filter-out %.ld,$(bootblock-objs)) --end-group

endif # CONFIG_ARCH_BOOTBLOCK_MIPS

###############################################################################
# romstage
###############################################################################

ifeq ($(CONFIG_ARCH_ROMSTAGE_MIPS),y)

romstage-y += boot.c
romstage-y += cache.c
romstage-y += mmu.c
romstage-y += stages.c
romstage-y += ../../lib/memcpy.c
romstage-y += ../../lib/memmove.c
romstage-y += ../../lib/memset.c

$(objcbfs)/romstage.debug: $$(romstage-objs)
	@printf "    LINK       $(subst $(obj)/,,$(@))\n"
	$(LD_romstage) $(LDFLAGS_romstage) -o $@ -L$(obj) -T $(call src-to-obj,romstage,src/mainboard/$(MAINBOARDDIR)/memlayout.ld) --whole-archive --start-group $(filter-out %.ld,$(romstage-objs)) --end-group

endif # CONFIG_ARCH_ROMSTAGE_MIPS

###############################################################################
# ramstage
###############################################################################

ifeq ($(CONFIG_ARCH_RAMSTAGE_MIPS),y)

ramstage-y += ashldi3.c
ramstage-y += boot.c
ramstage-y += cache.c
ramstage-y += mmu.c
ramstage-y += stages.c
ramstage-y += tables.c
ramstage-y += ../../lib/memcpy.c
ramstage-y += ../../lib/memmove.c
ramstage-y += ../../lib/memset.c

ramstage-srcs += $(wildcard src/mainboard/$(MAINBOARDDIR)/mainboard.c)

$(objcbfs)/ramstage.debug: $$(ramstage-objs)
	@printf "    CC         $(subst $(obj)/,,$(@))\n"
	$(LD_ramstage) $(LDFLAGS_ramstage) -o $@ -L$(obj) -T $(call src-to-obj,ramstage,src/mainboard/$(MAINBOARDDIR)/memlayout.ld) --whole-archive --start-group $(filter-out %.ld,$(ramstage-objs)) --end-group

endif # CONFIG_ARCH_RAMSTAGE_MIPS
