/* -*- Mode: C++; tab-width: 8; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 * vim: set ts=8 sts=4 et sw=4 tw=99:
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef frontend_ParseNode_inl_h
#define frontend_ParseNode_inl_h

#include "frontend/ParseNode.h"

#include "frontend/SharedContext.h"

namespace js {
namespace frontend {

inline PropertyName*
ParseNode::name() const
{
    JS_ASSERT(isKind(PNK_FUNCTION) || isKind(PNK_NAME));
    JSAtom* atom = isKind(PNK_FUNCTION) ? pn_funbox->function()->atom() : pn_atom;
    return atom->asPropertyName();
}

inline JSAtom*
ParseNode::atom() const
{
    JS_ASSERT(isKind(PNK_STRING));
    return pn_atom;
}

} /* namespace frontend */
} /* namespace js */

#endif /* frontend_ParseNode_inl_h */
