/*
 * Decompiled with CFR 0.152.
 */
package gnu.bytecode;

import gnu.bytecode.CodeAttr;
import gnu.bytecode.Type;

public class Label {
    int first_fixup;
    int position;
    Type[] stackTypes;
    Type[] localTypes;

    public final boolean defined() {
        return this.position >= 0;
    }

    public Label() {
        this(-1);
    }

    public Label(CodeAttr code) {
        this(-1);
    }

    public Label(int position) {
        this.position = position;
    }

    void setTypes(Type[] locals, int usedLocals, Type[] stack, int usedStack) {
        Type last;
        while (usedLocals > 0 && (last = locals[usedLocals - 1]) == null) {
            --usedLocals;
        }
        if (this.stackTypes == null) {
            if (usedStack == 0) {
                this.stackTypes = Type.typeArray0;
            } else {
                this.stackTypes = new Type[usedStack];
                System.arraycopy(stack, 0, this.stackTypes, 0, usedStack);
            }
            if (usedLocals == 0) {
                this.localTypes = Type.typeArray0;
            } else {
                this.localTypes = new Type[usedLocals];
                System.arraycopy(locals, 0, this.localTypes, 0, usedLocals);
            }
        } else {
            int i;
            int SP = usedStack;
            int slen = this.stackTypes.length;
            if (SP != slen) {
                throw new Error("inconsistent stack len was:" + slen + " now:" + SP + " for " + this);
            }
            for (int i2 = 0; i2 < SP; ++i2) {
                this.stackTypes[i2] = Type.lowestCommonSuperType(this.stackTypes[i2], stack[i2]);
            }
            int min = usedLocals < this.localTypes.length ? usedLocals : this.localTypes.length;
            for (i = 0; i < min; ++i) {
                this.localTypes[i] = Type.lowestCommonSuperType(this.localTypes[i], locals[i]);
            }
            for (i = usedLocals; i < this.localTypes.length; ++i) {
                this.localTypes[i] = null;
            }
        }
    }

    public void setTypes(CodeAttr code) {
        if (this.stackTypes != null && code.SP != this.stackTypes.length) {
            throw new Error();
        }
        this.setTypes(code.local_types, code.local_types == null ? 0 : code.local_types.length, code.stack_types, code.SP);
    }

    public void setTypes(Label other) {
        this.setTypes(other.localTypes, other.localTypes.length, other.stackTypes, other.stackTypes.length);
    }

    void setTypesSame(Label other) {
        this.stackTypes = other.stackTypes;
        this.localTypes = other.localTypes;
    }

    public void defineRaw(CodeAttr code) {
        if (this.position >= 0) {
            throw new Error("label definition more than once");
        }
        this.position = code.PC;
        this.first_fixup = code.fixup_count;
        if (this.first_fixup >= 0) {
            code.fixupAdd(1, this);
        }
    }

    public void define(CodeAttr code) {
        if (code.reachableHere()) {
            this.setTypes(code);
        }
        if (this.localTypes != null) {
            code.setTypes(this);
        }
        code.setReachable(true);
        this.defineRaw(code);
    }
}

