/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.expr.Compilation;
import gnu.expr.Declaration;
import gnu.expr.ExpWalker;
import gnu.expr.Expression;
import gnu.expr.LetExp;
import gnu.expr.ModuleExp;
import gnu.expr.NameLookup;
import gnu.expr.ReferenceExp;
import gnu.expr.ScopeExp;
import gnu.expr.SetExp;

public class ResolveNames
extends ExpWalker {
    protected NameLookup lookup;

    public ResolveNames() {
    }

    public ResolveNames(Compilation comp) {
        this.setContext(comp);
        this.lookup = comp.lexical;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resolveModule(ModuleExp exp) {
        Compilation save_comp = Compilation.getCurrent();
        try {
            if (this.comp != null) {
                Compilation.setCurrent(this.comp);
            }
            this.push(exp);
            exp.walkChildren(this);
        }
        finally {
            Compilation.setCurrent(save_comp);
        }
    }

    protected void push(ScopeExp exp) {
        this.lookup.push(exp);
    }

    protected Expression walkScopeExp(ScopeExp exp) {
        this.walkDeclarationTypes(exp);
        this.push(exp);
        exp.walkChildren(this);
        this.lookup.pop(exp);
        return exp;
    }

    protected Expression walkLetExp(LetExp exp) {
        this.walkDeclarationTypes(exp);
        exp.walkInitializers(this);
        this.push(exp);
        exp.body = this.walk(exp.body);
        this.lookup.pop(exp);
        return exp;
    }

    public Declaration lookup(Expression exp, Object symbol, boolean function2) {
        return this.lookup.lookup(symbol, function2);
    }

    protected Expression walkReferenceExp(ReferenceExp exp) {
        Declaration decl = exp.getBinding();
        if (decl == null && (decl = this.lookup(exp, exp.getSymbol(), exp.isProcedureName())) != null) {
            exp.setBinding(decl);
        }
        return exp;
    }

    protected Expression walkSetExp(SetExp exp) {
        if (exp.binding == null) {
            Declaration decl = this.lookup(exp, exp.getSymbol(), exp.isFuncDef());
            if (decl != null) {
                decl.setCanWrite(true);
            }
            exp.binding = decl;
        }
        return super.walkSetExp(exp);
    }
}

