/*
 * Decompiled with CFR 0.152.
 */
package gnu.lists;

import gnu.lists.ByteVector;
import gnu.lists.Convert;
import gnu.lists.Sequence;
import java.util.Collection;

public class U8Vector
extends ByteVector {
    public U8Vector() {
        this.data = ByteVector.empty;
    }

    public U8Vector(int size, byte value) {
        byte[] array = new byte[size];
        this.data = array;
        this.size = size;
        while (--size >= 0) {
            array[size] = value;
        }
    }

    public U8Vector(int size) {
        this.data = new byte[size];
        this.size = size;
    }

    public U8Vector(byte[] data) {
        this.data = data;
        this.size = data.length;
    }

    public U8Vector(Sequence seq) {
        this.data = new byte[seq.size()];
        this.addAll((Collection)seq);
    }

    @Override
    public final int intAtBuffer(int index) {
        return this.data[index] & 0xFF;
    }

    @Override
    public final Object get(int index) {
        if (index > this.size) {
            throw new IndexOutOfBoundsException();
        }
        return Convert.toObjectUnsigned(this.data[index]);
    }

    @Override
    public final Object getBuffer(int index) {
        return Convert.toObjectUnsigned(this.data[index]);
    }

    @Override
    public Object setBuffer(int index, Object value) {
        byte old = this.data[index];
        this.data[index] = Convert.toByteUnsigned(value);
        return Convert.toObjectUnsigned(old);
    }

    @Override
    public int getElementKind() {
        return 17;
    }

    @Override
    public String getTag() {
        return "u8";
    }

    public int compareTo(Object obj) {
        return U8Vector.compareToInt(this, (U8Vector)obj);
    }
}

