/*
 * Decompiled with CFR 0.152.
 */
package gnu.jemacs.lang;

import gnu.bytecode.Type;
import gnu.commonlisp.lang.Lisp2;
import gnu.commonlisp.lang.SymbolTable;
import gnu.commonlisp.lang.Symbols;
import gnu.commonlisp.lang.UnwindProtect;
import gnu.commonlisp.lang.defun;
import gnu.commonlisp.lang.defvar;
import gnu.commonlisp.lang.function;
import gnu.commonlisp.lang.prog1;
import gnu.commonlisp.lang.setq;
import gnu.expr.Interpreter;
import gnu.jemacs.buffer.SelfInsertCommand;
import gnu.jemacs.buffer.Signal;
import gnu.jemacs.lang.AddOp;
import gnu.jemacs.lang.DivideOp;
import gnu.jemacs.lang.ELispReader;
import gnu.jemacs.lang.NumberCompare;
import gnu.jemacs.lang.Print;
import gnu.jemacs.lang.SaveExcursion;
import gnu.jemacs.lang.While;
import gnu.jemacs.lang.defcustom;
import gnu.jemacs.lang.defgroup;
import gnu.jemacs.lang.lambda;
import gnu.kawa.functions.DisplayFormat;
import gnu.kawa.functions.IsEq;
import gnu.kawa.functions.IsEqual;
import gnu.kawa.lispexpr.LangPrimType;
import gnu.kawa.reflect.InstanceOf;
import gnu.lists.FormatToConsumer;
import gnu.mapping.Environment;
import gnu.mapping.InPort;
import gnu.mapping.Named;
import gnu.mapping.Procedure;
import gnu.mapping.Symbol;
import gnu.mapping.SymbolEnumeration;
import gnu.math.IntNum;
import gnu.math.Numeric;
import gnu.text.Char;
import gnu.text.Lexer;
import gnu.text.SourceMessages;
import gnu.text.SyntaxException;
import java.io.IOException;
import javax.swing.text.Position;
import kawa.lang.Lambda;
import kawa.lang.Syntax;
import kawa.repl;
import kawa.standard.Scheme;
import kawa.standard.and_or;
import kawa.standard.begin;
import kawa.standard.fluid_let;
import kawa.standard.ifp;
import kawa.standard.not;

public class ELisp
extends Lisp2 {
    static boolean charIsInt = false;
    static ELisp instance;
    static int elispCounter;
    static final DisplayFormat writeFormat;
    static final DisplayFormat displayFormat;
    LangPrimType booleanType;

    public static Object getCharacter(int n) {
        if (charIsInt) {
            return IntNum.make(n);
        }
        return Char.make((char)n);
    }

    public static Numeric asNumber(Object object2) {
        if (object2 instanceof Char) {
            return IntNum.make(((Char)object2).intValue());
        }
        if (object2 instanceof Position) {
            return IntNum.make(1 + ((Position)object2).getOffset());
        }
        return (Numeric)object2;
    }

    public static char asChar(Object object2) {
        if (object2 instanceof Char) {
            return ((Char)object2).charValue();
        }
        int n = object2 instanceof Numeric ? ((Numeric)object2).intValue() : (object2 instanceof Position ? ((Position)object2).getOffset() + 1 : -1);
        if (n < 0 || n > 65535) {
            throw new Signal("error", "not a character value");
        }
        return (char)n;
    }

    public Lexer getLexer(InPort inPort, SourceMessages sourceMessages) {
        return new ELispReader(inPort, sourceMessages);
    }

    public String getName() {
        return "Emacs-Lisp";
    }

    protected void defun(String string, Object object2) {
        Named named;
        Symbols.setFunctionBinding(this.environ, string, object2);
        if (object2 instanceof Named && (named = (Named)object2).getName() == null) {
            named.setName(string);
        }
    }

    private void defun(Procedure procedure) {
        this.defun(procedure.getName(), procedure);
    }

    public ELisp() {
        Object object2;
        Named named;
        Environment environment = Scheme.builtin();
        this.environ = SymbolTable.make("interaction-environment." + ++elispCounter);
        Environment.setCurrent(this.environ);
        TRUE = this.environ.getSymbol("t");
        TRUE.set(TRUE);
        this.define("nil", FALSE);
        Scheme.getInstance();
        SymbolEnumeration symbolEnumeration = Scheme.builtin().enumerateAllSymbols();
        while (symbolEnumeration.hasMoreElements()) {
            named = symbolEnumeration.nextSymbol();
            object2 = ((Symbol)named).get(null);
            if (object2 == null) continue;
            String string = ((Procedure)named).getName();
            if (object2 instanceof Procedure || object2 instanceof Syntax) {
                this.defun(string, object2);
                continue;
            }
            this.define(string, object2);
        }
        if (instance == null) {
            instance = this;
        }
        try {
            this.loadClass("kawa.lib.std_syntax");
            this.loadClass("kawa.lib.lists");
            this.loadClass("kawa.lib.strings");
            this.loadClass("gnu.commonlisp.lisp.PrimOps");
            this.loadClass("gnu.jemacs.lang.NumberOps");
            this.loadClass("gnu.jemacs.lang.MiscOps");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        this.defun(AddOp.$Pl);
        this.defun(AddOp.$Mn);
        this.defun(DivideOp.$Sl);
        this.defun(NumberCompare.$Eq);
        this.defun(NumberCompare.$Ls);
        this.defun(NumberCompare.$Gr);
        this.defun(NumberCompare.$Ls$Eq);
        this.defun(NumberCompare.$Gr$Eq);
        this.defun("self-insert-command", new SelfInsertCommand());
        named = new lambda();
        ((Lambda)named).setKeywords(ELisp.getSymbol("&optional"), ELisp.getSymbol("&rest"), ELisp.getSymbol("&key"));
        ((lambda)named).defaultDefault = nilExpr;
        this.defun("lambda", named);
        this.defun("defun", new defun((Lambda)named));
        this.defun("function", new function((Syntax)named));
        this.defun("defgroup", new defgroup());
        this.defun("defcustom", new defcustom());
        this.defun("defvar", new defvar(false));
        this.defun("defconst", new defvar(true));
        this.defun("defsubst", new defun((Lambda)named));
        this.defun("setq", new setq());
        this.defun("prog1", prog1.prog1);
        this.defun("prog2", prog1.prog2);
        this.defun("progn", new begin());
        this.defun("if", new ifp());
        this.defun("or", new and_or(false, this));
        this.defun("and", new and_or(true, this));
        this.defun("while", new While());
        this.defun("unwind-protect", new UnwindProtect());
        this.defun("save-excursion", new SaveExcursion(false));
        this.defun("save-current-buffer", new SaveExcursion(true));
        this.defun("let", new fluid_let(false, nilExpr));
        this.defun("let*", new fluid_let(true, nilExpr));
        this.define_field("concat", "kawa.lib.strings", "string$Mnappend");
        object2 = new not(this);
        this.defun("not", object2);
        this.defun("null", object2);
        this.defun("eq", new IsEq(this, "eq"));
        this.defun("equal", new IsEqual(this, "equal"));
        this.defun("typep", new InstanceOf(this));
        this.defun("princ", displayFormat);
        this.defun("prin1", writeFormat);
        try {
            this.loadClass("gnu.jemacs.lisp.primitives");
            this.loadClass("gnu.jemacs.buffer.emacs");
            this.loadClass("gnu.jemacs.lisp.simple");
            this.loadClass("gnu.jemacs.lisp.autoloads");
            this.loadClass("gnu.jemacs.lisp.keymap");
            this.loadClass("gnu.jemacs.lisp.editfns");
            this.loadClass("gnu.jemacs.lisp.keydefs");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ELisp getInstance() {
        if (instance == null) {
            Environment environment = Environment.getCurrent();
            try {
                instance = new ELisp();
            }
            finally {
                Environment.setCurrent(environment);
            }
        }
        return instance;
    }

    public static void registerEnvironment() {
        ELisp eLisp = new ELisp();
        Interpreter.defaultInterpreter = eLisp;
        Environment.setCurrent(eLisp.getEnvironment());
    }

    public Object read(InPort inPort) throws IOException, SyntaxException {
        return ELispReader.readObject(inPort);
    }

    public FormatToConsumer getFormat(boolean bl) {
        return bl ? writeFormat : displayFormat;
    }

    public Type getTypeFor(String string) {
        if (string == "t") {
            string = "java.lang.Object";
        } else if (string == "marker") {
            string = "gnu.jemacs.buffer.Marker";
        } else if (string == "buffer") {
            string = "gnu.jemacs.buffer.Buffer";
        } else if (string == "window") {
            string = "gnu.jemacs.buffer.Window";
        }
        return Scheme.string2Type(string);
    }

    public Type getTypeFor(Class clazz) {
        if (clazz.isPrimitive()) {
            String string = clazz.getName();
            if (string.equals("boolean")) {
                if (this.booleanType == null) {
                    this.booleanType = new LangPrimType(Type.boolean_type, this);
                }
                return this.booleanType;
            }
            return Scheme.getNamedType(string);
        }
        return Type.make(clazz);
    }

    public void defineFromFieldValue(String string, Object object2) throws Throwable {
        string = object2 instanceof Named ? ((Named)object2).getName() : string.intern();
        if (object2 instanceof Symbol) {
            this.environ.addSymbol((Symbol)object2);
        } else if (object2 instanceof Procedure || object2 instanceof Syntax) {
            Symbols.setFunctionBinding(this.environ, string, object2);
        } else {
            this.environ.define(string, object2);
        }
    }

    public static void readableChar(char c, StringBuffer stringBuffer, boolean bl) {
        if (bl && (c == '\\' || c == '\'' || c == '\"')) {
            stringBuffer.append('\\');
            stringBuffer.append(c);
        } else if (c > '\u007f') {
            stringBuffer.append("\\u");
            String string = Integer.toHexString(c);
            for (int i = string.length(); i < 4; ++i) {
                stringBuffer.append('0');
            }
            stringBuffer.append(string);
        } else if (c >= ' ') {
            stringBuffer.append(c);
        } else if (c == '\t') {
            stringBuffer.append("\\t");
        } else if (c == '\r') {
            stringBuffer.append("\\r");
        } else if (c == '\n') {
            stringBuffer.append("\\n");
        } else {
            stringBuffer.append("\\0");
            stringBuffer.append(c >> 3 & 7);
            stringBuffer.append(c & 7);
        }
    }

    public static String readableString(Object object2) {
        String string = object2.toString();
        StringBuffer stringBuffer = new StringBuffer(200);
        for (int i = 0; i < string.length(); ++i) {
            ELisp.readableChar(string.charAt(i), stringBuffer, false);
        }
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        ELisp.registerEnvironment();
        if (stringArray.length == 0) {
            stringArray = new String[]{"-e", "(emacs)", "--"};
        }
        repl.main(stringArray);
    }

    static {
        elispCounter = 0;
        writeFormat = new Print(true);
        displayFormat = new Print(false);
    }
}

