/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.reflect;

import gnu.bytecode.ClassType;
import gnu.bytecode.Filter;
import gnu.bytecode.Method;
import gnu.bytecode.Type;
import gnu.expr.Compilation;
import gnu.expr.Expression;
import gnu.expr.GenericProc;
import gnu.expr.Interpreter;
import gnu.expr.PrimProcedure;
import gnu.expr.QuoteExp;
import gnu.kawa.reflect.MethodFilter;
import gnu.lists.FString;
import gnu.mapping.MethodProc;
import gnu.mapping.Procedure;
import gnu.mapping.Procedure2;
import gnu.mapping.Symbol;
import gnu.mapping.WrongType;
import java.util.Vector;

public class ClassMethods
extends Procedure2 {
    public Object apply2(Object object2, Object object3) {
        return ClassMethods.apply(this, object2, object3, null, null, 0, 0);
    }

    public static MethodProc apply(String string, String string2) {
        String string3 = string2.equals("new") ? "<init>" : Compilation.mangleName(string2);
        ClassType classType = ClassType.make(string);
        MethodProc methodProc = ClassMethods.apply(classType, string3, null, null, 0, 0);
        if (methodProc == null) {
            StringBuffer stringBuffer = new StringBuffer();
            if (!classType.isExisting()) {
                stringBuffer.append("no class named ");
                stringBuffer.append(string);
            } else {
                stringBuffer.append("no method named `");
                stringBuffer.append(string3);
                stringBuffer.append("' in class ");
                stringBuffer.append(string);
            }
            throw new RuntimeException(stringBuffer.toString());
        }
        return methodProc;
    }

    public static MethodProc apply(Procedure procedure, Object object2, Object object3, Type type, Type[] typeArray, int n, int n2) {
        MethodProc methodProc;
        ClassType classType;
        if (object2 instanceof Class) {
            object2 = Type.make((Class)object2);
        }
        if (object2 instanceof ClassType) {
            classType = (ClassType)object2;
        } else if (object2 instanceof String || object2 instanceof FString || object2 instanceof Symbol) {
            classType = ClassType.make(object2.toString());
        } else {
            throw new WrongType(procedure, 0, null);
        }
        if (!(object3 instanceof String || object3 instanceof FString || object3 instanceof Symbol)) {
            throw new WrongType(procedure, 1, null);
        }
        String string = object3.toString();
        if (!"<init>".equals(string)) {
            string = Compilation.mangleName(string);
        }
        if ((methodProc = ClassMethods.apply(classType, string, type, typeArray, n, n2)) == null) {
            throw new RuntimeException("no applicable method named `" + string + "' in " + classType.getName());
        }
        return methodProc;
    }

    public static PrimProcedure[] getMethods(ClassType classType, String string, int n, int n2, Interpreter interpreter) {
        return ClassMethods.getMethods(classType, string, n, n2, false, interpreter);
    }

    private static int removeRedundantMethods(Vector vector) {
        int n = vector.size();
        int n2 = 1;
        block0: while (n2 < n) {
            Method method = (Method)vector.elementAt(n2);
            ClassType classType = method.getDeclaringClass();
            Type[] typeArray = method.getParameterTypes();
            int n3 = typeArray.length;
            for (int i = 0; i < n2; ++i) {
                Method method2 = (Method)vector.elementAt(i);
                Type[] typeArray2 = method2.getParameterTypes();
                if (n3 != typeArray2.length) continue;
                int n4 = n3;
                while (--n4 >= 0 && typeArray[n4] == typeArray2[n4]) {
                }
                if (n4 >= 0) continue;
                if (classType.isSubtype(method2.getDeclaringClass())) {
                    vector.setElementAt(method, i);
                }
                vector.setElementAt(vector.elementAt(n - 1), n2);
                --n;
                continue block0;
            }
            ++n2;
        }
        return n;
    }

    public static PrimProcedure[] getMethods(ClassType classType, String string, int n, int n2, boolean bl, Interpreter interpreter) {
        MethodFilter methodFilter = new MethodFilter(string, n, n2);
        boolean bl2 = bl || "<init>".equals(string);
        Vector vector = new Vector();
        classType.getMethods((Filter)methodFilter, bl2 ? 0 : 2, vector, "-");
        int n3 = bl2 ? vector.size() : ClassMethods.removeRedundantMethods(vector);
        PrimProcedure[] primProcedureArray = new PrimProcedure[n3];
        int n4 = 0;
        int n5 = n3;
        while (--n5 >= 0) {
            Method method = (Method)vector.elementAt(n5);
            if ((method.getModifiers() & n2) != n) continue;
            PrimProcedure primProcedure = new PrimProcedure(method, bl, interpreter);
            primProcedureArray[n4++] = primProcedure;
        }
        return primProcedureArray;
    }

    public static long selectApplicable(PrimProcedure[] primProcedureArray, Type[] typeArray) {
        int n = primProcedureArray.length;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (n4 < n) {
            PrimProcedure primProcedure;
            int n5 = primProcedureArray[n4].isApplicable(typeArray);
            if (n5 < 0) {
                primProcedure = primProcedureArray[n - 1];
                primProcedureArray[n - 1] = primProcedureArray[n4];
                primProcedureArray[n4] = primProcedure;
                --n;
                continue;
            }
            if (n5 > 0) {
                primProcedure = primProcedureArray[n2];
                primProcedureArray[n2] = primProcedureArray[n4];
                primProcedureArray[n4] = primProcedure;
                ++n2;
                ++n4;
                continue;
            }
            ++n3;
            ++n4;
        }
        return ((long)n2 << 32) + (long)n3;
    }

    public static MethodProc apply(ClassType classType, String string, Type type, Type[] typeArray, int n, int n2) {
        Interpreter interpreter = Interpreter.defaultInterpreter;
        PrimProcedure[] primProcedureArray = ClassMethods.getMethods(classType, string, n, n2, interpreter);
        GenericProc genericProc = null;
        PrimProcedure primProcedure = null;
        for (int i = 0; i < primProcedureArray.length; ++i) {
            PrimProcedure primProcedure2 = primProcedureArray[i];
            if (typeArray != null) {
                MethodProc methodProc;
                int n3 = primProcedure2.isApplicable(typeArray);
                if (n3 == -1) continue;
                if (primProcedure != null && (methodProc = MethodProc.mostSpecific(primProcedure, primProcedure2)) != null) {
                    if (primProcedure2 != methodProc) continue;
                    primProcedure = primProcedure2;
                    continue;
                }
            }
            if (primProcedure != null && genericProc == null) {
                genericProc = new GenericProc();
                genericProc.add(primProcedure);
            }
            primProcedure = primProcedure2;
            if (genericProc == null) continue;
            genericProc.add(primProcedure);
        }
        if (genericProc != null) {
            genericProc.setName(classType.getName() + "." + string);
            return genericProc;
        }
        return primProcedure;
    }

    static String checkName(Expression expression, boolean bl) {
        if (expression instanceof QuoteExp) {
            String string;
            Object object2 = ((QuoteExp)expression).getValue();
            if (object2 instanceof FString || object2 instanceof String) {
                string = object2.toString();
            } else if (object2 instanceof Symbol) {
                string = ((Symbol)object2).getName();
            } else {
                return null;
            }
            if (Compilation.isValidJavaName(string)) {
                return string;
            }
            return Compilation.mangleName(string, bl);
        }
        return null;
    }
}

