/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.xml;

import gnu.bytecode.CodeAttr;
import gnu.bytecode.Method;
import gnu.bytecode.Variable;
import gnu.expr.ApplyExp;
import gnu.expr.Compilation;
import gnu.expr.ConsumerTarget;
import gnu.expr.Expression;
import gnu.expr.Target;
import gnu.kawa.xml.NodeConstructor;
import gnu.lists.Consumable;
import gnu.lists.Consumer;
import gnu.mapping.CallContext;
import gnu.mapping.Symbol;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class ElementConstructor
extends NodeConstructor
implements Externalizable {
    String sname;
    Symbol qname;
    static final Method beginGroupMethod = Compilation.typeConsumer.getDeclaredMethod("beginGroup", 2);
    static final Method endGroupMethod = Compilation.typeConsumer.getDeclaredMethod("endGroup", 1);

    public String getXmlName() {
        return this.sname;
    }

    public Symbol getQName() {
        return this.qname;
    }

    public final String getNamespaceURI() {
        return this.qname.getNamespaceURI();
    }

    public final String getLocalName() {
        return this.qname.getLocalName();
    }

    public final String getPrefix() {
        int n = this.sname.indexOf(58);
        if (n <= 0) {
            return null;
        }
        return this.sname.substring(0, n);
    }

    public static ElementConstructor make(String string, Symbol symbol) {
        ElementConstructor elementConstructor = new ElementConstructor();
        elementConstructor.sname = string.intern();
        elementConstructor.qname = symbol;
        return elementConstructor;
    }

    public static ElementConstructor make(String string, String string2, String string3) {
        ElementConstructor elementConstructor = new ElementConstructor();
        elementConstructor.sname = string.intern();
        elementConstructor.qname = Symbol.make(string2, string3);
        return elementConstructor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void apply(CallContext callContext) {
        Consumer consumer = callContext.consumer;
        Consumer consumer2 = ElementConstructor.pushNodeContext(callContext);
        try {
            Object object2;
            consumer2.beginGroup(this.sname, this.qname);
            String string = Symbol.UNBOUND;
            while ((object2 = callContext.getNextArg(string)) != string) {
                if (object2 instanceof Consumable) {
                    ((Consumable)object2).consume(consumer2);
                    continue;
                }
                consumer2.writeObject(object2);
            }
            consumer2.endGroup(this.sname);
        }
        finally {
            ElementConstructor.popNodeContext(consumer, callContext);
        }
    }

    public void compileToNode(ApplyExp applyExp, Compilation compilation, ConsumerTarget consumerTarget) {
        Variable variable = consumerTarget.getConsumerVariable();
        Expression[] expressionArray = applyExp.getArgs();
        int n = expressionArray.length;
        CodeAttr codeAttr = compilation.getCode();
        codeAttr.emitLoad(variable);
        compilation.compileConstant(this.sname, Target.pushObject);
        compilation.compileConstant(this.qname, Target.pushObject);
        codeAttr.emitInvokeInterface(beginGroupMethod);
        for (int i = 0; i < n; ++i) {
            ElementConstructor.compileChild(expressionArray[i], compilation, consumerTarget);
        }
        codeAttr.emitLoad(variable);
        compilation.compileConstant(this.sname, Target.pushObject);
        codeAttr.emitInvokeInterface(endGroupMethod);
    }

    public String toString() {
        return "#<ElementConstructor " + this.sname + " :: " + this.qname + '>';
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(this.sname);
        objectOutput.writeObject(this.qname);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.sname = ((String)objectInput.readObject()).intern();
        this.qname = (Symbol)objectInput.readObject();
    }
}

