/*
 * Decompiled with CFR 0.152.
 */
package gnu.lists;

import gnu.lists.Consumer;
import gnu.lists.Convert;
import gnu.lists.Sequence;
import gnu.lists.SimpleVector;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;

public class BitVector
extends SimpleVector
implements Externalizable {
    boolean[] data;
    protected static boolean[] empty = new boolean[0];

    public BitVector() {
        this.data = empty;
    }

    public BitVector(int n, boolean bl) {
        boolean[] blArray = new boolean[n];
        this.data = blArray;
        this.size = n;
        if (bl) {
            while (--n >= 0) {
                blArray[n] = true;
            }
        }
    }

    public BitVector(int n) {
        this.data = new boolean[n];
        this.size = n;
    }

    public BitVector(boolean[] blArray) {
        this.data = blArray;
        this.size = blArray.length;
    }

    public BitVector(Sequence sequence) {
        this.data = new boolean[sequence.size()];
        this.addAll((Collection)sequence);
    }

    public int getBufferLength() {
        return this.data.length;
    }

    public void setBufferLength(int n) {
        int n2 = this.data.length;
        if (n2 != n) {
            boolean[] blArray = new boolean[n];
            System.arraycopy(this.data, 0, blArray, 0, n2 < n ? n2 : n);
            this.data = blArray;
        }
    }

    protected Object getBuffer() {
        return this.data;
    }

    public final boolean booleanAt(int n) {
        if (n > this.size) {
            throw new IndexOutOfBoundsException();
        }
        return this.data[n];
    }

    public final boolean booleanAtBuffer(int n) {
        return this.data[n];
    }

    public final Object get(int n) {
        if (n > this.size) {
            throw new IndexOutOfBoundsException();
        }
        return Convert.toObject(this.data[n]);
    }

    public final Object getBuffer(int n) {
        return Convert.toObject(this.data[n]);
    }

    public Object setBuffer(int n, Object object2) {
        boolean bl = this.data[n];
        this.data[n] = Convert.toBoolean(object2);
        return Convert.toObject(bl);
    }

    public final void setBooleanAt(int n, boolean bl) {
        if (n > this.size) {
            throw new IndexOutOfBoundsException();
        }
        this.data[n] = bl;
    }

    public final void setBooleanAtBuffer(int n, boolean bl) {
        this.data[n] = bl;
    }

    protected void clearBuffer(int n, int n2) {
        while (--n2 >= 0) {
            this.data[n++] = false;
        }
    }

    public int getElementKind() {
        return 27;
    }

    public String getTag() {
        return "b";
    }

    public boolean consumeNext(int n, Consumer consumer) {
        int n2 = n >>> 1;
        if (n2 >= this.size) {
            return false;
        }
        consumer.writeBoolean(this.data[n2]);
        return true;
    }

    public void consumePosRange(int n, int n2, Consumer consumer) {
        if (consumer.ignoring()) {
            return;
        }
        int n3 = n >>> 1;
        int n4 = n2 >>> 1;
        while (n3 < n4) {
            consumer.writeBoolean(this.data[n3]);
            ++n3;
        }
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        int n = this.size;
        objectOutput.writeInt(n);
        int n2 = 0;
        while (n2 < n) {
            objectOutput.writeBoolean(this.data[n2]);
            ++n2;
        }
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n = objectInput.readInt();
        boolean[] blArray = new boolean[n];
        int n2 = 0;
        while (n2 < n) {
            blArray[n2] = objectInput.readBoolean();
            ++n2;
        }
        this.data = blArray;
        this.size = n;
    }
}

