/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.bytecode.CodeAttr;
import gnu.bytecode.ExitableBlock;
import gnu.bytecode.Label;
import gnu.bytecode.Type;
import gnu.expr.BlockExitException;
import gnu.expr.Compilation;
import gnu.expr.Declaration;
import gnu.expr.ExpWalker;
import gnu.expr.Expression;
import gnu.expr.StackTarget;
import gnu.expr.Target;
import gnu.mapping.CallContext;
import gnu.mapping.OutPort;

public class BlockExp
extends Expression {
    Declaration label;
    Expression body;
    Expression exitBody;
    ExitableBlock exitableBlock;
    Target exitTarget;

    public void setBody(Expression expression) {
        this.body = expression;
    }

    public void setBody(Expression expression, Expression expression2) {
        this.body = expression;
        this.exitBody = expression2;
    }

    public void setLabel(Declaration declaration) {
        this.label = declaration;
    }

    protected boolean mustCompile() {
        return false;
    }

    public void apply(CallContext callContext) throws Throwable {
        Object object2;
        block3: {
            try {
                object2 = this.body.eval(callContext);
            }
            catch (BlockExitException blockExitException) {
                if (blockExitException.exit.block != this) {
                    throw blockExitException;
                }
                object2 = blockExitException.exit.result;
                if (this.exitBody == null) break block3;
                object2 = this.exitBody.eval(callContext);
            }
        }
        callContext.writeValue(object2);
    }

    public void compile(Compilation compilation, Target target) {
        ExitableBlock exitableBlock;
        CodeAttr codeAttr = compilation.getCode();
        Type type = this.exitBody == null && target instanceof StackTarget ? target.getType() : null;
        this.exitableBlock = exitableBlock = codeAttr.startExitableBlock(type, true);
        this.exitTarget = this.exitBody == null ? target : Target.Ignore;
        this.body.compileWithPosition(compilation, target);
        if (this.exitBody != null) {
            Label label = new Label(codeAttr);
            codeAttr.emitGoto(label);
            codeAttr.endExitableBlock();
            this.exitBody.compileWithPosition(compilation, target);
            label.define(codeAttr);
        } else {
            codeAttr.endExitableBlock();
        }
        this.exitableBlock = null;
    }

    protected Expression walk(ExpWalker expWalker) {
        return expWalker.walkBlockExp(this);
    }

    protected void walkChildren(ExpWalker expWalker) {
        this.body = expWalker.walk(this.body);
        if (expWalker.exitValue == null && this.exitBody != null) {
            this.exitBody = expWalker.walk(this.exitBody);
        }
    }

    public void print(OutPort outPort) {
        outPort.startLogicalBlock("(Block", ")", 2);
        if (this.label != null) {
            outPort.print(' ');
            outPort.print(this.label.getName());
        }
        outPort.writeSpaceLinear();
        this.body.print(outPort);
        if (this.exitBody != null) {
            outPort.writeSpaceLinear();
            outPort.print("else ");
            this.exitBody.print(outPort);
        }
        outPort.endLogicalBlock(")");
    }
}

