/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.bytecode.ArrayType;
import gnu.bytecode.ClassType;
import gnu.bytecode.CodeAttr;
import gnu.bytecode.Method;
import gnu.bytecode.ObjectType;
import gnu.bytecode.PrimType;
import gnu.bytecode.Type;
import gnu.expr.Compilation;
import gnu.expr.Literal;
import gnu.expr.StackTarget;
import gnu.lists.FString;
import gnu.mapping.Table2D;
import gnu.mapping.Values;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectOutput;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.IdentityHashMap;
import java.util.regex.Pattern;

public class LitTable
implements ObjectOutput {
    Compilation comp;
    ClassType mainClass;
    IdentityHashMap literalTable = new IdentityHashMap(100);
    static Table2D staticTable = new Table2D(100);
    int literalsCount;
    Literal literalsChain;
    Object[] valueStack = new Object[20];
    Type[] typeStack = new Type[20];
    int stackPointer;

    public LitTable(Compilation compilation) {
        this.comp = compilation;
        this.mainClass = compilation.mainClass;
    }

    public void emit() throws IOException {
        Literal literal = this.literalsChain;
        while (literal != null) {
            this.writeObject(literal.value);
            literal = literal.next;
        }
        literal = this.literalsChain;
        while (literal != null) {
            this.emit(literal, true);
            literal = literal.next;
        }
        this.literalTable = null;
        this.literalsCount = 0;
    }

    void push(Object object2, Type type) {
        if (this.stackPointer >= this.valueStack.length) {
            Object[] objectArray = new Object[2 * this.valueStack.length];
            Type[] typeArray = new Type[2 * this.typeStack.length];
            System.arraycopy(this.valueStack, 0, objectArray, 0, this.stackPointer);
            System.arraycopy(this.typeStack, 0, typeArray, 0, this.stackPointer);
            this.valueStack = objectArray;
            this.typeStack = typeArray;
        }
        this.valueStack[this.stackPointer] = object2;
        this.typeStack[this.stackPointer] = type;
        ++this.stackPointer;
    }

    void error(String string) {
        throw new Error(string);
    }

    public void flush() {
    }

    public void close() {
    }

    public void write(int n) throws IOException {
        this.error("cannot handle call to write(int) when externalizing literal");
    }

    public void writeBytes(String string) throws IOException {
        this.error("cannot handle call to writeBytes(String) when externalizing literal");
    }

    public void write(byte[] byArray) throws IOException {
        this.error("cannot handle call to write(byte[]) when externalizing literal");
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.error("cannot handle call to write(byte[],int,int) when externalizing literal");
    }

    public void writeBoolean(boolean bl) {
        this.push(new Boolean(bl), Type.booleanType);
    }

    public void writeChar(int n) {
        this.push(new Character((char)n), Type.charType);
    }

    public void writeByte(int n) {
        this.push(new Byte((byte)n), Type.byteType);
    }

    public void writeShort(int n) {
        this.push(new Short((short)n), Type.shortType);
    }

    public void writeInt(int n) {
        this.push(new Integer(n), Type.intType);
    }

    public void writeLong(long l) {
        this.push(new Long(l), Type.longType);
    }

    public void writeFloat(float f) {
        this.push(new Float(f), Type.floatType);
    }

    public void writeDouble(double d) {
        this.push(new Double(d), Type.doubleType);
    }

    public void writeUTF(String string) {
        this.push(string, Type.string_type);
    }

    public void writeChars(String string) {
        this.push(string, Type.string_type);
    }

    public void writeObject(Object object2) throws IOException {
        Literal literal = this.findLiteral(object2);
        if ((literal.flags & 3) != 0) {
            if (literal.field == null && object2 != null && !(object2 instanceof String)) {
                literal.assign(this);
            }
            if ((literal.flags & 2) == 0) {
                literal.flags |= 4;
            }
        } else {
            Object object3;
            literal.flags |= 1;
            int n = this.stackPointer;
            if (object2 instanceof FString && ((FString)object2).size() < 65535) {
                this.push(object2.toString(), Type.string_type);
            } else if (object2 instanceof Externalizable) {
                ((Externalizable)object2).writeExternal(this);
            } else if (object2 instanceof Object[]) {
                object3 = (Object[])object2;
                for (int i = 0; i < ((Object[])object3).length; ++i) {
                    this.writeObject(object3[i]);
                }
            } else if (object2 != null && !(object2 instanceof String) && !(literal.type instanceof ArrayType)) {
                if (object2 instanceof BigInteger) {
                    this.writeChars(object2.toString());
                } else if (object2 instanceof BigDecimal) {
                    object3 = (BigDecimal)object2;
                    this.writeObject(((BigDecimal)object3).unscaledValue());
                    this.writeInt(((BigDecimal)object3).scale());
                } else if (object2 instanceof Integer) {
                    this.push(object2, Type.intType);
                } else if (object2 instanceof Short) {
                    this.push(object2, Type.shortType);
                } else if (object2 instanceof Byte) {
                    this.push(object2, Type.byteType);
                } else if (object2 instanceof Long) {
                    this.push(object2, Type.longType);
                } else if (object2 instanceof Double) {
                    this.push(object2, Type.doubleType);
                } else if (object2 instanceof Float) {
                    this.push(object2, Type.floatType);
                } else if (object2 instanceof Character) {
                    this.push(object2, Type.charType);
                } else if (object2 instanceof Class) {
                    this.push(object2, Type.java_lang_Class_type);
                } else if (object2 instanceof Pattern) {
                    object3 = (Pattern)object2;
                    this.push(((Pattern)object3).pattern(), Type.string_type);
                    this.push(((Pattern)object3).flags(), Type.intType);
                } else {
                    this.error(object2.getClass().getName() + " does not implement Externalizable");
                }
            }
            int n2 = this.stackPointer - n;
            if (n2 == 0) {
                literal.argValues = Values.noArgs;
                literal.argTypes = Type.typeArray0;
            } else {
                literal.argValues = new Object[n2];
                literal.argTypes = new Type[n2];
                System.arraycopy(this.valueStack, n, literal.argValues, 0, n2);
                System.arraycopy(this.typeStack, n, literal.argTypes, 0, n2);
                this.stackPointer = n;
            }
            literal.flags |= 2;
        }
        this.push(literal, literal.type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Literal findLiteral(Object object2) {
        if (object2 == null) {
            return Literal.nullLiteral;
        }
        Literal literal = (Literal)this.literalTable.get(object2);
        if (literal != null) {
            return literal;
        }
        if (this.comp.immediate) {
            return new Literal(object2, this);
        }
        Class<?> clazz = object2.getClass();
        Type type = Type.make(clazz);
        Table2D table2D = staticTable;
        synchronized (table2D) {
            literal = (Literal)staticTable.get(object2, null, null);
            if ((literal == null || literal.value != object2) && type instanceof ClassType) {
                int n = 25;
                Class<?> clazz2 = clazz;
                ClassType classType = (ClassType)type;
                while (staticTable.get(clazz2, Boolean.TRUE, null) == null) {
                    staticTable.put(clazz2, Boolean.TRUE, clazz2);
                    for (gnu.bytecode.Field field = classType.getFields(); field != null; field = field.getNext()) {
                        if ((field.getModifiers() & n) != n) continue;
                        try {
                            Field field2 = field.getReflectField();
                            Object object3 = field2.get(null);
                            if (object3 == null || !clazz2.isInstance(object3)) continue;
                            Literal literal2 = new Literal(object3, field, this);
                            staticTable.put(object3, null, literal2);
                            if (object2 != object3) continue;
                            literal = literal2;
                            continue;
                        }
                        catch (Throwable throwable) {
                            this.error("caught " + throwable + " getting static field " + field);
                        }
                    }
                    if ((clazz2 = clazz2.getSuperclass()) == null) break;
                    classType = (ClassType)Type.make(clazz2);
                }
            }
        }
        if (literal != null) {
            this.literalTable.put(object2, literal);
        } else {
            literal = new Literal(object2, type, this);
        }
        return literal;
    }

    Method getMethod(ClassType classType, String string, Literal literal, boolean bl) {
        int n;
        int n2;
        Type[] typeArray = literal.argTypes;
        int n3 = typeArray.length;
        Method method = null;
        long l = 0L;
        boolean bl2 = false;
        Type[] typeArray2 = null;
        block0: for (Method method2 = classType.getDeclaredMethods(); method2 != null; method2 = method2.getNext()) {
            boolean bl3;
            if (!string.equals(method2.getName()) || bl != (bl3 = method2.getStaticFlag())) continue;
            long l2 = 0L;
            Type[] typeArray3 = method2.getParameterTypes();
            int n4 = 0;
            n2 = 0;
            while (true) {
                int n5;
                if (n4 == n3 && n2 == typeArray3.length) {
                    if (method == null || l != 0L && l2 == 0L) {
                        method = method2;
                        typeArray2 = typeArray3;
                        l = l2;
                        continue block0;
                    }
                    if (l2 != 0L) continue block0;
                    boolean bl4 = false;
                    boolean bl5 = false;
                    n5 = n3;
                    while (--n5 >= 0) {
                        int n6 = typeArray2[n5].compare(typeArray3[n5]);
                        if (n6 != 1) {
                            bl5 = true;
                            if (bl4) break;
                        }
                        if (n6 == -1) continue;
                        bl4 = true;
                        if (!bl5) continue;
                        break;
                    }
                    if (bl4) {
                        method = method2;
                        typeArray2 = typeArray3;
                    }
                    bl2 = bl4 && bl5;
                    continue block0;
                }
                if (n4 == n3 || n2 == typeArray3.length) continue block0;
                Type type = typeArray[n4];
                Type type2 = typeArray3[n2];
                if (!type.isSubtype(type2)) {
                    if (!(type2 instanceof ArrayType) || n2 >= 64 || type != Type.intType && type != Type.shortType) continue block0;
                    n5 = ((Number)literal.argValues[n4]).intValue();
                    if (n5 < 0 && classType.getName().equals("gnu.math.IntNum")) {
                        n5 -= Integer.MIN_VALUE;
                    }
                    Type type3 = ((ArrayType)type2).getComponentType();
                    if (n5 < 0 || n4 + n5 >= n3) continue block0;
                    n = n5;
                    while (--n >= 0) {
                        Type type4 = typeArray[n4 + n + 1];
                        if (!(type3 instanceof PrimType ? type3.getSignature() != type4.getSignature() : !type4.isSubtype(type3))) continue;
                        continue block0;
                    }
                    n4 += n5;
                    l2 |= (long)(1 << n2);
                }
                ++n4;
                ++n2;
            }
        }
        if (bl2) {
            return null;
        }
        if (l != 0L) {
            Object[] objectArray = new Object[typeArray2.length];
            Type[] typeArray4 = new Type[typeArray2.length];
            int n7 = 0;
            int n8 = 0;
            while (n7 != n3) {
                void var17_20 = typeArray2[n8];
                if ((l & (long)(1 << n8)) == 0L) {
                    objectArray[n8] = literal.argValues[n7];
                    typeArray4[n8] = literal.argTypes[n7];
                } else {
                    n2 = ((Number)literal.argValues[n7]).intValue();
                    boolean bl6 = classType.getName().equals("gnu.math.IntNum");
                    if (bl6) {
                        n2 -= Integer.MIN_VALUE;
                    }
                    Type type = ((ArrayType)var17_20).getComponentType();
                    typeArray4[n8] = var17_20;
                    objectArray[n8] = Array.newInstance(type.getReflectClass(), n2);
                    Object[] objectArray2 = literal.argValues;
                    if (bl6) {
                        int[] nArray = (int[])objectArray[n8];
                        for (n = n2; n > 0; --n) {
                            nArray[n2 - n] = (Integer)objectArray2[n7 + n];
                        }
                    } else {
                        int n9 = n2;
                        while (--n9 >= 0) {
                            Array.set(objectArray[n8], n9, objectArray2[n7 + 1 + n9]);
                        }
                    }
                    Literal literal2 = new Literal(objectArray[n8], (Type)var17_20);
                    if (type instanceof ObjectType) {
                        literal2.argValues = (Object[])objectArray[n8];
                    }
                    objectArray[n8] = literal2;
                    n7 += n2;
                }
                ++n7;
                ++n8;
            }
            literal.argValues = objectArray;
            literal.argTypes = typeArray4;
        }
        return method;
    }

    void putArgs(Literal literal, CodeAttr codeAttr) {
        Type[] typeArray = literal.argTypes;
        int n = typeArray.length;
        for (int i = 0; i < n; ++i) {
            Object object2 = literal.argValues[i];
            if (object2 instanceof Literal) {
                this.emit((Literal)object2, false);
                continue;
            }
            this.comp.compileConstant(object2, new StackTarget(typeArray[i]));
        }
    }

    private void store(Literal literal, boolean bl, CodeAttr codeAttr) {
        if (literal.field != null) {
            if (!bl) {
                codeAttr.emitDup(literal.type);
            }
            codeAttr.emitPutStatic(literal.field);
        }
        literal.flags |= 8;
    }

    void emit(Literal literal, boolean bl) {
        CodeAttr codeAttr = this.comp.getCode();
        if (literal.value == null) {
            if (!bl) {
                codeAttr.emitPushNull();
            }
        } else if (literal.value instanceof String) {
            if (!bl) {
                codeAttr.emitPushString(literal.value.toString());
            }
        } else if ((literal.flags & 8) != 0) {
            if (!bl) {
                codeAttr.emitGetStatic(literal.field);
            }
        } else if (literal.value instanceof Object[]) {
            int n = literal.argValues.length;
            Type type = ((ArrayType)literal.type).getComponentType();
            codeAttr.emitPushInt(n);
            codeAttr.emitNewArray(type);
            this.store(literal, bl, codeAttr);
            for (int i = 0; i < n; ++i) {
                Literal literal2 = (Literal)literal.argValues[i];
                if (literal2.value == null) continue;
                codeAttr.emitDup(type);
                codeAttr.emitPushInt(i);
                this.emit(literal2, false);
                codeAttr.emitArrayStore(type);
            }
        } else if (literal.type instanceof ArrayType) {
            codeAttr.emitPushPrimArray(literal.value, (ArrayType)literal.type);
            this.store(literal, bl, codeAttr);
        } else if (literal.value instanceof Class) {
            Class clazz = (Class)literal.value;
            if (clazz.isPrimitive()) {
                String string = clazz.getName();
                if (string.equals("int")) {
                    string = "integer";
                }
                string = "java.lang." + Character.toUpperCase(string.charAt(0)) + string.substring(1);
                codeAttr.emitGetStatic(ClassType.make(string).getDeclaredField("TYPE"));
            } else {
                this.comp.loadClassRef((ObjectType)Type.make(clazz));
            }
            this.store(literal, bl, codeAttr);
        } else if (literal.value instanceof ClassType && !((ClassType)literal.value).isExisting()) {
            this.comp.loadClassRef((ClassType)literal.value);
            Method method = Compilation.typeType.getDeclaredMethod("valueOf", 1);
            if (method == null) {
                method = Compilation.typeType.getDeclaredMethod("make", 1);
            }
            codeAttr.emitInvokeStatic(method);
            codeAttr.emitCheckcast(Compilation.typeClassType);
            this.store(literal, bl, codeAttr);
        } else {
            Object object2;
            ClassType classType = (ClassType)literal.type;
            boolean bl2 = (literal.flags & 4) != 0;
            Method method = null;
            boolean bl3 = false;
            if (!bl2) {
                method = this.getMethod(classType, "valueOf", literal, true);
                if (method == null && !(literal.value instanceof Values)) {
                    object2 = "make";
                    if (literal.value instanceof Pattern) {
                        object2 = "compile";
                    }
                    method = this.getMethod(classType, (String)object2, literal, true);
                }
                if (method != null) {
                    bl3 = true;
                } else if (literal.argTypes.length > 0) {
                    method = this.getMethod(classType, "<init>", literal, false);
                }
                if (method == null) {
                    bl2 = true;
                }
            }
            if (bl2) {
                method = this.getMethod(classType, "set", literal, false);
            }
            if (method == null && literal.argTypes.length > 0) {
                this.error("no method to construct " + literal.type);
            }
            if (bl3) {
                this.putArgs(literal, codeAttr);
                codeAttr.emitInvokeStatic(method);
            } else if (bl2) {
                codeAttr.emitNew(classType);
                codeAttr.emitDup(classType);
                object2 = classType.getDeclaredMethod("<init>", 0);
                codeAttr.emitInvokeSpecial((Method)object2);
            } else {
                codeAttr.emitNew(classType);
                codeAttr.emitDup(classType);
                this.putArgs(literal, codeAttr);
                codeAttr.emitInvokeSpecial(method);
            }
            Object object3 = object2 = bl3 || literal.value instanceof Values ? null : classType.getDeclaredMethod("readResolve", 0);
            if (object2 != null) {
                codeAttr.emitInvokeVirtual((Method)object2);
                classType.emitCoerceFromObject(codeAttr);
            }
            this.store(literal, bl && (!bl2 || method == null), codeAttr);
            if (bl2 && method != null) {
                if (!bl) {
                    codeAttr.emitDup(classType);
                }
                this.putArgs(literal, codeAttr);
                codeAttr.emitInvokeVirtual(method);
            }
        }
    }
}

