/*
 * Decompiled with CFR 0.152.
 */
package gnu.mapping;

import gnu.lists.Consumer;
import gnu.mapping.Environment;
import gnu.mapping.OutPort;
import gnu.mapping.ThreadLocation;
import gnu.mapping.TtyInPort;
import gnu.text.LineBufferedReader;
import gnu.text.Path;
import gnu.text.Printable;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;

public class InPort
extends LineBufferedReader
implements Printable {
    private static InPort systemInPort = new TtyInPort(System.in, Path.valueOf("/dev/stdin"), OutPort.outInitial);
    public static final ThreadLocation inLocation = new ThreadLocation("in-default");

    public InPort(Reader reader) {
        super(reader);
    }

    public InPort(Reader reader, Path path) {
        this(reader);
        this.setPath(path);
    }

    public InPort(InputStream inputStream) {
        super(inputStream);
    }

    public InPort(InputStream inputStream, Path path) {
        this(inputStream);
        this.setPath(path);
    }

    public static Reader convertToReader(InputStream inputStream, Object object2) {
        if (object2 != null && object2 != Boolean.TRUE) {
            String string = object2 == Boolean.FALSE ? "8859_1" : object2.toString();
            try {
                return new InputStreamReader(inputStream, string);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new RuntimeException("unknown character encoding: " + string);
            }
        }
        return new InputStreamReader(inputStream);
    }

    public InPort(InputStream inputStream, Path path, Object object2) throws UnsupportedEncodingException {
        this(InPort.convertToReader(inputStream, object2), path);
        if (object2 == Boolean.FALSE) {
            try {
                this.setBuffer(new char[2048]);
            }
            catch (IOException iOException) {}
        } else {
            this.setConvertCR(true);
        }
    }

    public static InPort inDefault() {
        return (InPort)inLocation.get();
    }

    public static void setInDefault(InPort inPort) {
        inLocation.set(inPort);
    }

    public static InPort openFile(Object object2) throws IOException {
        Path path = Path.valueOf(object2);
        InputStream inputStream = path.openInputStream();
        inputStream = new BufferedInputStream(inputStream);
        return InPort.openFile(inputStream, path);
    }

    public static InPort openFile(InputStream inputStream, Object object2) throws UnsupportedEncodingException {
        return new InPort(inputStream, Path.valueOf(object2), Environment.user().get("port-char-encoding"));
    }

    public void print(Consumer consumer) {
        consumer.write("#<input-port");
        String string = this.getName();
        if (string != null) {
            consumer.write(32);
            consumer.write(string);
        }
        consumer.write(62);
    }

    static {
        inLocation.setGlobal(systemInPort);
    }
}

