/*
 * Decompiled with CFR 0.152.
 */
package kawa.lang;

import gnu.expr.Compilation;
import gnu.expr.Declaration;
import gnu.expr.ModuleExp;
import gnu.expr.ScopeExp;
import gnu.lists.Consumer;
import gnu.lists.FVector;
import gnu.lists.LList;
import gnu.lists.Pair;
import gnu.mapping.OutPort;
import gnu.mapping.Symbol;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.PrintWriter;
import java.util.Vector;
import kawa.lang.Macro;
import kawa.lang.Pattern;
import kawa.lang.PatternScope;
import kawa.lang.SyntaxForm;
import kawa.lang.SyntaxTemplate;
import kawa.lang.TemplateScope;
import kawa.lang.Translator;

public class SyntaxPattern
extends Pattern
implements Externalizable {
    String program;
    static final int MATCH_MISC = 0;
    static final int MATCH_NIL = 8;
    static final int MATCH_VECTOR = 16;
    static final int MATCH_IGNORE = 24;
    static final int MATCH_WIDE = 1;
    static final int MATCH_EQUALS = 2;
    static final int MATCH_ANY = 3;
    static final int MATCH_PAIR = 4;
    static final int MATCH_LREPEAT = 5;
    static final int MATCH_LENGTH = 6;
    static final int MATCH_ANY_CAR = 7;
    Object[] literals;
    int varCount;

    public int varCount() {
        return this.varCount;
    }

    public boolean match(Object object2, Object[] objectArray, int n) {
        boolean bl = this.match(object2, objectArray, n, 0, null);
        return bl;
    }

    public SyntaxPattern(String string, Object[] objectArray, int n) {
        this.program = string;
        this.literals = objectArray;
        this.varCount = n;
    }

    public SyntaxPattern(Object object2, Object[] objectArray, Translator translator) {
        this(new StringBuffer(), object2, null, objectArray, translator);
    }

    SyntaxPattern(StringBuffer stringBuffer, Object object2, SyntaxForm syntaxForm, Object[] objectArray, Translator translator) {
        Vector vector = new Vector();
        this.translate(object2, stringBuffer, objectArray, 0, vector, null, '\u0000', translator);
        this.program = stringBuffer.toString();
        this.literals = new Object[vector.size()];
        vector.copyInto(this.literals);
        this.varCount = translator.patternScope.pattern_names.size();
    }

    public void disassemble() {
        this.disassemble(OutPort.errDefault(), (Translator)Compilation.getCurrent(), 0, this.program.length());
    }

    public void disassemble(PrintWriter printWriter, Translator translator) {
        this.disassemble(printWriter, translator, 0, this.program.length());
    }

    void disassemble(PrintWriter printWriter, Translator translator, int n, int n2) {
        Vector vector = null;
        if (translator != null && translator.patternScope != null) {
            vector = translator.patternScope.pattern_names;
        }
        int n3 = 0;
        int n4 = n;
        block9: while (n4 < n2) {
            char c = this.program.charAt(n4);
            printWriter.print(" " + n4 + ": " + c);
            ++n4;
            int n5 = c & 7;
            n3 = n3 << 13 | c >> 3;
            switch (n5) {
                case 1: {
                    printWriter.println(" - WIDE " + n3);
                    continue block9;
                }
                case 2: {
                    printWriter.print(" - EQUALS[" + n3 + "]");
                    if (this.literals != null && n3 >= 0 && n3 < this.literals.length) {
                        printWriter.print(this.literals[n3]);
                    }
                    printWriter.println();
                    break;
                }
                case 3: 
                case 7: {
                    printWriter.print((n5 == 3 ? " - ANY[" : " - ANY_CAR[") + n3 + "]");
                    if (vector != null && n3 >= 0 && n3 < vector.size()) {
                        printWriter.print(vector.elementAt(n3));
                    }
                    printWriter.println();
                    break;
                }
                case 4: {
                    printWriter.println(" - PAIR[" + n3 + "]");
                    break;
                }
                case 5: {
                    printWriter.println(" - LREPEAT[" + n3 + "]");
                    this.disassemble(printWriter, translator, n4, n4 + n3);
                    printWriter.println(" " + (n4 += n3) + ": - repeat first var:" + (this.program.charAt(n4++) >> 3));
                    printWriter.println(" " + n4 + ": - repeast nested vars:" + (this.program.charAt(n4++) >> 3));
                    break;
                }
                case 6: {
                    printWriter.println(" - LENGTH " + (n3 >> 1) + " pairs. " + ((n3 & 1) == 0 ? "pure list" : "impure list"));
                    break;
                }
                case 0: {
                    printWriter.print("[misc ch:" + c + " n:" + 8 + "]");
                    if (c == '\b') {
                        printWriter.println(" - NIL");
                        break;
                    }
                    if (c == '\u0010') {
                        printWriter.println(" - VECTOR");
                        break;
                    }
                    if (c == '\u0018') {
                        printWriter.println(" - IGNORE");
                        break;
                    }
                }
                default: {
                    printWriter.println(" - " + n5 + '/' + n3);
                }
            }
            n3 = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void translate(Object object2, StringBuffer stringBuffer, Object[] objectArray, int n, Vector vector, SyntaxForm syntaxForm, char c, Translator translator) {
        PatternScope patternScope = translator.patternScope;
        Vector vector2 = patternScope.pattern_names;
        while (true) {
            Object object3;
            Object object4;
            Object object5;
            if (object2 instanceof SyntaxForm) {
                syntaxForm = (SyntaxForm)object2;
                object2 = syntaxForm.form;
                continue;
            }
            if (object2 instanceof Pair) {
                Object object6 = translator.pushPositionOf(object2);
                try {
                    int n2 = stringBuffer.length();
                    stringBuffer.append('\u0004');
                    object5 = (Pair)object2;
                    object4 = syntaxForm;
                    object3 = ((Pair)object5).getCdr();
                    while (object3 instanceof SyntaxForm) {
                        syntaxForm = (SyntaxForm)object3;
                        object3 = syntaxForm.form;
                    }
                    boolean bl = false;
                    if (object3 instanceof Pair && translator.matches(((Pair)object3).getCar(), "...")) {
                        bl = true;
                        object3 = ((Pair)object3).getCdr();
                        while (object3 instanceof SyntaxForm) {
                            syntaxForm = (SyntaxForm)object3;
                            object3 = syntaxForm.form;
                        }
                    }
                    int n3 = vector2.size();
                    if (c == 'P') {
                        c = '\u0000';
                    }
                    this.translate(((Pair)object5).getCar(), stringBuffer, objectArray, bl ? n + 1 : n, vector, (SyntaxForm)object4, c == 'V' ? (char)'\u0000' : 'P', translator);
                    int n4 = vector2.size() - n3;
                    int n5 = stringBuffer.length() - n2 - 1 << 3 | (bl ? 5 : 4);
                    if (n5 > 65535) {
                        n2 += SyntaxPattern.insertInt(n2, stringBuffer, (n5 >> 13) + 1);
                    }
                    stringBuffer.setCharAt(n2, (char)n5);
                    int n6 = Translator.listLength(object3);
                    if (n6 == Integer.MIN_VALUE) {
                        translator.syntaxError("cyclic pattern list");
                        return;
                    }
                    if (bl) {
                        SyntaxPattern.addInt(stringBuffer, n3 << 3);
                        SyntaxPattern.addInt(stringBuffer, n4 << 3);
                        if (object3 == LList.Empty) {
                            stringBuffer.append('\b');
                            return;
                        }
                        n6 = n6 >= 0 ? n6 << 1 : (-n6 << 1) - 1;
                        SyntaxPattern.addInt(stringBuffer, n6 << 3 | 6);
                    }
                    object2 = object3;
                }
                finally {
                    translator.popPositionOf(object6);
                }
                continue;
            }
            if (object2 instanceof Symbol) {
                int n7 = objectArray.length;
                while (--n7 >= 0) {
                    ScopeExp scopeExp = translator.currentScope();
                    object5 = syntaxForm == null ? scopeExp : syntaxForm.scope;
                    object3 = objectArray[n7];
                    if (object3 instanceof SyntaxForm) {
                        SyntaxForm syntaxForm2 = (SyntaxForm)object3;
                        object3 = syntaxForm2.form;
                        object4 = syntaxForm2.scope;
                    } else {
                        object4 = translator.currentMacroDefinition != null ? translator.currentMacroDefinition.getCapturedScope() : scopeExp;
                    }
                    if (!SyntaxPattern.literalIdentifierEq(object2, (ScopeExp)object5, object3, (ScopeExp)object4)) continue;
                    int n8 = SyntaxTemplate.indexOf(vector, object2);
                    if (n8 < 0) {
                        n8 = vector.size();
                        vector.addElement(object2);
                    }
                    SyntaxPattern.addInt(stringBuffer, n8 << 3 | 2);
                    return;
                }
                if (vector2.contains(object2)) {
                    translator.syntaxError("duplicated pattern variable " + object2);
                }
                n7 = vector2.size();
                vector2.addElement(object2);
                boolean bl = c == 'P';
                int n9 = (n << 1) + (bl ? 1 : 0);
                patternScope.patternNesting.append((char)n9);
                object4 = patternScope.addDeclaration(object2);
                ((Declaration)object4).setLocation(translator);
                translator.push((Declaration)object4);
                SyntaxPattern.addInt(stringBuffer, n7 << 3 | (bl ? 7 : 3));
                return;
            }
            if (object2 == LList.Empty) {
                stringBuffer.append('\b');
                return;
            }
            if (!(object2 instanceof FVector)) break;
            stringBuffer.append('\u0010');
            object2 = LList.makeList((FVector)object2);
            c = (char)86;
        }
        int n10 = SyntaxTemplate.indexOf(vector, object2);
        if (n10 < 0) {
            n10 = vector.size();
            vector.addElement(object2);
        }
        SyntaxPattern.addInt(stringBuffer, n10 << 3 | 2);
    }

    private static void addInt(StringBuffer stringBuffer, int n) {
        if (n > 65535) {
            SyntaxPattern.addInt(stringBuffer, (n << 13) + 1);
        }
        stringBuffer.append((char)n);
    }

    private static int insertInt(int n, StringBuffer stringBuffer, int n2) {
        if (n2 > 65535) {
            n += SyntaxPattern.insertInt(n, stringBuffer, (n2 << 13) + 1);
        }
        stringBuffer.insert(n, (char)n2);
        return n + 1;
    }

    boolean match_car(Pair pair, Object[] objectArray, int n, int n2, SyntaxForm syntaxForm) {
        int n3 = n2;
        char c = this.program.charAt(n2++);
        int n4 = c >> 3;
        while ((c & 7) == 1) {
            c = this.program.charAt(n2++);
            n4 = n4 << 13 | c >> 3;
        }
        if ((c & 7) == 7) {
            if (syntaxForm != null && !(pair.getCar() instanceof SyntaxForm)) {
                pair = Translator.makePair(pair, syntaxForm.fromDatum(pair.getCar()), pair.getCdr());
            }
            objectArray[n + n4] = pair;
            return true;
        }
        return this.match(pair.getCar(), objectArray, n, n3, syntaxForm);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean match(Object object2, Object[] objectArray, int n, int n2, SyntaxForm syntaxForm) {
        int n3 = 0;
        block10: while (true) {
            if (object2 instanceof SyntaxForm) {
                syntaxForm = (SyntaxForm)object2;
                object2 = syntaxForm.form;
                continue;
            }
            char c = this.program.charAt(n2++);
            int n4 = c & 7;
            n3 = n3 << 13 | c >> 3;
            switch (n4) {
                case 1: {
                    continue block10;
                }
                case 0: {
                    if (c == '\b') {
                        if (object2 != LList.Empty) return false;
                        return true;
                    }
                    if (c == '\u0010') {
                        if (object2 instanceof FVector) return this.match(LList.makeList((FVector)object2), objectArray, n, n2, syntaxForm);
                        return false;
                    }
                    if (c != '\u0018') throw new Error("unknwon pattern opcode");
                    return true;
                }
                case 8: {
                    if (object2 != LList.Empty) return false;
                    return true;
                }
                case 6: {
                    int n5 = n3 >> 1;
                    Object object3 = object2;
                    int n6 = 0;
                    while (true) {
                        if (object3 instanceof SyntaxForm) {
                            object3 = ((SyntaxForm)object3).form;
                            continue;
                        }
                        if (n6 == n5) {
                            if (!((n3 & 1) == 0 ? object3 != LList.Empty : object3 instanceof Pair)) break;
                            return false;
                        }
                        if (!(object3 instanceof Pair)) return false;
                        object3 = ((Pair)object3).getCdr();
                        ++n6;
                    }
                    n3 = 0;
                    continue block10;
                }
                case 4: {
                    if (!(object2 instanceof Pair)) {
                        return false;
                    }
                    Pair pair = (Pair)object2;
                    if (!this.match_car(pair, objectArray, n, n2, syntaxForm)) {
                        return false;
                    }
                    n2 += n3;
                    n3 = 0;
                    object2 = pair.getCdr();
                    continue block10;
                }
                case 5: {
                    int n7;
                    boolean bl;
                    int n8;
                    Pair pair;
                    int n6 = n2;
                    n2 += n3;
                    c = this.program.charAt(n2++);
                    int n9 = c >> 3;
                    while ((c & 7) == 1) {
                        c = this.program.charAt(n2++);
                        n9 = n9 << 13 | c >> 3;
                    }
                    n9 += n;
                    int n10 = this.program.charAt(n2++) >> 3;
                    while ((c & 7) == 1) {
                        c = this.program.charAt(n2++);
                        n10 = n10 << 13 | c >> 3;
                    }
                    c = this.program.charAt(n2++);
                    boolean bl2 = true;
                    if (c == '\b') {
                        n8 = 0;
                    } else {
                        n3 = c >> 3;
                        while ((c & 7) == 1) {
                            c = this.program.charAt(n2++);
                            n3 = n3 << 13 | c >> 3;
                        }
                        if ((n3 & 1) != 0) {
                            bl2 = false;
                        }
                        n8 = n3 >> 1;
                    }
                    int n11 = Translator.listLength(object2);
                    if (n11 >= 0) {
                        bl = true;
                    } else {
                        bl = false;
                        n11 = -1 - n11;
                    }
                    if (n11 < n8) return false;
                    if (bl2 && !bl) {
                        return false;
                    }
                    int n12 = n11 - n8;
                    Object[][] objectArrayArray = new Object[n10][];
                    for (n7 = 0; n7 < n10; ++n7) {
                        objectArrayArray[n7] = new Object[n12];
                    }
                    for (n7 = 0; n7 < n12; ++n7) {
                        while (object2 instanceof SyntaxForm) {
                            syntaxForm = (SyntaxForm)object2;
                            object2 = syntaxForm.form;
                        }
                        pair = (Pair)object2;
                        if (!this.match_car(pair, objectArray, n, n6, syntaxForm)) {
                            return false;
                        }
                        object2 = pair.getCdr();
                        for (int i = 0; i < n10; ++i) {
                            objectArrayArray[i][n7] = objectArray[n9 + i];
                        }
                    }
                    for (n7 = 0; n7 < n10; ++n7) {
                        objectArray[n9 + n7] = objectArrayArray[n7];
                    }
                    n3 = 0;
                    if (n8 == 0 && bl2) return true;
                    continue block10;
                }
                case 2: {
                    ScopeExp scopeExp;
                    Object object4;
                    TemplateScope templateScope;
                    Object object5;
                    Object object6;
                    Object object7 = this.literals[n3];
                    Translator translator = (Translator)Compilation.getCurrent();
                    if (object7 instanceof SyntaxForm) {
                        object6 = (SyntaxForm)object7;
                        object5 = ((SyntaxForm)object6).form;
                        templateScope = ((SyntaxForm)object6).scope;
                    } else {
                        object5 = object7;
                        object6 = translator.getCurrentSyntax();
                        ScopeExp scopeExp2 = templateScope = object6 instanceof Macro ? ((Macro)object6).getCapturedScope() : null;
                    }
                    if (object2 instanceof SyntaxForm) {
                        object6 = (SyntaxForm)object2;
                        object4 = ((SyntaxForm)object6).form;
                        scopeExp = ((SyntaxForm)object6).scope;
                        return SyntaxPattern.literalIdentifierEq(object5, templateScope, object4, scopeExp);
                    } else {
                        object4 = object2;
                        scopeExp = syntaxForm == null ? translator.currentScope() : syntaxForm.scope;
                    }
                    return SyntaxPattern.literalIdentifierEq(object5, templateScope, object4, scopeExp);
                }
                case 3: {
                    if (syntaxForm != null) {
                        object2 = syntaxForm.fromDatum(object2);
                    }
                    objectArray[n + n3] = object2;
                    return true;
                }
            }
            break;
        }
        this.disassemble();
        throw new Error("unrecognized pattern opcode @pc:" + n2);
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(this.program);
        objectOutput.writeObject(this.literals);
        objectOutput.writeInt(this.varCount);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.literals = (Object[])objectInput.readObject();
        this.program = (String)objectInput.readObject();
        this.varCount = objectInput.readInt();
    }

    public static Object[] allocVars(int n, Object[] objectArray) {
        Object[] objectArray2 = new Object[n];
        if (objectArray != null) {
            System.arraycopy(objectArray, 0, objectArray2, 0, objectArray.length);
        }
        return objectArray2;
    }

    public static boolean literalIdentifierEq(Object object2, ScopeExp scopeExp, Object object3, ScopeExp scopeExp2) {
        if (!(object2 == object3 || object2 != null && object3 != null && object2.equals(object3))) {
            return false;
        }
        if (scopeExp == scopeExp2) {
            return true;
        }
        Declaration declaration = null;
        Declaration declaration2 = null;
        while (scopeExp != null && !(scopeExp instanceof ModuleExp) && (declaration = scopeExp.lookup(object2)) == null) {
            scopeExp = scopeExp.outer;
        }
        while (scopeExp2 != null && !(scopeExp2 instanceof ModuleExp) && (declaration2 = scopeExp2.lookup(object3)) == null) {
            scopeExp2 = scopeExp2.outer;
        }
        return declaration == declaration2;
    }

    public static Object[] getLiteralsList(Object object2, SyntaxForm syntaxForm, Translator translator) {
        Object object3 = translator.pushPositionOf(object2);
        int n = Translator.listLength(object2);
        if (n < 0) {
            translator.error('e', "missing or malformed literals list");
            n = 0;
        }
        Object[] objectArray = new Object[n + 1];
        for (int i = 1; i <= n; ++i) {
            Object object4;
            while (object2 instanceof SyntaxForm) {
                syntaxForm = (SyntaxForm)object2;
                object2 = syntaxForm.form;
            }
            Pair pair = (Pair)object2;
            translator.pushPositionOf(pair);
            Object object5 = pair.getCar();
            if (object5 instanceof SyntaxForm) {
                object4 = object5;
                object5 = ((SyntaxForm)object5).form;
            } else {
                object4 = object5;
            }
            if (!(object5 instanceof Symbol)) {
                translator.error('e', "non-symbol '" + object5 + "' in literals list");
            }
            objectArray[i] = object4;
            object2 = pair.getCdr();
        }
        translator.popPositionOf(object3);
        return objectArray;
    }

    public void print(Consumer consumer) {
        consumer.write("#<syntax-pattern>");
    }
}

