/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.models;

import de.erichseifert.vectorgraphics2d.Document;
import de.erichseifert.vectorgraphics2d.VectorGraphics2D;
import de.erichseifert.vectorgraphics2d.svg.SVGProcessor;
import de.erichseifert.vectorgraphics2d.util.PageSize;
import gnu.kawa.models.Paintable;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.Rectangle2D;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;

public class SVGUtils {
    public static boolean haveToSvg = true;
    public static final String UNSUPPORTED = "[converting to SVG not supported]";

    public static String toSVG(Paintable p) {
        VectorGraphics2D g2;
        SVGProcessor svgProcessor;
        try {
            svgProcessor = new SVGProcessor();
            g2 = new VectorGraphics2D();
        }
        catch (Throwable ex) {
            return UNSUPPORTED;
        }
        try {
            int close;
            Rectangle2D bounds = p.getBounds2D();
            g2.setPaint((Paint)Color.BLACK);
            p.paint((Graphics2D)g2);
            Document document = svgProcessor.getDocument(g2.getCommands(), new PageSize(bounds));
            ByteArrayOutputStream byteOutput = new ByteArrayOutputStream();
            document.writeTo((OutputStream)byteOutput);
            String str = new String(byteOutput.toByteArray());
            str = str.trim();
            int doctype = str.indexOf("<!DOCTYPE svg");
            if (doctype >= 0 && (close = str.indexOf(">\n", doctype)) > 0) {
                str = str.substring(close + 2);
            }
            return str;
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            return "[Caught " + ex + " while generating SVG]";
        }
    }
}

