/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.relaxNG;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.javaee.ResourceRegistrar;
import com.intellij.javaee.StandardResourceProvider;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.filters.AndFilter;
import com.intellij.psi.filters.ClassFilter;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.filters.position.NamespaceFilter;
import com.intellij.psi.meta.MetaDataContributor;
import com.intellij.psi.meta.MetaDataRegistrar;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import java.util.Arrays;
import java.util.List;
import org.intellij.plugins.relaxNG.compact.psi.impl.RncDocument;
import org.intellij.plugins.relaxNG.inspections.RngDomInspection;
import org.intellij.plugins.relaxNG.inspections.UnusedDefineInspection;
import org.intellij.plugins.relaxNG.model.descriptors.RngNsDescriptor;
import org.intellij.plugins.relaxNG.xml.dom.RngDefine;
import org.intellij.plugins.relaxNG.xml.dom.impl.RngDefineMetaData;
import org.jetbrains.annotations.NotNull;

public final class RelaxNgMetaDataContributor
implements MetaDataContributor {
    public static final String RNG_NAMESPACE = "http://relaxng.org/ns/structure/1.0";

    public void contributeMetaData(@NotNull MetaDataRegistrar registrar) {
        if (registrar == null) {
            RelaxNgMetaDataContributor.$$$reportNull$$$0(0);
        }
        registrar.registerMetaData((ElementFilter)new AndFilter((ElementFilter)new NamespaceFilter(new String[]{RNG_NAMESPACE}), (ElementFilter)new ClassFilter(XmlDocument.class)), RngNsDescriptor.class);
        registrar.registerMetaData((ElementFilter)new ClassFilter(RncDocument.class), RngNsDescriptor.class);
        registrar.registerMetaData(new ElementFilter(this){

            public boolean isAcceptable(Object element, PsiElement context) {
                if (element instanceof XmlTag) {
                    XmlTag tag = (XmlTag)element;
                    DomElement domElement = DomManager.getDomManager((Project)tag.getProject()).getDomElement(tag);
                    return domElement instanceof RngDefine;
                }
                return false;
            }

            public boolean isClassAcceptable(Class hintClass) {
                return XmlTag.class.isAssignableFrom(hintClass);
            }
        }, RngDefineMetaData.class);
    }

    @NotNull
    public static List<Class<? extends LocalInspectionTool>> getInspectionClasses() {
        List<Class<? extends LocalInspectionTool>> list = Arrays.asList(RngDomInspection.class, UnusedDefineInspection.class);
        if (list == null) {
            RelaxNgMetaDataContributor.$$$reportNull$$$0(1);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registrar";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/plugins/relaxNG/RelaxNgMetaDataContributor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/plugins/relaxNG/RelaxNgMetaDataContributor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInspectionClasses";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "contributeMetaData";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    static final class ResourceProvider
    implements StandardResourceProvider {
        ResourceProvider() {
        }

        public void registerResources(ResourceRegistrar registrar) {
            ClassLoader classLoader = this.getClass().getClassLoader();
            registrar.addStdResource(RelaxNgMetaDataContributor.RNG_NAMESPACE, "resources/relaxng.rng", classLoader);
            registrar.addStdResource("http://www.w3.org/2000/svg", "resources/html5-schema/svg20/svg20.rnc", classLoader);
            registrar.addStdResource("http://www.w3.org/1998/Math/MathML", "resources/html5-schema/mml3/mathml3.rnc", classLoader);
            registrar.addIgnoredResource("http://relaxng.org/ns/compatibility/annotations/1.0");
        }
    }
}

