/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.model;

import net.sf.freecol.common.model.Direction;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.IndianSettlement;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TileType;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.server.ServerTestHelper;
import net.sf.freecol.server.model.ServerGame;
import net.sf.freecol.util.test.FreeColTestCase;

public class ServerIndianSettlementTest
extends FreeColTestCase {
    private static final GoodsType clothType = ServerIndianSettlementTest.spec().getGoodsType("model.goods.cloth");
    private static final GoodsType coatsType = ServerIndianSettlementTest.spec().getGoodsType("model.goods.coats");
    private static final GoodsType foodType = ServerIndianSettlementTest.spec().getPrimaryFoodType();
    private static final GoodsType grainType = ServerIndianSettlementTest.spec().getGoodsType("model.goods.grain");
    private static final GoodsType horsesType = ServerIndianSettlementTest.spec().getGoodsType("model.goods.horses");
    private static final GoodsType rumType = ServerIndianSettlementTest.spec().getGoodsType("model.goods.rum");
    private static final GoodsType toolsType = ServerIndianSettlementTest.spec().getGoodsType("model.goods.tools");
    private static final TileType desertType = ServerIndianSettlementTest.spec().getTileType("model.tile.desert");
    private static final TileType plainsType = ServerIndianSettlementTest.spec().getTileType("model.tile.plains");
    private static final UnitType brave = ServerIndianSettlementTest.spec().getUnitType("model.unit.brave");

    public void testFoodConsumption() {
        ServerGame game = ServerTestHelper.startServerGame(ServerIndianSettlementTest.getTestMap());
        FreeColTestCase.IndianSettlementBuilder builder = new FreeColTestCase.IndianSettlementBuilder(game);
        IndianSettlement camp = builder.build();
        ServerIndianSettlementTest.assertEquals((int)1, (int)camp.getUnitCount());
        ServerIndianSettlementTest.assertEquals((int)0, (int)camp.getGoodsCount(foodType));
        int foodProduced = camp.getTotalProductionOf(grainType);
        int foodConsumed = camp.getFoodConsumption();
        ServerIndianSettlementTest.assertTrue((String)"Food Produced should be more the food consumed", (foodProduced > foodConsumed ? 1 : 0) != 0);
        ServerTestHelper.newTurn();
        int foodRemaining = Math.max(foodProduced - foodConsumed, 0);
        ServerIndianSettlementTest.assertEquals((String)"Unexpected value for remaining food, ", (int)foodRemaining, (int)camp.getGoodsCount(foodType));
    }

    public void testHorseBreeding() {
        ServerGame game = ServerTestHelper.startServerGame(ServerIndianSettlementTest.getTestMap());
        FreeColTestCase.IndianSettlementBuilder builder = new FreeColTestCase.IndianSettlementBuilder(game);
        IndianSettlement camp = builder.build();
        ServerIndianSettlementTest.assertEquals((int)1, (int)camp.getUnitCount());
        ServerIndianSettlementTest.assertEquals((int)0, (int)camp.getGoodsCount(foodType));
        int initialHorses = horsesType.getBreedingNumber();
        camp.addGoods(horsesType, initialHorses);
        ServerIndianSettlementTest.assertEquals((String)"Horses need grain", (Object)grainType, (Object)horsesType.getInputType());
        int foodProduced = camp.getTotalProductionOf(grainType);
        int foodConsumed = camp.getFoodConsumption();
        int foodAvail = foodProduced - foodConsumed;
        ServerIndianSettlementTest.assertTrue((String)"Food Produced should be more the food consumed", (foodProduced > foodConsumed ? 1 : 0) != 0);
        int expectedHorseProd = Math.min(2, foodAvail);
        ServerIndianSettlementTest.assertTrue((String)"Horses should breed", (expectedHorseProd > 0 ? 1 : 0) != 0);
        ServerTestHelper.newTurn();
        int horsesBred = camp.getGoodsCount(horsesType) - initialHorses;
        ServerIndianSettlementTest.assertEquals((String)"Wrong number of horses bred", (int)expectedHorseProd, (int)horsesBred);
    }

    public void testHorseBreedingNoFoodAvail() {
        ServerGame game = ServerTestHelper.startServerGame(ServerIndianSettlementTest.getTestMap(desertType));
        int initialBravesInCamp = 3;
        FreeColTestCase.IndianSettlementBuilder builder = new FreeColTestCase.IndianSettlementBuilder(game);
        IndianSettlement camp1 = builder.initialBravesInCamp(initialBravesInCamp).build();
        IndianSettlement camp2 = builder.reset().settlementTile(camp1.getTile().getNeighbourOrNull(Direction.N).getNeighbourOrNull(Direction.N)).build();
        for (Tile t : camp1.getTile().getSurroundingTiles(camp1.getRadius())) {
            t.changeOwnership(camp2.getOwner(), camp2);
        }
        ServerIndianSettlementTest.assertEquals((int)initialBravesInCamp, (int)camp1.getUnitCount());
        ServerIndianSettlementTest.assertEquals((int)0, (int)camp1.getGoodsCount(foodType));
        int foodProduced = camp1.getTotalProductionOf(grainType);
        int foodConsumed = camp1.getFoodConsumption();
        ServerIndianSettlementTest.assertEquals((int)2, (int)brave.getConsumptionOf(foodType));
        ServerIndianSettlementTest.assertEquals((int)(2 * camp1.getUnitCount()), (int)foodConsumed);
        ServerIndianSettlementTest.assertTrue((String)"Food Produced should be less the food consumed", (foodProduced < foodConsumed ? 1 : 0) != 0);
        int initialHorses = 2;
        camp1.addGoods(horsesType, initialHorses);
        ServerTestHelper.newTurn();
        int expectedHorsesBreeded = 0;
        int horsesBreeded = camp1.getGoodsCount(horsesType) - initialHorses;
        ServerIndianSettlementTest.assertEquals((String)"No horses should be bred", (int)expectedHorsesBreeded, (int)horsesBreeded);
    }

    public void testPricing() {
        ServerGame game = ServerTestHelper.startServerGame(ServerIndianSettlementTest.getTestMap(plainsType));
        int braveCount = 4;
        FreeColTestCase.IndianSettlementBuilder builder = new FreeColTestCase.IndianSettlementBuilder(game);
        IndianSettlement camp = builder.initialBravesInCamp(4).build();
        int topPrice = 12 + camp.getType().getTradeBonus();
        camp.setWantedGoods(0, null);
        camp.setWantedGoods(1, null);
        camp.setWantedGoods(2, null);
        ServerIndianSettlementTest.assertEquals((int)4, (int)camp.getUnitCount());
        ServerIndianSettlementTest.assertEquals((String)"High price for horses", (int)topPrice, (int)camp.getPriceToBuy(horsesType, 1));
        camp.addGoods(horsesType, 50);
        ServerIndianSettlementTest.assertEquals((String)"Still high price for horses", (int)topPrice, (int)camp.getPriceToBuy(horsesType, 1));
        camp.addGoods(horsesType, 50);
        ServerIndianSettlementTest.assertTrue((String)"Commercial price for horses", (camp.getPriceToBuy(horsesType, 1) <= topPrice / 2 ? 1 : 0) != 0);
        ServerIndianSettlementTest.assertTrue((String)"Grain is farmed", (boolean)grainType.isFarmed());
        ServerIndianSettlementTest.assertTrue((String)"Devalue farmed goods", (camp.getPriceToBuy(grainType, 100) <= 100 * topPrice / 2 ? 1 : 0) != 0);
        ServerIndianSettlementTest.assertEquals((int)0, (int)camp.getGoodsCount(rumType));
        ServerIndianSettlementTest.assertEquals((String)"Buy rum", (int)topPrice, (int)camp.getPriceToBuy(rumType, 1));
        camp.addGoods(rumType, 100);
        ServerIndianSettlementTest.assertTrue((String)"Add rum", (camp.getPriceToBuy(rumType, 1) <= topPrice / 2 ? 1 : 0) != 0);
        ServerIndianSettlementTest.assertTrue((String)"Add more rum", (camp.getPriceToBuy(rumType, 99) <= 99 * topPrice / 2 ? 1 : 0) != 0);
        camp.addGoods(rumType, 100);
        ServerIndianSettlementTest.assertEquals((String)"Do not buy more rum", (int)0, (int)camp.getPriceToBuy(rumType, 1));
        ServerIndianSettlementTest.assertTrue((String)("Cloth (" + camp.getPriceToBuy(clothType, 50) + ") cheaper than coats (" + camp.getPriceToBuy(coatsType, 50) + ")"), (camp.getPriceToBuy(clothType, 50) < camp.getPriceToBuy(coatsType, 50) ? 1 : 0) != 0);
        camp.addGoods(clothType, 20);
        camp.addGoods(coatsType, 20);
        ServerIndianSettlementTest.assertTrue((String)("Cloth still (" + camp.getPriceToBuy(clothType, 50) + ") cheaper than coats (" + camp.getPriceToBuy(coatsType, 50) + ")"), (camp.getPriceToBuy(clothType, 50) < camp.getPriceToBuy(coatsType, 50) ? 1 : 0) != 0);
        camp.addGoods(clothType, 100);
        camp.addGoods(coatsType, 100);
        ServerIndianSettlementTest.assertEquals((String)"Cloth now ignored", (int)0, (int)camp.getPriceToBuy(clothType, 1));
        ServerIndianSettlementTest.assertEquals((String)"Coats now ignored", (int)0, (int)camp.getPriceToBuy(coatsType, 1));
        camp.setWantedGoods(2, horsesType);
        camp.setWantedGoods(1, horsesType);
        camp.setWantedGoods(0, horsesType);
        int p3 = camp.getPriceToBuy(toolsType, 50);
        camp.setWantedGoods(2, toolsType);
        camp.setWantedGoods(1, horsesType);
        camp.setWantedGoods(0, horsesType);
        int p2 = camp.getPriceToBuy(toolsType, 50);
        ServerIndianSettlementTest.assertTrue((String)("Wanted 2: (" + p2 + " > " + p3 + ")"), (p2 > p3 ? 1 : 0) != 0);
        camp.setWantedGoods(2, horsesType);
        camp.setWantedGoods(1, toolsType);
        camp.setWantedGoods(0, horsesType);
        int p1 = camp.getPriceToBuy(toolsType, 50);
        ServerIndianSettlementTest.assertTrue((String)("Wanted 1: (" + p1 + " > " + p2 + ")"), (p1 > p2 ? 1 : 0) != 0);
        camp.setWantedGoods(2, horsesType);
        camp.setWantedGoods(1, horsesType);
        camp.setWantedGoods(0, toolsType);
        int p0 = camp.getPriceToBuy(toolsType, 50);
        ServerIndianSettlementTest.assertTrue((String)("Wanted 0: (" + p0 + " > " + p1 + ")"), (p0 > p1 ? 1 : 0) != 0);
    }
}

