/*
 * Decompiled with CFR 0.152.
 */
package com.inet.jortho;

import com.inet.jortho.UserDictionaryProvider;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Locale;

public class FileUserDictionary
implements UserDictionaryProvider {
    private File file;
    private final String fileBase;

    public FileUserDictionary() {
        this("");
    }

    public FileUserDictionary(String fileBase) {
        if (fileBase == null) {
            fileBase = "";
        }
        fileBase = fileBase.trim();
        if ((fileBase = fileBase.replace('\\', '/')).length() > 0 && !fileBase.endsWith("/")) {
            fileBase = fileBase + "/";
        }
        this.fileBase = fileBase;
    }

    @Override
    public void addWord(String word) {
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(this.file, true), "UTF8");){
            if (this.file.length() > 0L) {
                writer.write("\n");
            }
            writer.write(word);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public String getUserWords(Locale locale) {
        this.file = new File(this.fileBase + "UserDictionary_" + locale + ".txt");
        try {
            FileInputStream input = new FileInputStream(this.file);
            StringBuilder builder = new StringBuilder();
            char[] buffer = new char[4096];
            try (InputStreamReader reader = new InputStreamReader((InputStream)input, "UTF8");){
                int count = 0;
                while ((count = reader.read(buffer)) > 0) {
                    builder.append(buffer, 0, count);
                }
            }
            return builder.toString();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    public void setUserWords(String wordList) {
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(this.file), "UTF8");){
            writer.write(wordList);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

