/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.mode;

import java.util.TreeMap;
import org.freeplane.features.mode.IPropertyHandler;
import org.freeplane.features.styles.LogicalStyleController;

public class CombinedPropertyChain<V, T> {
    private final boolean reversed;
    private final TreeMap<Integer, IPropertyHandler<V, T>> handlers = new TreeMap();

    public CombinedPropertyChain(boolean reversed) {
        this.reversed = reversed;
    }

    public IPropertyHandler<V, T> addGetter(Integer key, IPropertyHandler<V, T> getter) {
        return this.handlers.put(this.key(key), getter);
    }

    private int key(int key) {
        return this.reversed ? -key : key;
    }

    public V getProperty(T node, LogicalStyleController.StyleOption option, V property) {
        for (IPropertyHandler<V, T> getter : this.handlers.values()) {
            property = getter.getProperty(node, option, property);
        }
        return property;
    }

    public IPropertyHandler<V, T> removeGetter(Integer key) {
        return this.handlers.remove(this.key(key));
    }
}

