/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.specification.internal;

import jakarta.persistence.EntityManager;
import jakarta.persistence.TypedQueryReference;
import jakarta.persistence.criteria.CommonAbstractCriteria;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaDelete;
import jakarta.persistence.criteria.CriteriaUpdate;
import jakarta.persistence.criteria.Root;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.BiConsumer;
import org.hibernate.AssertionFailure;
import org.hibernate.Session;
import org.hibernate.SharedSessionContract;
import org.hibernate.StatelessSession;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.query.IllegalMutationQueryException;
import org.hibernate.query.MutationQuery;
import org.hibernate.query.criteria.JpaRoot;
import org.hibernate.query.restriction.Restriction;
import org.hibernate.query.specification.MutationSpecification;
import org.hibernate.query.spi.HqlInterpretation;
import org.hibernate.query.spi.QueryEngine;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SqmQuerySource;
import org.hibernate.query.sqm.internal.SqmQueryImpl;
import org.hibernate.query.sqm.internal.SqmUtil;
import org.hibernate.query.sqm.tree.AbstractSqmDmlStatement;
import org.hibernate.query.sqm.tree.SqmCopyContext;
import org.hibernate.query.sqm.tree.SqmDeleteOrUpdateStatement;
import org.hibernate.query.sqm.tree.delete.SqmDeleteStatement;
import org.hibernate.query.sqm.tree.from.SqmRoot;
import org.hibernate.query.sqm.tree.predicate.SqmPredicate;
import org.hibernate.query.sqm.tree.update.SqmUpdateStatement;

public class MutationSpecificationImpl<T>
implements MutationSpecification<T>,
TypedQueryReference<Void> {
    private final List<BiConsumer<SqmDeleteOrUpdateStatement<T>, SqmRoot<T>>> specifications = new ArrayList<BiConsumer<SqmDeleteOrUpdateStatement<T>, SqmRoot<T>>>();
    private final String hql;
    private final Class<T> mutationTarget;
    private final SqmDeleteOrUpdateStatement<T> deleteOrUpdateStatement;

    public MutationSpecificationImpl(String hql, Class<T> mutationTarget) {
        this.hql = hql;
        this.mutationTarget = mutationTarget;
        this.deleteOrUpdateStatement = null;
    }

    public MutationSpecificationImpl(CriteriaUpdate<T> criteriaQuery) {
        this.deleteOrUpdateStatement = (SqmUpdateStatement)criteriaQuery;
        this.mutationTarget = ((SqmRoot)this.deleteOrUpdateStatement.getTarget()).getManagedType().getJavaType();
        this.hql = null;
    }

    public MutationSpecificationImpl(CriteriaDelete<T> criteriaQuery) {
        this.deleteOrUpdateStatement = (SqmDeleteStatement)criteriaQuery;
        this.mutationTarget = ((SqmRoot)this.deleteOrUpdateStatement.getTarget()).getManagedType().getJavaType();
        this.hql = null;
    }

    public String getName() {
        return null;
    }

    public Class<Void> getResultType() {
        return null;
    }

    public Map<String, Object> getHints() {
        return Collections.emptyMap();
    }

    @Override
    public TypedQueryReference<Void> reference() {
        return this;
    }

    @Override
    public MutationSpecification<T> restrict(Restriction<? super T> restriction) {
        this.specifications.add((sqmStatement, mutationTargetRoot) -> {
            SqmPredicate sqmPredicate = (SqmPredicate)restriction.toPredicate((Root)mutationTargetRoot, sqmStatement.nodeBuilder());
            sqmStatement.applyPredicate(sqmPredicate);
        });
        return this;
    }

    @Override
    public MutationSpecification<T> augment(MutationSpecification.Augmentation<T> augmentation) {
        this.specifications.add((sqmStatement, mutationTargetRoot) -> augmentation.augment(sqmStatement.nodeBuilder(), (CommonAbstractCriteria)sqmStatement, (Root)mutationTargetRoot));
        return this;
    }

    @Override
    public MutationQuery createQuery(Session session) {
        return this.createQuery((SharedSessionContract)session);
    }

    @Override
    public MutationQuery createQuery(StatelessSession session) {
        return this.createQuery((SharedSessionContract)session);
    }

    public MutationQuery createQuery(SharedSessionContract session) {
        SharedSessionContractImplementor sessionImpl = session.unwrap(SharedSessionContractImplementor.class);
        SqmDeleteOrUpdateStatement<T> sqmStatement = this.build(sessionImpl.getFactory().getQueryEngine());
        return new SqmQueryImpl<T>(sqmStatement, false, null, sessionImpl);
    }

    private SqmDeleteOrUpdateStatement<T> build(QueryEngine queryEngine) {
        SqmRoot<Object> mutationTargetRoot;
        SqmDeleteOrUpdateStatement sqmStatement;
        if (this.hql != null) {
            sqmStatement = MutationSpecificationImpl.resolveSqmTree(this.hql, queryEngine);
            mutationTargetRoot = MutationSpecificationImpl.resolveSqmRoot(sqmStatement, this.mutationTarget);
        } else if (this.deleteOrUpdateStatement != null) {
            sqmStatement = (SqmDeleteOrUpdateStatement)this.deleteOrUpdateStatement.copy(SqmCopyContext.simpleContext());
            mutationTargetRoot = MutationSpecificationImpl.resolveSqmRoot(sqmStatement, ((SqmRoot)sqmStatement.getTarget()).getManagedType().getJavaType());
        } else {
            throw new AssertionFailure("No HQL or criteria");
        }
        this.specifications.forEach(consumer -> consumer.accept(sqmStatement, mutationTargetRoot));
        return sqmStatement;
    }

    @Override
    public MutationQuery createQuery(EntityManager entityManager) {
        return this.createQuery((SharedSessionContract)entityManager);
    }

    @Override
    public CommonAbstractCriteria buildCriteria(CriteriaBuilder builder) {
        NodeBuilder nodeBuilder = (NodeBuilder)builder;
        return this.build(nodeBuilder.getQueryEngine());
    }

    @Override
    public MutationSpecification<T> validate(CriteriaBuilder builder) {
        NodeBuilder nodeBuilder = (NodeBuilder)builder;
        SqmDeleteOrUpdateStatement<T> statement = this.build(nodeBuilder.getQueryEngine());
        ((AbstractSqmDmlStatement)((Object)statement)).validate(this.hql);
        return this;
    }

    private static <T> SqmDeleteOrUpdateStatement<T> resolveSqmTree(String hql, QueryEngine queryEngine) {
        HqlInterpretation hqlInterpretation = queryEngine.getInterpretationCache().resolveHqlInterpretation(hql, null, queryEngine.getHqlTranslator());
        if (!SqmUtil.isRestrictedMutation(hqlInterpretation.getSqmStatement())) {
            throw new IllegalMutationQueryException("Expecting a delete or update query, but found '" + hql + "'", hql);
        }
        return (SqmDeleteOrUpdateStatement)hqlInterpretation.getSqmStatement().copy(SqmCopyContext.noParamCopyContext(SqmQuerySource.CRITERIA));
    }

    private static <T> SqmRoot<T> resolveSqmRoot(SqmDeleteOrUpdateStatement<T> sqmStatement, Class<T> mutationTarget) {
        JpaRoot mutationTargetRoot = sqmStatement.getTarget();
        if (mutationTargetRoot.getJavaType() != null && !mutationTarget.isAssignableFrom(mutationTargetRoot.getJavaType())) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Mutation target types do not match : %s / %s", mutationTargetRoot.getJavaType().getName(), mutationTarget.getName()));
        }
        return mutationTargetRoot;
    }
}

