/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.pico;

import com.intellij.util.pico.PicoIntrospectionException;
import java.util.Arrays;
import org.jetbrains.annotations.NonNls;

public final class AmbiguousComponentResolutionException
extends PicoIntrospectionException {
    private Class<?> component;
    private final Class<?> ambiguousDependency;
    private final Object[] ambiguousComponentKeys;

    public AmbiguousComponentResolutionException(Class ambiguousDependency, Object[] componentKeys) {
        super("");
        this.ambiguousDependency = ambiguousDependency;
        this.ambiguousComponentKeys = (Object[])componentKeys.clone();
    }

    @Override
    @NonNls
    public String getMessage() {
        return this.component + " has ambiguous dependency on " + this.ambiguousDependency + ", resolves to multiple classes: " + Arrays.asList(this.getAmbiguousComponentKeys());
    }

    public Object[] getAmbiguousComponentKeys() {
        return this.ambiguousComponentKeys;
    }

    public void setComponent(Class component) {
        this.component = component;
    }
}

