/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.symbols.impl;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirPureAbstractElement;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.expressions.FirDelegatedConstructorCall;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import org.jetbrains.kotlin.fir.symbols.FirLazyDeclarationResolverKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirFunctionSymbol;
import org.jetbrains.kotlin.mpp.ConstructorSymbolMarker;
import org.jetbrains.kotlin.name.CallableId;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqNamesUtilKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u0011\b\u0016\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\u0006\u0010\nR\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\rR\u0013\u0010\u000e\u001a\u0004\u0018\u00010\u00008F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0013\u0010\u0011\u001a\u0004\u0018\u00010\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\r\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/fir/symbols/impl/FirConstructorSymbol;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirFunctionSymbol;", "Lorg/jetbrains/kotlin/fir/declarations/FirConstructor;", "Lorg/jetbrains/kotlin/mpp/ConstructorSymbolMarker;", "callableId", "Lorg/jetbrains/kotlin/name/CallableId;", "<init>", "(Lorg/jetbrains/kotlin/name/CallableId;)V", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "(Lorg/jetbrains/kotlin/name/ClassId;)V", "isPrimary", "", "()Z", "resolvedDelegatedConstructor", "getResolvedDelegatedConstructor", "()Lorg/jetbrains/kotlin/fir/symbols/impl/FirConstructorSymbol;", "resolvedDelegatedConstructorCall", "Lorg/jetbrains/kotlin/fir/expressions/FirDelegatedConstructorCall;", "getResolvedDelegatedConstructorCall", "()Lorg/jetbrains/kotlin/fir/expressions/FirDelegatedConstructorCall;", "delegatedConstructorCallIsThis", "getDelegatedConstructorCallIsThis", "tree"})
public final class FirConstructorSymbol
extends FirFunctionSymbol<FirConstructor>
implements ConstructorSymbolMarker {
    public FirConstructorSymbol(@NotNull CallableId callableId) {
        Intrinsics.checkNotNullParameter(callableId, "callableId");
        super(callableId, null);
    }

    public FirConstructorSymbol(@NotNull ClassId classId) {
        Intrinsics.checkNotNullParameter(classId, "classId");
        this(FqNamesUtilKt.callableIdForConstructor(classId));
    }

    public final boolean isPrimary() {
        return ((FirConstructor)this.getFir()).isPrimary();
    }

    @Nullable
    public final FirConstructorSymbol getResolvedDelegatedConstructor() {
        FirPureAbstractElement firPureAbstractElement = this.getResolvedDelegatedConstructorCall();
        return firPureAbstractElement != null && (firPureAbstractElement = firPureAbstractElement.getCalleeReference()) != null ? FirReferenceUtilsKt.toResolvedConstructorSymbol$default((FirReference)firPureAbstractElement, false, 1, null) : null;
    }

    @Nullable
    public final FirDelegatedConstructorCall getResolvedDelegatedConstructorCall() {
        if (((FirConstructor)this.getFir()).getDelegatedConstructor() == null) {
            return null;
        }
        FirLazyDeclarationResolverKt.lazyResolveToPhase(this, FirResolvePhase.BODY_RESOLVE);
        return ((FirConstructor)this.getFir()).getDelegatedConstructor();
    }

    public final boolean getDelegatedConstructorCallIsThis() {
        FirDelegatedConstructorCall firDelegatedConstructorCall = ((FirConstructor)this.getFir()).getDelegatedConstructor();
        return firDelegatedConstructorCall != null ? firDelegatedConstructorCall.isThis() : false;
    }
}

