/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.checkers;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.diagnostics.LibrarySpecialCompatibilityChecker;
import org.jetbrains.kotlin.library.KotlinLibrary;
import org.jetbrains.kotlin.library.KotlinLibraryKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\"\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u0007H\u0014\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/checkers/JsLibrarySpecialCompatibilityChecker;", "Lorg/jetbrains/kotlin/backend/common/diagnostics/LibrarySpecialCompatibilityChecker;", "<init>", "()V", "shouldCheckLibrary", "", "library", "Lorg/jetbrains/kotlin/library/KotlinLibrary;", "getMessageToReport", "", "compilerVersion", "Lorg/jetbrains/kotlin/backend/common/diagnostics/LibrarySpecialCompatibilityChecker$Version;", "libraryVersion", "ir.serialization.js"})
public final class JsLibrarySpecialCompatibilityChecker
extends LibrarySpecialCompatibilityChecker {
    @NotNull
    public static final JsLibrarySpecialCompatibilityChecker INSTANCE = new JsLibrarySpecialCompatibilityChecker();

    private JsLibrarySpecialCompatibilityChecker() {
    }

    @Override
    protected boolean shouldCheckLibrary(@NotNull KotlinLibrary library) {
        Intrinsics.checkNotNullParameter(library, "library");
        return KotlinLibraryKt.isJsStdlib(library) || KotlinLibraryKt.isJsKotlinTest(library);
    }

    @Override
    @Nullable
    protected String getMessageToReport(@NotNull LibrarySpecialCompatibilityChecker.Version compilerVersion2, @NotNull LibrarySpecialCompatibilityChecker.Version libraryVersion, @NotNull KotlinLibrary library) {
        String string;
        Intrinsics.checkNotNullParameter(compilerVersion2, "compilerVersion");
        Intrinsics.checkNotNullParameter(libraryVersion, "libraryVersion");
        Intrinsics.checkNotNullParameter(library, "library");
        String libraryDisplayName = KotlinLibraryKt.isJsStdlib(library) ? "standard" : (KotlinLibraryKt.isJsKotlinTest(library) ? "kotlin-test" : null);
        if (libraryVersion.compareTo(compilerVersion2) < 0) {
            string = "The Kotlin/JS " + libraryDisplayName + " library has an older version (" + libraryVersion + ") than the compiler (" + compilerVersion2 + "). Such a configuration is not supported.";
        } else if (!libraryVersion.hasSameLanguageVersion(compilerVersion2)) {
            string = "The Kotlin/JS " + libraryDisplayName + " library has a more recent version (" + libraryVersion + ") than the compiler supports. The compiler version is " + compilerVersion2 + '.';
        } else {
            return null;
        }
        String rootCause = string;
        return rootCause + "\nPlease, make sure that the " + libraryDisplayName + " library has the version in the range [" + compilerVersion2.toComparableVersionString() + " .. " + compilerVersion2.toLanguageVersionString() + ".255]. Adjust your project's settings if necessary.";
    }
}

