/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.utils;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.NotImplementedError;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.backend.js.JsCommonBackendContext;
import org.jetbrains.kotlin.ir.backend.js.JsIrAttributesKt;
import org.jetbrains.kotlin.ir.backend.js.JsIrBackendContext;
import org.jetbrains.kotlin.ir.backend.js.JsLoweredDeclarationOrigin;
import org.jetbrains.kotlin.ir.backend.js.export.ExportModelGeneratorKt;
import org.jetbrains.kotlin.ir.backend.js.ir.JsIrBuilder;
import org.jetbrains.kotlin.ir.backend.js.utils.AnnotationUtilsKt;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrParameterKind;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrSyntheticBody;
import org.jetbrains.kotlin.ir.symbols.IrPropertySymbol;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.js.config.JSConfigurationKeys;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000J\n\u0000\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0012\u0010\u0004\u001a\u00020\u0005*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u001a\n\u0010\t\u001a\u00020\u0005*\u00020\u0006\u001a\u0012\u0010\r\u001a\u00020\u000e*\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011\u001a\n\u0010\u0012\u001a\u00020\u0013*\u00020\u0014\u001a\n\u0010\u0015\u001a\u00020\u0016*\u00020\u0014\u001a\u0010\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u0011H\u0000\"\u0015\u0010\n\u001a\u00020\u0005*\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\f\"\u0015\u0010\u0017\u001a\u00020\u0005*\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001b"}, d2={"TODO", "", "element", "Lorg/jetbrains/kotlin/ir/IrElement;", "hasStableJsName", "", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "context", "Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "isEqualsInheritedFromAny", "isDispatchReceiver", "Lorg/jetbrains/kotlin/ir/declarations/IrValueDeclaration;", "(Lorg/jetbrains/kotlin/ir/declarations/IrValueDeclaration;)Z", "prependFunctionCall", "", "Lorg/jetbrains/kotlin/ir/expressions/IrBody;", "call", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "findUnitGetInstanceFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "Lorg/jetbrains/kotlin/ir/backend/js/JsCommonBackendContext;", "findUnitInstanceField", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "compileSuspendAsJsGenerator", "getCompileSuspendAsJsGenerator", "(Lorg/jetbrains/kotlin/ir/backend/js/JsCommonBackendContext;)Z", "invokeFunForLambda", "backend.js"})
public final class MiscKt {
    @NotNull
    public static final Void TODO(@NotNull IrElement element) {
        Intrinsics.checkNotNullParameter(element, "element");
        String string = element.getClass().getSimpleName() + " is not supported yet here";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    public static final boolean hasStableJsName(@NotNull IrFunction $this$hasStableJsName, @NotNull JsIrBackendContext context2) {
        boolean bl;
        block11: {
            block10: {
                Intrinsics.checkNotNullParameter($this$hasStableJsName, "<this>");
                Intrinsics.checkNotNullParameter(context2, "context");
                if (Intrinsics.areEqual($this$hasStableJsName.getOrigin(), JsLoweredDeclarationOrigin.INSTANCE.getBRIDGE_WITH_STABLE_NAME())) break block10;
                IrSimpleFunction irSimpleFunction = $this$hasStableJsName instanceof IrSimpleFunction ? (IrSimpleFunction)$this$hasStableJsName : null;
                boolean bl2 = irSimpleFunction != null ? IrUtilsKt.isMethodOfAny(irSimpleFunction) : false;
                if (!bl2) break block11;
            }
            return true;
        }
        if (Intrinsics.areEqual($this$hasStableJsName.getOrigin(), JsLoweredDeclarationOrigin.INSTANCE.getJS_SHADOWED_EXPORT()) || Intrinsics.areEqual($this$hasStableJsName.getOrigin(), JsLoweredDeclarationOrigin.INSTANCE.getBRIDGE_WITHOUT_STABLE_NAME()) || Intrinsics.areEqual($this$hasStableJsName.getOrigin(), JsLoweredDeclarationOrigin.INSTANCE.getBRIDGE_PROPERTY_ACCESSOR())) {
            return false;
        }
        IrFunction irFunction = $this$hasStableJsName;
        if (irFunction instanceof IrSimpleFunction) {
            IrProperty owner;
            IrPropertySymbol irPropertySymbol = ((IrSimpleFunction)$this$hasStableJsName).getCorrespondingPropertySymbol();
            IrProperty irProperty = owner = irPropertySymbol != null ? (IrProperty)irPropertySymbol.getOwner() : null;
            if (owner == null) {
                bl = true;
            } else {
                IrSimpleFunction irSimpleFunction = owner.getGetter();
                bl = (irSimpleFunction != null ? AnnotationUtilsKt.getJsName(irSimpleFunction) : null) != null;
            }
        } else if (irFunction instanceof IrConstructor) {
            bl = true;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        boolean namedOrMissingGetter = bl;
        return (IrUtilsKt.isEffectivelyExternal($this$hasStableJsName) || AnnotationUtilsKt.getJsName($this$hasStableJsName) != null || ExportModelGeneratorKt.isExported($this$hasStableJsName, context2)) && namedOrMissingGetter;
    }

    public static final boolean isEqualsInheritedFromAny(@NotNull IrFunction $this$isEqualsInheritedFromAny) {
        Intrinsics.checkNotNullParameter($this$isEqualsInheritedFromAny, "<this>");
        return Intrinsics.areEqual($this$isEqualsInheritedFromAny.getName(), OperatorNameConventions.EQUALS) && IrUtilsKt.hasShape$default($this$isEqualsInheritedFromAny, true, false, 0, 1, null, 22, null) && IrTypePredicatesKt.isNullableAny($this$isEqualsInheritedFromAny.getParameters().get(1).getType());
    }

    public static final boolean isDispatchReceiver(@NotNull IrValueDeclaration $this$isDispatchReceiver) {
        Intrinsics.checkNotNullParameter($this$isDispatchReceiver, "<this>");
        return $this$isDispatchReceiver instanceof IrValueParameter && ((IrValueParameter)$this$isDispatchReceiver).getKind() == IrParameterKind.DispatchReceiver;
    }

    public static final void prependFunctionCall(@NotNull IrBody $this$prependFunctionCall, @NotNull IrCall call2) {
        Intrinsics.checkNotNullParameter($this$prependFunctionCall, "<this>");
        Intrinsics.checkNotNullParameter(call2, "call");
        IrBody irBody = $this$prependFunctionCall;
        if (irBody instanceof IrExpressionBody) {
            IrExpression[] irExpressionArray = new IrExpression[]{call2, ((IrExpressionBody)$this$prependFunctionCall).getExpression()};
            ((IrExpressionBody)$this$prependFunctionCall).setExpression(JsIrBuilder.INSTANCE.buildComposite(((IrExpressionBody)$this$prependFunctionCall).getExpression().getType(), CollectionsKt.listOf(irExpressionArray)));
        } else if (irBody instanceof IrBlockBody) {
            ((IrBlockBody)$this$prependFunctionCall).getStatements().add(0, call2);
        } else if (!(irBody instanceof IrSyntheticBody)) {
            throw new NoWhenBranchMatchedException();
        }
    }

    @NotNull
    public static final IrSimpleFunction findUnitGetInstanceFunction(@NotNull JsCommonBackendContext $this$findUnitGetInstanceFunction) {
        Intrinsics.checkNotNullParameter($this$findUnitGetInstanceFunction, "<this>");
        IrSimpleFunction irSimpleFunction = JsIrAttributesKt.getObjectGetInstanceFunction((IrClass)$this$findUnitGetInstanceFunction.getIrBuiltIns().getUnitClass().getOwner());
        Intrinsics.checkNotNull(irSimpleFunction);
        return irSimpleFunction;
    }

    @NotNull
    public static final IrField findUnitInstanceField(@NotNull JsCommonBackendContext $this$findUnitInstanceField) {
        Intrinsics.checkNotNullParameter($this$findUnitInstanceField, "<this>");
        IrField irField = JsIrAttributesKt.getObjectInstanceField((IrClass)$this$findUnitInstanceField.getIrBuiltIns().getUnitClass().getOwner());
        Intrinsics.checkNotNull(irField);
        return irField;
    }

    public static final boolean getCompileSuspendAsJsGenerator(@NotNull JsCommonBackendContext $this$compileSuspendAsJsGenerator) {
        Intrinsics.checkNotNullParameter($this$compileSuspendAsJsGenerator, "<this>");
        return $this$compileSuspendAsJsGenerator instanceof JsIrBackendContext && Intrinsics.areEqual(((JsIrBackendContext)$this$compileSuspendAsJsGenerator).getConfiguration().get(JSConfigurationKeys.COMPILE_SUSPEND_AS_JS_GENERATOR), true);
    }

    @NotNull
    public static final IrSimpleFunction invokeFunForLambda(@NotNull IrCall call2) {
        Intrinsics.checkNotNullParameter(call2, "call");
        Object e2 = call2.getArguments().get(0);
        Intrinsics.checkNotNull(e2);
        IrClass irClass = IrTypesKt.getClass(((IrExpression)e2).getType());
        Intrinsics.checkNotNull(irClass);
        IrSimpleFunction irSimpleFunction = IrUtilsKt.getInvokeFun(irClass);
        Intrinsics.checkNotNull(irSimpleFunction);
        return irSimpleFunction;
    }
}

