/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi;

import com.google.common.collect.Lists;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.IfNotParsed;
import org.jetbrains.kotlin.psi.KtContainerNode;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtExpressionImpl;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtVisitor;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

public class KtArrayAccessExpression
extends KtExpressionImpl
implements KtReferenceExpression {
    public KtArrayAccessExpression(@NotNull ASTNode node) {
        if (node == null) {
            KtArrayAccessExpression.$$$reportNull$$$0(0);
        }
        super(node);
    }

    @Override
    public <R, D> R accept(@NotNull KtVisitor<R, D> visitor2, D data) {
        if (visitor2 == null) {
            KtArrayAccessExpression.$$$reportNull$$$0(1);
        }
        return visitor2.visitArrayAccessExpression(this, data);
    }

    @IfNotParsed
    @Nullable
    public KtExpression getArrayExpression() {
        return this.findChildByClass(KtExpression.class);
    }

    @NotNull
    public List<KtExpression> getIndexExpressions() {
        List<KtExpression> list = PsiTreeUtil.getChildrenOfTypeAsList(this.getIndicesNode(), KtExpression.class);
        if (list == null) {
            KtArrayAccessExpression.$$$reportNull$$$0(2);
        }
        return list;
    }

    @NotNull
    public KtContainerNode getIndicesNode() {
        KtContainerNode indicesNode = (KtContainerNode)this.findChildByType(KtNodeTypes.INDICES);
        assert (indicesNode != null) : "Can't be null because of parser";
        KtContainerNode ktContainerNode = indicesNode;
        if (ktContainerNode == null) {
            KtArrayAccessExpression.$$$reportNull$$$0(3);
        }
        return ktContainerNode;
    }

    @NotNull
    public List<TextRange> getBracketRanges() {
        PsiElement lBracket = this.getLeftBracket();
        PsiElement rBracket = this.getRightBracket();
        if (lBracket == null || rBracket == null) {
            List<TextRange> list = Collections.emptyList();
            if (list == null) {
                KtArrayAccessExpression.$$$reportNull$$$0(4);
            }
            return list;
        }
        ArrayList<TextRange> arrayList = Lists.newArrayList(lBracket.getTextRange(), rBracket.getTextRange());
        if (arrayList == null) {
            KtArrayAccessExpression.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    @Nullable
    public PsiElement getLeftBracket() {
        return this.getIndicesNode().findChildByType(KtTokens.LBRACKET);
    }

    @Nullable
    public PsiElement getRightBracket() {
        return this.getIndicesNode().findChildByType(KtTokens.RBRACKET);
    }

    public PsiElement getTrailingComma() {
        return KtPsiUtilKt.getTrailingCommaByClosingElement(this.getRightBracket());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/psi/KtArrayAccessExpression";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/psi/KtArrayAccessExpression";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexExpressions";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndicesNode";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getBracketRanges";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

