/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.checkers;

import com.intellij.psi.PsiElement;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.NotFoundClasses;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.checkers.ClassifierUsageChecker;
import org.jetbrains.kotlin.resolve.checkers.ClassifierUsageCheckerContext;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.serialization.deserialization.IncompatibleVersionErrorData;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedContainerAbiStability;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedContainerSource;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedMemberDescriptor;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.utils.CollectionsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0016B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0004\u001a\u00020\u00052\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u001a\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\tH\u0002J\u001c\u0010\u0010\u001a\u0004\u0018\u00010\r2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\b\u001a\u00020\tH\u0002J\u001e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\r0\u00142\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u0015H\u0002\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/MissingDependencyClassChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "<init>", "()V", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lcom/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "diagnosticFor", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptor;", "incompatibilityDiagnosticFor", "source", "Lorg/jetbrains/kotlin/descriptors/SourceElement;", "collectDiagnostics", "", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "ClassifierUsage", "frontend"})
@SourceDebugExtension(value={"SMAP\nMissingDependencyClassChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MissingDependencyClassChecker.kt\norg/jetbrains/kotlin/resolve/checkers/MissingDependencyClassChecker\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,104:1\n1#2:105\n1869#3,2:106\n*S KotlinDebug\n*F\n+ 1 MissingDependencyClassChecker.kt\norg/jetbrains/kotlin/resolve/checkers/MissingDependencyClassChecker\n*L\n90#1:106,2\n*E\n"})
public final class MissingDependencyClassChecker
implements CallChecker {
    @NotNull
    public static final MissingDependencyClassChecker INSTANCE = new MissingDependencyClassChecker();

    private MissingDependencyClassChecker() {
    }

    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context2) {
        block1: {
            Intrinsics.checkNotNullParameter(resolvedCall2, "resolvedCall");
            Intrinsics.checkNotNullParameter(reportOn, "reportOn");
            Intrinsics.checkNotNullParameter(context2, "context");
            Object obj = resolvedCall2.getResultingDescriptor();
            Intrinsics.checkNotNullExpressionValue(obj, "getResultingDescriptor(...)");
            Object resultingDescriptor = obj;
            for (Diagnostic diagnostic : this.collectDiagnostics(reportOn, (CallableDescriptor)resultingDescriptor)) {
                context2.getTrace().report(diagnostic);
            }
            DeserializedMemberDescriptor deserializedMemberDescriptor = resultingDescriptor instanceof DeserializedMemberDescriptor ? (DeserializedMemberDescriptor)resultingDescriptor : null;
            DeserializedContainerSource containerSource = deserializedMemberDescriptor != null ? deserializedMemberDescriptor.getContainerSource() : null;
            Diagnostic diagnostic = this.incompatibilityDiagnosticFor(containerSource, reportOn);
            if (diagnostic == null) break block1;
            Diagnostic diagnostic2 = diagnostic;
            BindingTrace bindingTrace = context2.getTrace();
            Diagnostic p0 = diagnostic2;
            boolean bl = false;
            bindingTrace.report(p0);
        }
    }

    private final Diagnostic diagnosticFor(ClassifierDescriptor descriptor, PsiElement reportOn) {
        if (descriptor instanceof NotFoundClasses.MockClassDescriptor) {
            return Errors.MISSING_DEPENDENCY_CLASS.on(reportOn, DescriptorUtilsKt.getFqNameSafe(descriptor));
        }
        return this.incompatibilityDiagnosticFor(descriptor.getSource(), reportOn);
    }

    private final Diagnostic incompatibilityDiagnosticFor(SourceElement source, PsiElement reportOn) {
        if (source instanceof DeserializedContainerSource) {
            IncompatibleVersionErrorData<?> incompatibility = ((DeserializedContainerSource)source).getIncompatibility();
            if (incompatibility != null) {
                return Errors.INCOMPATIBLE_CLASS.on(reportOn, ((DeserializedContainerSource)source).getPresentableString(), incompatibility);
            }
            if (((DeserializedContainerSource)source).getPreReleaseInfo().isInvisible()) {
                return Errors.PRE_RELEASE_CLASS.on(reportOn, ((DeserializedContainerSource)source).getPresentableString());
            }
            if (((DeserializedContainerSource)source).getAbiStability() == DeserializedContainerAbiStability.UNSTABLE) {
                return Errors.IR_WITH_UNSTABLE_ABI_COMPILED_CLASS.on(reportOn, ((DeserializedContainerSource)source).getPresentableString());
            }
        }
        return null;
    }

    private final Set<Diagnostic> collectDiagnostics(PsiElement reportOn, CallableDescriptor descriptor) {
        Object object;
        Set result2 = CollectionsKt.newLinkedHashSetWithExpectedSize(1);
        KotlinType kotlinType = descriptor.getReturnType();
        if (kotlinType != null) {
            KotlinType p0 = kotlinType;
            boolean bl = false;
            MissingDependencyClassChecker.collectDiagnostics$consider$0(reportOn, result2, p0);
        }
        if ((object = descriptor.getExtensionReceiverParameter()) != null && (object = object.getValue()) != null && (object = object.getType()) != null) {
            Object p0 = object;
            boolean bl = false;
            MissingDependencyClassChecker.collectDiagnostics$consider$0(reportOn, result2, (KotlinType)p0);
        }
        List<ValueParameterDescriptor> list = descriptor.getValueParameters();
        Intrinsics.checkNotNullExpressionValue(list, "getValueParameters(...)");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ValueParameterDescriptor it = (ValueParameterDescriptor)element$iv;
            boolean bl = false;
            KotlinType kotlinType2 = it.getType();
            Intrinsics.checkNotNullExpressionValue(kotlinType2, "getType(...)");
            MissingDependencyClassChecker.collectDiagnostics$consider$0(reportOn, result2, kotlinType2);
        }
        return result2;
    }

    private static final void collectDiagnostics$consider(PsiElement $reportOn, Set<Diagnostic> result2, ClassDescriptor classDescriptor) {
        block1: {
            Diagnostic diagnostic = INSTANCE.diagnosticFor(classDescriptor, $reportOn);
            if (diagnostic != null) {
                result2.add(diagnostic);
                return;
            }
            DeclarationDescriptor declarationDescriptor = classDescriptor.getContainingDeclaration();
            ClassDescriptor classDescriptor2 = declarationDescriptor instanceof ClassDescriptor ? (ClassDescriptor)declarationDescriptor : null;
            if (classDescriptor2 == null) break block1;
            ClassDescriptor p0 = classDescriptor2;
            boolean bl = false;
            MissingDependencyClassChecker.collectDiagnostics$consider($reportOn, result2, p0);
        }
    }

    private static final void collectDiagnostics$consider$0(PsiElement $reportOn, Set<Diagnostic> result2, KotlinType type) {
        block1: {
            if (CallCheckerKt.isComputingDeferredType(INSTANCE, type)) break block1;
            ClassifierDescriptor classifierDescriptor = type.getConstructor().getDeclarationDescriptor();
            ClassDescriptor classDescriptor = classifierDescriptor instanceof ClassDescriptor ? (ClassDescriptor)classifierDescriptor : null;
            if (classDescriptor != null) {
                ClassDescriptor p0 = classDescriptor;
                boolean bl = false;
                MissingDependencyClassChecker.collectDiagnostics$consider($reportOn, result2, p0);
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/MissingDependencyClassChecker$ClassifierUsage;", "Lorg/jetbrains/kotlin/resolve/checkers/ClassifierUsageChecker;", "<init>", "()V", "check", "", "targetDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptor;", "element", "Lcom/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/ClassifierUsageCheckerContext;", "frontend"})
    @SourceDebugExtension(value={"SMAP\nMissingDependencyClassChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MissingDependencyClassChecker.kt\norg/jetbrains/kotlin/resolve/checkers/MissingDependencyClassChecker$ClassifierUsage\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,104:1\n1#2:105\n*E\n"})
    public static final class ClassifierUsage
    implements ClassifierUsageChecker {
        @NotNull
        public static final ClassifierUsage INSTANCE = new ClassifierUsage();

        private ClassifierUsage() {
        }

        @Override
        public void check(@NotNull ClassifierDescriptor targetDescriptor, @NotNull PsiElement element, @NotNull ClassifierUsageCheckerContext context2) {
            block1: {
                Object object;
                Intrinsics.checkNotNullParameter(targetDescriptor, "targetDescriptor");
                Intrinsics.checkNotNullParameter(element, "element");
                Intrinsics.checkNotNullParameter(context2, "context");
                Diagnostic diagnostic = INSTANCE.diagnosticFor(targetDescriptor, element);
                if (diagnostic != null) {
                    Diagnostic diagnostic2 = diagnostic;
                    object = context2.getTrace();
                    Diagnostic p0 = diagnostic2;
                    boolean bl = false;
                    object.report(p0);
                }
                DeserializedMemberDescriptor deserializedMemberDescriptor = targetDescriptor instanceof DeserializedMemberDescriptor ? (DeserializedMemberDescriptor)((Object)targetDescriptor) : null;
                DeserializedContainerSource containerSource = deserializedMemberDescriptor != null ? deserializedMemberDescriptor.getContainerSource() : null;
                Diagnostic diagnostic3 = INSTANCE.incompatibilityDiagnosticFor(containerSource, element);
                if (diagnostic3 == null) break block1;
                object = diagnostic3;
                BindingTrace bindingTrace = context2.getTrace();
                Object p0 = object;
                boolean bl = false;
                bindingTrace.report((Diagnostic)p0);
            }
        }
    }
}

