/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.daemon;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.impl.ZipHandler;
import com.intellij.openapi.vfs.impl.jar.CoreJarFileSystem;
import java.io.File;
import java.lang.invoke.LambdaMetafactory;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Handler;
import java.util.logging.Level;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.CLICompiler;
import org.jetbrains.kotlin.cli.common.ExitCode;
import org.jetbrains.kotlin.cli.common.arguments.ArgumentParseErrors;
import org.jetbrains.kotlin.cli.common.arguments.CommonToolArguments;
import org.jetbrains.kotlin.cli.common.arguments.K2JSCompilerArguments;
import org.jetbrains.kotlin.cli.common.arguments.K2JVMCompilerArguments;
import org.jetbrains.kotlin.cli.common.arguments.ParseCommandLineArgumentsKt;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.common.repl.IReplStageState;
import org.jetbrains.kotlin.cli.common.repl.ReplCheckResult;
import org.jetbrains.kotlin.cli.common.repl.ReplCodeLine;
import org.jetbrains.kotlin.cli.common.repl.ReplCompileResult;
import org.jetbrains.kotlin.cli.js.K2JSCompiler;
import org.jetbrains.kotlin.cli.jvm.K2JVMCompiler;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreApplicationEnvironment;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreEnvironment;
import org.jetbrains.kotlin.cli.jvm.modules.CoreJrtFileSystem;
import org.jetbrains.kotlin.cli.metadata.KotlinMetadataCompiler;
import org.jetbrains.kotlin.config.IncrementalCompilation;
import org.jetbrains.kotlin.config.KotlinCompilerVersion;
import org.jetbrains.kotlin.config.Services;
import org.jetbrains.kotlin.daemon.CompileServiceImplBase;
import org.jetbrains.kotlin.daemon.CompileServiceImplKt;
import org.jetbrains.kotlin.daemon.CompilerSelector;
import org.jetbrains.kotlin.daemon.EventManager;
import org.jetbrains.kotlin.daemon.EventManagerImpl;
import org.jetbrains.kotlin.daemon.KotlinJvmReplService;
import org.jetbrains.kotlin.daemon.RemoteCompilationCanceledStatusClient;
import org.jetbrains.kotlin.daemon.RemoteEnumWhenTracker;
import org.jetbrains.kotlin.daemon.RemoteExpectActualTracker;
import org.jetbrains.kotlin.daemon.RemoteIncrementalCompilationComponentsClient;
import org.jetbrains.kotlin.daemon.RemoteIncrementalDataProvider;
import org.jetbrains.kotlin.daemon.RemoteIncrementalResultsConsumer;
import org.jetbrains.kotlin.daemon.RemoteInlineConstTracker;
import org.jetbrains.kotlin.daemon.RemoteLookupTrackerClient;
import org.jetbrains.kotlin.daemon.RemoteReplStateFacadeServer;
import org.jetbrains.kotlin.daemon.common.BuildMetricsValue;
import org.jetbrains.kotlin.daemon.common.ClientUtilsKt;
import org.jetbrains.kotlin.daemon.common.CompilationOptions;
import org.jetbrains.kotlin.daemon.common.CompilationResultCategory;
import org.jetbrains.kotlin.daemon.common.CompilationResults;
import org.jetbrains.kotlin.daemon.common.CompileService;
import org.jetbrains.kotlin.daemon.common.CompilerCallbackServicesFacade;
import org.jetbrains.kotlin.daemon.common.CompilerId;
import org.jetbrains.kotlin.daemon.common.CompilerServicesFacadeBase;
import org.jetbrains.kotlin.daemon.common.DaemonJVMOptions;
import org.jetbrains.kotlin.daemon.common.DaemonJVMOptionsMemoryComparator;
import org.jetbrains.kotlin.daemon.common.DaemonOptions;
import org.jetbrains.kotlin.daemon.common.DaemonParamsKt;
import org.jetbrains.kotlin.daemon.common.DaemonReportCategory;
import org.jetbrains.kotlin.daemon.common.DaemonWithMetadata;
import org.jetbrains.kotlin.daemon.common.DummyProfiler;
import org.jetbrains.kotlin.daemon.common.FileAgeComparator;
import org.jetbrains.kotlin.daemon.common.IncrementalCompilationOptions;
import org.jetbrains.kotlin.daemon.common.JpsCompilerServicesFacade;
import org.jetbrains.kotlin.daemon.common.LoopbackNetworkInterface;
import org.jetbrains.kotlin.daemon.common.PerfCounters;
import org.jetbrains.kotlin.daemon.common.Profiler;
import org.jetbrains.kotlin.daemon.common.ReplStateFacade;
import org.jetbrains.kotlin.daemon.common.ReportSeverity;
import org.jetbrains.kotlin.daemon.common.WallAndThreadAndMemoryTotalProfiler;
import org.jetbrains.kotlin.daemon.common.WallAndThreadTotalProfiler;
import org.jetbrains.kotlin.daemon.report.CompileServicesFacadeMessageCollector;
import org.jetbrains.kotlin.daemon.report.DaemonMessageReporterKt;
import org.jetbrains.kotlin.daemon.report.GetICReporterKt;
import org.jetbrains.kotlin.incremental.components.EnumWhenTracker;
import org.jetbrains.kotlin.incremental.components.ExpectActualTracker;
import org.jetbrains.kotlin.incremental.components.InlineConstTracker;
import org.jetbrains.kotlin.incremental.components.LookupTracker;
import org.jetbrains.kotlin.incremental.js.IncrementalDataProvider;
import org.jetbrains.kotlin.incremental.js.IncrementalResultsConsumer;
import org.jetbrains.kotlin.incremental.parsing.ParseFileUtilsKt;
import org.jetbrains.kotlin.load.kotlin.incremental.components.IncrementalCompilationComponents;
import org.jetbrains.kotlin.progress.CompilationCanceledStatus;
import org.jetbrains.kotlin.util.PerformanceManager;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00ee\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0001\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u00012\u00020\u0002BM\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012\u00a2\u0006\u0004\b\u0014\u0010\u0015J<\u0010\u001c\u001a\b\u0012\u0004\u0012\u0002H\u001e0\u001d\"\u0004\b\u0000\u0010\u001e2\u0006\u0010\u001f\u001a\u00020\u000e2\u001d\u0010 \u001a\u0019\u0012\u0004\u0012\u00020\"\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u001e0\u001d0!\u00a2\u0006\u0002\b#H\u0082\bJ\u000e\u0010*\u001a\b\u0012\u0004\u0012\u00020+0\u001dH\u0016J\u000e\u0010,\u001a\b\u0012\u0004\u0012\u00020+0\u001dH\u0016J\u000e\u0010-\u001a\b\u0012\u0004\u0012\u00020\n0\u001dH\u0016J\u000e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\f0\u001dH\u0016J\u0018\u0010.\u001a\b\u0012\u0004\u0012\u00020/0\u001d2\b\u00100\u001a\u0004\u0018\u00010+H\u0016J\u0014\u00101\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020+020\u001dH\u0016J\u0018\u00103\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001d2\b\u00100\u001a\u0004\u0018\u00010+H\u0016J\u0016\u00104\u001a\b\u0012\u0004\u0012\u00020/0\u001d2\u0006\u0010\u001f\u001a\u00020\u000eH\u0016J\u0010\u00105\u001a\u0002062\u0006\u00107\u001a\u00020\bH\u0016J\u0016\u00108\u001a\b\u0012\u0004\u0012\u00020%0\u001d2\u0006\u00109\u001a\u000206H\u0016J\u000e\u0010:\u001a\b\u0012\u0004\u0012\u00020/0\u001dH\u0016J\u0016\u0010;\u001a\b\u0012\u0004\u0012\u0002060\u001d2\u0006\u0010<\u001a\u000206H\u0016J*\u0010=\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020+0>0\u001d2\u0006\u0010\u001f\u001a\u00020\u000e2\f\u0010?\u001a\b\u0012\u0004\u0012\u00020@0>H\u0016JE\u0010A\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001d2\u0006\u0010\u001f\u001a\u00020\u000e2\u000e\u0010B\u001a\n\u0012\u0006\b\u0001\u0012\u00020+0C2\u0006\u0010D\u001a\u00020E2\u0006\u0010F\u001a\u00020G2\b\u0010H\u001a\u0004\u0018\u00010IH\u0016\u00a2\u0006\u0002\u0010JJ\u0016\u0010K\u001a\b\u0012\u0004\u0012\u00020/0\u001d2\u0006\u0010\u001f\u001a\u00020\u000eH\u0016J \u0010L\u001a\u00020M2\u0006\u0010N\u001a\u00020O2\u0006\u0010P\u001a\u00020Q2\u0006\u0010R\u001a\u00020SH\u0002JS\u0010T\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001d2\b\u00100\u001a\u0004\u0018\u00010+2\u000e\u0010B\u001a\n\u0012\u0006\b\u0001\u0012\u00020+0C2\u0006\u0010D\u001a\u00020E2\u0006\u0010F\u001a\u00020G2\f\u0010U\u001a\b\u0012\u0004\u0012\u00020@022\u0006\u0010V\u001a\u00020+H\u0016\u00a2\u0006\u0002\u0010WJ\u0016\u0010X\u001a\b\u0012\u0004\u0012\u00020Y0\u001d2\u0006\u0010\u001f\u001a\u00020\u000eH\u0016J&\u0010Z\u001a\b\u0012\u0004\u0012\u00020[0\u001d2\u0006\u0010\u001f\u001a\u00020\u000e2\u0006\u0010\\\u001a\u00020\u000e2\u0006\u0010]\u001a\u00020^H\u0016J&\u0010_\u001a\b\u0012\u0004\u0012\u00020`0\u001d2\u0006\u0010\u001f\u001a\u00020\u000e2\u0006\u0010\\\u001a\u00020\u000e2\u0006\u0010]\u001a\u00020^H\u0016J\b\u0010a\u001a\u00020\u0013H\u0014J\b\u0010b\u001a\u00020\u0013H\u0014J\b\u0010c\u001a\u00020\u0013H\u0014J\b\u0010d\u001a\u00020\u0013H\u0002J\b\u0010e\u001a\u00020\u0013H\u0002J\u0010\u0010f\u001a\u0002062\u0006\u0010g\u001a\u000206H\u0002J\b\u0010h\u001a\u00020\u0013H\u0016J3\u0010i\u001a\b\u0012\u0004\u0012\u0002H\u001e0\u001d\"\u0004\b\u0000\u0010\u001e2\b\b\u0002\u0010j\u001a\u00020k2\u0012\u0010 \u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u001e0\u001d0\u0012H\u0082\bJ!\u0010l\u001a\u00020\u00132\b\b\u0002\u0010j\u001a\u00020k2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0082\bJ3\u0010m\u001a\b\u0012\u0004\u0012\u0002H\u001e0\u001d\"\u0004\b\u0000\u0010\u001e2\b\b\u0002\u0010j\u001a\u00020k2\u0012\u0010 \u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u001e0\u001d0\u0012H\u0082\bJ!\u0010n\u001a\u00020\u00132\b\b\u0002\u0010j\u001a\u00020k2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0082\bR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010$\u001a\u00020%8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010'R\u000e\u0010(\u001a\u00020)X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006o"}, d2={"Lorg/jetbrains/kotlin/daemon/CompileServiceImpl;", "Lorg/jetbrains/kotlin/daemon/common/CompileService;", "Lorg/jetbrains/kotlin/daemon/CompileServiceImplBase;", "registry", "Ljava/rmi/registry/Registry;", "compiler", "Lorg/jetbrains/kotlin/daemon/CompilerSelector;", "compilerId", "Lorg/jetbrains/kotlin/daemon/common/CompilerId;", "daemonOptions", "Lorg/jetbrains/kotlin/daemon/common/DaemonOptions;", "daemonJVMOptions", "Lorg/jetbrains/kotlin/daemon/common/DaemonJVMOptions;", "port", "", "timer", "Ljava/util/Timer;", "onShutdown", "Lkotlin/Function0;", "", "<init>", "(Ljava/rmi/registry/Registry;Lorg/jetbrains/kotlin/daemon/CompilerSelector;Lorg/jetbrains/kotlin/daemon/common/CompilerId;Lorg/jetbrains/kotlin/daemon/common/DaemonOptions;Lorg/jetbrains/kotlin/daemon/common/DaemonJVMOptions;ILjava/util/Timer;Lkotlin/jvm/functions/Function0;)V", "getRegistry", "()Ljava/rmi/registry/Registry;", "getCompiler", "()Lorg/jetbrains/kotlin/daemon/CompilerSelector;", "getDaemonJVMOptions", "()Lorg/jetbrains/kotlin/daemon/common/DaemonJVMOptions;", "withValidRepl", "Lorg/jetbrains/kotlin/daemon/common/CompileService$CallResult;", "R", "sessionId", "body", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/daemon/KotlinJvmReplService;", "Lkotlin/ExtensionFunctionType;", "lastUsedSeconds", "", "getLastUsedSeconds", "()J", "rwlock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "getDaemonInfo", "", "getKotlinVersion", "getDaemonOptions", "registerClient", "", "aliveFlagPath", "getClients", "", "leaseCompileSession", "releaseCompileSession", "checkCompilerId", "", "expectedCompilerId", "getUsedMemory", "withGC", "shutdown", "scheduleShutdown", "graceful", "classesFqNamesByFiles", "", "sourceFiles", "Ljava/io/File;", "compile", "compilerArguments", "", "compilationOptions", "Lorg/jetbrains/kotlin/daemon/common/CompilationOptions;", "servicesFacade", "Lorg/jetbrains/kotlin/daemon/common/CompilerServicesFacadeBase;", "compilationResults", "Lorg/jetbrains/kotlin/daemon/common/CompilationResults;", "(I[Ljava/lang/String;Lorg/jetbrains/kotlin/daemon/common/CompilationOptions;Lorg/jetbrains/kotlin/daemon/common/CompilerServicesFacadeBase;Lorg/jetbrains/kotlin/daemon/common/CompilationResults;)Lorg/jetbrains/kotlin/daemon/common/CompileService$CallResult;", "releaseReplSession", "createCompileServices", "Lorg/jetbrains/kotlin/config/Services;", "facade", "Lorg/jetbrains/kotlin/daemon/common/CompilerCallbackServicesFacade;", "eventManager", "Lorg/jetbrains/kotlin/daemon/EventManager;", "rpcProfiler", "Lorg/jetbrains/kotlin/daemon/common/Profiler;", "leaseReplSession", "templateClasspath", "templateClassName", "(Ljava/lang/String;[Ljava/lang/String;Lorg/jetbrains/kotlin/daemon/common/CompilationOptions;Lorg/jetbrains/kotlin/daemon/common/CompilerServicesFacadeBase;Ljava/util/List;Ljava/lang/String;)Lorg/jetbrains/kotlin/daemon/common/CompileService$CallResult;", "replCreateState", "Lorg/jetbrains/kotlin/daemon/common/ReplStateFacade;", "replCheck", "Lorg/jetbrains/kotlin/cli/common/repl/ReplCheckResult;", "replStateId", "codeLine", "Lorg/jetbrains/kotlin/cli/common/repl/ReplCodeLine;", "replCompile", "Lorg/jetbrains/kotlin/cli/common/repl/ReplCompileResult;", "periodicAndAfterSessionCheck", "periodicSeldomCheck", "initiateElections", "shutdownNow", "shutdownWithDelay", "gracefulShutdown", "onAnotherThread", "clearJarCache", "ifAlive", "minAliveness", "Lorg/jetbrains/kotlin/daemon/CompileServiceImplBase$Aliveness;", "ifAliveUnit", "ifAliveExclusive", "ifAliveExclusiveUnit", "kotlin-daemon"})
@SourceDebugExtension(value={"SMAP\nCompileServiceImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CompileServiceImpl.kt\norg/jetbrains/kotlin/daemon/CompileServiceImpl\n+ 2 CompileServiceImpl.kt\norg/jetbrains/kotlin/daemon/CompileServiceImplBase\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 PerfUtils.kt\norg/jetbrains/kotlin/daemon/common/PerfUtilsKt\n+ 6 CompilerRunnerUtils.kt\norg/jetbrains/kotlin/incremental/CompilerRunnerUtils\n+ 7 IncrementalJsCompilerRunner.kt\norg/jetbrains/kotlin/incremental/IncrementalJsCompilerRunnerKt\n+ 8 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,1172:1\n1147#1,2:1185\n1149#1:1210\n1144#1,5:1211\n1149#1:1239\n1144#1,5:1240\n1149#1:1268\n1144#1,5:1269\n1149#1:1297\n1147#1,2:1298\n1149#1:1323\n1144#1,5:1324\n1149#1:1352\n1147#1,2:1353\n1149#1:1378\n1147#1,2:1379\n1149#1:1404\n1144#1,5:1408\n1149#1:1441\n1161#1,2:1442\n1163#1:1467\n1147#1,2:1468\n1149#1:1493\n1144#1,5:1494\n1149#1:1532\n1144#1,5:1533\n1149#1:1976\n1147#1,2:1977\n1149#1:2002\n1147#1,2:2003\n720#1:2025\n1149#1:2041\n1147#1,2:2042\n720#1:2064\n1149#1:2080\n1147#1,2:2081\n720#1:2103\n1149#1:2119\n1151#1,2:2120\n1153#1,2:2142\n1156#1:2147\n1151#1,2:2148\n1153#1,2:2170\n1156#1:2175\n1151#1,2:2176\n1153#1,2:2198\n1156#1:2203\n1151#1,2:2204\n1153#1:2226\n1154#1:2234\n1156#1:2238\n1165#1,2:2421\n1167#1,2:2443\n1170#1:2448\n700#2:1173\n587#2,2:1174\n586#2,6:1176\n702#2:1182\n593#2:1183\n703#2:1184\n555#2,7:1187\n562#2,15:1195\n555#2,7:1216\n562#2,15:1224\n555#2,7:1245\n562#2,15:1253\n555#2,7:1274\n562#2,15:1282\n555#2,7:1300\n562#2,15:1308\n555#2,7:1329\n562#2,15:1337\n555#2,7:1355\n562#2,15:1363\n555#2,7:1381\n562#2,15:1389\n555#2,7:1413\n562#2,12:1421\n574#2,3:1438\n555#2,7:1444\n562#2,15:1452\n555#2,7:1470\n562#2,15:1478\n555#2,7:1499\n562#2,12:1507\n587#2,2:1519\n586#2,8:1521\n574#2,3:1529\n555#2,7:1538\n562#2,12:1546\n344#2,25:1558\n369#2:1591\n445#2,3:1592\n587#2,2:1595\n586#2,6:1597\n448#2,6:1603\n472#2,4:1609\n454#2:1615\n370#2,6:1616\n376#2,2:1623\n378#2,3:1626\n477#2:1631\n479#2,36:1637\n456#2,5:1673\n593#2:1678\n461#2,2:1679\n381#2:1681\n385#2:1683\n445#2,3:1684\n587#2,2:1687\n586#2,6:1689\n448#2,6:1695\n472#2,4:1701\n454#2:1705\n386#2,11:1706\n477#2:1719\n479#2,36:1725\n456#2,5:1761\n593#2:1766\n461#2,2:1767\n400#2,5:1769\n405#2:1783\n445#2,3:1784\n587#2,2:1787\n586#2,6:1789\n448#2,6:1795\n472#2,4:1801\n454#2:1805\n406#2,10:1806\n477#2:1818\n479#2,36:1824\n456#2,5:1860\n593#2:1865\n461#2,2:1866\n416#2:1868\n418#2:1870\n419#2:1880\n445#2,3:1881\n587#2,2:1884\n586#2,6:1886\n448#2,6:1892\n472#2,4:1898\n454#2:1902\n420#2,10:1903\n477#2:1915\n479#2,36:1921\n456#2,5:1957\n593#2:1962\n461#2,2:1963\n430#2:1965\n432#2,6:1967\n574#2,3:1973\n555#2,7:1979\n562#2,15:1987\n555#2,7:2005\n562#2,12:2013\n700#2:2026\n587#2,2:2027\n586#2,6:2029\n702#2:2035\n593#2:2036\n703#2:2037\n574#2,3:2038\n555#2,7:2044\n562#2,12:2052\n700#2:2065\n587#2,2:2066\n586#2,6:2068\n702#2:2074\n593#2:2075\n703#2:2076\n574#2,3:2077\n555#2,7:2083\n562#2,12:2091\n700#2:2104\n587#2,2:2105\n586#2,6:2107\n702#2:2113\n593#2:2114\n703#2:2115\n574#2,3:2116\n555#2,7:2122\n562#2,12:2130\n574#2,3:2144\n555#2,7:2150\n562#2,12:2158\n574#2,3:2172\n555#2,7:2178\n562#2,12:2186\n574#2,3:2200\n555#2,7:2206\n562#2,12:2214\n574#2,3:2235\n555#2,7:2241\n562#2,15:2249\n555#2,22:2264\n555#2,7:2286\n562#2,15:2294\n555#2,22:2309\n555#2,7:2331\n562#2,15:2339\n555#2,22:2354\n555#2,7:2376\n562#2,15:2384\n555#2,22:2399\n555#2,7:2423\n562#2,12:2431\n574#2,3:2445\n1#3:1194\n1#3:1223\n1#3:1252\n1#3:1281\n1#3:1307\n1#3:1336\n1#3:1362\n1#3:1388\n1#3:1420\n1#3:1451\n1#3:1477\n1#3:1506\n1#3:1545\n1#3:1986\n1#3:2012\n1#3:2051\n1#3:2090\n1#3:2129\n1#3:2157\n1#3:2185\n1#3:2213\n1#3:2228\n1#3:2248\n1#3:2293\n1#3:2338\n1#3:2383\n1#3:2430\n1740#4,3:1405\n1869#4:1622\n1870#4:1625\n1869#4:2227\n1869#4,2:2229\n1870#4:2231\n1869#4,2:2232\n90#5,5:1433\n44#5,2:1613\n46#5,2:1629\n90#5,5:1632\n46#5,2:1717\n90#5,5:1720\n46#5,2:1816\n90#5,5:1819\n46#5,2:1913\n90#5,5:1916\n91#6,8:1583\n100#6:1682\n90#6,9:1774\n100#6:1869\n62#7,9:1871\n72#7:1966\n13805#8,2:2239\n*S KotlinDebug\n*F\n+ 1 CompileServiceImpl.kt\norg/jetbrains/kotlin/daemon/CompileServiceImpl\n*L\n730#1:1185,2\n730#1:1210\n734#1:1211,5\n734#1:1239\n742#1:1240,5\n742#1:1268\n746#1:1269,5\n746#1:1297\n752#1:1298,2\n752#1:1323\n758#1:1324,5\n758#1:1352\n763#1:1353,2\n763#1:1378\n771#1:1379,2\n771#1:1404\n784#1:1408,5\n784#1:1441\n786#1:1442,2\n786#1:1467\n791#1:1468,2\n791#1:1493\n805#1:1494,5\n805#1:1532\n817#1:1533,5\n817#1:1976\n880#1:1977,2\n880#1:2002\n897#1:2003,2\n898#1:2025\n897#1:2041\n904#1:2042,2\n905#1:2064\n904#1:2080\n913#1:2081,2\n914#1:2103\n913#1:2119\n927#1:2120,2\n927#1:2142,2\n927#1:2147\n949#1:2148,2\n949#1:2170,2\n949#1:2175\n967#1:2176,2\n967#1:2198,2\n967#1:2203\n981#1:2204,2\n981#1:2226\n981#1:2234\n981#1:2238\n1088#1:2421,2\n1088#1:2443,2\n1088#1:2448\n720#1:1173\n720#1:1174,2\n720#1:1176,6\n720#1:1182\n720#1:1183\n720#1:1184\n730#1:1187,7\n730#1:1195,15\n734#1:1216,7\n734#1:1224,15\n742#1:1245,7\n742#1:1253,15\n746#1:1274,7\n746#1:1282,15\n752#1:1300,7\n752#1:1308,15\n758#1:1329,7\n758#1:1337,15\n763#1:1355,7\n763#1:1363,15\n771#1:1381,7\n771#1:1389,15\n784#1:1413,7\n784#1:1421,12\n784#1:1438,3\n786#1:1444,7\n786#1:1452,15\n791#1:1470,7\n791#1:1478,15\n805#1:1499,7\n805#1:1507,12\n806#1:1519,2\n806#1:1521,8\n805#1:1529,3\n817#1:1538,7\n817#1:1546,12\n818#1:1558,25\n818#1:1591\n818#1:1592,3\n818#1:1595,2\n818#1:1597,6\n818#1:1603,6\n818#1:1609,4\n818#1:1615\n818#1:1616,6\n818#1:1623,2\n818#1:1626,3\n818#1:1631\n818#1:1637,36\n818#1:1673,5\n818#1:1678\n818#1:1679,2\n818#1:1681\n818#1:1683\n818#1:1684,3\n818#1:1687,2\n818#1:1689,6\n818#1:1695,6\n818#1:1701,4\n818#1:1705\n818#1:1706,11\n818#1:1719\n818#1:1725,36\n818#1:1761,5\n818#1:1766\n818#1:1767,2\n818#1:1769,5\n818#1:1783\n818#1:1784,3\n818#1:1787,2\n818#1:1789,6\n818#1:1795,6\n818#1:1801,4\n818#1:1805\n818#1:1806,10\n818#1:1818\n818#1:1824,36\n818#1:1860,5\n818#1:1865\n818#1:1866,2\n818#1:1868\n818#1:1870\n818#1:1880\n818#1:1881,3\n818#1:1884,2\n818#1:1886,6\n818#1:1892,6\n818#1:1898,4\n818#1:1902\n818#1:1903,10\n818#1:1915\n818#1:1921,36\n818#1:1957,5\n818#1:1962\n818#1:1963,2\n818#1:1965\n818#1:1967,6\n817#1:1973,3\n880#1:1979,7\n880#1:1987,15\n897#1:2005,7\n897#1:2013,12\n898#1:2026\n898#1:2027,2\n898#1:2029,6\n898#1:2035\n898#1:2036\n898#1:2037\n897#1:2038,3\n904#1:2044,7\n904#1:2052,12\n905#1:2065\n905#1:2066,2\n905#1:2068,6\n905#1:2074\n905#1:2075\n905#1:2076\n904#1:2077,3\n913#1:2083,7\n913#1:2091,12\n914#1:2104\n914#1:2105,2\n914#1:2107,6\n914#1:2113\n914#1:2114\n914#1:2115\n913#1:2116,3\n927#1:2122,7\n927#1:2130,12\n927#1:2144,3\n949#1:2150,7\n949#1:2158,12\n949#1:2172,3\n967#1:2178,7\n967#1:2186,12\n967#1:2200,3\n981#1:2206,7\n981#1:2214,12\n981#1:2235,3\n1148#1:2241,7\n1148#1:2249,15\n1148#1:2264,22\n1152#1:2286,7\n1152#1:2294,15\n1152#1:2309,22\n1162#1:2331,7\n1162#1:2339,15\n1162#1:2354,22\n1166#1:2376,7\n1166#1:2384,15\n1166#1:2399,22\n1088#1:2423,7\n1088#1:2431,12\n1088#1:2445,3\n730#1:1194\n734#1:1223\n742#1:1252\n746#1:1281\n752#1:1307\n758#1:1336\n763#1:1362\n771#1:1388\n784#1:1420\n786#1:1451\n791#1:1477\n805#1:1506\n817#1:1545\n880#1:1986\n897#1:2012\n904#1:2051\n913#1:2090\n927#1:2129\n949#1:2157\n967#1:2185\n981#1:2213\n1148#1:2248\n1152#1:2293\n1162#1:2338\n1166#1:2383\n1088#1:2430\n780#1:1405,3\n818#1:1622\n818#1:1625\n1002#1:2227\n1005#1:2229,2\n1002#1:2231\n1036#1:2232,2\n784#1:1433,5\n818#1:1613,2\n818#1:1629,2\n818#1:1632,5\n818#1:1717,2\n818#1:1720,5\n818#1:1816,2\n818#1:1819,5\n818#1:1913,2\n818#1:1916,5\n818#1:1583,8\n818#1:1682\n818#1:1774,9\n818#1:1869\n818#1:1871,9\n818#1:1966\n1061#1:2239,2\n*E\n"})
public final class CompileServiceImpl
extends CompileServiceImplBase
implements CompileService {
    @NotNull
    private final Registry registry;
    @NotNull
    private final CompilerSelector compiler;
    @NotNull
    private final DaemonJVMOptions daemonJVMOptions;
    @NotNull
    private final ReentrantReadWriteLock rwlock;

    public CompileServiceImpl(@NotNull Registry registry, @NotNull CompilerSelector compiler, @NotNull CompilerId compilerId, @NotNull DaemonOptions daemonOptions, @NotNull DaemonJVMOptions daemonJVMOptions, int port, @NotNull Timer timer, @NotNull Function0<Unit> onShutdown) {
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        Intrinsics.checkNotNullParameter((Object)compiler, (String)"compiler");
        Intrinsics.checkNotNullParameter((Object)compilerId, (String)"compilerId");
        Intrinsics.checkNotNullParameter((Object)daemonOptions, (String)"daemonOptions");
        Intrinsics.checkNotNullParameter((Object)daemonJVMOptions, (String)"daemonJVMOptions");
        Intrinsics.checkNotNullParameter((Object)timer, (String)"timer");
        Intrinsics.checkNotNullParameter(onShutdown, (String)"onShutdown");
        super(daemonOptions, compilerId, port, timer, onShutdown);
        this.registry = registry;
        this.compiler = compiler;
        this.daemonJVMOptions = daemonJVMOptions;
        this.rwlock = new ReentrantReadWriteLock();
        try {
            UnicastRemoteObject.unexportObject(this, false);
        }
        catch (NoSuchObjectException noSuchObjectException) {
            // empty catch block
        }
        Remote remote = UnicastRemoteObject.exportObject(this, port, LoopbackNetworkInterface.INSTANCE.getClientLoopbackSocketFactory(), LoopbackNetworkInterface.INSTANCE.getServerLoopbackSocketFactory());
        Intrinsics.checkNotNull((Object)remote, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.daemon.common.CompileService");
        CompileService stub = (CompileService)remote;
        this.registry.rebind("KotlinJvmCompilerService", stub);
    }

    @NotNull
    public final Registry getRegistry() {
        return this.registry;
    }

    @NotNull
    public final CompilerSelector getCompiler() {
        return this.compiler;
    }

    @NotNull
    public final DaemonJVMOptions getDaemonJVMOptions() {
        return this.daemonJVMOptions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final <R> CompileService.CallResult<R> withValidRepl(int sessionId, Function1<? super KotlinJvmReplService, ? extends CompileService.CallResult<? extends R>> body) {
        Object object;
        void this_$iv$iv;
        CompileServiceImplBase.ClientOrSessionProxy<Object> clientOrSessionProxy;
        void this_$iv;
        boolean $i$f$withValidRepl = false;
        CompileServiceImplBase compileServiceImplBase = this;
        int sessionId$iv = sessionId;
        boolean $i$f$withValidReplImpl = false;
        void var7_7 = this_$iv;
        int sessionId$iv$iv = sessionId$iv;
        boolean $i$f$withValidClientOrSessionProxy = false;
        if (sessionId$iv$iv == 0) {
            clientOrSessionProxy = null;
        } else {
            clientOrSessionProxy = CompileServiceImplBase.access$getState((CompileServiceImplBase)this_$iv$iv).getSessions().get(sessionId$iv$iv);
            if (clientOrSessionProxy == null) {
                object = new CompileService.CallResult.Error("Unknown or invalid session " + sessionId$iv$iv);
                return object;
            }
        }
        CompileServiceImplBase.ClientOrSessionProxy<Object> session$iv$iv = clientOrSessionProxy;
        try {
            Object object2;
            CompileServiceImplBase.access$getCompilationsCounter((CompileServiceImplBase)this_$iv$iv).incrementAndGet();
            CompileServiceImplBase.ClientOrSessionProxy<Object> session$iv = session$iv$iv;
            boolean bl = false;
            CompileServiceImplBase.ClientOrSessionProxy<Object> clientOrSessionProxy2 = session$iv;
            Object object3 = clientOrSessionProxy2 != null ? clientOrSessionProxy2.getData() : null;
            if (object3 == null) {
                object3 = object2 = null;
            }
            if (object3 == null || (object2 = (CompileService.CallResult)body.invoke(object2)) == null) {
                object2 = new CompileService.CallResult.Error("Not a REPL session " + sessionId$iv);
            }
            Object object4 = object2;
            object = object4;
            return object;
        }
        finally {
            InlineMarker.finallyStart((int)1);
            CompileServiceImplBase.access$set_lastUsedSeconds((CompileServiceImplBase)this_$iv$iv, CompileServiceImplKt.nowSeconds());
            InlineMarker.finallyEnd((int)1);
        }
    }

    @Override
    protected long getLastUsedSeconds() {
        return this.rwlock.isWriteLocked() || this.rwlock.getReadLockCount() - this.rwlock.getReadHoldCount() > 0 ? CompileServiceImplKt.nowSeconds() : this.get_lastUsedSeconds();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public CompileService.CallResult<String> getDaemonInfo() {
        CompileService.CallResult callResult;
        void this_$iv;
        CompileServiceImpl compileServiceImpl = this;
        CompileServiceImplBase.Aliveness minAliveness$iv = CompileServiceImplBase.Aliveness.Dying;
        boolean $i$f$ifAlive = false;
        ReentrantReadWriteLock.ReadLock readLock = ((CompileServiceImpl)this_$iv).rwlock.readLock();
        readLock.lock();
        try {
            CompileService.CallResult callResult2;
            block11: {
                CompileService.CallResult callResult3;
                void this_$iv$iv;
                block8: {
                    Object object;
                    int curState$iv$iv;
                    CompileServiceImplBase.Aliveness minAliveness$iv$iv;
                    block10: {
                        block9: {
                            boolean bl = false;
                            CompileServiceImplBase compileServiceImplBase = (CompileServiceImplBase)this_$iv;
                            minAliveness$iv$iv = minAliveness$iv;
                            boolean $i$f$ifAliveChecksImpl = false;
                            curState$iv$iv = CompileServiceImplBase.access$getState((CompileServiceImplBase)this_$iv$iv).getAlive().get();
                            if (curState$iv$iv >= minAliveness$iv$iv.ordinal()) break block8;
                            Object[] stackTrace$iv$iv = Thread.currentThread().getStackTrace();
                            int rmiBusinessCallDepth$iv$iv = 1;
                            Intrinsics.checkNotNull((Object)stackTrace$iv$iv);
                            object = (StackTraceElement)ArraysKt.getOrNull((Object[])stackTrace$iv$iv, (int)rmiBusinessCallDepth$iv$iv);
                            if (object == null) break block9;
                            StackTraceElement it$iv$iv = object;
                            boolean bl2 = false;
                            String string = " Operation: " + it$iv$iv;
                            object = string;
                            if (string != null) break block10;
                        }
                        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
                        Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray, (String)"getStackTrace(...)");
                        object = ArraysKt.joinToString$default((Object[])stackTraceElementArray, (CharSequence)"\n at ", (CharSequence)" at ", null, (int)0, null, null, (int)60, null);
                    }
                    Object callSource$iv$iv = object;
                    CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv).info(StringsKt.trimMargin$default((String)("\n                    |Cannot perform operation, requested state: " + minAliveness$iv$iv.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName((CompileServiceImplBase)this_$iv$iv, curState$iv$iv) + "\n                    |" + (String)callSource$iv$iv + "\n                    "), null, (int)1, null));
                    callResult2 = new CompileService.CallResult.Dying();
                    break block11;
                }
                try {
                    boolean bl = false;
                    callResult3 = new CompileService.CallResult.Good<String>("Kotlin daemon on port " + this.getPort());
                }
                catch (Throwable e$iv$iv) {
                    CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv).log(Level.SEVERE, "Exception", e$iv$iv);
                    callResult3 = new CompileService.CallResult.Error(e$iv$iv);
                }
                callResult2 = callResult3;
            }
            callResult = callResult2;
        }
        finally {
            readLock.unlock();
        }
        return callResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public CompileService.CallResult<String> getKotlinVersion() {
        CompileService.CallResult callResult;
        CompileServiceImpl $this$iv = this;
        CompileServiceImplBase.Aliveness minAliveness$iv = CompileServiceImplBase.Aliveness.LastSession;
        boolean $i$f$ifAlive = false;
        ReentrantReadWriteLock.ReadLock readLock = $this$iv.rwlock.readLock();
        readLock.lock();
        try {
            CompileService.CallResult callResult2;
            block13: {
                CompileService.CallResult callResult3;
                void this_$iv$iv;
                block10: {
                    Object object;
                    int curState$iv$iv;
                    CompileServiceImplBase.Aliveness minAliveness$iv$iv;
                    block12: {
                        block11: {
                            boolean bl = false;
                            CompileServiceImplBase compileServiceImplBase = $this$iv;
                            minAliveness$iv$iv = minAliveness$iv;
                            boolean $i$f$ifAliveChecksImpl = false;
                            curState$iv$iv = CompileServiceImplBase.access$getState((CompileServiceImplBase)this_$iv$iv).getAlive().get();
                            if (curState$iv$iv >= minAliveness$iv$iv.ordinal()) break block10;
                            Object[] stackTrace$iv$iv = Thread.currentThread().getStackTrace();
                            int rmiBusinessCallDepth$iv$iv = 1;
                            Intrinsics.checkNotNull((Object)stackTrace$iv$iv);
                            object = (StackTraceElement)ArraysKt.getOrNull((Object[])stackTrace$iv$iv, (int)rmiBusinessCallDepth$iv$iv);
                            if (object == null) break block11;
                            StackTraceElement it$iv$iv = object;
                            boolean bl2 = false;
                            String string = " Operation: " + it$iv$iv;
                            object = string;
                            if (string != null) break block12;
                        }
                        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
                        Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray, (String)"getStackTrace(...)");
                        object = ArraysKt.joinToString$default((Object[])stackTraceElementArray, (CharSequence)"\n at ", (CharSequence)" at ", null, (int)0, null, null, (int)60, null);
                    }
                    Object callSource$iv$iv = object;
                    CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv).info(StringsKt.trimMargin$default((String)("\n                    |Cannot perform operation, requested state: " + minAliveness$iv$iv.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName((CompileServiceImplBase)this_$iv$iv, curState$iv$iv) + "\n                    |" + (String)callSource$iv$iv + "\n                    "), null, (int)1, null));
                    callResult2 = new CompileService.CallResult.Dying();
                    break block13;
                }
                try {
                    CompileService.CallResult callResult4;
                    boolean bl = false;
                    try {
                        callResult4 = new CompileService.CallResult.Good<String>(KotlinCompilerVersion.VERSION);
                    }
                    catch (Exception e) {
                        callResult4 = new CompileService.CallResult.Error("Unknown Kotlin version");
                    }
                    callResult3 = callResult4;
                }
                catch (Throwable e$iv$iv) {
                    CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv).log(Level.SEVERE, "Exception", e$iv$iv);
                    callResult3 = new CompileService.CallResult.Error(e$iv$iv);
                }
                callResult2 = callResult3;
            }
            callResult = callResult2;
        }
        finally {
            readLock.unlock();
        }
        return callResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public CompileService.CallResult<DaemonOptions> getDaemonOptions() {
        CompileService.CallResult callResult;
        CompileServiceImpl $this$iv = this;
        CompileServiceImplBase.Aliveness minAliveness$iv = CompileServiceImplBase.Aliveness.LastSession;
        boolean $i$f$ifAlive = false;
        ReentrantReadWriteLock.ReadLock readLock = $this$iv.rwlock.readLock();
        readLock.lock();
        try {
            CompileService.CallResult callResult2;
            block11: {
                CompileService.CallResult callResult3;
                void this_$iv$iv;
                block8: {
                    Object object;
                    int curState$iv$iv;
                    CompileServiceImplBase.Aliveness minAliveness$iv$iv;
                    block10: {
                        block9: {
                            boolean bl = false;
                            CompileServiceImplBase compileServiceImplBase = $this$iv;
                            minAliveness$iv$iv = minAliveness$iv;
                            boolean $i$f$ifAliveChecksImpl = false;
                            curState$iv$iv = CompileServiceImplBase.access$getState((CompileServiceImplBase)this_$iv$iv).getAlive().get();
                            if (curState$iv$iv >= minAliveness$iv$iv.ordinal()) break block8;
                            Object[] stackTrace$iv$iv = Thread.currentThread().getStackTrace();
                            int rmiBusinessCallDepth$iv$iv = 1;
                            Intrinsics.checkNotNull((Object)stackTrace$iv$iv);
                            object = (StackTraceElement)ArraysKt.getOrNull((Object[])stackTrace$iv$iv, (int)rmiBusinessCallDepth$iv$iv);
                            if (object == null) break block9;
                            StackTraceElement it$iv$iv = object;
                            boolean bl2 = false;
                            String string = " Operation: " + it$iv$iv;
                            object = string;
                            if (string != null) break block10;
                        }
                        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
                        Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray, (String)"getStackTrace(...)");
                        object = ArraysKt.joinToString$default((Object[])stackTraceElementArray, (CharSequence)"\n at ", (CharSequence)" at ", null, (int)0, null, null, (int)60, null);
                    }
                    Object callSource$iv$iv = object;
                    CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv).info(StringsKt.trimMargin$default((String)("\n                    |Cannot perform operation, requested state: " + minAliveness$iv$iv.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName((CompileServiceImplBase)this_$iv$iv, curState$iv$iv) + "\n                    |" + (String)callSource$iv$iv + "\n                    "), null, (int)1, null));
                    callResult2 = new CompileService.CallResult.Dying();
                    break block11;
                }
                try {
                    boolean bl = false;
                    callResult3 = new CompileService.CallResult.Good<DaemonOptions>(this.getDaemonOptions());
                }
                catch (Throwable e$iv$iv) {
                    CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv).log(Level.SEVERE, "Exception", e$iv$iv);
                    callResult3 = new CompileService.CallResult.Error(e$iv$iv);
                }
                callResult2 = callResult3;
            }
            callResult = callResult2;
        }
        finally {
            readLock.unlock();
        }
        return callResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public CompileService.CallResult<DaemonJVMOptions> getDaemonJVMOptions() {
        CompileService.CallResult callResult;
        CompileServiceImpl $this$iv = this;
        CompileServiceImplBase.Aliveness minAliveness$iv = CompileServiceImplBase.Aliveness.LastSession;
        boolean $i$f$ifAlive = false;
        ReentrantReadWriteLock.ReadLock readLock = $this$iv.rwlock.readLock();
        readLock.lock();
        try {
            CompileService.CallResult callResult2;
            block11: {
                CompileService.CallResult callResult3;
                void this_$iv$iv;
                block8: {
                    Object object;
                    int curState$iv$iv;
                    CompileServiceImplBase.Aliveness minAliveness$iv$iv;
                    block10: {
                        block9: {
                            boolean bl = false;
                            CompileServiceImplBase compileServiceImplBase = $this$iv;
                            minAliveness$iv$iv = minAliveness$iv;
                            boolean $i$f$ifAliveChecksImpl = false;
                            curState$iv$iv = CompileServiceImplBase.access$getState((CompileServiceImplBase)this_$iv$iv).getAlive().get();
                            if (curState$iv$iv >= minAliveness$iv$iv.ordinal()) break block8;
                            Object[] stackTrace$iv$iv = Thread.currentThread().getStackTrace();
                            int rmiBusinessCallDepth$iv$iv = 1;
                            Intrinsics.checkNotNull((Object)stackTrace$iv$iv);
                            object = (StackTraceElement)ArraysKt.getOrNull((Object[])stackTrace$iv$iv, (int)rmiBusinessCallDepth$iv$iv);
                            if (object == null) break block9;
                            StackTraceElement it$iv$iv = object;
                            boolean bl2 = false;
                            String string = " Operation: " + it$iv$iv;
                            object = string;
                            if (string != null) break block10;
                        }
                        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
                        Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray, (String)"getStackTrace(...)");
                        object = ArraysKt.joinToString$default((Object[])stackTraceElementArray, (CharSequence)"\n at ", (CharSequence)" at ", null, (int)0, null, null, (int)60, null);
                    }
                    Object callSource$iv$iv = object;
                    CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv).info(StringsKt.trimMargin$default((String)("\n                    |Cannot perform operation, requested state: " + minAliveness$iv$iv.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName((CompileServiceImplBase)this_$iv$iv, curState$iv$iv) + "\n                    |" + (String)callSource$iv$iv + "\n                    "), null, (int)1, null));
                    callResult2 = new CompileService.CallResult.Dying();
                    break block11;
                }
                try {
                    boolean bl = false;
                    this.getLog().info("getDaemonJVMOptions: " + this.daemonJVMOptions);
                    callResult3 = new CompileService.CallResult.Good<DaemonJVMOptions>(this.daemonJVMOptions);
                }
                catch (Throwable e$iv$iv) {
                    CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv).log(Level.SEVERE, "Exception", e$iv$iv);
                    callResult3 = new CompileService.CallResult.Error(e$iv$iv);
                }
                callResult2 = callResult3;
            }
            callResult = callResult2;
        }
        finally {
            readLock.unlock();
        }
        return callResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public CompileService.CallResult registerClient(@Nullable String aliveFlagPath) {
        CompileService.CallResult callResult;
        void this_$iv;
        CompileServiceImpl compileServiceImpl = this;
        CompileServiceImplBase.Aliveness minAliveness$iv = CompileServiceImplBase.Aliveness.Alive;
        boolean $i$f$ifAlive = false;
        ReentrantReadWriteLock.ReadLock readLock = ((CompileServiceImpl)this_$iv).rwlock.readLock();
        readLock.lock();
        try {
            CompileService.CallResult callResult2;
            block11: {
                CompileService.CallResult callResult3;
                void this_$iv$iv;
                block8: {
                    Object object;
                    int curState$iv$iv;
                    CompileServiceImplBase.Aliveness minAliveness$iv$iv;
                    block10: {
                        block9: {
                            boolean bl = false;
                            CompileServiceImplBase compileServiceImplBase = (CompileServiceImplBase)this_$iv;
                            minAliveness$iv$iv = minAliveness$iv;
                            boolean $i$f$ifAliveChecksImpl = false;
                            curState$iv$iv = CompileServiceImplBase.access$getState((CompileServiceImplBase)this_$iv$iv).getAlive().get();
                            if (curState$iv$iv >= minAliveness$iv$iv.ordinal()) break block8;
                            Object[] stackTrace$iv$iv = Thread.currentThread().getStackTrace();
                            int rmiBusinessCallDepth$iv$iv = 1;
                            Intrinsics.checkNotNull((Object)stackTrace$iv$iv);
                            object = (StackTraceElement)ArraysKt.getOrNull((Object[])stackTrace$iv$iv, (int)rmiBusinessCallDepth$iv$iv);
                            if (object == null) break block9;
                            StackTraceElement it$iv$iv = object;
                            boolean bl2 = false;
                            String string = " Operation: " + it$iv$iv;
                            object = string;
                            if (string != null) break block10;
                        }
                        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
                        Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray, (String)"getStackTrace(...)");
                        object = ArraysKt.joinToString$default((Object[])stackTraceElementArray, (CharSequence)"\n at ", (CharSequence)" at ", null, (int)0, null, null, (int)60, null);
                    }
                    Object callSource$iv$iv = object;
                    CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv).info(StringsKt.trimMargin$default((String)("\n                    |Cannot perform operation, requested state: " + minAliveness$iv$iv.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName((CompileServiceImplBase)this_$iv$iv, curState$iv$iv) + "\n                    |" + (String)callSource$iv$iv + "\n                    "), null, (int)1, null));
                    callResult2 = new CompileService.CallResult.Dying();
                    break block11;
                }
                try {
                    boolean bl = false;
                    this.getState().addClient(aliveFlagPath);
                    this.getLog().info("Registered a client alive file: " + aliveFlagPath);
                    callResult3 = new CompileService.CallResult.Ok();
                }
                catch (Throwable e$iv$iv) {
                    CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv).log(Level.SEVERE, "Exception", e$iv$iv);
                    callResult3 = new CompileService.CallResult.Error(e$iv$iv);
                }
                callResult2 = callResult3;
            }
            callResult = callResult2;
        }
        finally {
            readLock.unlock();
        }
        return callResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public CompileService.CallResult<List<String>> getClients() {
        CompileService.CallResult callResult;
        CompileServiceImpl $this$iv = this;
        CompileServiceImplBase.Aliveness minAliveness$iv = CompileServiceImplBase.Aliveness.LastSession;
        boolean $i$f$ifAlive = false;
        ReentrantReadWriteLock.ReadLock readLock = $this$iv.rwlock.readLock();
        readLock.lock();
        try {
            CompileService.CallResult callResult2;
            block11: {
                CompileService.CallResult callResult3;
                void this_$iv$iv;
                block8: {
                    Object object;
                    int curState$iv$iv;
                    CompileServiceImplBase.Aliveness minAliveness$iv$iv;
                    block10: {
                        block9: {
                            boolean bl = false;
                            CompileServiceImplBase compileServiceImplBase = $this$iv;
                            minAliveness$iv$iv = minAliveness$iv;
                            boolean $i$f$ifAliveChecksImpl = false;
                            curState$iv$iv = CompileServiceImplBase.access$getState((CompileServiceImplBase)this_$iv$iv).getAlive().get();
                            if (curState$iv$iv >= minAliveness$iv$iv.ordinal()) break block8;
                            Object[] stackTrace$iv$iv = Thread.currentThread().getStackTrace();
                            int rmiBusinessCallDepth$iv$iv = 1;
                            Intrinsics.checkNotNull((Object)stackTrace$iv$iv);
                            object = (StackTraceElement)ArraysKt.getOrNull((Object[])stackTrace$iv$iv, (int)rmiBusinessCallDepth$iv$iv);
                            if (object == null) break block9;
                            StackTraceElement it$iv$iv = object;
                            boolean bl2 = false;
                            String string = " Operation: " + it$iv$iv;
                            object = string;
                            if (string != null) break block10;
                        }
                        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
                        Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray, (String)"getStackTrace(...)");
                        object = ArraysKt.joinToString$default((Object[])stackTraceElementArray, (CharSequence)"\n at ", (CharSequence)" at ", null, (int)0, null, null, (int)60, null);
                    }
                    Object callSource$iv$iv = object;
                    CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv).info(StringsKt.trimMargin$default((String)("\n                    |Cannot perform operation, requested state: " + minAliveness$iv$iv.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName((CompileServiceImplBase)this_$iv$iv, curState$iv$iv) + "\n                    |" + (String)callSource$iv$iv + "\n                    "), null, (int)1, null));
                    callResult2 = new CompileService.CallResult.Dying();
                    break block11;
                }
                try {
                    boolean bl = false;
                    callResult3 = new CompileService.CallResult.Good<List<String>>(this.getState().getClientsFlagPaths());
                }
                catch (Throwable e$iv$iv) {
                    CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv).log(Level.SEVERE, "Exception", e$iv$iv);
                    callResult3 = new CompileService.CallResult.Error(e$iv$iv);
                }
                callResult2 = callResult3;
            }
            callResult = callResult2;
        }
        finally {
            readLock.unlock();
        }
        return callResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public CompileService.CallResult<Integer> leaseCompileSession(@Nullable String aliveFlagPath) {
        CompileService.CallResult callResult;
        void this_$iv;
        CompileServiceImpl compileServiceImpl = this;
        CompileServiceImplBase.Aliveness minAliveness$iv = CompileServiceImplBase.Aliveness.Alive;
        boolean $i$f$ifAlive = false;
        ReentrantReadWriteLock.ReadLock readLock = ((CompileServiceImpl)this_$iv).rwlock.readLock();
        readLock.lock();
        try {
            CompileService.CallResult callResult2;
            block11: {
                CompileService.CallResult callResult3;
                void this_$iv$iv;
                block8: {
                    Object object;
                    int curState$iv$iv;
                    CompileServiceImplBase.Aliveness minAliveness$iv$iv;
                    block10: {
                        block9: {
                            boolean bl = false;
                            CompileServiceImplBase compileServiceImplBase = (CompileServiceImplBase)this_$iv;
                            minAliveness$iv$iv = minAliveness$iv;
                            boolean $i$f$ifAliveChecksImpl = false;
                            curState$iv$iv = CompileServiceImplBase.access$getState((CompileServiceImplBase)this_$iv$iv).getAlive().get();
                            if (curState$iv$iv >= minAliveness$iv$iv.ordinal()) break block8;
                            Object[] stackTrace$iv$iv = Thread.currentThread().getStackTrace();
                            int rmiBusinessCallDepth$iv$iv = 1;
                            Intrinsics.checkNotNull((Object)stackTrace$iv$iv);
                            object = (StackTraceElement)ArraysKt.getOrNull((Object[])stackTrace$iv$iv, (int)rmiBusinessCallDepth$iv$iv);
                            if (object == null) break block9;
                            StackTraceElement it$iv$iv = object;
                            boolean bl2 = false;
                            String string = " Operation: " + it$iv$iv;
                            object = string;
                            if (string != null) break block10;
                        }
                        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
                        Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray, (String)"getStackTrace(...)");
                        object = ArraysKt.joinToString$default((Object[])stackTraceElementArray, (CharSequence)"\n at ", (CharSequence)" at ", null, (int)0, null, null, (int)60, null);
                    }
                    Object callSource$iv$iv = object;
                    CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv).info(StringsKt.trimMargin$default((String)("\n                    |Cannot perform operation, requested state: " + minAliveness$iv$iv.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName((CompileServiceImplBase)this_$iv$iv, curState$iv$iv) + "\n                    |" + (String)callSource$iv$iv + "\n                    "), null, (int)1, null));
                    callResult2 = new CompileService.CallResult.Dying();
                    break block11;
                }
                try {
                    boolean bl = false;
                    Integer n = this.getState().getSessions().leaseSession(new CompileServiceImplBase.ClientOrSessionProxy(aliveFlagPath, null, null, 6, null));
                    int $this$leaseCompileSession_u24lambda_u240_u240 = ((Number)n).intValue();
                    boolean bl3 = false;
                    this.getLog().info("leased a new session " + $this$leaseCompileSession_u24lambda_u240_u240 + ", session alive file: " + aliveFlagPath);
                    Integer n2 = n;
                    callResult3 = new CompileService.CallResult.Good<Integer>(n2);
                }
                catch (Throwable e$iv$iv) {
                    CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv).log(Level.SEVERE, "Exception", e$iv$iv);
                    callResult3 = new CompileService.CallResult.Error(e$iv$iv);
                }
                callResult2 = callResult3;
            }
            callResult = callResult2;
        }
        finally {
            readLock.unlock();
        }
        return callResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public CompileService.CallResult releaseCompileSession(int sessionId) {
        CompileService.CallResult callResult;
        void this_$iv;
        CompileServiceImpl compileServiceImpl = this;
        CompileServiceImplBase.Aliveness minAliveness$iv = CompileServiceImplBase.Aliveness.LastSession;
        boolean $i$f$ifAlive = false;
        ReentrantReadWriteLock.ReadLock readLock = ((CompileServiceImpl)this_$iv).rwlock.readLock();
        readLock.lock();
        try {
            CompileService.CallResult callResult2;
            block11: {
                CompileService.CallResult callResult3;
                void this_$iv$iv;
                block8: {
                    Object object;
                    int curState$iv$iv;
                    CompileServiceImplBase.Aliveness minAliveness$iv$iv;
                    block10: {
                        block9: {
                            boolean bl = false;
                            CompileServiceImplBase compileServiceImplBase = (CompileServiceImplBase)this_$iv;
                            minAliveness$iv$iv = minAliveness$iv;
                            boolean $i$f$ifAliveChecksImpl = false;
                            curState$iv$iv = CompileServiceImplBase.access$getState((CompileServiceImplBase)this_$iv$iv).getAlive().get();
                            if (curState$iv$iv >= minAliveness$iv$iv.ordinal()) break block8;
                            Object[] stackTrace$iv$iv = Thread.currentThread().getStackTrace();
                            int rmiBusinessCallDepth$iv$iv = 1;
                            Intrinsics.checkNotNull((Object)stackTrace$iv$iv);
                            object = (StackTraceElement)ArraysKt.getOrNull((Object[])stackTrace$iv$iv, (int)rmiBusinessCallDepth$iv$iv);
                            if (object == null) break block9;
                            StackTraceElement it$iv$iv = object;
                            boolean bl2 = false;
                            String string = " Operation: " + it$iv$iv;
                            object = string;
                            if (string != null) break block10;
                        }
                        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
                        Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray, (String)"getStackTrace(...)");
                        object = ArraysKt.joinToString$default((Object[])stackTraceElementArray, (CharSequence)"\n at ", (CharSequence)" at ", null, (int)0, null, null, (int)60, null);
                    }
                    Object callSource$iv$iv = object;
                    CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv).info(StringsKt.trimMargin$default((String)("\n                    |Cannot perform operation, requested state: " + minAliveness$iv$iv.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName((CompileServiceImplBase)this_$iv$iv, curState$iv$iv) + "\n                    |" + (String)callSource$iv$iv + "\n                    "), null, (int)1, null));
                    callResult2 = new CompileService.CallResult.Dying();
                    break block11;
                }
                try {
                    boolean bl = false;
                    this.getState().getSessions().remove(sessionId);
                    this.getLog().info("cleaning after session " + sessionId);
                    this.clearJarCache();
                    callResult3 = this.postReleaseCompileSession();
                }
                catch (Throwable e$iv$iv) {
                    CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv).log(Level.SEVERE, "Exception", e$iv$iv);
                    callResult3 = new CompileService.CallResult.Error(e$iv$iv);
                }
                callResult2 = callResult3;
            }
            callResult = callResult2;
        }
        finally {
            readLock.unlock();
        }
        return callResult;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean checkCompilerId(@NotNull CompilerId expectedCompilerId) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)expectedCompilerId, (String)"expectedCompilerId");
        if (!(((CharSequence)this.getCompilerId().getCompilerVersion()).length() == 0)) {
            if (!Intrinsics.areEqual((Object)this.getCompilerId().getCompilerVersion(), (Object)expectedCompilerId.getCompilerVersion())) return false;
        }
        Iterable $this$all$iv = this.getCompilerId().getCompilerClasspath();
        boolean $i$f$all = false;
        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
            bl = true;
        } else {
            for (Object element$iv : $this$all$iv) {
                String it = (String)element$iv;
                boolean bl2 = false;
                if (expectedCompilerId.getCompilerClasspath().contains(it)) continue;
                return false;
            }
            bl = true;
        }
        if (!bl) return false;
        if (this.getClasspathWatcher().isChanged()) return false;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public CompileService.CallResult<Long> getUsedMemory(boolean withGC) {
        CompileService.CallResult callResult;
        CompileServiceImpl $this$iv = this;
        CompileServiceImplBase.Aliveness minAliveness$iv = CompileServiceImplBase.Aliveness.LastSession;
        boolean $i$f$ifAlive = false;
        ReentrantReadWriteLock.ReadLock readLock = $this$iv.rwlock.readLock();
        readLock.lock();
        try {
            CompileService.CallResult callResult2;
            block13: {
                CompileService.CallResult callResult3;
                void this_$iv$iv;
                block10: {
                    Object object;
                    int curState$iv$iv;
                    CompileServiceImplBase.Aliveness minAliveness$iv$iv;
                    block12: {
                        block11: {
                            boolean bl = false;
                            CompileServiceImplBase compileServiceImplBase = $this$iv;
                            minAliveness$iv$iv = minAliveness$iv;
                            boolean $i$f$ifAliveChecksImpl = false;
                            curState$iv$iv = CompileServiceImplBase.access$getState((CompileServiceImplBase)this_$iv$iv).getAlive().get();
                            if (curState$iv$iv >= minAliveness$iv$iv.ordinal()) break block10;
                            Object[] stackTrace$iv$iv = Thread.currentThread().getStackTrace();
                            int rmiBusinessCallDepth$iv$iv = 1;
                            Intrinsics.checkNotNull((Object)stackTrace$iv$iv);
                            object = (StackTraceElement)ArraysKt.getOrNull((Object[])stackTrace$iv$iv, (int)rmiBusinessCallDepth$iv$iv);
                            if (object == null) break block11;
                            StackTraceElement it$iv$iv = object;
                            boolean bl2 = false;
                            String string = " Operation: " + it$iv$iv;
                            object = string;
                            if (string != null) break block12;
                        }
                        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
                        Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray, (String)"getStackTrace(...)");
                        object = ArraysKt.joinToString$default((Object[])stackTraceElementArray, (CharSequence)"\n at ", (CharSequence)" at ", null, (int)0, null, null, (int)60, null);
                    }
                    Object callSource$iv$iv = object;
                    CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv).info(StringsKt.trimMargin$default((String)("\n                    |Cannot perform operation, requested state: " + minAliveness$iv$iv.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName((CompileServiceImplBase)this_$iv$iv, curState$iv$iv) + "\n                    |" + (String)callSource$iv$iv + "\n                    "), null, (int)1, null));
                    callResult2 = new CompileService.CallResult.Dying();
                    break block13;
                }
                try {
                    boolean bl = false;
                    boolean withGC$iv = withGC;
                    boolean $i$f$usedMemory = false;
                    if (withGC$iv) {
                        System.gc();
                    }
                    Runtime rt$iv = Runtime.getRuntime();
                    callResult3 = new CompileService.CallResult.Good<Long>(rt$iv.totalMemory() - rt$iv.freeMemory());
                }
                catch (Throwable e$iv$iv) {
                    CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv).log(Level.SEVERE, "Exception", e$iv$iv);
                    callResult3 = new CompileService.CallResult.Error(e$iv$iv);
                }
                callResult2 = callResult3;
            }
            callResult = callResult2;
        }
        finally {
            readLock.unlock();
        }
        return callResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public CompileService.CallResult shutdown() {
        CompileService.CallResult callResult;
        void this_$iv;
        CompileServiceImpl compileServiceImpl = this;
        CompileServiceImplBase.Aliveness minAliveness$iv = CompileServiceImplBase.Aliveness.LastSession;
        boolean $i$f$ifAliveExclusive = false;
        ReentrantReadWriteLock reentrantReadWriteLock = ((CompileServiceImpl)this_$iv).rwlock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        for (int i = 0; i < n; ++i) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            CompileService.CallResult callResult2;
            block13: {
                CompileService.CallResult callResult3;
                void this_$iv$iv;
                block10: {
                    Object object;
                    int curState$iv$iv;
                    CompileServiceImplBase.Aliveness minAliveness$iv$iv;
                    block12: {
                        block11: {
                            boolean bl = false;
                            CompileServiceImplBase compileServiceImplBase = (CompileServiceImplBase)this_$iv;
                            minAliveness$iv$iv = minAliveness$iv;
                            boolean $i$f$ifAliveChecksImpl = false;
                            curState$iv$iv = CompileServiceImplBase.access$getState((CompileServiceImplBase)this_$iv$iv).getAlive().get();
                            if (curState$iv$iv >= minAliveness$iv$iv.ordinal()) break block10;
                            Object[] stackTrace$iv$iv = Thread.currentThread().getStackTrace();
                            int rmiBusinessCallDepth$iv$iv = 1;
                            Intrinsics.checkNotNull((Object)stackTrace$iv$iv);
                            object = (StackTraceElement)ArraysKt.getOrNull((Object[])stackTrace$iv$iv, (int)rmiBusinessCallDepth$iv$iv);
                            if (object == null) break block11;
                            StackTraceElement it$iv$iv = object;
                            boolean bl2 = false;
                            String string = " Operation: " + it$iv$iv;
                            object = string;
                            if (string != null) break block12;
                        }
                        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
                        Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray, (String)"getStackTrace(...)");
                        object = ArraysKt.joinToString$default((Object[])stackTraceElementArray, (CharSequence)"\n at ", (CharSequence)" at ", null, (int)0, null, null, (int)60, null);
                    }
                    Object callSource$iv$iv = object;
                    CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv).info(StringsKt.trimMargin$default((String)("\n                    |Cannot perform operation, requested state: " + minAliveness$iv$iv.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName((CompileServiceImplBase)this_$iv$iv, curState$iv$iv) + "\n                    |" + (String)callSource$iv$iv + "\n                    "), null, (int)1, null));
                    callResult2 = new CompileService.CallResult.Dying();
                    break block13;
                }
                try {
                    boolean bl = false;
                    this.shutdownWithDelay();
                    callResult3 = new CompileService.CallResult.Ok();
                }
                catch (Throwable e$iv$iv) {
                    CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv).log(Level.SEVERE, "Exception", e$iv$iv);
                    callResult3 = new CompileService.CallResult.Error(e$iv$iv);
                }
                callResult2 = callResult3;
            }
            callResult = callResult2;
        }
        finally {
            for (int i = 0; i < n; ++i) {
                readLock.lock();
            }
            writeLock.unlock();
        }
        return callResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public CompileService.CallResult<Boolean> scheduleShutdown(boolean graceful) {
        CompileService.CallResult callResult;
        void this_$iv;
        CompileServiceImpl compileServiceImpl = this;
        CompileServiceImplBase.Aliveness minAliveness$iv = CompileServiceImplBase.Aliveness.LastSession;
        boolean $i$f$ifAlive = false;
        ReentrantReadWriteLock.ReadLock readLock = ((CompileServiceImpl)this_$iv).rwlock.readLock();
        readLock.lock();
        try {
            CompileService.CallResult callResult2;
            block14: {
                CompileService.CallResult callResult3;
                void this_$iv$iv;
                block11: {
                    Object object;
                    int curState$iv$iv;
                    CompileServiceImplBase.Aliveness minAliveness$iv$iv;
                    block13: {
                        block12: {
                            boolean bl = false;
                            CompileServiceImplBase compileServiceImplBase = (CompileServiceImplBase)this_$iv;
                            minAliveness$iv$iv = minAliveness$iv;
                            boolean $i$f$ifAliveChecksImpl = false;
                            curState$iv$iv = CompileServiceImplBase.access$getState((CompileServiceImplBase)this_$iv$iv).getAlive().get();
                            if (curState$iv$iv >= minAliveness$iv$iv.ordinal()) break block11;
                            Object[] stackTrace$iv$iv = Thread.currentThread().getStackTrace();
                            int rmiBusinessCallDepth$iv$iv = 1;
                            Intrinsics.checkNotNull((Object)stackTrace$iv$iv);
                            object = (StackTraceElement)ArraysKt.getOrNull((Object[])stackTrace$iv$iv, (int)rmiBusinessCallDepth$iv$iv);
                            if (object == null) break block12;
                            StackTraceElement it$iv$iv = object;
                            boolean bl2 = false;
                            String string = " Operation: " + it$iv$iv;
                            object = string;
                            if (string != null) break block13;
                        }
                        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
                        Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray, (String)"getStackTrace(...)");
                        object = ArraysKt.joinToString$default((Object[])stackTraceElementArray, (CharSequence)"\n at ", (CharSequence)" at ", null, (int)0, null, null, (int)60, null);
                    }
                    Object callSource$iv$iv = object;
                    CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv).info(StringsKt.trimMargin$default((String)("\n                    |Cannot perform operation, requested state: " + minAliveness$iv$iv.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName((CompileServiceImplBase)this_$iv$iv, curState$iv$iv) + "\n                    |" + (String)callSource$iv$iv + "\n                    "), null, (int)1, null));
                    callResult2 = new CompileService.CallResult.Dying();
                    break block14;
                }
                try {
                    boolean bl;
                    boolean bl3 = false;
                    if (graceful) {
                        bl = this.gracefulShutdown(true);
                    } else {
                        this.shutdownWithDelay();
                        bl = true;
                    }
                    boolean res = bl;
                    callResult3 = new CompileService.CallResult.Good<Boolean>(res);
                }
                catch (Throwable e$iv$iv) {
                    CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv).log(Level.SEVERE, "Exception", e$iv$iv);
                    callResult3 = new CompileService.CallResult.Error(e$iv$iv);
                }
                callResult2 = callResult3;
            }
            callResult = callResult2;
        }
        finally {
            readLock.unlock();
        }
        return callResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    @NotNull
    public CompileService.CallResult<Set<String>> classesFqNamesByFiles(int sessionId, @NotNull Set<? extends File> sourceFiles) {
        Intrinsics.checkNotNullParameter(sourceFiles, (String)"sourceFiles");
        $this$iv = this;
        minAliveness$iv = CompileServiceImplBase.Aliveness.LastSession;
        $i$f$ifAlive = false;
        var6_6 = CompileServiceImpl.access$getRwlock$p($this$iv).readLock();
        var6_6.lock();
        try {
            block19: {
                block16: {
                    block18: {
                        block17: {
                            $i$a$-read-CompileServiceImpl$ifAlive$1$iv = false;
                            var8_9 = $this$iv;
                            minAliveness$iv$iv = minAliveness$iv;
                            $i$f$ifAliveChecksImpl = false;
                            curState$iv$iv = CompileServiceImplBase.access$getState((CompileServiceImplBase)this_$iv$iv).getAlive().get();
                            if (curState$iv$iv >= minAliveness$iv$iv.ordinal()) break block16;
                            stackTrace$iv$iv = Thread.currentThread().getStackTrace();
                            rmiBusinessCallDepth$iv$iv = 1;
                            Intrinsics.checkNotNull((Object)stackTrace$iv$iv);
                            v0 = (StackTraceElement)ArraysKt.getOrNull((Object[])stackTrace$iv$iv, (int)rmiBusinessCallDepth$iv$iv);
                            if (v0 == null) break block17;
                            it$iv$iv = v0;
                            $i$a$-let-CompileServiceImplBase$ifAliveChecksImpl$callSource$1$iv$iv = false;
                            v1 = " Operation: " + it$iv$iv;
                            v0 = v1;
                            if (v1 != null) break block18;
                        }
                        v2 = Thread.currentThread().getStackTrace();
                        Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"getStackTrace(...)");
                        v0 = ArraysKt.joinToString$default((Object[])v2, (CharSequence)"\n at ", (CharSequence)" at ", null, (int)0, null, null, (int)60, null);
                    }
                    callSource$iv$iv = v0;
                    CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv).info(StringsKt.trimMargin$default((String)("\n                    |Cannot perform operation, requested state: " + minAliveness$iv$iv.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName((CompileServiceImplBase)this_$iv$iv, curState$iv$iv) + "\n                    |" + (String)callSource$iv$iv + "\n                    "), null, (int)1, null));
                    v3 = new CompileService.CallResult.Dying();
                    break block19;
                }
                try {
                    block20: {
                        $i$a$-ifAlive$default-CompileServiceImpl$classesFqNamesByFiles$1 = false;
                        var18_22 = this;
                        sessionId$iv = sessionId;
                        $i$f$withValidClientOrSessionProxy = false;
                        if (sessionId$iv != 0) break block20;
                        v4 = null;
                        ** GOTO lbl-1000
                    }
                    v4 = CompileServiceImplBase.access$getState((CompileServiceImplBase)this_$iv).getSessions().get(sessionId$iv);
                    if (v4 == null) {
                        v5 = new CompileService.CallResult.Error("Unknown or invalid session " + sessionId$iv);
                    } else lbl-1000:
                    // 2 sources

                    {
                        session$iv = v4;
                        try {
                            CompileServiceImplBase.access$getCompilationsCounter((CompileServiceImplBase)this_$iv).incrementAndGet();
                            it = session$iv;
                            $i$a$-withValidClientOrSessionProxy-CompileServiceImpl$classesFqNamesByFiles$1$1 = false;
                            var22_26 = new CompileService.CallResult.Good<Set>(ParseFileUtilsKt.classesFqNames(sourceFiles));
                            v5 = var22_26;
                        }
                        finally {
                            CompileServiceImplBase.access$set_lastUsedSeconds((CompileServiceImplBase)this_$iv, CompileServiceImplKt.nowSeconds());
                        }
                    }
                    var12_15 = v5;
                }
                catch (Throwable e$iv$iv) {
                    CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv).log(Level.SEVERE, "Exception", e$iv$iv);
                    var12_15 = new CompileService.CallResult.Error(e$iv$iv);
                }
                v3 = var12_15;
            }
            var7_8 = v3;
        }
        finally {
            var6_6.unlock();
        }
        return var7_8;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    @Override
    @NotNull
    public CompileService.CallResult<Integer> compile(int sessionId, @NotNull String[] compilerArguments, @NotNull CompilationOptions compilationOptions, @NotNull CompilerServicesFacadeBase servicesFacade, @Nullable CompilationResults compilationResults) {
        Intrinsics.checkNotNullParameter((Object)compilerArguments, (String)"compilerArguments");
        Intrinsics.checkNotNullParameter((Object)compilationOptions, (String)"compilationOptions");
        Intrinsics.checkNotNullParameter((Object)servicesFacade, (String)"servicesFacade");
        $this$iv = this;
        minAliveness$iv = CompileServiceImplBase.Aliveness.LastSession;
        $i$f$ifAlive = false;
        var9_9 = CompileServiceImpl.access$getRwlock$p($this$iv).readLock();
        var9_9.lock();
        try {
            block100: {
                block97: {
                    block99: {
                        block98: {
                            $i$a$-read-CompileServiceImpl$ifAlive$1$iv = false;
                            var11_12 = $this$iv;
                            minAliveness$iv$iv = minAliveness$iv;
                            $i$f$ifAliveChecksImpl = false;
                            curState$iv$iv = CompileServiceImplBase.access$getState((CompileServiceImplBase)this_$iv$iv).getAlive().get();
                            if (curState$iv$iv >= minAliveness$iv$iv.ordinal()) break block97;
                            stackTrace$iv$iv = Thread.currentThread().getStackTrace();
                            rmiBusinessCallDepth$iv$iv = 1;
                            Intrinsics.checkNotNull((Object)stackTrace$iv$iv);
                            v0 = (StackTraceElement)ArraysKt.getOrNull((Object[])stackTrace$iv$iv, (int)rmiBusinessCallDepth$iv$iv);
                            if (v0 == null) break block98;
                            it$iv$iv = v0;
                            $i$a$-let-CompileServiceImplBase$ifAliveChecksImpl$callSource$1$iv$iv = false;
                            v1 = " Operation: " + it$iv$iv;
                            v0 = v1;
                            if (v1 != null) break block99;
                        }
                        v2 = Thread.currentThread().getStackTrace();
                        Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"getStackTrace(...)");
                        v0 = ArraysKt.joinToString$default((Object[])v2, (CharSequence)"\n at ", (CharSequence)" at ", null, (int)0, null, null, (int)60, null);
                    }
                    callSource$iv$iv = v0;
                    CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv).info(StringsKt.trimMargin$default((String)("\n                    |Cannot perform operation, requested state: " + minAliveness$iv$iv.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName((CompileServiceImplBase)this_$iv$iv, curState$iv$iv) + "\n                    |" + (String)callSource$iv$iv + "\n                    "), null, (int)1, null));
                    v3 = new CompileService.CallResult.Dying();
                    break block100;
                }
                try {
                    block102: {
                        block101: {
                            $i$a$-ifAlive$default-CompileServiceImpl$compile$1 = false;
                            var21_25 = this;
                            var22_26 = sessionId;
                            var23_27 = compilerArguments;
                            var24_28 = compilationOptions;
                            var25_29 = servicesFacade;
                            var26_30 = compilationResults;
                            $i$f$compileImpl = false;
                            $i$a$-run-CompileServiceImplBase$compileImpl$1$iv = false;
                            var29_33 = compilationOptions$iv;
                            p0 /* !! */  = servicesFacade$iv;
                            $i$a$-compileImpl-CompileServiceImpl$compile$1$2 = false;
                            messageCollector$iv = new CompileServicesFacadeMessageCollector(p0 /* !! */ , (CompilationOptions)p1);
                            p1 = compilationOptions$iv;
                            p0 /* !! */  = servicesFacade$iv;
                            $i$a$-compileImpl-CompileServiceImpl$compile$1$3 = false;
                            daemonReporter$iv = DaemonMessageReporterKt.DaemonMessageReporter(p0 /* !! */ , (CompilationOptions)p1);
                            targetPlatform$iv = compilationOptions$iv.getTargetPlatform();
                            CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv).info("Starting compilation with args: " + ArraysKt.joinToString$default((Object[])compilerArguments$iv, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null));
                            switch (CompileServiceImplBase.WhenMappings.$EnumSwitchMapping$1[targetPlatform$iv.ordinal()]) {
                                case 1: {
                                    v4 = (CLICompiler)new K2JVMCompiler();
                                    break;
                                }
                                case 2: {
                                    v4 = (CLICompiler)new K2JSCompiler();
                                    break;
                                }
                                case 3: {
                                    v4 = (CLICompiler)new KotlinMetadataCompiler();
                                    break;
                                }
                                default: {
                                    throw new NoWhenBranchMatchedException();
                                }
                            }
                            compiler$iv = v4;
                            k2PlatformArgs$iv = compiler$iv.createArguments();
                            ParseCommandLineArgumentsKt.parseCommandLineArguments$default((List)ArraysKt.asList((Object[])compilerArguments$iv), (CommonToolArguments)((CommonToolArguments)k2PlatformArgs$iv), (boolean)false, (int)4, null);
                            argumentParseError$iv = ParseCommandLineArgumentsKt.validateArguments((ArgumentParseErrors)k2PlatformArgs$iv.getErrors());
                            if (argumentParseError$iv == null) break block101;
                            MessageCollector.report$default((MessageCollector)messageCollector$iv, (CompilerMessageSeverity)CompilerMessageSeverity.ERROR, (String)argumentParseError$iv, null, (int)4, null);
                            v5 = new CompileService.CallResult.Good<Integer>(ExitCode.COMPILATION_ERROR.getCode());
                            break block102;
                        }
                        block22 : switch (CompileServiceImplBase.WhenMappings.$EnumSwitchMapping$2[compilationOptions$iv.getCompilerMode().ordinal()]) {
                            case 1: {
                                (Object)servicesFacade$iv;
                                var38_47 = k2PlatformArgs$iv;
                                p0 /* !! */  = (JpsCompilerServicesFacade)servicesFacade$iv;
                                $i$a$-compileImpl-CompileServiceImpl$compile$1$1 = false;
                                enabled$iv$iv = p0 /* !! */ .hasIncrementalCaches();
                                $i$f$withIncrementalCompilation = false;
                                isEnabledBackup$iv$iv = IncrementalCompilation.isEnabledForJvm();
                                IncrementalCompilation.setIsEnabledForJvm((boolean)enabled$iv$iv);
                                try {
                                    if (args$iv$iv.getIncrementalCompilation() == null) {
                                        args$iv$iv.setIncrementalCompilation(Boolean.valueOf(enabled$iv$iv));
                                    }
                                    $i$a$-withIncrementalCompilation-CompileServiceImplBase$compileImpl$1$1$iv = false;
                                    var43_61 = this_$iv;
                                    var44_65 = sessionId$iv;
                                    var45_69 = daemonReporter$iv;
                                    tracer$iv$iv = null;
                                    $i$f$doCompile = false;
                                    $this$doCompile_u24lambda_u240$iv$iv = this_$iv$iv;
                                    $i$a$-run-CompileServiceImplBase$doCompile$1$iv$iv = false;
                                    CompileServiceImplBase.access$getLog((CompileServiceImplBase)$this$doCompile_u24lambda_u240$iv$iv).fine("alive!");
                                    var50_89 = $this$doCompile_u24lambda_u240$iv$iv;
                                    sessionId$iv$iv$iv = sessionId$iv$iv;
                                    $i$f$withValidClientOrSessionProxy = false;
                                    if (sessionId$iv$iv$iv != false) ** GOTO lbl112
                                    v6 = null;
                                    ** GOTO lbl116
lbl112:
                                    // 1 sources

                                    v6 = CompileServiceImplBase.access$getState((CompileServiceImplBase)this_$iv$iv$iv).getSessions().get((int)sessionId$iv$iv$iv);
                                    if (v6 != null) ** GOTO lbl116
                                    v7 = new CompileService.CallResult.Error("Unknown or invalid session " + (int)sessionId$iv$iv$iv);
                                    ** GOTO lbl232
lbl116:
                                    // 2 sources

                                    session$iv$iv$iv = v6;
                                    try {
                                        CompileServiceImplBase.access$getCompilationsCounter((CompileServiceImplBase)this_$iv$iv$iv).incrementAndGet();
                                        it$iv$iv = session$iv$iv$iv;
                                        $i$a$-withValidClientOrSessionProxy-CompileServiceImplBase$doCompile$1$1$iv$iv = false;
                                        rpcProfiler$iv$iv = $this$doCompile_u24lambda_u240$iv$iv.getDaemonOptions().getReportPerf() != false ? (Profiler)new WallAndThreadTotalProfiler() : (Profiler)new DummyProfiler();
                                        eventManager$iv$iv = new EventManagerImpl();
                                        try {
                                            CompileServiceImplBase.access$getLog((CompileServiceImplBase)$this$doCompile_u24lambda_u240$iv$iv).fine("trying get exitCode");
                                            var58_122 = $this$doCompile_u24lambda_u240$iv$iv;
                                            var59_127 = daemonMessageReporter$iv$iv;
                                            rpcProfiler$iv$iv$iv = rpcProfiler$iv$iv;
                                            $i$f$checkedCompile = false;
                                            try {
                                                var63_148 = profiler$iv$iv$iv = this_$iv$iv$iv.getDaemonOptions().getReportPerf() != false ? (Profiler)new WallAndThreadAndMemoryTotalProfiler(false) : (Profiler)new DummyProfiler();
                                                obj$iv$iv$iv$iv = null;
                                                $i$f$withMeasure = false;
                                                startState$iv$iv$iv$iv = $this$withMeasure$iv$iv$iv$iv.beginMeasure(obj$iv$iv$iv$iv);
                                                $i$a$-checkedCompile-CompileServiceImplBase$doCompile$1$1$exitCode$1$iv$iv = false;
                                                var68_169 = rpcProfiler$iv$iv;
                                                eventManger$iv = eventManager$iv$iv;
                                                $i$a$-doCompile-CompileServiceImplBase$compileImpl$1$1$1$iv = false;
                                                $i$a$-compileImpl-CompileServiceImpl$compile$1$3 = profiler$iv;
                                                $i$a$-compileImpl-CompileServiceImpl$compile$1$1 = eventManger$iv;
                                                p0 /* !! */  = (CompilerCallbackServicesFacade)servicesFacade$iv;
                                                $i$a$-compileImpl-CompileServiceImpl$compile$1$4 = false;
                                                services$iv = this.createCompileServices(p0 /* !! */ , (EventManager)p1, (Profiler)p2);
                                                exitCode$iv = compiler$iv.exec(messageCollector$iv, services$iv, k2PlatformArgs$iv);
                                                it$iv = var74_197 = compilationResults$iv;
                                                $i$a$-also-CompileServiceImplBase$compileImpl$1$1$1$1$iv = false;
                                                Intrinsics.checkNotNull((Object)it$iv, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.daemon.common.CompilationResults");
                                                compilationResult$iv = it$iv;
                                                $this$forEach$iv$iv = CompileServiceImplBase.access$getPerformanceMetrics((CompileServiceImplBase)this_$iv, compiler$iv);
                                                $i$f$forEach = false;
                                                for (T element$iv$iv : $this$forEach$iv$iv) {
                                                    it$iv = (BuildMetricsValue)element$iv$iv;
                                                    $i$a$-forEach-CompileServiceImplBase$compileImpl$1$1$1$1$1$iv = false;
                                                    compilationResult$iv.add(CompilationResultCategory.BUILD_METRICS.getCode(), it$iv);
                                                }
                                                res$iv$iv$iv$iv = exitCode$iv.getCode();
                                                $this$withMeasure$iv$iv$iv$iv.endMeasure(obj$iv$iv$iv$iv, startState$iv$iv$iv$iv);
                                                res$iv$iv$iv = res$iv$iv$iv$iv;
                                                if (this_$iv$iv$iv.getDaemonOptions().getReportPerf()) {
                                                    withGC$iv$iv$iv$iv = false;
                                                    $i$f$usedMemory = false;
                                                    rt$iv$iv$iv$iv = Runtime.getRuntime();
                                                    v8 = rt$iv$iv$iv$iv.totalMemory() - rt$iv$iv$iv$iv.freeMemory();
                                                } else {
                                                    v8 = 0L;
                                                }
                                                endMem$iv$iv$iv = v8;
                                                CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv$iv).info("Done with result " + res$iv$iv$iv);
                                                if (this_$iv$iv$iv.getDaemonOptions().getReportPerf()) {
                                                    pc$iv$iv$iv = profiler$iv$iv$iv.getTotalCounters();
                                                    rpc$iv$iv$iv = rpcProfiler$iv$iv$iv.getTotalCounters();
                                                    v9 = new StringBuilder().append("PERF: Compile on daemon: ").append(this_$iv$iv$iv.ms(pc$iv$iv$iv.getTime())).append(" ms; thread: user ").append(this_$iv$iv$iv.ms(pc$iv$iv$iv.getThreadUserTime())).append(" ms, sys ").append(this_$iv$iv$iv.ms(pc$iv$iv$iv.getThreadTime() - pc$iv$iv$iv.getThreadUserTime())).append(" ms; rpc: ").append(rpc$iv$iv$iv.getCount()).append(" calls, ").append(this_$iv$iv$iv.ms(rpc$iv$iv$iv.getTime())).append(" ms, thread ").append(this_$iv$iv$iv.ms(rpc$iv$iv$iv.getThreadTime())).append(" ms; memory: ").append(this_$iv$iv$iv.kb(endMem$iv$iv$iv)).append(" kb (");
                                                    var84_240 = "%+d";
                                                    var88_249 = new Object[]{this_$iv$iv$iv.kb(pc$iv$iv$iv.getMemory())};
                                                    v10 = String.format(var84_240, Arrays.copyOf(var88_249, ((Object[])var88_249).length));
                                                    Intrinsics.checkNotNullExpressionValue((Object)v10, (String)"format(...)");
                                                    it$iv$iv$iv = v9.append(v10).append(" kb)").toString();
                                                    $i$a$-let-CompileServiceImplBase$checkedCompile$1$iv$iv$iv = false;
                                                    daemonMessageReporter$iv$iv$iv.report(ReportSeverity.INFO, it$iv$iv$iv);
                                                    CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv$iv).info(it$iv$iv$iv);
                                                    for (Object var88_249 : rpcProfiler$iv$iv$iv.getCounters().entrySet()) {
                                                        obj$iv$iv$iv = var88_249.getKey();
                                                        counters$iv$iv$iv = (PerfCounters)var88_249.getValue();
                                                        it$iv$iv$iv = "PERF: rpc by " + obj$iv$iv$iv + ": " + counters$iv$iv$iv.getCount() + " calls, " + this_$iv$iv$iv.ms(counters$iv$iv$iv.getTime()) + " ms, thread " + this_$iv$iv$iv.ms(counters$iv$iv$iv.getThreadTime()) + " ms";
                                                        $i$a$-let-CompileServiceImplBase$checkedCompile$2$iv$iv$iv = false;
                                                        daemonMessageReporter$iv$iv$iv.report(ReportSeverity.INFO, it$iv$iv$iv);
                                                        CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv$iv).info(it$iv$iv$iv);
                                                    }
                                                }
                                                v11 = res$iv$iv$iv;
                                            }
                                            catch (Throwable e$iv$iv$iv) {
                                                v12 = CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv$iv);
                                                v13 = new StringBuilder().append("Exception: ").append(e$iv$iv$iv).append("\n  ");
                                                v14 = e$iv$iv$iv.getStackTrace();
                                                Intrinsics.checkNotNullExpressionValue((Object)v14, (String)"getStackTrace(...)");
                                                v15 = v13.append(ArraysKt.joinToString$default((Object[])v14, (CharSequence)"\n  ", null, null, (int)0, null, null, (int)62, null));
                                                if (e$iv$iv$iv.getCause() != null && !Intrinsics.areEqual((Object)e$iv$iv$iv.getCause(), (Object)e$iv$iv$iv)) {
                                                    v16 = new StringBuilder().append("\nCaused by: ").append(e$iv$iv$iv.getCause()).append("\n  ");
                                                    v17 = e$iv$iv$iv.getCause();
                                                    Intrinsics.checkNotNull((Object)v17);
                                                    v18 = v17.getStackTrace();
                                                    Intrinsics.checkNotNullExpressionValue((Object)v18, (String)"getStackTrace(...)");
                                                    v19 = v16.append(ArraysKt.joinToString$default((Object[])v18, (CharSequence)"\n  ", null, null, (int)0, null, null, (int)62, null)).toString();
                                                } else {
                                                    v19 = "";
                                                }
                                                v12.log(Level.SEVERE, v15.append(v19).toString());
                                                throw e$iv$iv$iv;
                                            }
                                            exitCode$iv$iv = ((Number)v11).intValue();
                                            var93_256 = new CompileService.CallResult.Good<Integer>(exitCode$iv$iv);
                                        }
                                        finally {
                                            eventManager$iv$iv.fireCompilationFinished();
                                        }
                                        var30_37 = var93_256;
                                        v7 = var30_37;
                                    }
                                    finally {
                                        CompileServiceImplBase.access$set_lastUsedSeconds((CompileServiceImplBase)this_$iv$iv$iv, CompileServiceImplKt.nowSeconds());
                                    }
lbl232:
                                    // 2 sources

                                    var31_40 = v7;
                                    v5 = var31_40;
                                    break;
                                }
                                finally {
                                    IncrementalCompilation.setIsEnabledForJvm((boolean)isEnabledBackup$iv$iv);
                                }
                            }
                            case 2: {
                                args$iv$iv = this_$iv;
                                enabled$iv$iv = sessionId$iv;
                                $i$f$withIncrementalCompilation = daemonReporter$iv;
                                tracer$iv$iv = null;
                                $i$f$doCompile = false;
                                $this$doCompile_u24lambda_u240$iv$iv = this_$iv$iv;
                                $i$a$-run-CompileServiceImplBase$doCompile$1$iv$iv = false;
                                CompileServiceImplBase.access$getLog((CompileServiceImplBase)$this$doCompile_u24lambda_u240$iv$iv).fine("alive!");
                                daemonMessageReporter$iv$iv = $this$doCompile_u24lambda_u240$iv$iv;
                                sessionId$iv$iv$iv = sessionId$iv$iv;
                                $i$f$withValidClientOrSessionProxy = false;
                                if (sessionId$iv$iv$iv == false) {
                                    v20 = null;
                                } else {
                                    v20 = CompileServiceImplBase.access$getState((CompileServiceImplBase)this_$iv$iv$iv).getSessions().get((int)sessionId$iv$iv$iv);
                                    if (v20 == null) {
                                        v5 = new CompileService.CallResult.Error("Unknown or invalid session " + (int)sessionId$iv$iv$iv);
                                        break;
                                    }
                                }
                                session$iv$iv$iv = v20;
                                try {
                                    CompileServiceImplBase.access$getCompilationsCounter((CompileServiceImplBase)this_$iv$iv$iv).incrementAndGet();
                                    it$iv$iv = session$iv$iv$iv;
                                    $i$a$-withValidClientOrSessionProxy-CompileServiceImplBase$doCompile$1$1$iv$iv = false;
                                    rpcProfiler$iv$iv = $this$doCompile_u24lambda_u240$iv$iv.getDaemonOptions().getReportPerf() != false ? (Profiler)new WallAndThreadTotalProfiler() : (Profiler)new DummyProfiler();
                                    eventManager$iv$iv = new EventManagerImpl();
                                    try {
                                        CompileServiceImplBase.access$getLog((CompileServiceImplBase)$this$doCompile_u24lambda_u240$iv$iv).fine("trying get exitCode");
                                        session$iv$iv$iv = $this$doCompile_u24lambda_u240$iv$iv;
                                        it$iv$iv = daemonMessageReporter$iv$iv;
                                        rpcProfiler$iv$iv$iv = rpcProfiler$iv$iv;
                                        $i$f$checkedCompile = false;
                                        try {
                                            this_$iv$iv$iv = profiler$iv$iv$iv = this_$iv$iv$iv.getDaemonOptions().getReportPerf() != false ? (Profiler)new WallAndThreadAndMemoryTotalProfiler(false) : (Profiler)new DummyProfiler();
                                            obj$iv$iv$iv$iv = null;
                                            $i$f$withMeasure = false;
                                            startState$iv$iv$iv$iv = $this$withMeasure$iv$iv$iv$iv.beginMeasure(obj$iv$iv$iv$iv);
                                            $i$a$-checkedCompile-CompileServiceImplBase$doCompile$1$1$exitCode$1$iv$iv = false;
                                            (EventManager)eventManager$iv$iv;
                                            $i$a$-doCompile-CompileServiceImplBase$compileImpl$1$2$iv = false;
                                            exitCode$iv = compiler$iv.exec(messageCollector$iv, Services.EMPTY, k2PlatformArgs$iv);
                                            perfString$iv = compiler$iv.getDefaultPerformanceManager().createPerformanceReport(PerformanceManager.DumpFormat.PlainText);
                                            v21 = compilationResults$iv;
                                            if (v21 != null) {
                                                it$iv = profiler$iv = v21;
                                                $i$a$-also-CompileServiceImplBase$compileImpl$1$2$1$iv = false;
                                                Intrinsics.checkNotNull((Object)it$iv, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.daemon.common.CompilationResults");
                                                services$iv = new String[]{perfString$iv};
                                                it$iv.add(CompilationResultCategory.BUILD_REPORT_LINES.getCode(), CollectionsKt.arrayListOf((Object[])services$iv));
                                                v22 = profiler$iv;
                                            } else {
                                                v22 = null;
                                            }
                                            res$iv$iv$iv$iv = exitCode$iv.getCode();
                                            $this$withMeasure$iv$iv$iv$iv.endMeasure(obj$iv$iv$iv$iv, startState$iv$iv$iv$iv);
                                            res$iv$iv$iv = res$iv$iv$iv$iv;
                                            if (this_$iv$iv$iv.getDaemonOptions().getReportPerf()) {
                                                withGC$iv$iv$iv$iv = false;
                                                $i$f$usedMemory = false;
                                                rt$iv$iv$iv$iv = Runtime.getRuntime();
                                                v23 = rt$iv$iv$iv$iv.totalMemory() - rt$iv$iv$iv$iv.freeMemory();
                                            } else {
                                                v23 = 0L;
                                            }
                                            endMem$iv$iv$iv = v23;
                                            CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv$iv).info("Done with result " + res$iv$iv$iv);
                                            if (this_$iv$iv$iv.getDaemonOptions().getReportPerf()) {
                                                pc$iv$iv$iv = profiler$iv$iv$iv.getTotalCounters();
                                                rpc$iv$iv$iv = rpcProfiler$iv$iv$iv.getTotalCounters();
                                                v24 = new StringBuilder().append("PERF: Compile on daemon: ").append(this_$iv$iv$iv.ms(pc$iv$iv$iv.getTime())).append(" ms; thread: user ").append(this_$iv$iv$iv.ms(pc$iv$iv$iv.getThreadUserTime())).append(" ms, sys ").append(this_$iv$iv$iv.ms(pc$iv$iv$iv.getThreadTime() - pc$iv$iv$iv.getThreadUserTime())).append(" ms; rpc: ").append(rpc$iv$iv$iv.getCount()).append(" calls, ").append(this_$iv$iv$iv.ms(rpc$iv$iv$iv.getTime())).append(" ms, thread ").append(this_$iv$iv$iv.ms(rpc$iv$iv$iv.getThreadTime())).append(" ms; memory: ").append(this_$iv$iv$iv.kb(endMem$iv$iv$iv)).append(" kb (");
                                                rt$iv$iv$iv$iv = "%+d";
                                                compilationResult$iv = new Object[]{this_$iv$iv$iv.kb(pc$iv$iv$iv.getMemory())};
                                                v25 = String.format((String)rt$iv$iv$iv$iv, Arrays.copyOf(compilationResult$iv, compilationResult$iv.length));
                                                Intrinsics.checkNotNullExpressionValue((Object)v25, (String)"format(...)");
                                                it$iv$iv$iv = v24.append(v25).append(" kb)").toString();
                                                $i$a$-let-CompileServiceImplBase$checkedCompile$1$iv$iv$iv = false;
                                                daemonMessageReporter$iv$iv$iv.report(ReportSeverity.INFO, it$iv$iv$iv);
                                                CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv$iv).info(it$iv$iv$iv);
                                                for (Map.Entry<Object, PerfCounters> var77_209 : rpcProfiler$iv$iv$iv.getCounters().entrySet()) {
                                                    obj$iv$iv$iv = var77_209.getKey();
                                                    counters$iv$iv$iv = var77_209.getValue();
                                                    it$iv$iv$iv = "PERF: rpc by " + obj$iv$iv$iv + ": " + counters$iv$iv$iv.getCount() + " calls, " + this_$iv$iv$iv.ms(counters$iv$iv$iv.getTime()) + " ms, thread " + this_$iv$iv$iv.ms(counters$iv$iv$iv.getThreadTime()) + " ms";
                                                    $i$a$-let-CompileServiceImplBase$checkedCompile$2$iv$iv$iv = false;
                                                    daemonMessageReporter$iv$iv$iv.report(ReportSeverity.INFO, it$iv$iv$iv);
                                                    CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv$iv).info(it$iv$iv$iv);
                                                }
                                            }
                                            v26 = res$iv$iv$iv;
                                        }
                                        catch (Throwable e$iv$iv$iv) {
                                            v27 = CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv$iv);
                                            v28 = new StringBuilder().append("Exception: ").append(e$iv$iv$iv).append("\n  ");
                                            v29 = e$iv$iv$iv.getStackTrace();
                                            Intrinsics.checkNotNullExpressionValue((Object)v29, (String)"getStackTrace(...)");
                                            v30 = v28.append(ArraysKt.joinToString$default((Object[])v29, (CharSequence)"\n  ", null, null, (int)0, null, null, (int)62, null));
                                            if (e$iv$iv$iv.getCause() != null && !Intrinsics.areEqual((Object)e$iv$iv$iv.getCause(), (Object)e$iv$iv$iv)) {
                                                v31 = new StringBuilder().append("\nCaused by: ").append(e$iv$iv$iv.getCause()).append("\n  ");
                                                v32 = e$iv$iv$iv.getCause();
                                                Intrinsics.checkNotNull((Object)v32);
                                                v33 = v32.getStackTrace();
                                                Intrinsics.checkNotNullExpressionValue((Object)v33, (String)"getStackTrace(...)");
                                                v34 = v31.append(ArraysKt.joinToString$default((Object[])v33, (CharSequence)"\n  ", null, null, (int)0, null, null, (int)62, null)).toString();
                                            } else {
                                                v34 = "";
                                            }
                                            v27.log(Level.SEVERE, v30.append(v34).toString());
                                            throw e$iv$iv$iv;
                                        }
                                        exitCode$iv$iv = ((Number)v26).intValue();
                                        exitCode$iv$iv = new CompileService.CallResult.Good<Integer>(exitCode$iv$iv);
                                    }
                                    finally {
                                        eventManager$iv$iv.fireCompilationFinished();
                                    }
                                    $i$a$-forEach-CompileServiceImplBase$compileImpl$1$1$1$1$1$iv = exitCode$iv$iv;
                                    v5 = $i$a$-forEach-CompileServiceImplBase$compileImpl$1$1$1$1$1$iv;
                                    break;
                                }
                                finally {
                                    CompileServiceImplBase.access$set_lastUsedSeconds((CompileServiceImplBase)this_$iv$iv$iv, CompileServiceImplKt.nowSeconds());
                                }
                            }
                            case 3: {
                                gradleIncrementalArgs$iv = (IncrementalCompilationOptions)compilationOptions$iv;
                                gradleIncrementalServicesFacade$iv = servicesFacade$iv;
                                switch (CompileServiceImplBase.WhenMappings.$EnumSwitchMapping$1[targetPlatform$iv.ordinal()]) {
                                    case 1: {
                                        args$iv$iv = k2PlatformArgs$iv;
                                        enabled$iv$iv = true;
                                        $i$f$withIncrementalCompilation = false;
                                        isEnabledBackup$iv$iv = IncrementalCompilation.isEnabledForJvm();
                                        IncrementalCompilation.setIsEnabledForJvm((boolean)enabled$iv$iv);
                                        try {
                                            if (args$iv$iv.getIncrementalCompilation() == null) {
                                                args$iv$iv.setIncrementalCompilation(Boolean.valueOf(enabled$iv$iv));
                                            }
                                            $i$a$-withIncrementalCompilation$default-CompileServiceImplBase$compileImpl$1$3$iv = false;
                                            $i$f$withValidClientOrSessionProxy = this_$iv;
                                            session$iv$iv$iv = sessionId$iv;
                                            it$iv$iv = daemonReporter$iv;
                                            tracer$iv$iv = null;
                                            $i$f$doCompile = false;
                                            $this$doCompile_u24lambda_u240$iv$iv = this_$iv$iv;
                                            $i$a$-run-CompileServiceImplBase$doCompile$1$iv$iv = false;
                                            CompileServiceImplBase.access$getLog((CompileServiceImplBase)$this$doCompile_u24lambda_u240$iv$iv).fine("alive!");
                                            daemonMessageReporter$iv$iv$iv = $this$doCompile_u24lambda_u240$iv$iv;
                                            sessionId$iv$iv$iv = sessionId$iv$iv;
                                            $i$f$withValidClientOrSessionProxy = false;
                                            if (sessionId$iv$iv$iv != false) ** GOTO lbl395
                                            v35 = null;
                                            ** GOTO lbl399
lbl395:
                                            // 1 sources

                                            v35 = CompileServiceImplBase.access$getState((CompileServiceImplBase)this_$iv$iv$iv).getSessions().get((int)sessionId$iv$iv$iv);
                                            if (v35 != null) ** GOTO lbl399
                                            v36 = new CompileService.CallResult.Error("Unknown or invalid session " + (int)sessionId$iv$iv$iv);
                                            ** GOTO lbl511
lbl399:
                                            // 2 sources

                                            session$iv$iv$iv = v35;
                                            try {
                                                CompileServiceImplBase.access$getCompilationsCounter((CompileServiceImplBase)this_$iv$iv$iv).incrementAndGet();
                                                it$iv$iv = session$iv$iv$iv;
                                                $i$a$-withValidClientOrSessionProxy-CompileServiceImplBase$doCompile$1$1$iv$iv = false;
                                                rpcProfiler$iv$iv = $this$doCompile_u24lambda_u240$iv$iv.getDaemonOptions().getReportPerf() != false ? (Profiler)new WallAndThreadTotalProfiler() : (Profiler)new DummyProfiler();
                                                eventManager$iv$iv = new EventManagerImpl();
                                                try {
                                                    CompileServiceImplBase.access$getLog((CompileServiceImplBase)$this$doCompile_u24lambda_u240$iv$iv).fine("trying get exitCode");
                                                    $i$a$-checkedCompile-CompileServiceImplBase$doCompile$1$1$exitCode$1$iv$iv = $this$doCompile_u24lambda_u240$iv$iv;
                                                    $this$withMeasure$iv$iv$iv$iv = daemonMessageReporter$iv$iv;
                                                    rpcProfiler$iv$iv$iv = rpcProfiler$iv$iv;
                                                    $i$f$checkedCompile = false;
                                                    try {
                                                        perfString$iv = profiler$iv$iv$iv = this_$iv$iv$iv.getDaemonOptions().getReportPerf() != false ? (Profiler)new WallAndThreadAndMemoryTotalProfiler(false) : (Profiler)new DummyProfiler();
                                                        obj$iv$iv$iv$iv = null;
                                                        $i$f$withMeasure = false;
                                                        startState$iv$iv$iv$iv = $this$withMeasure$iv$iv$iv$iv.beginMeasure(obj$iv$iv$iv$iv);
                                                        $i$a$-checkedCompile-CompileServiceImplBase$doCompile$1$1$exitCode$1$iv$iv = false;
                                                        (EventManager)eventManager$iv$iv;
                                                        $i$a$-doCompile-CompileServiceImplBase$compileImpl$1$3$1$iv = false;
                                                        Intrinsics.checkNotNull((Object)k2PlatformArgs$iv, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.cli.common.arguments.K2JVMCompilerArguments");
                                                        v37 = (K2JVMCompilerArguments)k2PlatformArgs$iv;
                                                        v38 = compilationResults$iv;
                                                        Intrinsics.checkNotNull((Object)v38);
                                                        var96_258 /* !! */  = gradleIncrementalArgs$iv;
                                                        var97_260 = v38;
                                                        var98_261 = gradleIncrementalServicesFacade$iv;
                                                        var99_262 = messageCollector$iv;
                                                        var100_264 = gradleIncrementalArgs$iv;
                                                        var101_266 = v37;
                                                        var102_268 = this_$iv;
                                                        $i$a$-compileImpl-CompileServiceImpl$compile$1$5 = false;
                                                        v39 = b;
                                                        Intrinsics.checkNotNull((Object)v39);
                                                        var104_273 = GetICReporterKt.getBuildReporter((CompilerServicesFacadeBase)a, (CompilationResults)v39, (IncrementalCompilationOptions)c);
                                                        res$iv$iv$iv$iv = CompileServiceImplBase.access$execIncrementalCompiler((CompileServiceImplBase)var102_268, var101_266, var100_264, var99_262, var104_273).getCode();
                                                        $this$withMeasure$iv$iv$iv$iv.endMeasure(obj$iv$iv$iv$iv, startState$iv$iv$iv$iv);
                                                        res$iv$iv$iv = res$iv$iv$iv$iv;
                                                        if (this_$iv$iv$iv.getDaemonOptions().getReportPerf()) {
                                                            withGC$iv$iv$iv$iv = false;
                                                            $i$f$usedMemory = false;
                                                            rt$iv$iv$iv$iv = Runtime.getRuntime();
                                                            v40 = rt$iv$iv$iv$iv.totalMemory() - rt$iv$iv$iv$iv.freeMemory();
                                                        } else {
                                                            v40 = 0L;
                                                        }
                                                        endMem$iv$iv$iv = v40;
                                                        CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv$iv).info("Done with result " + res$iv$iv$iv);
                                                        if (this_$iv$iv$iv.getDaemonOptions().getReportPerf()) {
                                                            pc$iv$iv$iv = profiler$iv$iv$iv.getTotalCounters();
                                                            rpc$iv$iv$iv = rpcProfiler$iv$iv$iv.getTotalCounters();
                                                            v41 = new StringBuilder().append("PERF: Compile on daemon: ").append(this_$iv$iv$iv.ms(pc$iv$iv$iv.getTime())).append(" ms; thread: user ").append(this_$iv$iv$iv.ms(pc$iv$iv$iv.getThreadUserTime())).append(" ms, sys ").append(this_$iv$iv$iv.ms(pc$iv$iv$iv.getThreadTime() - pc$iv$iv$iv.getThreadUserTime())).append(" ms; rpc: ").append(rpc$iv$iv$iv.getCount()).append(" calls, ").append(this_$iv$iv$iv.ms(rpc$iv$iv$iv.getTime())).append(" ms, thread ").append(this_$iv$iv$iv.ms(rpc$iv$iv$iv.getThreadTime())).append(" ms; memory: ").append(this_$iv$iv$iv.kb(endMem$iv$iv$iv)).append(" kb (");
                                                            rt$iv$iv$iv$iv = "%+d";
                                                            obj$iv$iv$iv = new Object[]{this_$iv$iv$iv.kb(pc$iv$iv$iv.getMemory())};
                                                            v42 = String.format((String)rt$iv$iv$iv$iv, Arrays.copyOf(obj$iv$iv$iv, obj$iv$iv$iv.length));
                                                            Intrinsics.checkNotNullExpressionValue((Object)v42, (String)"format(...)");
                                                            it$iv$iv$iv = v41.append(v42).append(" kb)").toString();
                                                            $i$a$-let-CompileServiceImplBase$checkedCompile$1$iv$iv$iv = false;
                                                            daemonMessageReporter$iv$iv$iv.report(ReportSeverity.INFO, (String)it$iv$iv$iv);
                                                            CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv$iv).info((String)it$iv$iv$iv);
                                                            for (Object it$iv$iv$iv : rpcProfiler$iv$iv$iv.getCounters().entrySet()) {
                                                                obj$iv$iv$iv = it$iv$iv$iv.getKey();
                                                                counters$iv$iv$iv = (PerfCounters)it$iv$iv$iv.getValue();
                                                                it$iv$iv$iv = "PERF: rpc by " + obj$iv$iv$iv + ": " + counters$iv$iv$iv.getCount() + " calls, " + this_$iv$iv$iv.ms(counters$iv$iv$iv.getTime()) + " ms, thread " + this_$iv$iv$iv.ms(counters$iv$iv$iv.getThreadTime()) + " ms";
                                                                $i$a$-let-CompileServiceImplBase$checkedCompile$2$iv$iv$iv = false;
                                                                daemonMessageReporter$iv$iv$iv.report(ReportSeverity.INFO, it$iv$iv$iv);
                                                                CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv$iv).info(it$iv$iv$iv);
                                                            }
                                                        }
                                                        v43 = res$iv$iv$iv;
                                                    }
                                                    catch (Throwable e$iv$iv$iv) {
                                                        v44 = CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv$iv);
                                                        v45 = new StringBuilder().append("Exception: ").append(e$iv$iv$iv).append("\n  ");
                                                        v46 = e$iv$iv$iv.getStackTrace();
                                                        Intrinsics.checkNotNullExpressionValue((Object)v46, (String)"getStackTrace(...)");
                                                        v47 = v45.append(ArraysKt.joinToString$default((Object[])v46, (CharSequence)"\n  ", null, null, (int)0, null, null, (int)62, null));
                                                        if (e$iv$iv$iv.getCause() != null && !Intrinsics.areEqual((Object)e$iv$iv$iv.getCause(), (Object)e$iv$iv$iv)) {
                                                            v48 = new StringBuilder().append("\nCaused by: ").append(e$iv$iv$iv.getCause()).append("\n  ");
                                                            v49 = e$iv$iv$iv.getCause();
                                                            Intrinsics.checkNotNull((Object)v49);
                                                            v50 = v49.getStackTrace();
                                                            Intrinsics.checkNotNullExpressionValue((Object)v50, (String)"getStackTrace(...)");
                                                            v51 = v48.append(ArraysKt.joinToString$default((Object[])v50, (CharSequence)"\n  ", null, null, (int)0, null, null, (int)62, null)).toString();
                                                        } else {
                                                            v51 = "";
                                                        }
                                                        v44.log(Level.SEVERE, v47.append(v51).toString());
                                                        throw e$iv$iv$iv;
                                                    }
                                                    exitCode$iv$iv = ((Number)v43).intValue();
                                                    exitCode$iv$iv = new CompileService.CallResult.Good<Integer>(exitCode$iv$iv);
                                                }
                                                finally {
                                                    eventManager$iv$iv.fireCompilationFinished();
                                                }
                                                var84_242 = exitCode$iv$iv;
                                                v36 = var84_242;
                                            }
                                            finally {
                                                CompileServiceImplBase.access$set_lastUsedSeconds((CompileServiceImplBase)this_$iv$iv$iv, CompileServiceImplKt.nowSeconds());
                                            }
lbl511:
                                            // 2 sources

                                            var96_258 /* !! */  = v36;
                                            v5 = var96_258 /* !! */ ;
                                            break block22;
                                        }
                                        finally {
                                            IncrementalCompilation.setIsEnabledForJvm((boolean)isEnabledBackup$iv$iv);
                                        }
                                    }
                                    case 2: {
                                        args$iv$iv = k2PlatformArgs$iv;
                                        enabled$iv$iv = true;
                                        $i$f$withJsIC = false;
                                        isJsEnabledBackup$iv$iv = IncrementalCompilation.isEnabledForJs();
                                        IncrementalCompilation.setIsEnabledForJs((boolean)true);
                                        try {
                                            if (args$iv$iv.getIncrementalCompilation() == null) {
                                                args$iv$iv.setIncrementalCompilation(Boolean.valueOf(enabled$iv$iv));
                                            }
                                            $i$a$-withJsIC$default-CompileServiceImplBase$compileImpl$1$4$iv = false;
                                            this_$iv$iv = this_$iv;
                                            sessionId$iv$iv = sessionId$iv;
                                            daemonMessageReporter$iv$iv = daemonReporter$iv;
                                            tracer$iv$iv = null;
                                            $i$f$doCompile = false;
                                            $this$doCompile_u24lambda_u240$iv$iv = this_$iv$iv;
                                            $i$a$-run-CompileServiceImplBase$doCompile$1$iv$iv = false;
                                            CompileServiceImplBase.access$getLog((CompileServiceImplBase)$this$doCompile_u24lambda_u240$iv$iv).fine("alive!");
                                            this_$iv$iv$iv = $this$doCompile_u24lambda_u240$iv$iv;
                                            sessionId$iv$iv$iv = sessionId$iv$iv;
                                            $i$f$withValidClientOrSessionProxy = false;
                                            if (sessionId$iv$iv$iv != false) ** GOTO lbl542
                                            v52 = null;
                                            ** GOTO lbl546
lbl542:
                                            // 1 sources

                                            v52 = CompileServiceImplBase.access$getState((CompileServiceImplBase)this_$iv$iv$iv).getSessions().get((int)sessionId$iv$iv$iv);
                                            if (v52 != null) ** GOTO lbl546
                                            v53 = new CompileService.CallResult.Error("Unknown or invalid session " + (int)sessionId$iv$iv$iv);
                                            ** GOTO lbl658
lbl546:
                                            // 2 sources

                                            session$iv$iv$iv = v52;
                                            try {
                                                CompileServiceImplBase.access$getCompilationsCounter((CompileServiceImplBase)this_$iv$iv$iv).incrementAndGet();
                                                it$iv$iv = session$iv$iv$iv;
                                                $i$a$-withValidClientOrSessionProxy-CompileServiceImplBase$doCompile$1$1$iv$iv = false;
                                                rpcProfiler$iv$iv = $this$doCompile_u24lambda_u240$iv$iv.getDaemonOptions().getReportPerf() != false ? (Profiler)new WallAndThreadTotalProfiler() : (Profiler)new DummyProfiler();
                                                eventManager$iv$iv = new EventManagerImpl();
                                                try {
                                                    CompileServiceImplBase.access$getLog((CompileServiceImplBase)$this$doCompile_u24lambda_u240$iv$iv).fine("trying get exitCode");
                                                    this_$iv$iv$iv = $this$doCompile_u24lambda_u240$iv$iv;
                                                    daemonMessageReporter$iv$iv$iv = daemonMessageReporter$iv$iv;
                                                    rpcProfiler$iv$iv$iv = rpcProfiler$iv$iv;
                                                    $i$f$checkedCompile = false;
                                                    try {
                                                        $this$withMeasure$iv$iv$iv$iv = profiler$iv$iv$iv = this_$iv$iv$iv.getDaemonOptions().getReportPerf() != false ? (Profiler)new WallAndThreadAndMemoryTotalProfiler(false) : (Profiler)new DummyProfiler();
                                                        obj$iv$iv$iv$iv = null;
                                                        $i$f$withMeasure = false;
                                                        startState$iv$iv$iv$iv = $this$withMeasure$iv$iv$iv$iv.beginMeasure(obj$iv$iv$iv$iv);
                                                        $i$a$-checkedCompile-CompileServiceImplBase$doCompile$1$1$exitCode$1$iv$iv = false;
                                                        (EventManager)eventManager$iv$iv;
                                                        $i$a$-doCompile-CompileServiceImplBase$compileImpl$1$4$1$iv = false;
                                                        Intrinsics.checkNotNull((Object)k2PlatformArgs$iv, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.cli.common.arguments.K2JSCompilerArguments");
                                                        v54 = (K2JSCompilerArguments)k2PlatformArgs$iv;
                                                        v55 = compilationResults$iv;
                                                        Intrinsics.checkNotNull((Object)v55);
                                                        var107_277 = gradleIncrementalArgs$iv;
                                                        var108_278 = v55;
                                                        var109_279 = gradleIncrementalServicesFacade$iv;
                                                        var99_263 = messageCollector$iv;
                                                        var100_265 = gradleIncrementalArgs$iv;
                                                        var101_267 = v54;
                                                        var102_269 = this_$iv;
                                                        $i$a$-compileImpl-CompileServiceImpl$compile$1$5 = false;
                                                        v56 = b;
                                                        Intrinsics.checkNotNull((Object)v56);
                                                        var104_274 = GetICReporterKt.getBuildReporter((CompilerServicesFacadeBase)a, (CompilationResults)v56, (IncrementalCompilationOptions)c);
                                                        res$iv$iv$iv$iv = CompileServiceImplBase.access$execJsIncrementalCompiler((CompileServiceImplBase)var102_269, var101_267, var100_265, var99_263, var104_274).getCode();
                                                        $this$withMeasure$iv$iv$iv$iv.endMeasure(obj$iv$iv$iv$iv, startState$iv$iv$iv$iv);
                                                        res$iv$iv$iv = res$iv$iv$iv$iv;
                                                        if (this_$iv$iv$iv.getDaemonOptions().getReportPerf()) {
                                                            withGC$iv$iv$iv$iv = false;
                                                            $i$f$usedMemory = false;
                                                            rt$iv$iv$iv$iv = Runtime.getRuntime();
                                                            v57 = rt$iv$iv$iv$iv.totalMemory() - rt$iv$iv$iv$iv.freeMemory();
                                                        } else {
                                                            v57 = 0L;
                                                        }
                                                        endMem$iv$iv$iv = v57;
                                                        CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv$iv).info("Done with result " + res$iv$iv$iv);
                                                        if (this_$iv$iv$iv.getDaemonOptions().getReportPerf()) {
                                                            pc$iv$iv$iv = profiler$iv$iv$iv.getTotalCounters();
                                                            rpc$iv$iv$iv = rpcProfiler$iv$iv$iv.getTotalCounters();
                                                            v58 = new StringBuilder().append("PERF: Compile on daemon: ").append(this_$iv$iv$iv.ms(pc$iv$iv$iv.getTime())).append(" ms; thread: user ").append(this_$iv$iv$iv.ms(pc$iv$iv$iv.getThreadUserTime())).append(" ms, sys ").append(this_$iv$iv$iv.ms(pc$iv$iv$iv.getThreadTime() - pc$iv$iv$iv.getThreadUserTime())).append(" ms; rpc: ").append(rpc$iv$iv$iv.getCount()).append(" calls, ").append(this_$iv$iv$iv.ms(rpc$iv$iv$iv.getTime())).append(" ms, thread ").append(this_$iv$iv$iv.ms(rpc$iv$iv$iv.getThreadTime())).append(" ms; memory: ").append(this_$iv$iv$iv.kb(endMem$iv$iv$iv)).append(" kb (");
                                                            var74_201 = "%+d";
                                                            it$iv$iv$iv /* !! */  = new Object[]{this_$iv$iv$iv.kb(pc$iv$iv$iv.getMemory())};
                                                            v59 = String.format(var74_201, Arrays.copyOf(it$iv$iv$iv /* !! */ , it$iv$iv$iv /* !! */ .length));
                                                            Intrinsics.checkNotNullExpressionValue((Object)v59, (String)"format(...)");
                                                            it$iv$iv$iv /* !! */  = v58.append(v59).append(" kb)").toString();
                                                            $i$a$-let-CompileServiceImplBase$checkedCompile$1$iv$iv$iv = false;
                                                            daemonMessageReporter$iv$iv$iv.report(ReportSeverity.INFO, (String)it$iv$iv$iv /* !! */ );
                                                            CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv$iv).info((String)it$iv$iv$iv /* !! */ );
                                                            for (Map.Entry var78_214 : rpcProfiler$iv$iv$iv.getCounters().entrySet()) {
                                                                obj$iv$iv$iv = var78_214.getKey();
                                                                counters$iv$iv$iv = (PerfCounters)var78_214.getValue();
                                                                it$iv$iv$iv = "PERF: rpc by " + obj$iv$iv$iv + ": " + counters$iv$iv$iv.getCount() + " calls, " + this_$iv$iv$iv.ms(counters$iv$iv$iv.getTime()) + " ms, thread " + this_$iv$iv$iv.ms(counters$iv$iv$iv.getThreadTime()) + " ms";
                                                                $i$a$-let-CompileServiceImplBase$checkedCompile$2$iv$iv$iv = false;
                                                                daemonMessageReporter$iv$iv$iv.report(ReportSeverity.INFO, it$iv$iv$iv);
                                                                CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv$iv).info(it$iv$iv$iv);
                                                            }
                                                        }
                                                        v60 = res$iv$iv$iv;
                                                    }
                                                    catch (Throwable e$iv$iv$iv) {
                                                        v61 = CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv$iv);
                                                        v62 = new StringBuilder().append("Exception: ").append(e$iv$iv$iv).append("\n  ");
                                                        v63 = e$iv$iv$iv.getStackTrace();
                                                        Intrinsics.checkNotNullExpressionValue((Object)v63, (String)"getStackTrace(...)");
                                                        v64 = v62.append(ArraysKt.joinToString$default((Object[])v63, (CharSequence)"\n  ", null, null, (int)0, null, null, (int)62, null));
                                                        if (e$iv$iv$iv.getCause() != null && !Intrinsics.areEqual((Object)e$iv$iv$iv.getCause(), (Object)e$iv$iv$iv)) {
                                                            v65 = new StringBuilder().append("\nCaused by: ").append(e$iv$iv$iv.getCause()).append("\n  ");
                                                            v66 = e$iv$iv$iv.getCause();
                                                            Intrinsics.checkNotNull((Object)v66);
                                                            v67 = v66.getStackTrace();
                                                            Intrinsics.checkNotNullExpressionValue((Object)v67, (String)"getStackTrace(...)");
                                                            v68 = v65.append(ArraysKt.joinToString$default((Object[])v67, (CharSequence)"\n  ", null, null, (int)0, null, null, (int)62, null)).toString();
                                                        } else {
                                                            v68 = "";
                                                        }
                                                        v61.log(Level.SEVERE, v64.append(v68).toString());
                                                        throw e$iv$iv$iv;
                                                    }
                                                    exitCode$iv$iv = ((Number)v60).intValue();
                                                    var83_239 = new CompileService.CallResult.Good<Integer>(exitCode$iv$iv);
                                                }
                                                finally {
                                                    eventManager$iv$iv.fireCompilationFinished();
                                                }
                                                var84_243 = var83_239;
                                                v53 = var84_243;
                                            }
                                            finally {
                                                CompileServiceImplBase.access$set_lastUsedSeconds((CompileServiceImplBase)this_$iv$iv$iv, CompileServiceImplKt.nowSeconds());
                                            }
lbl658:
                                            // 2 sources

                                            var96_259 = v53;
                                            v5 = var96_259;
                                            break block22;
                                        }
                                        finally {
                                            IncrementalCompilation.setIsEnabledForJs((boolean)isJsEnabledBackup$iv$iv);
                                        }
                                    }
                                }
                                throw new IllegalStateException("Incremental compilation is not supported for target platform: " + targetPlatform$iv);
                            }
                            default: {
                                throw new NoWhenBranchMatchedException();
                            }
                        }
                    }
                    var15_18 = v5;
                }
                catch (Throwable e$iv$iv) {
                    CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv).log(Level.SEVERE, "Exception", e$iv$iv);
                    var15_18 = new CompileService.CallResult.Error(e$iv$iv);
                }
                v3 = var15_18;
            }
            var10_11 = v3;
        }
        finally {
            var9_9.unlock();
        }
        return var10_11;
    }

    @Override
    @NotNull
    public CompileService.CallResult releaseReplSession(int sessionId) {
        return this.releaseCompileSession(sessionId);
    }

    private final Services createCompileServices(CompilerCallbackServicesFacade facade, EventManager eventManager, Profiler rpcProfiler) {
        Services.Builder builder = new Services.Builder();
        if (facade.hasIncrementalCaches()) {
            builder.register(IncrementalCompilationComponents.class, (Object)new RemoteIncrementalCompilationComponentsClient(facade, rpcProfiler));
        }
        if (facade.hasLookupTracker()) {
            builder.register(LookupTracker.class, (Object)new RemoteLookupTrackerClient(facade, eventManager, rpcProfiler));
        }
        if (facade.hasCompilationCanceledStatus()) {
            builder.register(CompilationCanceledStatus.class, (Object)new RemoteCompilationCanceledStatusClient(facade, rpcProfiler));
        }
        if (facade.hasExpectActualTracker()) {
            builder.register(ExpectActualTracker.class, (Object)new RemoteExpectActualTracker(facade, rpcProfiler));
        }
        if (facade.hasInlineConstTracker()) {
            builder.register(InlineConstTracker.class, (Object)new RemoteInlineConstTracker(facade, rpcProfiler));
        }
        if (facade.hasEnumWhenTracker()) {
            builder.register(EnumWhenTracker.class, (Object)new RemoteEnumWhenTracker(facade, rpcProfiler));
        }
        if (facade.hasIncrementalResultsConsumer()) {
            builder.register(IncrementalResultsConsumer.class, (Object)new RemoteIncrementalResultsConsumer(facade, rpcProfiler));
        }
        if (facade.hasIncrementalDataProvider()) {
            builder.register(IncrementalDataProvider.class, (Object)new RemoteIncrementalDataProvider(facade, rpcProfiler));
        }
        return builder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public CompileService.CallResult<Integer> leaseReplSession(@Nullable String aliveFlagPath, @NotNull String[] compilerArguments, @NotNull CompilationOptions compilationOptions, @NotNull CompilerServicesFacadeBase servicesFacade, @NotNull List<? extends File> templateClasspath, @NotNull String templateClassName) {
        CompileService.CallResult callResult;
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)compilerArguments, (String)"compilerArguments");
        Intrinsics.checkNotNullParameter((Object)compilationOptions, (String)"compilationOptions");
        Intrinsics.checkNotNullParameter((Object)servicesFacade, (String)"servicesFacade");
        Intrinsics.checkNotNullParameter(templateClasspath, (String)"templateClasspath");
        Intrinsics.checkNotNullParameter((Object)templateClassName, (String)"templateClassName");
        CompileServiceImpl compileServiceImpl = this;
        CompileServiceImplBase.Aliveness minAliveness$iv = CompileServiceImplBase.Aliveness.Alive;
        boolean $i$f$ifAlive = false;
        ReentrantReadWriteLock.ReadLock readLock = ((CompileServiceImpl)this_$iv).rwlock.readLock();
        readLock.lock();
        try {
            CompileService.CallResult callResult2;
            block14: {
                CompileService.CallResult callResult3;
                void this_$iv$iv;
                block11: {
                    Object object;
                    int curState$iv$iv;
                    CompileServiceImplBase.Aliveness minAliveness$iv$iv;
                    block13: {
                        block12: {
                            boolean bl = false;
                            CompileServiceImplBase compileServiceImplBase = (CompileServiceImplBase)this_$iv;
                            minAliveness$iv$iv = minAliveness$iv;
                            boolean $i$f$ifAliveChecksImpl = false;
                            curState$iv$iv = CompileServiceImplBase.access$getState((CompileServiceImplBase)this_$iv$iv).getAlive().get();
                            if (curState$iv$iv >= minAliveness$iv$iv.ordinal()) break block11;
                            Object[] stackTrace$iv$iv = Thread.currentThread().getStackTrace();
                            int rmiBusinessCallDepth$iv$iv = 1;
                            Intrinsics.checkNotNull((Object)stackTrace$iv$iv);
                            object = (StackTraceElement)ArraysKt.getOrNull((Object[])stackTrace$iv$iv, (int)rmiBusinessCallDepth$iv$iv);
                            if (object == null) break block12;
                            StackTraceElement it$iv$iv = object;
                            boolean bl2 = false;
                            String string = " Operation: " + it$iv$iv;
                            object = string;
                            if (string != null) break block13;
                        }
                        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
                        Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray, (String)"getStackTrace(...)");
                        object = ArraysKt.joinToString$default((Object[])stackTraceElementArray, (CharSequence)"\n at ", (CharSequence)" at ", null, (int)0, null, null, (int)60, null);
                    }
                    Object callSource$iv$iv = object;
                    CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv).info(StringsKt.trimMargin$default((String)("\n                    |Cannot perform operation, requested state: " + minAliveness$iv$iv.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName((CompileServiceImplBase)this_$iv$iv, curState$iv$iv) + "\n                    |" + (String)callSource$iv$iv + "\n                    "), null, (int)1, null));
                    callResult2 = new CompileService.CallResult.Dying();
                    break block14;
                }
                try {
                    CompileService.CallResult callResult4;
                    boolean bl = false;
                    if (compilationOptions.getTargetPlatform() != CompileService.TargetPlatform.JVM) {
                        callResult4 = new CompileService.CallResult.Error("Sorry, only JVM target platform is supported now");
                    } else {
                        Disposable disposable = Disposer.newDisposable((String)("Disposable for " + Reflection.getOrCreateKotlinClass(CompileServiceImpl.class).getSimpleName() + ".leaseReplSession"));
                        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newDisposable(...)");
                        Disposable disposable2 = disposable;
                        CompileServicesFacadeMessageCollector messageCollector = new CompileServicesFacadeMessageCollector(servicesFacade, compilationOptions);
                        KotlinJvmReplService repl = new KotlinJvmReplService(disposable2, this.getPort(), this.getCompilerId(), templateClasspath, templateClassName, messageCollector, null);
                        int sessionId = this.getState().getSessions().leaseSession(new CompileServiceImplBase.ClientOrSessionProxy<KotlinJvmReplService>(aliveFlagPath, repl, disposable2));
                        callResult4 = new CompileService.CallResult.Good<Integer>(sessionId);
                    }
                    callResult3 = callResult4;
                }
                catch (Throwable e$iv$iv) {
                    CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv).log(Level.SEVERE, "Exception", e$iv$iv);
                    callResult3 = new CompileService.CallResult.Error(e$iv$iv);
                }
                callResult2 = callResult3;
            }
            callResult = callResult2;
        }
        finally {
            readLock.unlock();
        }
        return callResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    @NotNull
    public CompileService.CallResult<ReplStateFacade> replCreateState(int sessionId) {
        var2_2 = this;
        minAliveness$iv = CompileServiceImplBase.Aliveness.Alive;
        $i$f$ifAlive = false;
        var5_5 = CompileServiceImpl.access$getRwlock$p((CompileServiceImpl)this_$iv).readLock();
        var5_5.lock();
        try {
            block22: {
                block19: {
                    block21: {
                        block20: {
                            $i$a$-read-CompileServiceImpl$ifAlive$1$iv = false;
                            var7_8 = (CompileServiceImplBase)this_$iv;
                            minAliveness$iv$iv = minAliveness$iv;
                            $i$f$ifAliveChecksImpl = false;
                            curState$iv$iv = CompileServiceImplBase.access$getState((CompileServiceImplBase)this_$iv$iv).getAlive().get();
                            if (curState$iv$iv >= minAliveness$iv$iv.ordinal()) break block19;
                            stackTrace$iv$iv = Thread.currentThread().getStackTrace();
                            rmiBusinessCallDepth$iv$iv = 1;
                            Intrinsics.checkNotNull((Object)stackTrace$iv$iv);
                            v0 = (StackTraceElement)ArraysKt.getOrNull((Object[])stackTrace$iv$iv, (int)rmiBusinessCallDepth$iv$iv);
                            if (v0 == null) break block20;
                            it$iv$iv = v0;
                            $i$a$-let-CompileServiceImplBase$ifAliveChecksImpl$callSource$1$iv$iv = false;
                            v1 = " Operation: " + it$iv$iv;
                            v0 = v1;
                            if (v1 != null) break block21;
                        }
                        v2 = Thread.currentThread().getStackTrace();
                        Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"getStackTrace(...)");
                        v0 = ArraysKt.joinToString$default((Object[])v2, (CharSequence)"\n at ", (CharSequence)" at ", null, (int)0, null, null, (int)60, null);
                    }
                    callSource$iv$iv = v0;
                    CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv).info(StringsKt.trimMargin$default((String)("\n                    |Cannot perform operation, requested state: " + minAliveness$iv$iv.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName((CompileServiceImplBase)this_$iv$iv, curState$iv$iv) + "\n                    |" + (String)callSource$iv$iv + "\n                    "), null, (int)1, null));
                    v3 = new CompileService.CallResult.Dying();
                    break block22;
                }
                try {
                    block23: {
                        $i$a$-ifAlive-CompileServiceImpl$replCreateState$1 = false;
                        var17_21 = this;
                        sessionId$iv = sessionId;
                        $i$f$withValidRepl = false;
                        var20_24 = (CompileServiceImplBase)this_$iv;
                        sessionId$iv$iv = sessionId$iv;
                        $i$f$withValidReplImpl = false;
                        var23_27 = this_$iv$iv;
                        sessionId$iv$iv$iv = sessionId$iv$iv;
                        $i$f$withValidClientOrSessionProxy = false;
                        if (sessionId$iv$iv$iv != 0) break block23;
                        v4 = null;
                        ** GOTO lbl-1000
                    }
                    v4 = CompileServiceImplBase.access$getState((CompileServiceImplBase)this_$iv$iv$iv).getSessions().get(sessionId$iv$iv$iv);
                    if (v4 == null) {
                        v5 = new CompileService.CallResult.Error("Unknown or invalid session " + sessionId$iv$iv$iv);
                    } else lbl-1000:
                    // 2 sources

                    {
                        session$iv$iv$iv = v4;
                        try {
                            CompileServiceImplBase.access$getCompilationsCounter((CompileServiceImplBase)this_$iv$iv$iv).incrementAndGet();
                            session$iv$iv = session$iv$iv$iv;
                            $i$a$-withValidClientOrSessionProxy-CompileServiceImplBase$withValidReplImpl$1$iv$iv = false;
                            v6 = session$iv$iv;
                            v7 = v6 != null ? v6.getData() : null;
                            if (v7 == null) {
                                v7 = null;
                            }
                            if (v7 != null) {
                                $this$replCreateState_u24lambda_u240_u240 = (KotlinJvmReplService)v7;
                                $i$a$-withValidRepl-CompileServiceImpl$replCreateState$1$1 = false;
                                v8 = new CompileService.CallResult.Good<RemoteReplStateFacadeServer>($this$replCreateState_u24lambda_u240_u240.createRemoteState(this.getPort()));
                            } else {
                                v8 = new CompileService.CallResult.Error("Not a REPL session " + sessionId$iv$iv);
                            }
                            var31_36 = v8;
                            v5 = var31_36;
                        }
                        finally {
                            CompileServiceImplBase.access$set_lastUsedSeconds((CompileServiceImplBase)this_$iv$iv$iv, CompileServiceImplKt.nowSeconds());
                        }
                    }
                    var11_14 = v5;
                }
                catch (Throwable e$iv$iv) {
                    CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv).log(Level.SEVERE, "Exception", e$iv$iv);
                    var11_14 = new CompileService.CallResult.Error(e$iv$iv);
                }
                v3 = var11_14;
            }
            var6_7 = v3;
        }
        finally {
            var5_5.unlock();
        }
        return var6_7;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public CompileService.CallResult<ReplCheckResult> replCheck(int sessionId, int replStateId, @NotNull ReplCodeLine codeLine) {
        CompileService.CallResult callResult;
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)codeLine, (String)"codeLine");
        CompileServiceImpl compileServiceImpl = this;
        CompileServiceImplBase.Aliveness minAliveness$iv = CompileServiceImplBase.Aliveness.Alive;
        boolean $i$f$ifAlive = false;
        ReentrantReadWriteLock.ReadLock readLock = ((CompileServiceImpl)this_$iv).rwlock.readLock();
        readLock.lock();
        try {
            CompileService.CallResult callResult2;
            block20: {
                CompileService.CallResult callResult3;
                void this_$iv$iv;
                block17: {
                    Object object;
                    int curState$iv$iv;
                    CompileServiceImplBase.Aliveness minAliveness$iv$iv;
                    block19: {
                        block18: {
                            boolean bl = false;
                            CompileServiceImplBase compileServiceImplBase = (CompileServiceImplBase)this_$iv;
                            minAliveness$iv$iv = minAliveness$iv;
                            boolean $i$f$ifAliveChecksImpl = false;
                            curState$iv$iv = CompileServiceImplBase.access$getState((CompileServiceImplBase)this_$iv$iv).getAlive().get();
                            if (curState$iv$iv >= minAliveness$iv$iv.ordinal()) break block17;
                            Object[] stackTrace$iv$iv = Thread.currentThread().getStackTrace();
                            int rmiBusinessCallDepth$iv$iv = 1;
                            Intrinsics.checkNotNull((Object)stackTrace$iv$iv);
                            object = (StackTraceElement)ArraysKt.getOrNull((Object[])stackTrace$iv$iv, (int)rmiBusinessCallDepth$iv$iv);
                            if (object == null) break block18;
                            StackTraceElement it$iv$iv = object;
                            boolean bl2 = false;
                            String string = " Operation: " + it$iv$iv;
                            object = string;
                            if (string != null) break block19;
                        }
                        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
                        Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray, (String)"getStackTrace(...)");
                        object = ArraysKt.joinToString$default((Object[])stackTraceElementArray, (CharSequence)"\n at ", (CharSequence)" at ", null, (int)0, null, null, (int)60, null);
                    }
                    Object callSource$iv$iv = object;
                    CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv).info(StringsKt.trimMargin$default((String)("\n                    |Cannot perform operation, requested state: " + minAliveness$iv$iv.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName((CompileServiceImplBase)this_$iv$iv, curState$iv$iv) + "\n                    |" + (String)callSource$iv$iv + "\n                    "), null, (int)1, null));
                    callResult2 = new CompileService.CallResult.Dying();
                    break block20;
                }
                try {
                    CompileService.CallResult callResult4;
                    block15: {
                        void this_$iv$iv$iv;
                        CompileServiceImplBase.ClientOrSessionProxy<Object> clientOrSessionProxy;
                        int sessionId$iv$iv;
                        block22: {
                            int sessionId$iv$iv$iv;
                            block21: {
                                void this_$iv$iv2;
                                void this_$iv2;
                                boolean bl = false;
                                CompileServiceImpl compileServiceImpl2 = this;
                                int sessionId$iv = sessionId;
                                boolean $i$f$withValidRepl = false;
                                CompileServiceImplBase compileServiceImplBase = (CompileServiceImplBase)this_$iv2;
                                sessionId$iv$iv = sessionId$iv;
                                boolean $i$f$withValidReplImpl = false;
                                void var25_29 = this_$iv$iv2;
                                sessionId$iv$iv$iv = sessionId$iv$iv;
                                boolean $i$f$withValidClientOrSessionProxy = false;
                                if (sessionId$iv$iv$iv != 0) break block21;
                                clientOrSessionProxy = null;
                                break block22;
                            }
                            clientOrSessionProxy = CompileServiceImplBase.access$getState((CompileServiceImplBase)this_$iv$iv$iv).getSessions().get(sessionId$iv$iv$iv);
                            if (clientOrSessionProxy != null) break block22;
                            callResult4 = new CompileService.CallResult.Error("Unknown or invalid session " + sessionId$iv$iv$iv);
                            break block15;
                        }
                        CompileServiceImplBase.ClientOrSessionProxy<Object> session$iv$iv$iv = clientOrSessionProxy;
                        try {
                            CompileService.CallResult callResult5;
                            block24: {
                                block23: {
                                    CompileServiceImplBase.access$getCompilationsCounter((CompileServiceImplBase)this_$iv$iv$iv).incrementAndGet();
                                    CompileServiceImplBase.ClientOrSessionProxy<Object> session$iv$iv = session$iv$iv$iv;
                                    boolean bl = false;
                                    CompileServiceImplBase.ClientOrSessionProxy<Object> clientOrSessionProxy2 = session$iv$iv;
                                    CompileService.CallResult callResult6 = clientOrSessionProxy2 != null ? clientOrSessionProxy2.getData() : null;
                                    if (callResult6 == null) {
                                        callResult6 = callResult5 = null;
                                    }
                                    if (callResult6 == null) break block23;
                                    KotlinJvmReplService $this$replCheck_u24lambda_u240_u240 = (KotlinJvmReplService)((Object)callResult5);
                                    boolean bl3 = false;
                                    CompileService.CallResult callResult7 = $this$replCheck_u24lambda_u240_u240.withValidReplState(replStateId, arg_0 -> CompileServiceImpl.replCheck$lambda$0$0$0($this$replCheck_u24lambda_u240_u240, codeLine, arg_0));
                                    callResult5 = callResult7;
                                    if (callResult7 != null) break block24;
                                }
                                callResult5 = new CompileService.CallResult.Error("Not a REPL session " + sessionId$iv$iv);
                            }
                            CompileService.CallResult callResult8 = callResult5;
                            callResult4 = callResult8;
                        }
                        finally {
                            CompileServiceImplBase.access$set_lastUsedSeconds((CompileServiceImplBase)this_$iv$iv$iv, CompileServiceImplKt.nowSeconds());
                        }
                    }
                    callResult3 = callResult4;
                }
                catch (Throwable e$iv$iv) {
                    CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv).log(Level.SEVERE, "Exception", e$iv$iv);
                    callResult3 = new CompileService.CallResult.Error(e$iv$iv);
                }
                callResult2 = callResult3;
            }
            callResult = callResult2;
        }
        finally {
            readLock.unlock();
        }
        return callResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public CompileService.CallResult<ReplCompileResult> replCompile(int sessionId, int replStateId, @NotNull ReplCodeLine codeLine) {
        CompileService.CallResult callResult;
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)codeLine, (String)"codeLine");
        CompileServiceImpl compileServiceImpl = this;
        CompileServiceImplBase.Aliveness minAliveness$iv = CompileServiceImplBase.Aliveness.Alive;
        boolean $i$f$ifAlive = false;
        ReentrantReadWriteLock.ReadLock readLock = ((CompileServiceImpl)this_$iv).rwlock.readLock();
        readLock.lock();
        try {
            CompileService.CallResult callResult2;
            block20: {
                CompileService.CallResult callResult3;
                void this_$iv$iv;
                block17: {
                    Object object;
                    int curState$iv$iv;
                    CompileServiceImplBase.Aliveness minAliveness$iv$iv;
                    block19: {
                        block18: {
                            boolean bl = false;
                            CompileServiceImplBase compileServiceImplBase = (CompileServiceImplBase)this_$iv;
                            minAliveness$iv$iv = minAliveness$iv;
                            boolean $i$f$ifAliveChecksImpl = false;
                            curState$iv$iv = CompileServiceImplBase.access$getState((CompileServiceImplBase)this_$iv$iv).getAlive().get();
                            if (curState$iv$iv >= minAliveness$iv$iv.ordinal()) break block17;
                            Object[] stackTrace$iv$iv = Thread.currentThread().getStackTrace();
                            int rmiBusinessCallDepth$iv$iv = 1;
                            Intrinsics.checkNotNull((Object)stackTrace$iv$iv);
                            object = (StackTraceElement)ArraysKt.getOrNull((Object[])stackTrace$iv$iv, (int)rmiBusinessCallDepth$iv$iv);
                            if (object == null) break block18;
                            StackTraceElement it$iv$iv = object;
                            boolean bl2 = false;
                            String string = " Operation: " + it$iv$iv;
                            object = string;
                            if (string != null) break block19;
                        }
                        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
                        Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray, (String)"getStackTrace(...)");
                        object = ArraysKt.joinToString$default((Object[])stackTraceElementArray, (CharSequence)"\n at ", (CharSequence)" at ", null, (int)0, null, null, (int)60, null);
                    }
                    Object callSource$iv$iv = object;
                    CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv).info(StringsKt.trimMargin$default((String)("\n                    |Cannot perform operation, requested state: " + minAliveness$iv$iv.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName((CompileServiceImplBase)this_$iv$iv, curState$iv$iv) + "\n                    |" + (String)callSource$iv$iv + "\n                    "), null, (int)1, null));
                    callResult2 = new CompileService.CallResult.Dying();
                    break block20;
                }
                try {
                    CompileService.CallResult callResult4;
                    block15: {
                        void this_$iv$iv$iv;
                        CompileServiceImplBase.ClientOrSessionProxy<Object> clientOrSessionProxy;
                        int sessionId$iv$iv;
                        block22: {
                            int sessionId$iv$iv$iv;
                            block21: {
                                void this_$iv$iv2;
                                void this_$iv2;
                                boolean bl = false;
                                CompileServiceImpl compileServiceImpl2 = this;
                                int sessionId$iv = sessionId;
                                boolean $i$f$withValidRepl = false;
                                CompileServiceImplBase compileServiceImplBase = (CompileServiceImplBase)this_$iv2;
                                sessionId$iv$iv = sessionId$iv;
                                boolean $i$f$withValidReplImpl = false;
                                void var25_29 = this_$iv$iv2;
                                sessionId$iv$iv$iv = sessionId$iv$iv;
                                boolean $i$f$withValidClientOrSessionProxy = false;
                                if (sessionId$iv$iv$iv != 0) break block21;
                                clientOrSessionProxy = null;
                                break block22;
                            }
                            clientOrSessionProxy = CompileServiceImplBase.access$getState((CompileServiceImplBase)this_$iv$iv$iv).getSessions().get(sessionId$iv$iv$iv);
                            if (clientOrSessionProxy != null) break block22;
                            callResult4 = new CompileService.CallResult.Error("Unknown or invalid session " + sessionId$iv$iv$iv);
                            break block15;
                        }
                        CompileServiceImplBase.ClientOrSessionProxy<Object> session$iv$iv$iv = clientOrSessionProxy;
                        try {
                            CompileService.CallResult callResult5;
                            block24: {
                                block23: {
                                    CompileServiceImplBase.access$getCompilationsCounter((CompileServiceImplBase)this_$iv$iv$iv).incrementAndGet();
                                    CompileServiceImplBase.ClientOrSessionProxy<Object> session$iv$iv = session$iv$iv$iv;
                                    boolean bl = false;
                                    CompileServiceImplBase.ClientOrSessionProxy<Object> clientOrSessionProxy2 = session$iv$iv;
                                    CompileService.CallResult callResult6 = clientOrSessionProxy2 != null ? clientOrSessionProxy2.getData() : null;
                                    if (callResult6 == null) {
                                        callResult6 = callResult5 = null;
                                    }
                                    if (callResult6 == null) break block23;
                                    KotlinJvmReplService $this$replCompile_u24lambda_u240_u240 = (KotlinJvmReplService)((Object)callResult5);
                                    boolean bl3 = false;
                                    CompileService.CallResult callResult7 = $this$replCompile_u24lambda_u240_u240.withValidReplState(replStateId, arg_0 -> CompileServiceImpl.replCompile$lambda$0$0$0($this$replCompile_u24lambda_u240_u240, codeLine, arg_0));
                                    callResult5 = callResult7;
                                    if (callResult7 != null) break block24;
                                }
                                callResult5 = new CompileService.CallResult.Error("Not a REPL session " + sessionId$iv$iv);
                            }
                            CompileService.CallResult callResult8 = callResult5;
                            callResult4 = callResult8;
                        }
                        finally {
                            CompileServiceImplBase.access$set_lastUsedSeconds((CompileServiceImplBase)this_$iv$iv$iv, CompileServiceImplKt.nowSeconds());
                        }
                    }
                    callResult3 = callResult4;
                }
                catch (Throwable e$iv$iv) {
                    CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv).log(Level.SEVERE, "Exception", e$iv$iv);
                    callResult3 = new CompileService.CallResult.Error(e$iv$iv);
                }
                callResult2 = callResult3;
            }
            callResult = callResult2;
        }
        finally {
            readLock.unlock();
        }
        return callResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    protected void periodicAndAfterSessionCheck() {
        block28: {
            block27: {
                block26: {
                    block31: {
                        block33: {
                            block32: {
                                if (this.getState().getDelayedShutdownQueued().get()) {
                                    return;
                                }
                                anyDead = this.getState().getSessions().cleanDead() != false || this.getState().cleanDeadClients() != false;
                                var2_2 = this;
                                minAliveness$iv = CompileServiceImplBase.Aliveness.LastSession;
                                $i$f$ifAliveUnit = false;
                                var5_5 = CompileServiceImpl.access$getRwlock$p(this_$iv).readLock();
                                var5_5.lock();
                                $i$a$-read-CompileServiceImpl$ifAliveUnit$1$iv = false;
                                var7_10 = this_$iv;
                                minAliveness$iv$iv = minAliveness$iv;
                                $i$f$ifAliveChecksImpl = false;
                                curState$iv$iv = CompileServiceImplBase.access$getState(this_$iv$iv).getAlive().get();
                                if (curState$iv$iv >= minAliveness$iv$iv.ordinal()) break block31;
                                stackTrace$iv$iv = Thread.currentThread().getStackTrace();
                                rmiBusinessCallDepth$iv$iv = 1;
                                Intrinsics.checkNotNull((Object)stackTrace$iv$iv);
                                v0 = (StackTraceElement)ArraysKt.getOrNull((Object[])stackTrace$iv$iv, (int)rmiBusinessCallDepth$iv$iv);
                                if (v0 == null) break block32;
                                it$iv$iv = v0;
                                $i$a$-let-CompileServiceImplBase$ifAliveChecksImpl$callSource$1$iv$iv = false;
                                v1 = " Operation: " + it$iv$iv;
                                v0 = v1;
                                if (v1 != null) break block33;
                            }
                            v2 = Thread.currentThread().getStackTrace();
                            Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"getStackTrace(...)");
                            v0 = ArraysKt.joinToString$default((Object[])v2, (CharSequence)"\n at ", (CharSequence)" at ", null, (int)0, null, null, (int)60, null);
                        }
                        callSource$iv$iv = v0;
                        CompileServiceImplBase.access$getLog(this_$iv$iv).info(StringsKt.trimMargin$default((String)("\n                    |Cannot perform operation, requested state: " + minAliveness$iv$iv.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName(this_$iv$iv, curState$iv$iv) + "\n                    |" + (String)callSource$iv$iv + "\n                    "), null, (int)1, null));
                        (CompileService.CallResult)new CompileService.CallResult.Dying();
                        ** GOTO lbl79
                    }
                    $i$a$-ifAliveChecksImpl-CompileServiceImpl$ifAliveUnit$1$1$iv = false;
                    $i$a$-ifAliveUnit-CompileServiceImpl$periodicAndAfterSessionCheck$1 = false;
                    if (this.getState().getAlive().get() != CompileServiceImplBase.Aliveness.LastSession.ordinal() || !this.getState().getSessions().isEmpty()) break block26;
                    this.getLog().info("All sessions finished");
                    this.shutdownWithDelay();
                    var5_5.unlock();
                    return;
                }
                if (this.getState().getAliveClientsCount() != 0) break block27;
                this.getLog().info("No more clients left");
                this.shutdownWithDelay();
                var5_5.unlock();
                return;
            }
            if (this.getRunFile().exists()) break block28;
            this.getLog().info("Run file removed");
            this.shutdownWithDelay();
            var5_5.unlock();
            return;
        }
        try {
            stackTrace$iv$iv = new CompileService.CallResult.Ok();
            {
                catch (Throwable e$iv$iv) {
                    CompileServiceImplBase.access$getLog(this_$iv$iv).log(Level.SEVERE, "Exception", e$iv$iv);
                    stackTrace$iv$iv = new CompileService.CallResult.Error(e$iv$iv);
                }
            }
lbl79:
            // 3 sources

            $i$a$-read-CompileServiceImpl$ifAliveUnit$1$iv = Unit.INSTANCE;
        }
        catch (Throwable this_$iv$iv) {
            throw this_$iv$iv;
        }
        finally {
            var5_5.unlock();
        }
        this_$iv = this;
        minAliveness$iv = CompileServiceImplBase.Aliveness.Alive;
        $i$f$ifAliveUnit = false;
        var5_5 = CompileServiceImpl.access$getRwlock$p(this_$iv).readLock();
        var5_5.lock();
        try {
            block37: {
                block34: {
                    block36: {
                        block35: {
                            $i$a$-read-CompileServiceImpl$ifAliveUnit$1$iv = false;
                            this_$iv$iv = this_$iv;
                            minAliveness$iv$iv = minAliveness$iv;
                            $i$f$ifAliveChecksImpl = false;
                            curState$iv$iv = CompileServiceImplBase.access$getState(this_$iv$iv).getAlive().get();
                            if (curState$iv$iv >= minAliveness$iv$iv.ordinal()) break block34;
                            stackTrace$iv$iv = Thread.currentThread().getStackTrace();
                            rmiBusinessCallDepth$iv$iv = 1;
                            Intrinsics.checkNotNull((Object)stackTrace$iv$iv);
                            v3 = (StackTraceElement)ArraysKt.getOrNull((Object[])stackTrace$iv$iv, (int)rmiBusinessCallDepth$iv$iv);
                            if (v3 == null) break block35;
                            it$iv$iv = v3;
                            $i$a$-let-CompileServiceImplBase$ifAliveChecksImpl$callSource$1$iv$iv = false;
                            v4 = " Operation: " + it$iv$iv;
                            v3 = v4;
                            if (v4 != null) break block36;
                        }
                        v5 = Thread.currentThread().getStackTrace();
                        Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"getStackTrace(...)");
                        v3 = ArraysKt.joinToString$default((Object[])v5, (CharSequence)"\n at ", (CharSequence)" at ", null, (int)0, null, null, (int)60, null);
                    }
                    callSource$iv$iv = v3;
                    CompileServiceImplBase.access$getLog(this_$iv$iv).info(StringsKt.trimMargin$default((String)("\n                    |Cannot perform operation, requested state: " + minAliveness$iv$iv.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName(this_$iv$iv, curState$iv$iv) + "\n                    |" + (String)callSource$iv$iv + "\n                    "), null, (int)1, null));
                    (CompileService.CallResult)new CompileService.CallResult.Dying();
                    break block37;
                }
                try {
                    $i$a$-ifAliveChecksImpl-CompileServiceImpl$ifAliveUnit$1$1$iv = false;
                    $i$a$-ifAliveUnit-CompileServiceImpl$periodicAndAfterSessionCheck$2 = false;
                    if (this.getDaemonOptions().getAutoshutdownUnusedSeconds() != 0 && this.getCompilationsCounter().get() == 0 && CompileServiceImplKt.nowSeconds() - this.getLastUsedSeconds() > (long)this.getDaemonOptions().getAutoshutdownUnusedSeconds()) {
                        this.getLog().info("Unused timeout exceeded " + this.getDaemonOptions().getAutoshutdownUnusedSeconds() + 's');
                        this.gracefulShutdown(false);
                    } else if (this.getDaemonOptions().getAutoshutdownIdleSeconds() != 0 && CompileServiceImplKt.nowSeconds() - this.getLastUsedSeconds() > (long)this.getDaemonOptions().getAutoshutdownIdleSeconds()) {
                        this.getLog().info("Idle timeout exceeded " + this.getDaemonOptions().getAutoshutdownIdleSeconds() + 's');
                        this.gracefulShutdown(false);
                    } else if (anyDead) {
                        this.clearJarCache();
                    }
                    var11_16 = new CompileService.CallResult.Ok();
                }
                catch (Throwable e$iv$iv) {
                    CompileServiceImplBase.access$getLog(this_$iv$iv).log(Level.SEVERE, "Exception", e$iv$iv);
                    var11_16 = new CompileService.CallResult.Error(e$iv$iv);
                }
            }
            var6_9 = Unit.INSTANCE;
        }
        finally {
            var5_5.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    protected void periodicSeldomCheck() {
        void this_$iv;
        CompileServiceImpl compileServiceImpl = this;
        CompileServiceImplBase.Aliveness minAliveness$iv = CompileServiceImplBase.Aliveness.Alive;
        boolean $i$f$ifAliveUnit = false;
        ReentrantReadWriteLock.ReadLock readLock = ((CompileServiceImpl)this_$iv).rwlock.readLock();
        readLock.lock();
        try {
            block13: {
                void this_$iv$iv;
                block10: {
                    Object object;
                    int curState$iv$iv;
                    CompileServiceImplBase.Aliveness minAliveness$iv$iv;
                    block12: {
                        block11: {
                            boolean bl = false;
                            CompileServiceImplBase compileServiceImplBase = (CompileServiceImplBase)this_$iv;
                            minAliveness$iv$iv = minAliveness$iv;
                            boolean $i$f$ifAliveChecksImpl = false;
                            curState$iv$iv = CompileServiceImplBase.access$getState((CompileServiceImplBase)this_$iv$iv).getAlive().get();
                            if (curState$iv$iv >= minAliveness$iv$iv.ordinal()) break block10;
                            Object[] stackTrace$iv$iv = Thread.currentThread().getStackTrace();
                            int rmiBusinessCallDepth$iv$iv = 1;
                            Intrinsics.checkNotNull((Object)stackTrace$iv$iv);
                            object = (StackTraceElement)ArraysKt.getOrNull((Object[])stackTrace$iv$iv, (int)rmiBusinessCallDepth$iv$iv);
                            if (object == null) break block11;
                            StackTraceElement it$iv$iv = object;
                            boolean bl2 = false;
                            String string = " Operation: " + it$iv$iv;
                            object = string;
                            if (string != null) break block12;
                        }
                        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
                        Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray, (String)"getStackTrace(...)");
                        object = ArraysKt.joinToString$default((Object[])stackTraceElementArray, (CharSequence)"\n at ", (CharSequence)" at ", null, (int)0, null, null, (int)60, null);
                    }
                    Object callSource$iv$iv = object;
                    CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv).info(StringsKt.trimMargin$default((String)("\n                    |Cannot perform operation, requested state: " + minAliveness$iv$iv.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName((CompileServiceImplBase)this_$iv$iv, curState$iv$iv) + "\n                    |" + (String)callSource$iv$iv + "\n                    "), null, (int)1, null));
                    CompileService.CallResult cfr_ignored_0 = new CompileService.CallResult.Dying();
                    break block13;
                }
                try {
                    boolean bl = false;
                    boolean bl3 = false;
                    if (this.getClasspathWatcher().isChanged()) {
                        this.getLog().info("Compiler changed.");
                        this.gracefulShutdown(false);
                    }
                    CompileService.CallResult callResult = new CompileService.CallResult.Ok();
                }
                catch (Throwable e$iv$iv) {
                    CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv).log(Level.SEVERE, "Exception", e$iv$iv);
                    CompileService.CallResult callResult = new CompileService.CallResult.Error(e$iv$iv);
                }
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    protected void initiateElections() {
        $this$iv = this;
        minAliveness$iv = CompileServiceImplBase.Aliveness.LastSession;
        $i$f$ifAliveUnit = false;
        var4_4 = CompileServiceImpl.access$getRwlock$p($this$iv).readLock();
        var4_4.lock();
        try {
            block21: {
                block18: {
                    block20: {
                        block19: {
                            $i$a$-read-CompileServiceImpl$ifAliveUnit$1$iv = false;
                            var6_7 = $this$iv;
                            minAliveness$iv$iv = minAliveness$iv;
                            $i$f$ifAliveChecksImpl = false;
                            curState$iv$iv = CompileServiceImplBase.access$getState((CompileServiceImplBase)this_$iv$iv).getAlive().get();
                            if (curState$iv$iv >= minAliveness$iv$iv.ordinal()) break block18;
                            stackTrace$iv$iv = Thread.currentThread().getStackTrace();
                            rmiBusinessCallDepth$iv$iv = 1;
                            Intrinsics.checkNotNull((Object)stackTrace$iv$iv);
                            v0 = (StackTraceElement)ArraysKt.getOrNull((Object[])stackTrace$iv$iv, (int)rmiBusinessCallDepth$iv$iv);
                            if (v0 == null) break block19;
                            it$iv$iv = v0;
                            $i$a$-let-CompileServiceImplBase$ifAliveChecksImpl$callSource$1$iv$iv = false;
                            v1 = " Operation: " + it$iv$iv;
                            v0 = v1;
                            if (v1 != null) break block20;
                        }
                        v2 = Thread.currentThread().getStackTrace();
                        Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"getStackTrace(...)");
                        v0 = ArraysKt.joinToString$default((Object[])v2, (CharSequence)"\n at ", (CharSequence)" at ", null, (int)0, null, null, (int)60, null);
                    }
                    callSource$iv$iv = v0;
                    CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv).info(StringsKt.trimMargin$default((String)("\n                    |Cannot perform operation, requested state: " + minAliveness$iv$iv.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName((CompileServiceImplBase)this_$iv$iv, curState$iv$iv) + "\n                    |" + (String)callSource$iv$iv + "\n                    "), null, (int)1, null));
                    (CompileService.CallResult)new CompileService.CallResult.Dying();
                    break block21;
                }
                try {
                    block22: {
                        block23: {
                            $i$a$-ifAliveChecksImpl-CompileServiceImpl$ifAliveUnit$1$1$iv = false;
                            $i$a$-ifAliveUnit$default-CompileServiceImpl$initiateElections$1 = false;
                            this.getLog().info("initiate elections");
                            aliveWithOpts = SequencesKt.toList(ClientUtilsKt.walkDaemons(new File(DaemonParamsKt.getRunFilesPathOrDefault(this.getDaemonOptions())), this.getCompilerId(), this.getRunFile(), (Function2<? super File, ? super Integer, Boolean>)(Function2)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, initiateElections$lambda$0$0(org.jetbrains.kotlin.daemon.CompileServiceImpl java.io.File int ), (Ljava/io/File;Ljava/lang/Integer;)Ljava/lang/Boolean;)((CompileServiceImpl)this), (Function2<? super DaemonReportCategory, ? super String, Unit>)(Function2)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, initiateElections$lambda$0$1(org.jetbrains.kotlin.daemon.CompileServiceImpl org.jetbrains.kotlin.daemon.common.DaemonReportCategory java.lang.String ), (Lorg/jetbrains/kotlin/daemon/common/DaemonReportCategory;Ljava/lang/String;)Lkotlin/Unit;)((CompileServiceImpl)this)));
                            var18_23 = new DaemonJVMOptionsMemoryComparator();
                            var18_23 = new Comparator(var18_23){
                                final /* synthetic */ Comparator $comparator;
                                {
                                    this.$comparator = $comparator;
                                }

                                public final int compare(T a, T b) {
                                    DaemonWithMetadata daemonWithMetadata = (DaemonWithMetadata)b;
                                    Comparator comparator = this.$comparator;
                                    boolean bl = false;
                                    DaemonWithMetadata it = (DaemonWithMetadata)a;
                                    DaemonJVMOptions daemonJVMOptions = it.getJvmOptions();
                                    bl = false;
                                    DaemonJVMOptions daemonJVMOptions2 = it.getJvmOptions();
                                    return comparator.compare(daemonJVMOptions, daemonJVMOptions2);
                                }
                            };
                            var19_24 = new FileAgeComparator();
                            comparator = new Comparator(var18_23, var19_24){
                                final /* synthetic */ Comparator $this_thenBy;
                                final /* synthetic */ Comparator $comparator;
                                {
                                    this.$this_thenBy = $receiver;
                                    this.$comparator = $comparator;
                                }

                                public final int compare(T a, T b) {
                                    int n;
                                    int previousCompare = this.$this_thenBy.compare(a, b);
                                    if (previousCompare != 0) {
                                        n = previousCompare;
                                    } else {
                                        DaemonWithMetadata daemonWithMetadata = (DaemonWithMetadata)a;
                                        Comparator comparator = this.$comparator;
                                        boolean bl = false;
                                        DaemonWithMetadata it = (DaemonWithMetadata)b;
                                        File file = it.getRunFile();
                                        bl = false;
                                        File file2 = it.getRunFile();
                                        n = comparator.compare(file, file2);
                                    }
                                    return n;
                                }
                            };
                            v3 = (DaemonWithMetadata)CollectionsKt.maxWithOrNull((Iterable)aliveWithOpts, (Comparator)comparator);
                            if (v3 == null) break block22;
                            bestDaemonWithMetadata = v3;
                            $i$a$-let-CompileServiceImpl$initiateElections$1$1 = false;
                            fattestOpts = bestDaemonWithMetadata.getJvmOptions();
                            if (!DaemonParamsKt.memorywiseFitsInto(fattestOpts, this.daemonJVMOptions)) break block23;
                            if (new FileAgeComparator().compare(bestDaemonWithMetadata.getRunFile(), this.getRunFile()) >= 0) break block23;
                            this.getLog().info("Assuming other daemons have lower prio, taking clients from them and schedule them to shutdown: my runfile: " + this.getRunFile().getName() + " (" + this.getRunFile().lastModified() + ") vs best other runfile: " + bestDaemonWithMetadata.getRunFile().getName() + " (" + bestDaemonWithMetadata.getRunFile().lastModified() + ')');
                            $this$forEach$iv = aliveWithOpts;
                            $i$f$forEach = false;
                            for (T element$iv : $this$forEach$iv) {
                                var28_36 = (DaemonWithMetadata)element$iv;
                                $i$a$-forEach-CompileServiceImpl$initiateElections$1$1$1 = false;
                                daemon = var28_36.component1();
                                runFile = var28_36.component2();
                                try {
                                    it = var32_44 = daemon.getClients();
                                    $i$a$-takeIf-CompileServiceImpl$initiateElections$1$1$1$1 = false;
                                    v4 = it.isGood() != false ? var32_44 : null;
                                    if (v4 != null) {
                                        it = v4;
                                        $i$a$-let-CompileServiceImpl$initiateElections$1$1$1$2 = false;
                                        $this$forEach$iv = it.get();
                                        $i$f$forEach = false;
                                        for (T element$iv : $this$forEach$iv) {
                                            clientAliveFile = (String)element$iv;
                                            $i$a$-forEach-CompileServiceImpl$initiateElections$1$1$1$2$1 = false;
                                            this.registerClient(clientAliveFile);
                                        }
                                    }
                                    daemon.scheduleShutdown(true);
                                }
                                catch (Throwable e) {
                                    this.getLog().info("Cannot connect to a daemon, assuming dying ('" + FilesKt.normalize((File)runFile).getAbsolutePath() + "'): " + e.getMessage());
                                }
                            }
                            break block22;
                        }
                        if (!DaemonParamsKt.memorywiseFitsInto(this.daemonJVMOptions, fattestOpts)) ** GOTO lbl-1000
                        if (new FileAgeComparator().compare(bestDaemonWithMetadata.getRunFile(), this.getRunFile()) > 0) {
                            this.getLog().info("Assuming other daemons have higher prio, handover clients to it and schedule shutdown: my runfile: " + this.getRunFile().getName() + " (" + this.getRunFile().lastModified() + ") vs best other runfile: " + bestDaemonWithMetadata.getRunFile().getName() + " (" + bestDaemonWithMetadata.getRunFile().lastModified() + ')');
                            it = var25_31 = this.getClients();
                            $i$a$-takeIf-CompileServiceImpl$initiateElections$1$1$2 = false;
                            v5 = it.isGood() != false ? var25_31 : null;
                            if (v5 != null) {
                                it = v5;
                                $i$a$-let-CompileServiceImpl$initiateElections$1$1$3 = false;
                                $this$forEach$iv = it.get();
                                $i$f$forEach = false;
                                for (T element$iv : $this$forEach$iv) {
                                    it = (String)element$iv;
                                    $i$a$-forEach-CompileServiceImpl$initiateElections$1$1$3$1 = false;
                                    bestDaemonWithMetadata.getDaemon().registerClient(it);
                                }
                            }
                            this.scheduleShutdown(true);
                        } else lbl-1000:
                        // 2 sources

                        {
                            this.getLog().info("Assuming other daemons have equal prio, continue: " + this.getRunFile().getName() + " (" + this.getRunFile().lastModified() + ") vs best other runfile: " + bestDaemonWithMetadata.getRunFile().getName() + " (" + bestDaemonWithMetadata.getRunFile().lastModified() + ')');
                        }
                    }
                    var10_13 = new CompileService.CallResult.Ok();
                }
                catch (Throwable e$iv$iv) {
                    CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv).log(Level.SEVERE, "Exception", e$iv$iv);
                    var10_14 = new CompileService.CallResult.Error(e$iv$iv);
                }
            }
            var5_6 = Unit.INSTANCE;
        }
        finally {
            var4_4.unlock();
        }
    }

    private final void shutdownNow() {
        this.getLog().info("Shutdown started");
        Runtime $this$shutdownNow_u24lambda_u240 = Runtime.getRuntime();
        boolean bl = false;
        this.getLog().info("Memory stats: total: " + CompileServiceImpl.shutdownNow$mb($this$shutdownNow_u24lambda_u240.totalMemory()) + "mb, free: " + CompileServiceImpl.shutdownNow$mb($this$shutdownNow_u24lambda_u240.freeMemory()) + "mb, max: " + CompileServiceImpl.shutdownNow$mb($this$shutdownNow_u24lambda_u240.maxMemory()) + "mb");
        this.getState().getAlive().set(CompileServiceImplBase.Aliveness.Dying.ordinal());
        UnicastRemoteObject.unexportObject(this, true);
        this.getLog().info("Shutdown complete");
        this.getOnShutdown().invoke();
        Handler[] handlerArray = this.getLog().getHandlers();
        Intrinsics.checkNotNullExpressionValue((Object)handlerArray, (String)"getHandlers(...)");
        Object[] $this$forEach$iv = handlerArray;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Handler it = (Handler)element$iv;
            boolean bl2 = false;
            it.flush();
        }
    }

    private final void shutdownWithDelay() {
        this.getState().getDelayedShutdownQueued().set(true);
        int currentClientsCount = this.getState().getClientsCounter();
        int currentSessionId = this.getState().getSessions().getLastSessionId();
        int currentCompilationsCount = this.getCompilationsCounter().get();
        this.getLog().info("Delayed shutdown in " + this.getDaemonOptions().getShutdownDelayMilliseconds() + "ms");
        Timer timer = this.getTimer();
        long l = this.getDaemonOptions().getShutdownDelayMilliseconds();
        TimerTask timerTask = new TimerTask(this, currentClientsCount, currentCompilationsCount, currentSessionId){
            final /* synthetic */ CompileServiceImpl this$0;
            final /* synthetic */ int $currentClientsCount$inlined;
            final /* synthetic */ int $currentCompilationsCount$inlined;
            final /* synthetic */ int $currentSessionId$inlined;
            {
                this.this$0 = compileServiceImpl;
                this.$currentClientsCount$inlined = n;
                this.$currentCompilationsCount$inlined = n2;
                this.$currentSessionId$inlined = n3;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            public void run() {
                block9: {
                    void this_$iv;
                    TimerTask $this$shutdownWithDelay_u24lambda_u240 = this;
                    boolean bl = false;
                    this.this$0.getState().getDelayedShutdownQueued().set(false);
                    if (this.$currentClientsCount$inlined != this.this$0.getState().getClientsCounter() || this.$currentCompilationsCount$inlined != this.this$0.getCompilationsCounter().get() || this.$currentSessionId$inlined != this.this$0.getState().getSessions().getLastSessionId()) break block9;
                    CompileServiceImpl compileServiceImpl = this.this$0;
                    CompileServiceImplBase.Aliveness minAliveness$iv = CompileServiceImplBase.Aliveness.LastSession;
                    boolean $i$f$ifAliveExclusiveUnit = false;
                    ReentrantReadWriteLock reentrantReadWriteLock = CompileServiceImpl.access$getRwlock$p((CompileServiceImpl)this_$iv);
                    ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
                    int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
                    for (int i = 0; i < n; ++i) {
                        readLock.unlock();
                    }
                    ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
                    writeLock.lock();
                    try {
                        block13: {
                            CompileService.CallResult callResult;
                            void this_$iv$iv;
                            block10: {
                                Object object;
                                int curState$iv$iv;
                                CompileServiceImplBase.Aliveness minAliveness$iv$iv;
                                block12: {
                                    block11: {
                                        boolean bl2 = false;
                                        CompileServiceImplBase compileServiceImplBase = (CompileServiceImplBase)this_$iv;
                                        minAliveness$iv$iv = minAliveness$iv;
                                        boolean $i$f$ifAliveChecksImpl = false;
                                        curState$iv$iv = CompileServiceImplBase.access$getState((CompileServiceImplBase)this_$iv$iv).getAlive().get();
                                        if (curState$iv$iv >= minAliveness$iv$iv.ordinal()) break block10;
                                        Object[] stackTrace$iv$iv = Thread.currentThread().getStackTrace();
                                        int rmiBusinessCallDepth$iv$iv = 1;
                                        Intrinsics.checkNotNull((Object)stackTrace$iv$iv);
                                        object = (StackTraceElement)ArraysKt.getOrNull((Object[])stackTrace$iv$iv, (int)rmiBusinessCallDepth$iv$iv);
                                        if (object == null) break block11;
                                        StackTraceElement it$iv$iv = object;
                                        boolean bl3 = false;
                                        String string = " Operation: " + it$iv$iv;
                                        object = string;
                                        if (string != null) break block12;
                                    }
                                    StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
                                    Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray, (String)"getStackTrace(...)");
                                    object = ArraysKt.joinToString$default((Object[])stackTraceElementArray, (CharSequence)"\n at ", (CharSequence)" at ", null, (int)0, null, null, (int)60, null);
                                }
                                Object callSource$iv$iv = object;
                                CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv).info(StringsKt.trimMargin$default((String)("\n                    |Cannot perform operation, requested state: " + minAliveness$iv$iv.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName((CompileServiceImplBase)this_$iv$iv, curState$iv$iv) + "\n                    |" + (String)callSource$iv$iv + "\n                    "), null, (int)1, null));
                                CompileService.CallResult cfr_ignored_0 = (CompileService.CallResult)new CompileService.CallResult.Dying();
                                break block13;
                            }
                            try {
                                boolean bl4 = false;
                                boolean bl5 = false;
                                this.this$0.getLog().fine("Execute delayed shutdown");
                                CompileServiceImpl.access$shutdownNow(this.this$0);
                                callResult = new CompileService.CallResult.Ok();
                            }
                            catch (Throwable e$iv$iv) {
                                CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv).log(Level.SEVERE, "Exception", e$iv$iv);
                                callResult = new CompileService.CallResult.Error(e$iv$iv);
                            }
                        }
                        Unit unit = Unit.INSTANCE;
                    }
                    finally {
                        for (int i = 0; i < n; ++i) {
                            readLock.lock();
                        }
                        writeLock.unlock();
                    }
                }
                this.this$0.getLog().info("Cancel delayed shutdown due to a new activity");
            }
        };
        timer.schedule(timerTask, l);
    }

    private final boolean gracefulShutdown(boolean onAnotherThread) {
        if (!this.getState().getAlive().compareAndSet(CompileServiceImplBase.Aliveness.Alive.ordinal(), CompileServiceImplBase.Aliveness.LastSession.ordinal())) {
            this.getLog().info("Invalid state for graceful shutdown: " + this.toAlivenessName(this.getState().getAlive().get()));
            return false;
        }
        this.getLog().info("Graceful shutdown signalled");
        if (!onAnotherThread) {
            CompileServiceImpl.gracefulShutdown$shutdownIfIdle(this);
        } else {
            Timer timer = this.getTimer();
            long l = 1L;
            TimerTask timerTask = new TimerTask(this){
                final /* synthetic */ CompileServiceImpl this$0;
                {
                    this.this$0 = compileServiceImpl;
                }

                public void run() {
                    TimerTask $this$gracefulShutdown_u24lambda_u241 = this;
                    boolean bl = false;
                    CompileServiceImpl.access$gracefulShutdown$shutdownIfIdle(this.this$0);
                }
            };
            timer.schedule(timerTask, l);
        }
        return true;
    }

    @Override
    public void clearJarCache() {
        block2: {
            KotlinCoreApplicationEnvironment kotlinCoreApplicationEnvironment;
            ZipHandler.clearFileAccessorCache();
            KotlinCoreApplicationEnvironment kotlinCoreApplicationEnvironment2 = KotlinCoreEnvironment.Companion.getApplicationEnvironment();
            if (kotlinCoreApplicationEnvironment2 == null) break block2;
            KotlinCoreApplicationEnvironment $this$clearJarCache_u24lambda_u240 = kotlinCoreApplicationEnvironment = kotlinCoreApplicationEnvironment2;
            boolean bl = false;
            VirtualFileSystem virtualFileSystem = $this$clearJarCache_u24lambda_u240.getJarFileSystem();
            CoreJarFileSystem coreJarFileSystem = virtualFileSystem instanceof CoreJarFileSystem ? (CoreJarFileSystem)virtualFileSystem : null;
            if (coreJarFileSystem != null) {
                coreJarFileSystem.clearHandlersCache();
            }
            virtualFileSystem = $this$clearJarCache_u24lambda_u240.getJrtFileSystem();
            CoreJrtFileSystem coreJrtFileSystem = virtualFileSystem instanceof CoreJrtFileSystem ? (CoreJrtFileSystem)virtualFileSystem : null;
            if (coreJrtFileSystem != null) {
                coreJrtFileSystem.clearRoots();
            }
            $this$clearJarCache_u24lambda_u240.idleCleanup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final <R> CompileService.CallResult<R> ifAlive(CompileServiceImplBase.Aliveness minAliveness, Function0<? extends CompileService.CallResult<? extends R>> body) {
        CompileService.CallResult callResult;
        boolean $i$f$ifAlive = false;
        ReentrantReadWriteLock.ReadLock readLock = this.rwlock.readLock();
        readLock.lock();
        try {
            CompileService.CallResult callResult2;
            block11: {
                CompileService.CallResult callResult3;
                void this_$iv;
                block8: {
                    Object object;
                    int curState$iv;
                    CompileServiceImplBase.Aliveness minAliveness$iv;
                    block10: {
                        block9: {
                            boolean bl = false;
                            CompileServiceImplBase compileServiceImplBase = this;
                            minAliveness$iv = minAliveness;
                            boolean $i$f$ifAliveChecksImpl = false;
                            curState$iv = CompileServiceImplBase.access$getState((CompileServiceImplBase)this_$iv).getAlive().get();
                            if (curState$iv >= minAliveness$iv.ordinal()) break block8;
                            Object[] stackTrace$iv = Thread.currentThread().getStackTrace();
                            int rmiBusinessCallDepth$iv = 1;
                            Intrinsics.checkNotNull((Object)stackTrace$iv);
                            object = (StackTraceElement)ArraysKt.getOrNull((Object[])stackTrace$iv, (int)rmiBusinessCallDepth$iv);
                            if (object == null) break block9;
                            StackTraceElement it$iv = object;
                            boolean bl2 = false;
                            String string = " Operation: " + it$iv;
                            object = string;
                            if (string != null) break block10;
                        }
                        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
                        Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray, (String)"getStackTrace(...)");
                        object = ArraysKt.joinToString$default((Object[])stackTraceElementArray, (CharSequence)"\n at ", (CharSequence)" at ", null, (int)0, null, null, (int)60, null);
                    }
                    Object callSource$iv = object;
                    CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv).info(StringsKt.trimMargin$default((String)("\n                    |Cannot perform operation, requested state: " + minAliveness$iv.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName((CompileServiceImplBase)this_$iv, curState$iv) + "\n                    |" + (String)callSource$iv + "\n                    "), null, (int)1, null));
                    callResult2 = new CompileService.CallResult.Dying();
                    break block11;
                }
                try {
                    callResult3 = (CompileService.CallResult)body.invoke();
                }
                catch (Throwable e$iv) {
                    CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv).log(Level.SEVERE, "Exception", e$iv);
                    callResult3 = new CompileService.CallResult.Error(e$iv);
                }
                callResult2 = callResult3;
            }
            callResult = callResult2;
        }
        finally {
            InlineMarker.finallyStart((int)1);
            readLock.unlock();
            InlineMarker.finallyEnd((int)1);
        }
        return callResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    static /* synthetic */ CompileService.CallResult ifAlive$default(CompileServiceImpl $this, CompileServiceImplBase.Aliveness minAliveness, Function0 body, int n, Object object) {
        CompileService.CallResult callResult;
        if ((n & 1) != 0) {
            minAliveness = CompileServiceImplBase.Aliveness.LastSession;
        }
        boolean $i$f$ifAlive = false;
        ReentrantReadWriteLock.ReadLock readLock = $this.rwlock.readLock();
        readLock.lock();
        try {
            CompileService.CallResult callResult2;
            block13: {
                CompileService.CallResult callResult3;
                void this_$iv;
                block10: {
                    Object object2;
                    int curState$iv;
                    CompileServiceImplBase.Aliveness minAliveness$iv;
                    block12: {
                        block11: {
                            boolean bl = false;
                            CompileServiceImplBase compileServiceImplBase = $this;
                            minAliveness$iv = minAliveness;
                            boolean $i$f$ifAliveChecksImpl = false;
                            curState$iv = CompileServiceImplBase.access$getState((CompileServiceImplBase)this_$iv).getAlive().get();
                            if (curState$iv >= minAliveness$iv.ordinal()) break block10;
                            Object[] stackTrace$iv = Thread.currentThread().getStackTrace();
                            int rmiBusinessCallDepth$iv = 1;
                            Intrinsics.checkNotNull((Object)stackTrace$iv);
                            object2 = (StackTraceElement)ArraysKt.getOrNull((Object[])stackTrace$iv, (int)rmiBusinessCallDepth$iv);
                            if (object2 == null) break block11;
                            StackTraceElement it$iv = object2;
                            boolean bl2 = false;
                            String string = " Operation: " + it$iv;
                            object2 = string;
                            if (string != null) break block12;
                        }
                        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
                        Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray, (String)"getStackTrace(...)");
                        object2 = ArraysKt.joinToString$default((Object[])stackTraceElementArray, (CharSequence)"\n at ", (CharSequence)" at ", null, (int)0, null, null, (int)60, null);
                    }
                    Object callSource$iv = object2;
                    CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv).info(StringsKt.trimMargin$default((String)("\n                    |Cannot perform operation, requested state: " + minAliveness$iv.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName((CompileServiceImplBase)this_$iv, curState$iv) + "\n                    |" + (String)callSource$iv + "\n                    "), null, (int)1, null));
                    callResult2 = new CompileService.CallResult.Dying();
                    break block13;
                }
                try {
                    callResult3 = (CompileService.CallResult)body.invoke();
                }
                catch (Throwable e$iv) {
                    CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv).log(Level.SEVERE, "Exception", e$iv);
                    callResult3 = new CompileService.CallResult.Error(e$iv);
                }
                callResult2 = callResult3;
            }
            callResult = callResult2;
        }
        finally {
            InlineMarker.finallyStart((int)1);
            readLock.unlock();
            InlineMarker.finallyEnd((int)1);
        }
        return callResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void ifAliveUnit(CompileServiceImplBase.Aliveness minAliveness, Function0<Unit> body) {
        boolean $i$f$ifAliveUnit = false;
        ReentrantReadWriteLock.ReadLock readLock = this.rwlock.readLock();
        readLock.lock();
        try {
            block11: {
                void this_$iv;
                block8: {
                    Object object;
                    int curState$iv;
                    CompileServiceImplBase.Aliveness minAliveness$iv;
                    block10: {
                        block9: {
                            boolean bl = false;
                            CompileServiceImplBase compileServiceImplBase = this;
                            minAliveness$iv = minAliveness;
                            boolean $i$f$ifAliveChecksImpl = false;
                            curState$iv = CompileServiceImplBase.access$getState((CompileServiceImplBase)this_$iv).getAlive().get();
                            if (curState$iv >= minAliveness$iv.ordinal()) break block8;
                            Object[] stackTrace$iv = Thread.currentThread().getStackTrace();
                            int rmiBusinessCallDepth$iv = 1;
                            Intrinsics.checkNotNull((Object)stackTrace$iv);
                            object = (StackTraceElement)ArraysKt.getOrNull((Object[])stackTrace$iv, (int)rmiBusinessCallDepth$iv);
                            if (object == null) break block9;
                            StackTraceElement it$iv = object;
                            boolean bl2 = false;
                            String string = " Operation: " + it$iv;
                            object = string;
                            if (string != null) break block10;
                        }
                        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
                        Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray, (String)"getStackTrace(...)");
                        object = ArraysKt.joinToString$default((Object[])stackTraceElementArray, (CharSequence)"\n at ", (CharSequence)" at ", null, (int)0, null, null, (int)60, null);
                    }
                    Object callSource$iv = object;
                    CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv).info(StringsKt.trimMargin$default((String)("\n                    |Cannot perform operation, requested state: " + minAliveness$iv.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName((CompileServiceImplBase)this_$iv, curState$iv) + "\n                    |" + (String)callSource$iv + "\n                    "), null, (int)1, null));
                    CompileService.CallResult cfr_ignored_0 = new CompileService.CallResult.Dying();
                    break block11;
                }
                try {
                    boolean bl = false;
                    body.invoke();
                    CompileService.CallResult callResult = new CompileService.CallResult.Ok();
                }
                catch (Throwable e$iv) {
                    CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv).log(Level.SEVERE, "Exception", e$iv);
                    CompileService.CallResult callResult = new CompileService.CallResult.Error(e$iv);
                }
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            InlineMarker.finallyStart((int)1);
            readLock.unlock();
            InlineMarker.finallyEnd((int)1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    static /* synthetic */ void ifAliveUnit$default(CompileServiceImpl $this, CompileServiceImplBase.Aliveness minAliveness, Function0 body, int n, Object object) {
        if ((n & 1) != 0) {
            minAliveness = CompileServiceImplBase.Aliveness.LastSession;
        }
        boolean $i$f$ifAliveUnit = false;
        ReentrantReadWriteLock.ReadLock readLock = $this.rwlock.readLock();
        readLock.lock();
        try {
            block13: {
                void this_$iv;
                block10: {
                    Object object2;
                    int curState$iv;
                    CompileServiceImplBase.Aliveness minAliveness$iv;
                    block12: {
                        block11: {
                            boolean bl = false;
                            CompileServiceImplBase compileServiceImplBase = $this;
                            minAliveness$iv = minAliveness;
                            boolean $i$f$ifAliveChecksImpl = false;
                            curState$iv = CompileServiceImplBase.access$getState((CompileServiceImplBase)this_$iv).getAlive().get();
                            if (curState$iv >= minAliveness$iv.ordinal()) break block10;
                            Object[] stackTrace$iv = Thread.currentThread().getStackTrace();
                            int rmiBusinessCallDepth$iv = 1;
                            Intrinsics.checkNotNull((Object)stackTrace$iv);
                            object2 = (StackTraceElement)ArraysKt.getOrNull((Object[])stackTrace$iv, (int)rmiBusinessCallDepth$iv);
                            if (object2 == null) break block11;
                            StackTraceElement it$iv = object2;
                            boolean bl2 = false;
                            String string = " Operation: " + it$iv;
                            object2 = string;
                            if (string != null) break block12;
                        }
                        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
                        Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray, (String)"getStackTrace(...)");
                        object2 = ArraysKt.joinToString$default((Object[])stackTraceElementArray, (CharSequence)"\n at ", (CharSequence)" at ", null, (int)0, null, null, (int)60, null);
                    }
                    Object callSource$iv = object2;
                    CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv).info(StringsKt.trimMargin$default((String)("\n                    |Cannot perform operation, requested state: " + minAliveness$iv.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName((CompileServiceImplBase)this_$iv, curState$iv) + "\n                    |" + (String)callSource$iv + "\n                    "), null, (int)1, null));
                    CompileService.CallResult cfr_ignored_0 = new CompileService.CallResult.Dying();
                    break block13;
                }
                try {
                    boolean bl = false;
                    body.invoke();
                    CompileService.CallResult callResult = new CompileService.CallResult.Ok();
                }
                catch (Throwable e$iv) {
                    CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv).log(Level.SEVERE, "Exception", e$iv);
                    CompileService.CallResult callResult = new CompileService.CallResult.Error(e$iv);
                }
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            InlineMarker.finallyStart((int)1);
            readLock.unlock();
            InlineMarker.finallyEnd((int)1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final <R> CompileService.CallResult<R> ifAliveExclusive(CompileServiceImplBase.Aliveness minAliveness, Function0<? extends CompileService.CallResult<? extends R>> body) {
        CompileService.CallResult callResult;
        boolean $i$f$ifAliveExclusive = false;
        ReentrantReadWriteLock reentrantReadWriteLock = this.rwlock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        for (int i = 0; i < n; ++i) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            CompileService.CallResult callResult2;
            block13: {
                CompileService.CallResult callResult3;
                void this_$iv;
                block10: {
                    Object object;
                    int curState$iv;
                    CompileServiceImplBase.Aliveness minAliveness$iv;
                    block12: {
                        block11: {
                            boolean bl = false;
                            CompileServiceImplBase compileServiceImplBase = this;
                            minAliveness$iv = minAliveness;
                            boolean $i$f$ifAliveChecksImpl = false;
                            curState$iv = CompileServiceImplBase.access$getState((CompileServiceImplBase)this_$iv).getAlive().get();
                            if (curState$iv >= minAliveness$iv.ordinal()) break block10;
                            Object[] stackTrace$iv = Thread.currentThread().getStackTrace();
                            int rmiBusinessCallDepth$iv = 1;
                            Intrinsics.checkNotNull((Object)stackTrace$iv);
                            object = (StackTraceElement)ArraysKt.getOrNull((Object[])stackTrace$iv, (int)rmiBusinessCallDepth$iv);
                            if (object == null) break block11;
                            StackTraceElement it$iv = object;
                            boolean bl2 = false;
                            String string = " Operation: " + it$iv;
                            object = string;
                            if (string != null) break block12;
                        }
                        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
                        Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray, (String)"getStackTrace(...)");
                        object = ArraysKt.joinToString$default((Object[])stackTraceElementArray, (CharSequence)"\n at ", (CharSequence)" at ", null, (int)0, null, null, (int)60, null);
                    }
                    Object callSource$iv = object;
                    CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv).info(StringsKt.trimMargin$default((String)("\n                    |Cannot perform operation, requested state: " + minAliveness$iv.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName((CompileServiceImplBase)this_$iv, curState$iv) + "\n                    |" + (String)callSource$iv + "\n                    "), null, (int)1, null));
                    callResult2 = new CompileService.CallResult.Dying();
                    break block13;
                }
                try {
                    callResult3 = (CompileService.CallResult)body.invoke();
                }
                catch (Throwable e$iv) {
                    CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv).log(Level.SEVERE, "Exception", e$iv);
                    callResult3 = new CompileService.CallResult.Error(e$iv);
                }
                callResult2 = callResult3;
            }
            callResult = callResult2;
        }
        finally {
            InlineMarker.finallyStart((int)1);
            for (int i = 0; i < n; ++i) {
                readLock.lock();
            }
            writeLock.unlock();
            InlineMarker.finallyEnd((int)1);
        }
        return callResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    static /* synthetic */ CompileService.CallResult ifAliveExclusive$default(CompileServiceImpl $this, CompileServiceImplBase.Aliveness minAliveness, Function0 body, int n, Object object) {
        CompileService.CallResult callResult;
        if ((n & 1) != 0) {
            minAliveness = CompileServiceImplBase.Aliveness.LastSession;
        }
        boolean $i$f$ifAliveExclusive = false;
        object = $this.rwlock;
        ReentrantReadWriteLock.ReadLock readLock = ((ReentrantReadWriteLock)object).readLock();
        int n2 = ((ReentrantReadWriteLock)object).getWriteHoldCount() == 0 ? ((ReentrantReadWriteLock)object).getReadHoldCount() : 0;
        for (int i = 0; i < n2; ++i) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = ((ReentrantReadWriteLock)object).writeLock();
        writeLock.lock();
        try {
            CompileService.CallResult callResult2;
            block15: {
                CompileService.CallResult callResult3;
                void this_$iv;
                block12: {
                    Object object2;
                    int curState$iv;
                    CompileServiceImplBase.Aliveness minAliveness$iv;
                    block14: {
                        block13: {
                            boolean bl = false;
                            CompileServiceImplBase compileServiceImplBase = $this;
                            minAliveness$iv = minAliveness;
                            boolean $i$f$ifAliveChecksImpl = false;
                            curState$iv = CompileServiceImplBase.access$getState((CompileServiceImplBase)this_$iv).getAlive().get();
                            if (curState$iv >= minAliveness$iv.ordinal()) break block12;
                            Object[] stackTrace$iv = Thread.currentThread().getStackTrace();
                            int rmiBusinessCallDepth$iv = 1;
                            Intrinsics.checkNotNull((Object)stackTrace$iv);
                            object2 = (StackTraceElement)ArraysKt.getOrNull((Object[])stackTrace$iv, (int)rmiBusinessCallDepth$iv);
                            if (object2 == null) break block13;
                            StackTraceElement it$iv = object2;
                            boolean bl2 = false;
                            String string = " Operation: " + it$iv;
                            object2 = string;
                            if (string != null) break block14;
                        }
                        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
                        Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray, (String)"getStackTrace(...)");
                        object2 = ArraysKt.joinToString$default((Object[])stackTraceElementArray, (CharSequence)"\n at ", (CharSequence)" at ", null, (int)0, null, null, (int)60, null);
                    }
                    Object callSource$iv = object2;
                    CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv).info(StringsKt.trimMargin$default((String)("\n                    |Cannot perform operation, requested state: " + minAliveness$iv.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName((CompileServiceImplBase)this_$iv, curState$iv) + "\n                    |" + (String)callSource$iv + "\n                    "), null, (int)1, null));
                    callResult2 = new CompileService.CallResult.Dying();
                    break block15;
                }
                try {
                    callResult3 = (CompileService.CallResult)body.invoke();
                }
                catch (Throwable e$iv) {
                    CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv).log(Level.SEVERE, "Exception", e$iv);
                    callResult3 = new CompileService.CallResult.Error(e$iv);
                }
                callResult2 = callResult3;
            }
            callResult = callResult2;
        }
        finally {
            InlineMarker.finallyStart((int)1);
            for (int i = 0; i < n2; ++i) {
                readLock.lock();
            }
            writeLock.unlock();
            InlineMarker.finallyEnd((int)1);
        }
        return callResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void ifAliveExclusiveUnit(CompileServiceImplBase.Aliveness minAliveness, Function0<Unit> body) {
        boolean $i$f$ifAliveExclusiveUnit = false;
        ReentrantReadWriteLock reentrantReadWriteLock = this.rwlock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        for (int i = 0; i < n; ++i) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            block13: {
                CompileService.CallResult callResult;
                void this_$iv;
                block10: {
                    Object object;
                    int curState$iv;
                    CompileServiceImplBase.Aliveness minAliveness$iv;
                    block12: {
                        block11: {
                            boolean bl = false;
                            CompileServiceImplBase compileServiceImplBase = this;
                            minAliveness$iv = minAliveness;
                            boolean $i$f$ifAliveChecksImpl = false;
                            curState$iv = CompileServiceImplBase.access$getState((CompileServiceImplBase)this_$iv).getAlive().get();
                            if (curState$iv >= minAliveness$iv.ordinal()) break block10;
                            Object[] stackTrace$iv = Thread.currentThread().getStackTrace();
                            int rmiBusinessCallDepth$iv = 1;
                            Intrinsics.checkNotNull((Object)stackTrace$iv);
                            object = (StackTraceElement)ArraysKt.getOrNull((Object[])stackTrace$iv, (int)rmiBusinessCallDepth$iv);
                            if (object == null) break block11;
                            StackTraceElement it$iv = object;
                            boolean bl2 = false;
                            String string = " Operation: " + it$iv;
                            object = string;
                            if (string != null) break block12;
                        }
                        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
                        Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray, (String)"getStackTrace(...)");
                        object = ArraysKt.joinToString$default((Object[])stackTraceElementArray, (CharSequence)"\n at ", (CharSequence)" at ", null, (int)0, null, null, (int)60, null);
                    }
                    Object callSource$iv = object;
                    CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv).info(StringsKt.trimMargin$default((String)("\n                    |Cannot perform operation, requested state: " + minAliveness$iv.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName((CompileServiceImplBase)this_$iv, curState$iv) + "\n                    |" + (String)callSource$iv + "\n                    "), null, (int)1, null));
                    CompileService.CallResult cfr_ignored_0 = new CompileService.CallResult.Dying();
                    break block13;
                }
                try {
                    boolean bl = false;
                    body.invoke();
                    callResult = new CompileService.CallResult.Ok();
                }
                catch (Throwable e$iv) {
                    CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv).log(Level.SEVERE, "Exception", e$iv);
                    callResult = new CompileService.CallResult.Error(e$iv);
                }
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            InlineMarker.finallyStart((int)1);
            for (int i = 0; i < n; ++i) {
                readLock.lock();
            }
            writeLock.unlock();
            InlineMarker.finallyEnd((int)1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    static /* synthetic */ void ifAliveExclusiveUnit$default(CompileServiceImpl $this, CompileServiceImplBase.Aliveness minAliveness, Function0 body, int n, Object object) {
        if ((n & 1) != 0) {
            minAliveness = CompileServiceImplBase.Aliveness.LastSession;
        }
        boolean $i$f$ifAliveExclusiveUnit = false;
        object = $this.rwlock;
        ReentrantReadWriteLock.ReadLock readLock = ((ReentrantReadWriteLock)object).readLock();
        int n2 = ((ReentrantReadWriteLock)object).getWriteHoldCount() == 0 ? ((ReentrantReadWriteLock)object).getReadHoldCount() : 0;
        for (int i = 0; i < n2; ++i) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = ((ReentrantReadWriteLock)object).writeLock();
        writeLock.lock();
        try {
            block15: {
                CompileService.CallResult callResult;
                void this_$iv;
                block12: {
                    Object object2;
                    int curState$iv;
                    CompileServiceImplBase.Aliveness minAliveness$iv;
                    block14: {
                        block13: {
                            boolean bl = false;
                            CompileServiceImplBase compileServiceImplBase = $this;
                            minAliveness$iv = minAliveness;
                            boolean $i$f$ifAliveChecksImpl = false;
                            curState$iv = CompileServiceImplBase.access$getState((CompileServiceImplBase)this_$iv).getAlive().get();
                            if (curState$iv >= minAliveness$iv.ordinal()) break block12;
                            Object[] stackTrace$iv = Thread.currentThread().getStackTrace();
                            int rmiBusinessCallDepth$iv = 1;
                            Intrinsics.checkNotNull((Object)stackTrace$iv);
                            object2 = (StackTraceElement)ArraysKt.getOrNull((Object[])stackTrace$iv, (int)rmiBusinessCallDepth$iv);
                            if (object2 == null) break block13;
                            StackTraceElement it$iv = object2;
                            boolean bl2 = false;
                            String string = " Operation: " + it$iv;
                            object2 = string;
                            if (string != null) break block14;
                        }
                        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
                        Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray, (String)"getStackTrace(...)");
                        object2 = ArraysKt.joinToString$default((Object[])stackTraceElementArray, (CharSequence)"\n at ", (CharSequence)" at ", null, (int)0, null, null, (int)60, null);
                    }
                    Object callSource$iv = object2;
                    CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv).info(StringsKt.trimMargin$default((String)("\n                    |Cannot perform operation, requested state: " + minAliveness$iv.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName((CompileServiceImplBase)this_$iv, curState$iv) + "\n                    |" + (String)callSource$iv + "\n                    "), null, (int)1, null));
                    CompileService.CallResult cfr_ignored_0 = new CompileService.CallResult.Dying();
                    break block15;
                }
                try {
                    boolean bl = false;
                    body.invoke();
                    callResult = new CompileService.CallResult.Ok();
                }
                catch (Throwable e$iv) {
                    CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv).log(Level.SEVERE, "Exception", e$iv);
                    callResult = new CompileService.CallResult.Error(e$iv);
                }
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            InlineMarker.finallyStart((int)1);
            for (int i = 0; i < n2; ++i) {
                readLock.lock();
            }
            writeLock.unlock();
            InlineMarker.finallyEnd((int)1);
        }
    }

    private static final ReplCheckResult replCheck$lambda$0$0$0(KotlinJvmReplService $this_withValidRepl, ReplCodeLine $codeLine, IReplStageState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return $this_withValidRepl.check(state, $codeLine);
    }

    private static final ReplCompileResult replCompile$lambda$0$0$0(KotlinJvmReplService $this_withValidRepl, ReplCodeLine $codeLine, IReplStageState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return $this_withValidRepl.compile(state, $codeLine);
    }

    private static final boolean initiateElections$lambda$0$0(CompileServiceImpl this$0, File file, int p) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"<unused var>");
        return p != this$0.getPort();
    }

    private static final Unit initiateElections$lambda$0$1(CompileServiceImpl this$0, DaemonReportCategory daemonReportCategory, String msg) {
        Intrinsics.checkNotNullParameter((Object)((Object)daemonReportCategory), (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        this$0.getLog().info(msg);
        return Unit.INSTANCE;
    }

    private static final long shutdownNow$mb(long $this$shutdownNow_u24mb) {
        return $this$shutdownNow_u24mb / (long)0x100000;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private static final void gracefulShutdown$shutdownIfIdle(CompileServiceImpl this$0) {
        void this_$iv;
        CompileServiceImpl compileServiceImpl = this$0;
        CompileServiceImplBase.Aliveness minAliveness$iv = CompileServiceImplBase.Aliveness.LastSession;
        boolean $i$f$ifAliveExclusiveUnit = false;
        ReentrantReadWriteLock reentrantReadWriteLock = ((CompileServiceImpl)this_$iv).rwlock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        for (int i = 0; i < n; ++i) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            block16: {
                CompileService.CallResult callResult;
                void this_$iv$iv;
                block13: {
                    Object object;
                    int curState$iv$iv;
                    CompileServiceImplBase.Aliveness minAliveness$iv$iv;
                    block15: {
                        block14: {
                            boolean bl = false;
                            CompileServiceImplBase compileServiceImplBase = (CompileServiceImplBase)this_$iv;
                            minAliveness$iv$iv = minAliveness$iv;
                            boolean $i$f$ifAliveChecksImpl = false;
                            curState$iv$iv = CompileServiceImplBase.access$getState((CompileServiceImplBase)this_$iv$iv).getAlive().get();
                            if (curState$iv$iv >= minAliveness$iv$iv.ordinal()) break block13;
                            Object[] stackTrace$iv$iv = Thread.currentThread().getStackTrace();
                            int rmiBusinessCallDepth$iv$iv = 1;
                            Intrinsics.checkNotNull((Object)stackTrace$iv$iv);
                            object = (StackTraceElement)ArraysKt.getOrNull((Object[])stackTrace$iv$iv, (int)rmiBusinessCallDepth$iv$iv);
                            if (object == null) break block14;
                            StackTraceElement it$iv$iv = object;
                            boolean bl2 = false;
                            String string = " Operation: " + it$iv$iv;
                            object = string;
                            if (string != null) break block15;
                        }
                        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
                        Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray, (String)"getStackTrace(...)");
                        object = ArraysKt.joinToString$default((Object[])stackTraceElementArray, (CharSequence)"\n at ", (CharSequence)" at ", null, (int)0, null, null, (int)60, null);
                    }
                    Object callSource$iv$iv = object;
                    CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv).info(StringsKt.trimMargin$default((String)("\n                    |Cannot perform operation, requested state: " + minAliveness$iv$iv.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName((CompileServiceImplBase)this_$iv$iv, curState$iv$iv) + "\n                    |" + (String)callSource$iv$iv + "\n                    "), null, (int)1, null));
                    CompileService.CallResult cfr_ignored_0 = new CompileService.CallResult.Dying();
                    break block16;
                }
                try {
                    boolean bl = false;
                    boolean bl3 = false;
                    if (this$0.getState().getSessions().isEmpty()) {
                        this$0.shutdownWithDelay();
                    } else {
                        this$0.getDaemonOptions().setAutoshutdownIdleSeconds((int)TimeUnit.MILLISECONDS.toSeconds(this$0.getDaemonOptions().getForceShutdownTimeoutMilliseconds()));
                        this$0.getDaemonOptions().setAutoshutdownUnusedSeconds(this$0.getDaemonOptions().getAutoshutdownIdleSeconds());
                        this$0.getLog().info("Some sessions are active, waiting for them to finish");
                        this$0.getLog().info("Unused/idle timeouts are set to " + this$0.getDaemonOptions().getAutoshutdownUnusedSeconds() + '/' + this$0.getDaemonOptions().getAutoshutdownIdleSeconds() + 's');
                    }
                    callResult = new CompileService.CallResult.Ok();
                }
                catch (Throwable e$iv$iv) {
                    CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv).log(Level.SEVERE, "Exception", e$iv$iv);
                    callResult = new CompileService.CallResult.Error(e$iv$iv);
                }
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            for (int i = 0; i < n; ++i) {
                readLock.lock();
            }
            writeLock.unlock();
        }
    }

    public static final /* synthetic */ void access$shutdownNow(CompileServiceImpl $this) {
        $this.shutdownNow();
    }

    public static final /* synthetic */ void access$gracefulShutdown$shutdownIfIdle(CompileServiceImpl this$0) {
        CompileServiceImpl.gracefulShutdown$shutdownIfIdle(this$0);
    }
}

