/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.osm;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.osmand.PlatformUtil;
import net.osmand.util.Algorithms;
import net.sourceforge.offroad.OsmWindow;
import org.apache.commons.logging.Log;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public abstract class MapRenderingTypes {
    private static final Log log = PlatformUtil.getLog(MapRenderingTypes.class);
    public static final String[] langs = new String[]{"af", "ar", "az", "be", "bg", "bn", "bpy", "br", "bs", "ca", "ceb", "cs", "cy", "da", "de", "el", "eo", "es", "et", "eu", "id", "fa", "fi", "fr", "fy", "ga", "gl", "he", "hi", "hr", "ht", "hu", "hy", "is", "it", "ja", "ka", "ko", "ku", "la", "lb", "lt", "lv", "mk", "ml", "mr", "ms", "nds", "new", "nl", "nn", "no", "nv", "os", "pl", "pms", "pt", "ro", "ru", "sc", "sh", "sk", "sl", "sq", "sr", "sv", "sw", "ta", "te", "th", "tl", "tr", "uk", "vi", "vo", "zh"};
    public static final byte RESTRICTION_NO_RIGHT_TURN = 1;
    public static final byte RESTRICTION_NO_LEFT_TURN = 2;
    public static final byte RESTRICTION_NO_U_TURN = 3;
    public static final byte RESTRICTION_NO_STRAIGHT_ON = 4;
    public static final byte RESTRICTION_ONLY_RIGHT_TURN = 5;
    public static final byte RESTRICTION_ONLY_LEFT_TURN = 6;
    public static final byte RESTRICTION_ONLY_STRAIGHT_ON = 7;
    private static char TAG_DELIMETER = (char)47;
    private String resourceName = null;
    protected Map<String, MapRulType> types = null;
    protected List<MapRulType> typeList = new ArrayList<MapRulType>();
    protected MapRulType nameRuleType;
    protected MapRulType nameEnRuleType;

    public MapRenderingTypes(String fileName) {
        this.resourceName = fileName;
    }

    public Map<String, MapRulType> getEncodingRuleTypes() {
        this.checkIfInitNeeded();
        return this.types;
    }

    protected void checkIfInitNeeded() {
        if (this.types == null) {
            this.types = new LinkedHashMap<String, MapRulType>();
            this.typeList.clear();
            this.nameRuleType = MapRulType.createText("name");
            this.nameRuleType.order = 40;
            this.registerRuleType(this.nameRuleType);
            this.nameEnRuleType = MapRulType.createText("name:en");
            this.nameEnRuleType.order = 45;
            this.registerRuleType(this.nameEnRuleType);
            this.init();
        }
    }

    public static Collection<Map<String, String>> splitTagsIntoDifferentObjects(Map<String, String> tags) {
        boolean split = MapRenderingTypes.splitIsNeeded(tags);
        if (!split) {
            return Collections.singleton(tags);
        }
        return MapRenderingTypes.splitOpenSeaMapsTags(tags);
    }

    protected static boolean splitIsNeeded(Map<String, String> tags) {
        boolean seamark = false;
        for (String s : tags.keySet()) {
            if (!s.startsWith("seamark:")) continue;
            seamark = true;
            break;
        }
        return seamark;
    }

    private static Collection<Map<String, String>> splitOpenSeaMapsTags(Map<String, String> tags) {
        HashMap groupByOpenSeamaps = new HashMap();
        HashMap<String, String> common = new HashMap<String, String>();
        String ATTACHED_KEY = "seamark:attached";
        String type = "";
        for (String s : tags.keySet()) {
            String value = tags.get(s);
            if (s.equals("seamark:type")) {
                type = value;
                common.put(ATTACHED_KEY, MapRenderingTypes.openSeaType(value));
                continue;
            }
            if (s.startsWith("seamark:")) {
                String stype = s.substring("seamark:".length());
                int ind = stype.indexOf(58);
                if (ind == -1) {
                    common.put(s, value);
                    continue;
                }
                String group = MapRenderingTypes.openSeaType(stype.substring(0, ind));
                String add = stype.substring(ind + 1);
                if (!groupByOpenSeamaps.containsKey(group)) {
                    groupByOpenSeamaps.put(group, new HashMap());
                }
                ((Map)groupByOpenSeamaps.get(group)).put("seamark:" + add, value);
                continue;
            }
            common.put(s, value);
        }
        ArrayList<Map<String, String>> res = new ArrayList<Map<String, String>>();
        for (Map.Entry g : groupByOpenSeamaps.entrySet()) {
            ((Map)g.getValue()).putAll(common);
            ((Map)g.getValue()).put("seamark", g.getKey());
            if (MapRenderingTypes.openSeaType(type).equals(g.getKey())) {
                ((Map)g.getValue()).remove(ATTACHED_KEY);
                ((Map)g.getValue()).put("seamark", type);
                res.add(0, (Map<String, String>)g.getValue());
                continue;
            }
            res.add((Map<String, String>)g.getValue());
        }
        return res;
    }

    private static String openSeaType(String value) {
        if (value.equals("light_major") || value.equals("light_minor")) {
            return "light";
        }
        return value;
    }

    public MapRulType getTypeByInternalId(int id2) {
        return this.typeList.get(id2);
    }

    private String lc(String a) {
        if (a != null) {
            return a.toLowerCase();
        }
        return a;
    }

    protected MapRulType getRuleType(String tag, String val, boolean poi, boolean map) {
        Map<String, MapRulType> types = this.getEncodingRuleTypes();
        MapRulType rType = types.get(MapRenderingTypes.constructRuleKey(tag = this.lc(tag), val = this.lc(val)));
        if (rType == null || !rType.isPOI() && poi || !rType.isMap() && map) {
            rType = types.get(MapRenderingTypes.constructRuleKey(tag, null));
        }
        if (rType == null || !rType.isPOI() && poi || !rType.isMap() && map) {
            return null;
        }
        if (rType.isAdditional() && rType.tagValuePattern.value == null) {
            MapRulType parent = rType;
            rType = MapRulType.createAdditional(tag, val);
            rType.additional = true;
            rType.order = parent.order;
            rType.map = parent.map;
            rType.poi = parent.poi;
            rType.onlyPoint = parent.onlyPoint;
            rType.namePrefix = parent.namePrefix;
            rType = this.registerRuleType(rType);
        }
        return rType;
    }

    public MapRulType getNameRuleType() {
        this.getEncodingRuleTypes();
        return this.nameRuleType;
    }

    public MapRulType getNameEnRuleType() {
        this.getEncodingRuleTypes();
        return this.nameEnRuleType;
    }

    protected void init() {
        try {
            int tok;
            InputStream is = this.resourceName == null ? OsmWindow.getInstance().getResource("rendering_types.xml") : OsmWindow.getInstance().getResource(this.resourceName);
            long time = System.currentTimeMillis();
            XmlPullParser parser = PlatformUtil.newXMLPullParser();
            parser.setInput(is, "UTF-8");
            MapRulType parentCategory = null;
            while ((tok = parser.next()) != 1) {
                if (tok != 2) continue;
                String name = parser.getName();
                if (name.equals("category")) {
                    parentCategory = this.parseCategoryFromXml(parser);
                    continue;
                }
                if (name.equals("type")) {
                    this.parseAndRegisterTypeFromXML(parser, parentCategory);
                    continue;
                }
                if (name.equals("routing_type")) {
                    this.parseRouteTagFromXML(parser);
                    continue;
                }
                if (!name.equals("entity_convert")) continue;
                this.parseEntityConvertXML(parser);
            }
            log.info((Object)("Time to init " + (System.currentTimeMillis() - time)));
            is.close();
        }
        catch (IOException e) {
            log.error((Object)"Unexpected error", (Throwable)e);
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        catch (RuntimeException e) {
            log.error((Object)"Unexpected error", (Throwable)e);
            e.printStackTrace();
            throw e;
        }
        catch (XmlPullParserException e) {
            log.error((Object)"Unexpected error", (Throwable)e);
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    protected abstract void parseEntityConvertXML(XmlPullParser var1);

    protected abstract void parseRouteTagFromXML(XmlPullParser var1);

    protected abstract void parseAndRegisterTypeFromXML(XmlPullParser var1, MapRulType var2);

    protected MapRulType parseBaseRuleType(XmlPullParser parser, MapRulType parentCategory, String tag) {
        String value = this.lc(parser.getAttributeValue("", "value"));
        String additional = parser.getAttributeValue("", "additional");
        if (value != null && value.length() == 0) {
            value = null;
        }
        MapRulType rtype = MapRulType.createMainEntity(tag, value);
        if ("true".equals(additional)) {
            rtype = MapRulType.createAdditional(tag, value);
        } else if ("text".equals(additional)) {
            rtype = MapRulType.createText(tag);
        }
        rtype.map = "true".equals(parser.getAttributeValue("", "map")) || "yes".equals(parser.getAttributeValue("", "map")) || parser.getAttributeValue("", "map") == null;
        rtype.poi = "true".equals(parser.getAttributeValue("", "poi")) || "yes".equals(parser.getAttributeValue("", "poi")) || parser.getAttributeValue("", "poi") == null;
        String order = parser.getAttributeValue("", "order");
        if (!Algorithms.isEmpty(order)) {
            rtype.order = Integer.parseInt(order);
        } else if (parentCategory != null) {
            rtype.order = parentCategory.order;
        }
        rtype.category = parentCategory == null ? null : parentCategory.category;
        rtype.onlyPoint = Boolean.parseBoolean(parser.getAttributeValue("", "point"));
        rtype.relation = Boolean.parseBoolean(parser.getAttributeValue("", "relation"));
        rtype.relationGroup = Boolean.parseBoolean(parser.getAttributeValue("", "relationGroup"));
        if (rtype.isMain()) {
            String v;
            rtype.namePrefix = parser.getAttributeValue("", "namePrefix");
            if (rtype.namePrefix == null) {
                rtype.namePrefix = "";
            }
            if ((v = parser.getAttributeValue("", "nameTags")) != null) {
                String[] names = v.split(",");
                rtype.names = new MapRulType[names.length];
                for (int i = 0; i < names.length; ++i) {
                    String tagName = names[i];
                    if (rtype.namePrefix.length() > 0) {
                        tagName = rtype.namePrefix + tagName;
                    }
                    MapRulType mt = MapRulType.createText(tagName);
                    rtype.names[i] = mt = this.registerRuleType(mt);
                }
            }
        }
        return rtype;
    }

    protected MapRulType registerRuleType(MapRulType rt) {
        String tag = rt.tagValuePattern.tag;
        String val = rt.tagValuePattern.value;
        String keyVal = MapRenderingTypes.constructRuleKey(tag, val);
        if (this.types.containsKey(keyVal)) {
            MapRulType mapRulType = this.types.get(keyVal);
            if (mapRulType.isAdditional() || mapRulType.isText()) {
                rt.id = mapRulType.id;
                if (rt.isMain()) {
                    mapRulType.main = true;
                    if (rt.minzoom != 0) {
                        mapRulType.minzoom = Math.max(rt.minzoom, mapRulType.minzoom);
                    }
                    if (rt.maxzoom != 0) {
                        mapRulType.maxzoom = Math.min(rt.maxzoom, mapRulType.maxzoom);
                    }
                }
                return mapRulType;
            }
            throw new RuntimeException("Duplicate " + keyVal);
        }
        rt.id = this.types.size();
        this.types.put(keyVal, rt);
        this.typeList.add(rt);
        return rt;
    }

    protected MapRulType parseCategoryFromXml(XmlPullParser parser) {
        MapRulType rtype = new MapRulType();
        rtype.category = parser.getAttributeValue("", "name");
        if (!Algorithms.isEmpty(parser.getAttributeValue("", "order"))) {
            rtype.order = Integer.parseInt(parser.getAttributeValue("", "order"));
        }
        return rtype;
    }

    protected static String constructRuleKey(String tag, String val) {
        if (val == null || val.length() == 0) {
            return tag;
        }
        return tag + TAG_DELIMETER + val;
    }

    protected static String getTagKey(String tagValue) {
        int i = tagValue.indexOf(TAG_DELIMETER);
        if (i >= 0) {
            return tagValue.substring(0, i);
        }
        return tagValue;
    }

    protected static String getValueKey(String tagValue) {
        int i = tagValue.indexOf(TAG_DELIMETER);
        if (i >= 0) {
            return tagValue.substring(i + 1);
        }
        return null;
    }

    public static class MapRulType {
        protected MapRulType[] names;
        protected TagValuePattern tagValuePattern;
        protected boolean additional;
        protected boolean additionalText;
        protected boolean main;
        protected int order = 50;
        protected String category = null;
        protected boolean relation;
        protected boolean relationGroup;
        protected boolean map = true;
        protected boolean poi = true;
        protected int minzoom;
        protected int maxzoom;
        protected boolean onlyPoint;
        protected String namePrefix = "";
        protected int id = -1;
        protected int freq;
        protected int targetId;
        protected int targetPoiId = -1;

        private MapRulType() {
        }

        public boolean isPOI() {
            return this.poi;
        }

        public boolean isMap() {
            return this.map;
        }

        public int getOrder() {
            return this.order;
        }

        public static MapRulType createMainEntity(String tag, String value) {
            MapRulType rt = new MapRulType();
            rt.tagValuePattern = new TagValuePattern(tag, value);
            rt.main = true;
            return rt;
        }

        public static MapRulType createText(String tag) {
            MapRulType rt = new MapRulType();
            rt.additionalText = true;
            rt.minzoom = 2;
            rt.maxzoom = 31;
            rt.tagValuePattern = new TagValuePattern(tag, null);
            return rt;
        }

        public static MapRulType createAdditional(String tag, String value) {
            MapRulType rt = new MapRulType();
            rt.additional = true;
            rt.minzoom = 2;
            rt.maxzoom = 31;
            rt.tagValuePattern = new TagValuePattern(tag, value);
            return rt;
        }

        public String getTag() {
            return this.tagValuePattern.tag;
        }

        public int getTargetId() {
            return this.targetId;
        }

        public int getTargetPoiId() {
            return this.targetPoiId;
        }

        public void setTargetPoiId(int catId, int valueId) {
            if (catId <= 31) {
                this.targetPoiId = valueId << 6 | catId << 1;
            } else {
                if (catId > 32768) {
                    throw new IllegalArgumentException("Refer source code");
                }
                this.targetPoiId = valueId << 16 | catId << 1 | 1;
            }
        }

        public int getInternalId() {
            return this.id;
        }

        public void setTargetId(int targetId) {
            this.targetId = targetId;
        }

        public String getValue() {
            return this.tagValuePattern.value;
        }

        public int getMinzoom() {
            return this.minzoom;
        }

        public boolean isAdditional() {
            return this.additional;
        }

        public boolean isAdditionalOrText() {
            return this.additional || this.additionalText;
        }

        public boolean isMain() {
            return this.main;
        }

        public boolean isText() {
            return this.additionalText;
        }

        public boolean isOnlyPoint() {
            return this.onlyPoint;
        }

        public boolean isRelation() {
            return this.relation;
        }

        public boolean isRelationGroup() {
            return this.relationGroup;
        }

        public int getFreq() {
            return this.freq;
        }

        public int updateFreq() {
            return ++this.freq;
        }

        public String toString() {
            return this.getTag() + " " + this.getValue();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.id;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MapRulType other = (MapRulType)obj;
            return this.id == other.id && this.id >= 0;
        }
    }

    protected static class TagValuePattern {
        protected String tag;
        protected String value;
        protected int substrSt = 0;
        protected int substrEnd = 0;

        protected TagValuePattern(String t, String v) {
            this.tag = t;
            this.value = v;
            if (this.tag == null && this.value == null) {
                throw new IllegalStateException("Tag/value null should be handled differently");
            }
            if (this.tag == null) {
                throw new UnsupportedOperationException();
            }
        }

        public boolean isApplicable(Map<String, String> e) {
            if (this.value == null) {
                return e.get(this.tag) != null;
            }
            return this.value.equals(e.get(this.tag));
        }

        public String toString() {
            return "tag=" + this.tag + " val=" + this.value;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.tag == null ? 0 : this.tag.hashCode());
            result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TagValuePattern other = (TagValuePattern)obj;
            if (this.tag == null ? other.tag != null : !this.tag.equals(other.tag)) {
                return false;
            }
            return !(this.value == null ? other.value != null : !this.value.equals(other.value));
        }
    }
}

